/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageBranch
extends AbstractEntityImage {
    private static final int SIZE = 12;

    public EntityImageBranch(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic uGraphic) {
        UPolygon uPolygon = new UPolygon();
        if (this.getSkinParam().shadowing()) {
            uPolygon.setDeltaShadow(5.0);
        }
        uPolygon.addPoint(12.0, 0.0);
        uPolygon.addPoint(24.0, 12.0);
        uPolygon.addPoint(12.0, 24.0);
        uPolygon.addPoint(0.0, 12.0);
        uPolygon.addPoint(12.0, 0.0);
        uGraphic.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBorder, this.getStereo()))).apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBackground, this.getStereo()))).apply(new UStroke(1.5)).draw(uPolygon);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

