/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLollipopInterface
extends AbstractEntityImage {
    private static final int SIZE = 10;
    private final TextBlock desc;
    private final Url url;

    public EntityImageLollipopInterface(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.CLASS, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS, stereotype), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, iSkinParam);
        this.url = iLeaf.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(10.0, 10.0);
    }

    @Override
    public final void drawU(UGraphic uGraphic) {
        UEllipse uEllipse = new UEllipse(10.0, 10.0);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBackground, this.getStereo()))).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, this.getStereo())));
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        uGraphic.apply(new UStroke(1.5)).draw(uEllipse);
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d = dimension2D.getWidth();
        double d2 = 5.0 - d / 2.0;
        this.desc.drawU(uGraphic.apply(new UTranslate(d2, 10.0)));
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE_IN_RECT;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

