/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.swing.ImageHelper;
import net.sourceforge.plantuml.swing.ImageSelection;
import net.sourceforge.plantuml.swing.MainWindow2;
import net.sourceforge.plantuml.swing.ScrollablePicture;
import net.sourceforge.plantuml.swing.SimpleLine2;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.version.PSystemVersion;

class ImageWindow2
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(ImageWindow2.class);
    private static final String KEY_ZOOM_FIT = "zoomfit";
    private SimpleLine2 simpleLine2;
    private final JScrollPane scrollPane;
    private final JButton next = new JButton("Next");
    private final JButton copy = new JButton("Copy");
    private final JButton previous = new JButton("Previous");
    private final JCheckBox zoomFitButt = new JCheckBox("Zoom fit");
    private final ListModel listModel;
    private int index;
    private SizeMode sizeMode = SizeMode.FULL_SIZE;

    public ImageWindow2(SimpleLine2 simpleLine2, final MainWindow2 mainWindow2, ListModel listModel, int n) {
        super(simpleLine2.toString());
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.simpleLine2 = simpleLine2;
        this.listModel = listModel;
        this.index = n;
        JPanel jPanel = new JPanel();
        jPanel.add(this.previous);
        jPanel.add(this.copy);
        jPanel.add(this.next);
        jPanel.add(this.zoomFitButt);
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.copy();
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.next();
            }
        });
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.previous();
            }
        });
        this.zoomFitButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.zoomFit();
            }
        });
        this.scrollPane = new JScrollPane(this.buildScrollablePicture());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setSize(640, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                mainWindow2.closing(ImageWindow2.this);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                ImageWindow2.this.refreshImage();
            }
        });
        boolean bl = prefs.getBoolean(KEY_ZOOM_FIT, false);
        this.zoomFitButt.setSelected(bl);
        if (bl) {
            this.sizeMode = SizeMode.ZOOM_FIT;
        }
    }

    private void next() {
        ++this.index;
        this.updateSimpleLine();
    }

    private void previous() {
        --this.index;
        this.updateSimpleLine();
    }

    private void zoomFit() {
        boolean bl = this.zoomFitButt.isSelected();
        prefs.putBoolean(KEY_ZOOM_FIT, bl);
        this.sizeMode = bl ? SizeMode.ZOOM_FIT : SizeMode.FULL_SIZE;
        this.refreshImage();
    }

    private void updateSimpleLine() {
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > this.listModel.getSize() - 1) {
            this.index = this.listModel.getSize() - 1;
        }
        this.simpleLine2 = (SimpleLine2)this.listModel.getElementAt(this.index);
        this.setTitle(this.simpleLine2.toString());
        this.refreshImage();
    }

    private ScrollablePicture buildScrollablePicture() {
        Object object;
        Serializable serializable;
        GeneratedImage generatedImage = this.simpleLine2.getGeneratedImage();
        if (generatedImage == null) {
            return null;
        }
        File file = generatedImage.getPngFile();
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(file.getAbsolutePath()));
            if (this.sizeMode == SizeMode.ZOOM_FIT) {
                serializable = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                object = ImageHelper.getScaledDimension(serializable, this.scrollPane.getViewport().getSize());
                RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                bufferedImage = ImageHelper.getScaledInstance(bufferedImage, (Dimension)object, renderingHints, true);
            }
        }
        catch (IOException iOException) {
            object = "Error reading file: " + iOException.toString();
            GraphicStrings graphicStrings = GraphicStrings.createDefault(Arrays.asList(object), false);
            ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, graphicStrings.getBackcolor(), null, null, 0.0, 0.0, null, false);
            imageBuilder.addUDrawable(graphicStrings);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                imageBuilder.writeImageTOBEMOVED(FileFormat.PNG, byteArrayOutputStream);
                byteArrayOutputStream.close();
                bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
        }
        serializable = new ImageIcon(bufferedImage, this.simpleLine2.toString());
        object = new ScrollablePicture((ImageIcon)serializable, 1);
        return object;
    }

    private void copy() {
        GeneratedImage generatedImage = this.simpleLine2.getGeneratedImage();
        if (generatedImage == null) {
            return;
        }
        File file = generatedImage.getPngFile();
        Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
        ImageSelection imageSelection = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public SimpleLine2 getSimpleLine() {
        return this.simpleLine2;
    }

    public void refreshImage() {
        this.scrollPane.setViewportView(this.buildScrollablePicture());
        this.force();
    }

    private void force() {
        this.repaint();
    }

    private static enum SizeMode {
        FULL_SIZE,
        ZOOM_FIT;

    }
}

