/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.ugraphic.SpriteGrayLevel;
import net.sourceforge.plantuml.ugraphic.SpriteUtils;
import net.sourceforge.plantuml.version.PSystemVersion;

public class SpriteWindow
extends JFrame {
    private final JTextArea area = new JTextArea();
    private String last;

    public SpriteWindow() {
        super("SpriteWindows");
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.area.setFont(new Font("Courier", 0, 14));
        this.area.setText("Copy an image to the clipboard.\nIt will be converted inside this window.\n");
        JScrollPane jScrollPane = new JScrollPane(this.area);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setSize(400, 320);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.startTimer();
    }

    private void startTimer() {
        Log.info("Init done");
        Timer timer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpriteWindow.this.tick();
            }
        });
        timer.setInitialDelay(0);
        timer.start();
        Log.info("Timer started");
    }

    private void tick() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpriteWindow.this.encode();
            }
        });
    }

    private void encode() {
        BufferedImage bufferedImage = SpriteWindow.getClipboard();
        if (bufferedImage == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.encode(bufferedImage, SpriteGrayLevel.GRAY_16, stringBuilder);
        this.encodeCompressed(bufferedImage, SpriteGrayLevel.GRAY_16, stringBuilder);
        this.encode(bufferedImage, SpriteGrayLevel.GRAY_8, stringBuilder);
        this.encodeCompressed(bufferedImage, SpriteGrayLevel.GRAY_8, stringBuilder);
        this.encode(bufferedImage, SpriteGrayLevel.GRAY_4, stringBuilder);
        this.encodeCompressed(bufferedImage, SpriteGrayLevel.GRAY_4, stringBuilder);
        this.printData(stringBuilder.toString());
    }

    private void encodeCompressed(BufferedImage bufferedImage, SpriteGrayLevel spriteGrayLevel, StringBuilder stringBuilder) {
        stringBuilder.append("\n");
        stringBuilder.append(SpriteUtils.encodeCompressed(bufferedImage, "demo", spriteGrayLevel));
    }

    private void encode(BufferedImage bufferedImage, SpriteGrayLevel spriteGrayLevel, StringBuilder stringBuilder) {
        stringBuilder.append("\n");
        stringBuilder.append(SpriteUtils.encode(bufferedImage, "demo", spriteGrayLevel));
    }

    private void printData(String string) {
        if (!string.equals(this.last)) {
            this.area.setText(string);
            this.last = string;
        }
    }

    public static BufferedImage getClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                BufferedImage bufferedImage = (BufferedImage)transferable.getTransferData(DataFlavor.imageFlavor);
                return bufferedImage;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Log.error(unsupportedFlavorException.toString());
        }
        catch (IOException iOException) {
            Log.error(iOException.toString());
        }
        return null;
    }

    public static void main(String[] stringArray) {
        new SpriteWindow();
    }
}

