/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.MinMaxMutable;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextLimitFinder
implements UGraphic {
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final MinMaxMutable minmax;

    @Override
    public boolean isSpecialTxt() {
        return false;
    }

    @Override
    public UGraphic apply(UChange uChange) {
        if (uChange instanceof UTranslate) {
            return new TextLimitFinder(this.stringBounder, this.minmax, this.translate.compose((UTranslate)uChange));
        }
        if (uChange instanceof UStroke) {
            return new TextLimitFinder(this);
        }
        if (uChange instanceof UChangeBackColor) {
            return new TextLimitFinder(this);
        }
        if (uChange instanceof UChangeColor) {
            return new TextLimitFinder(this);
        }
        throw new UnsupportedOperationException();
    }

    public TextLimitFinder(StringBounder stringBounder, boolean bl) {
        this(stringBounder, MinMaxMutable.getEmpty(bl), new UTranslate());
    }

    private TextLimitFinder(StringBounder stringBounder, MinMaxMutable minMaxMutable, UTranslate uTranslate) {
        this.stringBounder = stringBounder;
        this.minmax = minMaxMutable;
        this.translate = uTranslate;
    }

    private TextLimitFinder(TextLimitFinder textLimitFinder) {
        this(textLimitFinder.stringBounder, textLimitFinder.minmax, textLimitFinder.translate);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public UParam getParam() {
        return new UParamNull();
    }

    @Override
    public void draw(UShape uShape) {
        if (uShape instanceof UText) {
            double d = this.translate.getDx();
            double d2 = this.translate.getDy();
            this.drawText(d, d2, (UText)uShape);
        }
    }

    @Override
    public ColorMapper getColorMapper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeAction() {
    }

    private void drawText(double d, double d2, UText uText) {
        Dimension2D dimension2D = this.stringBounder.calculateDimension(uText.getFontConfiguration().getFont(), uText.getText());
        this.minmax.addPoint(d, d2 -= dimension2D.getHeight() - 1.5);
        this.minmax.addPoint(d, d2 + dimension2D.getHeight());
        this.minmax.addPoint(d + dimension2D.getWidth(), d2);
        this.minmax.addPoint(d + dimension2D.getWidth(), d2 + dimension2D.getHeight());
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    @Override
    public void flushUg() {
    }
}

