/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.ugraphic.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UGraphicCompress
extends UGraphicDelegator {
    private final CompressionTransform compressionTransform;
    private final UTranslate translate;

    @Override
    public UGraphic apply(UChange uChange) {
        if (uChange instanceof UTranslate) {
            return new UGraphicCompress(this.getUg(), this.compressionTransform, this.translate.compose((UTranslate)uChange));
        }
        if (uChange instanceof UStroke || uChange instanceof UChangeBackColor || uChange instanceof UChangeColor) {
            return new UGraphicCompress(this.getUg().apply(uChange), this.compressionTransform, this.translate);
        }
        throw new UnsupportedOperationException();
    }

    public UGraphicCompress(UGraphic uGraphic, CompressionTransform compressionTransform) {
        this(uGraphic, compressionTransform, new UTranslate());
    }

    private UGraphicCompress(UGraphic uGraphic, CompressionTransform compressionTransform, UTranslate uTranslate) {
        super(uGraphic);
        this.compressionTransform = compressionTransform;
        this.translate = uTranslate;
    }

    @Override
    public void draw(UShape uShape) {
        double d = this.translate.getDx();
        double d2 = this.translate.getDy();
        if (uShape instanceof ULine) {
            this.drawLine(d, d2, (ULine)uShape);
        } else {
            this.getUg().apply(new UTranslate(d, this.ct(d2))).draw(uShape);
        }
    }

    private void drawLine(double d, double d2, ULine uLine) {
        this.drawLine(d, this.ct(d2), d + uLine.getDX(), this.ct(d2 + uLine.getDY()));
    }

    private double ct(double d) {
        return this.compressionTransform.transform(d);
    }

    private void drawLine(double d, double d2, double d3, double d4) {
        double d5 = Math.min(d, d3);
        double d6 = Math.max(d, d3);
        double d7 = Math.min(d2, d4);
        double d8 = Math.max(d2, d4);
        this.getUg().apply(new UTranslate(d5, d7)).draw(new ULine(d6 - d5, d8 - d7));
    }
}

