/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public abstract class UGraphicUtils {
    public static UDrawable translate(final UDrawable uDrawable, final double d, final double d2) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic uGraphic) {
                uDrawable.drawU(uGraphic.apply(new UTranslate(d, d2)));
            }
        };
    }

    public static void writeImage(OutputStream outputStream, String string, FileFormatOption fileFormatOption, ColorMapper colorMapper, HtmlColor htmlColor, TextBlock textBlock) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage bufferedImage = UGraphicUtils.createImage(colorMapper, htmlColor, textBlock);
            PngIO.write((RenderedImage)bufferedImage, outputStream, fileFormatOption.isWithMetadata() ? string : null, 96);
        } else if (fileFormat == FileFormat.SVG) {
            UGraphicSvg uGraphicSvg = new UGraphicSvg(colorMapper, StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColor)), false, 1.0);
            textBlock.drawU(uGraphicSvg);
            uGraphicSvg.createXml(outputStream);
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps uGraphicEps = new UGraphicEps(colorMapper, EpsStrategy.getDefault2());
            textBlock.drawU(uGraphicEps);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            UGraphicEps uGraphicEps = new UGraphicEps(colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            textBlock.drawU(uGraphicEps);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static BufferedImage createImage(ColorMapper colorMapper, HtmlColor htmlColor, TextBlock textBlock) {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, colorMapper.getMappedColor(htmlColor));
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, 1.0);
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphicG2d.getStringBounder());
        graphics2D.dispose();
        emptyImageBuilder = new EmptyImageBuilder(dimension2D.getWidth(), dimension2D.getHeight(), colorMapper.getMappedColor(htmlColor));
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d2 = new UGraphicG2d(colorMapper, graphics2D, 1.0);
        textBlock.drawU(uGraphicG2d2);
        graphics2D.dispose();
        return bufferedImage;
    }
}

