/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.arc;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import net.sourceforge.plantuml.ugraphic.arc.ExtendedPathIterator;

public class ExtendedGeneralPath
implements Shape,
Cloneable {
    private GeneralPath path;
    private int numVals = 0;
    private int numSeg = 0;
    private double[] values = null;
    private int[] types = null;
    private double mx;
    private double my;
    private double cx;
    private double cy;

    public ExtendedGeneralPath() {
        this.path = new GeneralPath();
    }

    public ExtendedGeneralPath(int n) {
        this.path = new GeneralPath(n);
    }

    public ExtendedGeneralPath(int n, int n2) {
        this.path = new GeneralPath(n, n2);
    }

    public ExtendedGeneralPath(Shape shape) {
        this();
        this.append(shape, false);
    }

    public void arcTo(double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5) {
        if (d == 0.0 || d2 == 0.0) {
            this.lineTo(d4, d5);
            return;
        }
        this.checkMoveTo();
        double d6 = this.cx;
        double d7 = this.cy;
        if (d6 == d4 && d7 == d5) {
            return;
        }
        Arc2D arc2D = ExtendedGeneralPath.computeArc(d6, d7, d, d2, d3, bl, bl2, d4, d5);
        if (arc2D == null) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(d3), arc2D.getCenterX(), arc2D.getCenterY());
        Shape shape = affineTransform.createTransformedShape(arc2D);
        this.path.append(shape, true);
        this.makeRoom(7);
        this.types[this.numSeg++] = 4321;
        this.values[this.numVals++] = d;
        this.values[this.numVals++] = d2;
        this.values[this.numVals++] = d3;
        this.values[this.numVals++] = bl ? 1.0 : 0.0;
        this.values[this.numVals++] = bl2 ? 1.0 : 0.0;
        double d8 = d4;
        this.values[this.numVals++] = d8;
        this.cx = d8;
        double d9 = d5;
        this.values[this.numVals++] = d9;
        this.cy = d9;
    }

    public static Arc2D computeArc(double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, double d6, double d7) {
        double d8;
        double d9;
        double d10 = (d - d6) / 2.0;
        double d11 = (d2 - d7) / 2.0;
        d5 = Math.toRadians(d5 % 360.0);
        double d12 = Math.cos(d5);
        double d13 = Math.sin(d5);
        double d14 = d12 * d10 + d13 * d11;
        double d15 = -d13 * d10 + d12 * d11;
        double d16 = d14 * d14;
        double d17 = (d3 = Math.abs(d3)) * d3;
        double d18 = d16 / d17 + (d9 = d15 * d15) / (d8 = (d4 = Math.abs(d4)) * d4);
        if (d18 > 1.0) {
            d3 = Math.sqrt(d18) * d3;
            d4 = Math.sqrt(d18) * d4;
            d17 = d3 * d3;
            d8 = d4 * d4;
        }
        double d19 = bl == bl2 ? -1.0 : 1.0;
        double d20 = (d17 * d8 - d17 * d9 - d8 * d16) / (d17 * d9 + d8 * d16);
        d20 = d20 < 0.0 ? 0.0 : d20;
        double d21 = d19 * Math.sqrt(d20);
        double d22 = d21 * (d3 * d15 / d4);
        double d23 = d21 * -(d4 * d14 / d3);
        double d24 = (d + d6) / 2.0;
        double d25 = (d2 + d7) / 2.0;
        double d26 = d24 + (d12 * d22 - d13 * d23);
        double d27 = d25 + (d13 * d22 + d12 * d23);
        double d28 = (d14 - d22) / d3;
        double d29 = (d15 - d23) / d4;
        double d30 = (-d14 - d22) / d3;
        double d31 = (-d15 - d23) / d4;
        double d32 = Math.sqrt(d28 * d28 + d29 * d29);
        double d33 = d28;
        d19 = d29 < 0.0 ? -1.0 : 1.0;
        double d34 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        d32 = Math.sqrt((d28 * d28 + d29 * d29) * (d30 * d30 + d31 * d31));
        d33 = d28 * d30 + d29 * d31;
        d19 = d28 * d31 - d29 * d30 < 0.0 ? -1.0 : 1.0;
        double d35 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        if (!bl2 && d35 > 0.0) {
            d35 -= 360.0;
        } else if (bl2 && d35 < 0.0) {
            d35 += 360.0;
        }
        d35 %= 360.0;
        d34 %= 360.0;
        Arc2D.Double double_ = new Arc2D.Double();
        double_.x = d26 - d3;
        double_.y = d27 - d4;
        double_.width = d3 * 2.0;
        double_.height = d4 * 2.0;
        double_.start = -d34;
        double_.extent = -d35;
        return double_;
    }

    public void moveTo(double d, double d2) {
        this.makeRoom(2);
        this.types[this.numSeg++] = 0;
        double d3 = d;
        this.values[this.numVals++] = d3;
        this.mx = d3;
        this.cx = d3;
        double d4 = d2;
        this.values[this.numVals++] = d4;
        this.my = d4;
        this.cy = d4;
    }

    public void lineTo(double d, double d2) {
        this.checkMoveTo();
        this.path.lineTo(d, d2);
        this.makeRoom(2);
        this.types[this.numSeg++] = 1;
        double d3 = d;
        this.values[this.numVals++] = d3;
        this.cx = d3;
        double d4 = d2;
        this.values[this.numVals++] = d4;
        this.cy = d4;
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        this.checkMoveTo();
        this.path.quadTo(d, d2, d3, d4);
        this.makeRoom(4);
        this.types[this.numSeg++] = 2;
        this.values[this.numVals++] = d;
        this.values[this.numVals++] = d2;
        double d5 = d3;
        this.values[this.numVals++] = d5;
        this.cx = d5;
        double d6 = d4;
        this.values[this.numVals++] = d6;
        this.cy = d6;
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.checkMoveTo();
        this.path.curveTo(d, d2, d3, d4, d5, d6);
        this.makeRoom(6);
        this.types[this.numSeg++] = 3;
        this.values[this.numVals++] = d;
        this.values[this.numVals++] = d2;
        this.values[this.numVals++] = d3;
        this.values[this.numVals++] = d4;
        double d7 = d5;
        this.values[this.numVals++] = d7;
        this.cx = d7;
        double d8 = d6;
        this.values[this.numVals++] = d8;
        this.cy = d8;
    }

    public void closePath() {
        if (this.numSeg != 0 && this.types[this.numSeg - 1] == 4) {
            return;
        }
        if (this.numSeg != 0 && this.types[this.numSeg - 1] != 0) {
            this.path.closePath();
        }
        this.makeRoom(0);
        this.types[this.numSeg++] = 4;
        this.cx = this.mx;
        this.cy = this.my;
    }

    protected void checkMoveTo() {
        if (this.numSeg == 0) {
            return;
        }
        switch (this.types[this.numSeg - 1]) {
            case 0: {
                this.path.moveTo(this.values[this.numVals - 2], this.values[this.numVals - 1]);
                break;
            }
            case 4: {
                if (this.numSeg == 1) {
                    return;
                }
                if (this.types[this.numSeg - 2] != 0) break;
                this.path.moveTo(this.values[this.numVals - 2], this.values[this.numVals - 1]);
                break;
            }
        }
    }

    public void append(Shape shape, boolean bl) {
        this.append(shape.getPathIterator(new AffineTransform()), bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            Arrays.fill(dArray, 0.0);
            int n = pathIterator.currentSegment(dArray);
            pathIterator.next();
            if (bl && this.numVals != 0) {
                if (n == 0) {
                    double d = dArray[0];
                    double d2 = dArray[1];
                    if (d != this.cx || d2 != this.cy) {
                        n = 1;
                    } else {
                        if (pathIterator.isDone()) break;
                        n = pathIterator.currentSegment(dArray);
                        pathIterator.next();
                    }
                }
                bl = false;
            }
            switch (n) {
                case 4: {
                    this.closePath();
                    break;
                }
                case 0: {
                    this.moveTo(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                }
            }
        }
    }

    public void append(ExtendedPathIterator extendedPathIterator, boolean bl) {
        double[] dArray = new double[7];
        while (!extendedPathIterator.isDone()) {
            Arrays.fill(dArray, 0.0);
            int n = extendedPathIterator.currentSegment(dArray);
            extendedPathIterator.next();
            if (bl && this.numVals != 0) {
                if (n == 0) {
                    double d = dArray[0];
                    double d2 = dArray[1];
                    if (d != this.cx || d2 != this.cy) {
                        n = 1;
                    } else {
                        if (extendedPathIterator.isDone()) break;
                        n = extendedPathIterator.currentSegment(dArray);
                        extendedPathIterator.next();
                    }
                }
                bl = false;
            }
            switch (n) {
                case 4: {
                    this.closePath();
                    break;
                }
                case 0: {
                    this.moveTo(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 4321: {
                    this.arcTo(dArray[0], dArray[1], dArray[2], dArray[3] != 0.0, dArray[4] != 0.0, dArray[5], dArray[6]);
                }
            }
        }
    }

    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    public void setWindingRule(int n) {
        this.path.setWindingRule(n);
    }

    public Point2D getCurrentPoint() {
        if (this.numVals == 0) {
            return null;
        }
        return new Point2D.Double(this.cx, this.cy);
    }

    public void reset() {
        this.path.reset();
        this.numSeg = 0;
        this.numVals = 0;
        this.values = null;
        this.types = null;
    }

    public void transform(AffineTransform affineTransform) {
        if (affineTransform.getType() != 0) {
            throw new IllegalArgumentException("ExtendedGeneralPaths can not be transformed");
        }
    }

    public Shape createTransformedShape(AffineTransform affineTransform) {
        return this.path.createTransformedShape(affineTransform);
    }

    @Override
    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.path.contains(d, d2);
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.path.contains(point2D);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.path.contains(d, d2, d3, d4);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.path.contains(rectangle2D);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.path.intersects(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.path.intersects(rectangle2D);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.path.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.path.getPathIterator(affineTransform, d);
    }

    public ExtendedPathIterator getExtendedPathIterator() {
        return new EPI();
    }

    public Object clone() {
        try {
            ExtendedGeneralPath extendedGeneralPath = (ExtendedGeneralPath)super.clone();
            extendedGeneralPath.path = (GeneralPath)this.path.clone();
            if (this.values != null) {
                extendedGeneralPath.values = new double[this.values.length];
                System.arraycopy(this.values, 0, extendedGeneralPath.values, 0, this.values.length);
            }
            extendedGeneralPath.numVals = this.numVals;
            if (this.types != null) {
                extendedGeneralPath.types = new int[this.types.length];
                System.arraycopy(this.types, 0, extendedGeneralPath.types, 0, this.types.length);
            }
            extendedGeneralPath.numSeg = this.numSeg;
            return extendedGeneralPath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    private void makeRoom(int n) {
        if (this.values == null) {
            this.values = new double[2 * n];
            this.types = new int[2];
            this.numVals = 0;
            this.numSeg = 0;
            return;
        }
        int n2 = this.numVals + n;
        if (n2 > this.values.length) {
            int n3 = this.values.length * 2;
            if (n3 < n2) {
                n3 = n2;
            }
            double[] dArray = new double[n3];
            System.arraycopy(this.values, 0, dArray, 0, this.numVals);
            this.values = dArray;
        }
        if (this.numSeg == this.types.length) {
            int[] nArray = new int[this.types.length * 2];
            System.arraycopy(this.types, 0, nArray, 0, this.types.length);
            this.types = nArray;
        }
    }

    class EPI
    implements ExtendedPathIterator {
        private int segNum = 0;
        private int valsIdx = 0;

        EPI() {
        }

        @Override
        public int currentSegment() {
            return ExtendedGeneralPath.this.types[this.segNum];
        }

        @Override
        public int currentSegment(double[] dArray) {
            int n = ExtendedGeneralPath.this.types[this.segNum];
            switch (n) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    break;
                }
                case 2: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    break;
                }
                case 3: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    dArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    dArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    break;
                }
                case 4321: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    dArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    dArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    dArray[6] = ExtendedGeneralPath.this.values[this.valsIdx + 6];
                }
            }
            return n;
        }

        @Override
        public int getWindingRule() {
            return ExtendedGeneralPath.this.path.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.segNum == ExtendedGeneralPath.this.numSeg;
        }

        @Override
        public void next() {
            int n = ExtendedGeneralPath.this.types[this.segNum++];
            switch (n) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    this.valsIdx += 2;
                    break;
                }
                case 2: {
                    this.valsIdx += 4;
                    break;
                }
                case 3: {
                    this.valsIdx += 6;
                    break;
                }
                case 4321: {
                    this.valsIdx += 7;
                }
            }
        }
    }
}

