/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverRectangleEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        HtmlColor htmlColor;
        URectangle uRectangle = (URectangle)uShape;
        double d3 = uRectangle.getWidth();
        double d4 = uRectangle.getHeight();
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
            Rectangle2D.Double double_2 = uClip.getClippedRectangle(double_);
            if (double_2.height < 0.0) {
                return;
            }
            d = double_2.x;
            d2 = double_2.y;
            d3 = double_2.width;
            d4 = double_2.height;
        }
        double d5 = uRectangle.getRx();
        double d6 = uRectangle.getRy();
        if (uRectangle.getDeltaShadow() != 0.0) {
            epsGraphics.epsRectangleShadow(d, d2, d3, d4, d5 / 2.0, d6 / 2.0, uRectangle.getDeltaShadow());
        }
        if ((htmlColor = uParam.getBackcolor()) instanceof HtmlColorGradient) {
            epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
            epsGraphics.epsRectangle(d, d2, d3, d4, d5 / 2.0, d6 / 2.0, (HtmlColorGradient)htmlColor, colorMapper);
        } else {
            epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
            epsGraphics.setFillColor(colorMapper.getMappedColor(uParam.getBackcolor()));
            epsGraphics.setStrokeWidth("" + uParam.getStroke().getThickness(), uParam.getStroke().getDashVisible(), uParam.getStroke().getDashSpace());
            epsGraphics.epsRectangle(d, d2, d3, d4, d5 / 2.0, d6 / 2.0);
        }
    }
}

