/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverEllipseG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;
    private static final double ROU = 5.0;

    public DriverEllipseG2d(double d, EnsureVisible ensureVisible) {
        this.dpiFactor = d;
        this.visible = ensureVisible;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        UEllipse uEllipse = (UEllipse)uShape;
        graphics2D.setStroke(new BasicStroke((float)uParam.getStroke().getThickness()));
        this.visible.ensureVisible(d, d2);
        this.visible.ensureVisible(d + uEllipse.getWidth(), d2 + uEllipse.getHeight());
        if (uEllipse.getStart() == 0.0 && uEllipse.getExtend() == 0.0) {
            HtmlColor htmlColor;
            Ellipse2D.Double double_ = new Ellipse2D.Double(d, d2, uEllipse.getWidth(), uEllipse.getHeight());
            if (uEllipse.getDeltaShadow() != 0.0) {
                this.drawShadow(graphics2D, double_, uEllipse.getDeltaShadow(), this.dpiFactor);
            }
            if ((htmlColor = uParam.getBackcolor()) instanceof HtmlColorGradient) {
                GradientPaint gradientPaint = this.getPaintGradient(d, d2, colorMapper, uEllipse, htmlColor);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(double_);
                if (uParam.getColor() != null) {
                    graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
                    DriverLineG2d.manageStroke(uParam, graphics2D);
                    graphics2D.draw(double_);
                }
            } else {
                if (htmlColor != null) {
                    graphics2D.setColor(colorMapper.getMappedColor(uParam.getBackcolor()));
                    DriverRectangleG2d.managePattern(uParam, graphics2D);
                    graphics2D.fill(double_);
                }
                if (uParam.getColor() != null && !uParam.getColor().equals(uParam.getBackcolor())) {
                    graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
                    DriverLineG2d.manageStroke(uParam, graphics2D);
                    graphics2D.draw(double_);
                }
            }
        } else {
            Arc2D.Double double_ = new Arc2D.Double(d, d2, uEllipse.getWidth(), uEllipse.getHeight(), DriverEllipseG2d.round(uEllipse.getStart()), DriverEllipseG2d.round(uEllipse.getExtend()), 0);
            if (uParam.getColor() != null) {
                graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
                graphics2D.draw(double_);
            }
        }
    }

    private GradientPaint getPaintGradient(double d, double d2, ColorMapper colorMapper, UEllipse uEllipse, HtmlColor htmlColor) {
        HtmlColorGradient htmlColorGradient = (HtmlColorGradient)htmlColor;
        char c = htmlColorGradient.getPolicy();
        GradientPaint gradientPaint = c == '|' ? new GradientPaint((float)d, (float)(d2 + uEllipse.getHeight()) / 2.0f, colorMapper.getMappedColor(htmlColorGradient.getColor1()), (float)(d + uEllipse.getWidth()), (float)(d2 + uEllipse.getHeight()) / 2.0f, colorMapper.getMappedColor(htmlColorGradient.getColor2())) : (c == '\\' ? new GradientPaint((float)d, (float)(d2 + uEllipse.getHeight()), colorMapper.getMappedColor(htmlColorGradient.getColor1()), (float)(d + uEllipse.getWidth()), (float)d2, colorMapper.getMappedColor(htmlColorGradient.getColor2())) : (c == '-' ? new GradientPaint((float)(d + uEllipse.getWidth()) / 2.0f, (float)d2, colorMapper.getMappedColor(htmlColorGradient.getColor1()), (float)(d + uEllipse.getWidth()) / 2.0f, (float)(d2 + uEllipse.getHeight()), colorMapper.getMappedColor(htmlColorGradient.getColor2())) : new GradientPaint((float)d, (float)d2, colorMapper.getMappedColor(htmlColorGradient.getColor1()), (float)(d + uEllipse.getWidth()), (float)(d2 + uEllipse.getHeight()), colorMapper.getMappedColor(htmlColorGradient.getColor2()))));
        return gradientPaint;
    }

    static double round(double d) {
        return d;
    }
}

