/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.hand;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.hand.UDotPathHand;
import net.sourceforge.plantuml.ugraphic.hand.UEllipseHand;
import net.sourceforge.plantuml.ugraphic.hand.ULineHand;
import net.sourceforge.plantuml.ugraphic.hand.UPathHand;
import net.sourceforge.plantuml.ugraphic.hand.UPolygonHand;
import net.sourceforge.plantuml.ugraphic.hand.URectangleHand;

public class UGraphicHandwritten
implements UGraphic {
    private final UGraphic ug;

    public UGraphicHandwritten(UGraphic uGraphic) {
        this.ug = uGraphic;
    }

    @Override
    public StringBounder getStringBounder() {
        return this.ug.getStringBounder();
    }

    @Override
    public UParam getParam() {
        return this.ug.getParam();
    }

    @Override
    public void draw(UShape uShape) {
        if (uShape instanceof ULine) {
            this.drawHand((ULine)uShape);
        } else if (uShape instanceof URectangle) {
            this.drawHand((URectangle)uShape);
        } else if (uShape instanceof UPolygon) {
            this.drawHand((UPolygon)uShape);
        } else if (uShape instanceof UEllipse) {
            this.drawHand((UEllipse)uShape);
        } else if (uShape instanceof DotPath) {
            this.drawHand((DotPath)uShape);
        } else if (uShape instanceof UPath) {
            this.drawHand((UPath)uShape);
        } else {
            this.ug.draw(uShape);
        }
    }

    private void drawHand(UPath uPath) {
        UPathHand uPathHand = new UPathHand(uPath);
        this.ug.draw(uPathHand.getHanddrawn());
    }

    private void drawHand(DotPath dotPath) {
        UDotPathHand uDotPathHand = new UDotPathHand(dotPath);
        this.ug.draw(uDotPathHand.getHanddrawn());
    }

    private void drawHand(UPolygon uPolygon) {
        UPolygonHand uPolygonHand = new UPolygonHand(uPolygon);
        this.ug.draw(uPolygonHand.getHanddrawn());
    }

    private void drawHand(URectangle uRectangle) {
        URectangleHand uRectangleHand = new URectangleHand(uRectangle);
        this.ug.draw(uRectangleHand.getHanddrawn());
    }

    private void drawHand(ULine uLine) {
        ULineHand uLineHand = new ULineHand(uLine);
        this.ug.draw(uLineHand.getHanddrawn());
    }

    private void drawHand(UEllipse uEllipse) {
        UEllipseHand uEllipseHand = new UEllipseHand(uEllipse);
        this.ug.draw(uEllipseHand.getHanddrawn());
    }

    @Override
    public UGraphic apply(UChange uChange) {
        return new UGraphicHandwritten(this.ug.apply(uChange));
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.ug.getColorMapper();
    }

    @Override
    public void startUrl(Url url) {
        this.ug.startUrl(url);
    }

    @Override
    public void closeAction() {
        this.ug.closeAction();
    }

    @Override
    public void flushUg() {
        this.ug.flushUg();
    }

    @Override
    public boolean isSpecialTxt() {
        return false;
    }
}

