/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.html5;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.html5.Html5Drawer;

public class DriverRectangleHtml5
implements UDriver<Html5Drawer> {
    private final ClipContainer clipContainer;

    public DriverRectangleHtml5(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Html5Drawer html5Drawer) {
        URectangle uRectangle = (URectangle)uShape;
        double d3 = uRectangle.getWidth();
        double d4 = uRectangle.getHeight();
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            Rectangle2D.Double double_ = uClip.getClippedRectangle(new Rectangle2D.Double(d, d2, d3, d4));
            d = double_.x;
            d2 = double_.y;
            d3 = double_.width;
            d4 = double_.height;
        }
        double d5 = uRectangle.getRx();
        double d6 = uRectangle.getRy();
        HtmlColor htmlColor = uParam.getBackcolor();
        if (!(htmlColor instanceof HtmlColorGradient)) {
            String string = uParam.getColor() == null ? null : StringUtils.getAsHtml(colorMapper.getMappedColor(uParam.getColor()));
            String string2 = uParam.getColor() == null ? null : StringUtils.getAsHtml(colorMapper.getMappedColor(uParam.getBackcolor()));
            html5Drawer.setStrokeColor(string);
            html5Drawer.setFillColor(string2);
            html5Drawer.htmlRectangle(d, d2, d3, d4, d5 / 2.0, d6 / 2.0);
        }
    }
}

