/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverRectangleSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        Object object;
        Object object2;
        URectangle uRectangle = (URectangle)uShape;
        double d3 = uRectangle.getRx();
        double d4 = uRectangle.getRy();
        double d5 = uRectangle.getWidth();
        double d6 = uRectangle.getHeight();
        String string = StringUtils.getAsSvg(colorMapper, uParam.getColor());
        HtmlColor htmlColor = uParam.getBackcolor();
        if (htmlColor instanceof HtmlColorGradient) {
            object2 = (HtmlColorGradient)htmlColor;
            object = svgGraphics.createSvgGradient(StringUtils.getAsHtml(colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor1())), StringUtils.getAsHtml(colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor2())), ((HtmlColorGradient)object2).getPolicy());
            svgGraphics.setFillColor("url(#" + (String)object + ")");
            svgGraphics.setStrokeColor(string);
        } else {
            object2 = StringUtils.getAsSvg(colorMapper, htmlColor);
            svgGraphics.setFillColor((String)object2);
            svgGraphics.setStrokeColor(string);
        }
        svgGraphics.setStrokeWidth(uParam.getStroke().getThickness(), uParam.getStroke().getDasharraySvg());
        object2 = this.clipContainer.getClip();
        if (object2 != null) {
            object = ((UClip)object2).getClippedRectangle(new Rectangle2D.Double(d, d2, d5, d6));
            d = ((Rectangle2D.Double)object).x;
            d2 = ((Rectangle2D.Double)object).y;
            d5 = ((Rectangle2D.Double)object).width;
            d6 = ((Rectangle2D.Double)object).height;
            if (d6 <= 0.0) {
                return;
            }
        }
        svgGraphics.svgRectangle(d, d2, d5, d6, d3 / 2.0, d4 / 2.0, uRectangle.getDeltaShadow());
    }
}

