/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.visio;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.ugraphic.visio.VisioShape;

public class VisioText
implements VisioShape {
    private final int id;
    private final String text;
    private final int fontSize;
    private final double x;
    private final double y;
    private final double width;
    private final double height;
    private final double coefFont = 150.0;

    public static VisioText createInches(int n, String string, int n2, double d, double d2, double d3, double d4) {
        return new VisioText(n, string, n2, VisioText.toInches(d), VisioText.toInches(d2 + 2.5), VisioText.toInches(d3 * 1.8), VisioText.toInches(d4 * 1.8));
    }

    private static double toInches(double d) {
        return d / 72.0;
    }

    private VisioText(int n, String string, int n2, double d, double d2, double d3, double d4) {
        this.id = n;
        this.text = string;
        this.x = d;
        this.y = d2;
        this.height = d4;
        this.width = d3;
        this.fontSize = n2;
    }

    @Override
    public void print(OutputStream outputStream) throws IOException {
        this.out(outputStream, "<Shape ID='" + this.id + "' Type='Shape' LineStyle='1' FillStyle='1' TextStyle='3'>");
        this.out(outputStream, "<XForm>");
        this.out(outputStream, "<PinX>" + this.x + "</PinX>");
        this.out(outputStream, "<PinY>" + this.y + "</PinY>");
        this.out(outputStream, "<Width>" + this.width + "</Width>");
        this.out(outputStream, "<Height>" + this.height + "</Height>");
        this.out(outputStream, "<LocPinX F='Width*0'>0</LocPinX>");
        this.out(outputStream, "<LocPinY F='Height*0'>0</LocPinY>");
        this.out(outputStream, "<Angle>0</Angle>");
        this.out(outputStream, "<FlipX>0</FlipX>");
        this.out(outputStream, "<FlipY>0</FlipY>");
        this.out(outputStream, "<ResizeMode>0</ResizeMode>");
        this.out(outputStream, "</XForm>");
        this.out(outputStream, "<TextBlock>");
        this.out(outputStream, "<VerticalAlign>0</VerticalAlign>");
        this.out(outputStream, "</TextBlock>");
        this.out(outputStream, "<Char IX='" + this.id + "'>");
        this.out(outputStream, "<Font F='Inh'>0</Font>");
        this.out(outputStream, "<Color F='Inh'>0</Color>");
        this.out(outputStream, "<Style F='Inh'>0</Style>");
        this.out(outputStream, "<Case F='Inh'>0</Case>");
        this.out(outputStream, "<Pos F='Inh'>0</Pos>");
        this.out(outputStream, "<FontScale F='Inh'>1</FontScale>");
        this.out(outputStream, "<Locale F='Inh'>0</Locale>");
        this.out(outputStream, "<Size Unit='PT'>" + (double)this.fontSize / 150.0 + "</Size>");
        this.out(outputStream, "<DblUnderline F='Inh'>0</DblUnderline>");
        this.out(outputStream, "<Overline F='Inh'>0</Overline>");
        this.out(outputStream, "<Strikethru F='Inh'>0</Strikethru>");
        this.out(outputStream, "<Perpendicular F='Inh'>0</Perpendicular>");
        this.out(outputStream, "<Letterspace F='Inh'>0</Letterspace>");
        this.out(outputStream, "<ColorTrans F='Inh'>0</ColorTrans>");
        this.out(outputStream, "</Char>");
        this.out(outputStream, "<Para IX='" + this.id + "'>");
        this.out(outputStream, "<HorzAlign>0</HorzAlign>");
        this.out(outputStream, "</Para>");
        this.out(outputStream, "<Text><cp IX='" + this.id + "'/><pp IX='" + this.id + "'/>" + this.text + "</Text>");
        this.out(outputStream, "</Shape>");
    }

    @Override
    public VisioShape yReverse(double d) {
        double d2 = d - this.y;
        return new VisioText(this.id, this.text, this.fontSize, this.x, d2, this.width, this.height);
    }

    private void out(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
        outputStream.write("\n".getBytes());
    }
}

