# Migrating to Nautobot from NetBox

## Review the Release Notes

Be sure to carefully review all [release notes](../../release-notes/) that have been published. In particular, the [Nautobot 1.0 release notes](../../release-notes/version-1.0/) include an overview of key changes between NetBox 2.10 and Nautobot 1.0, while later release notes highlight incremental changes between Nautobot versions.

## Install Nautobot

Install Nautobot as described in [the documentation](../../installation/).

## Configure Nautobot

Although Nautobot will run perfectly well with a default configuration (such as generated by `nautobot-server init`, you may want to replicate aspects of your previous NetBox configuration to Nautobot. Refer to the [configuration documentation](../../configuration/) for details on the available options.

## Migrate database contents using `nautobot-netbox-importer`

Due to a number of significant infrastructural changes between the applications, you cannot simply point Nautobot at your existing NetBox PostgreSQL database and have it automatically load your data. Fortunately, Network to Code (NTC) and collaborators have developed a Nautobot plugin, `nautobot-netbox-importer`, that can be used to import a NetBox database dump file into Nautobot. For full details, refer to [the plugin's own documentation](https://github.com/nautobot/nautobot-plugin-netbox-importer/), but in brief, the following steps will be required:

1. Export your NetBox database to a JSON file using the `manage.py dumpdata` command
2. Install the `nautobot-netbox-importer` Nautobot plugin using `pip install nautobot-netbox-importer`
3. Enable the `nautobot-netbox-importer` plugin in your Nautobot configuration file
4. Run the command `nautobot-server import_netbox_json </path/to/netbox_dump.json> <netbox version, such as 2.10.4>`. This may take some time depending on the size of your database dump.
5. Connect to Nautobot and verify that your data has been successfully imported.

## Migrate files from NetBox to Nautobot

Uploaded media (device images, etc.) are stored on the filesystem rather than in the database and hence need to be migrated separately. The same is true for custom scripts and reports that you may wish to import.

### Copy uploaded media

The exact command will depend on where your [`MEDIA_ROOT`](../../configuration/optional-settings/#media_root) is configured in NetBox as well as where it's configured in Nautobot, but in general it will be:

```no-highlight
cp -pr $NETBOX_MEDIA_ROOT/* $NAUTOBOT_MEDIA_ROOT/*
```

### Copy custom scripts and reports

Similarly, the exact commands depend on your `SCRIPTS_ROOT` and `REPORTS_ROOT` settings in NetBox and your [`JOBS_ROOT`](../../configuration/optional-settings/#jobs_root) in Nautobot, but in general they will be:

```no-highlight
cp -pr $NETBOX_SCRIPTS_ROOT/* $NAUTOBOT_JOBS_ROOT/
cp -pr $NETBOX_REPORTS_ROOT/* $NAUTOBOT_JOBS_ROOT/
```

### Update scripts and reports for Nautobot compatibility

Depending on the complexity of your scripts and reports, and how tightly integrated with NetBox they were, it may be simple or complex to port them to be compatible with Nautobot, and we cannot possibly provide a generalized step-by-step guide that would cover all possibilities. One change that you will certainly have to make to even begin this process, however, is updating the Python module names for any modules that were being imported from NetBox:

- `circuits.* -> nautobot.circuits.*`
- `dcim.* -> nautobot.dcim.*`
- `extras.* -> nautobot.extras.*`
- `ipam.* -> nautobot.ipam.*`
- `netbox.* -> nautobot.core.*`
- `tenancy.* -> nautobot.tenancy.*`
- `utilities.* -> nautobot.utilities.*`
- `virtualization.* -> nautobot.virtualization.*`
