# coding: utf-8

"""
    Order API

    <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><span class=\"tablenote\"><b>Note:</b> This is a <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> API available only to select developers approved by business units.</span><br /><br />The Order API provides interfaces that let shoppers pay for items. It also returns payment and shipping status of the order.  # noqa: E501

    OpenAPI spec version: v2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ...buy_order.api_client import ApiClient


class GuestCheckoutSessionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def apply_guest_coupon(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """apply_guest_coupon  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method adds a coupon to an eBay guest checkout session and applies it to all the eligible items in the order.<br /><br />The <b>checkoutSessionId</b> is passed in as a URI parameter and is required. The redemption code of the coupon is in the payload and is also required.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/apply_coupon</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/apply_coupon</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_guest_coupon(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param CouponRequest body: The container for the fields used to apply a coupon to a guest checkout session.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.apply_guest_coupon_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.apply_guest_coupon_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
            return data

    def apply_guest_coupon_with_http_info(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """apply_guest_coupon  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method adds a coupon to an eBay guest checkout session and applies it to all the eligible items in the order.<br /><br />The <b>checkoutSessionId</b> is passed in as a URI parameter and is required. The redemption code of the coupon is in the payload and is also required.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/apply_coupon</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/apply_coupon</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_guest_coupon_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param CouponRequest body: The container for the fields used to apply a coupon to a guest checkout session.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_ebay_c_marketplace_id', 'checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method apply_guest_coupon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_ebay_c_marketplace_id' is set
        if ('x_ebay_c_marketplace_id' not in params or
                params['x_ebay_c_marketplace_id'] is None):
            raise ValueError("Missing the required parameter `x_ebay_c_marketplace_id` when calling `apply_guest_coupon`")  # noqa: E501
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `apply_guest_coupon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_ebay_c_marketplace_id' in params:
            header_params['X-EBAY-C-MARKETPLACE-ID'] = params['x_ebay_c_marketplace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/guest_checkout_session/{checkoutSessionId}/apply_coupon', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GuestCheckoutSessionResponseV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_guest_checkout_session(self, checkout_session_id, x_ebay_c_marketplace_id, **kwargs):  # noqa: E501
        """get_guest_checkout_session  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method returns the details of the specified guest checkout session. The <b>checkoutSessionId</b> is passed in as a URI parameter and is required. This method has no request payload.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_guest_checkout_session(checkout_session_id, x_ebay_c_marketplace_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_guest_checkout_session_with_http_info(checkout_session_id, x_ebay_c_marketplace_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_guest_checkout_session_with_http_info(checkout_session_id, x_ebay_c_marketplace_id, **kwargs)  # noqa: E501
            return data

    def get_guest_checkout_session_with_http_info(self, checkout_session_id, x_ebay_c_marketplace_id, **kwargs):  # noqa: E501
        """get_guest_checkout_session  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method returns the details of the specified guest checkout session. The <b>checkoutSessionId</b> is passed in as a URI parameter and is required. This method has no request payload.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_guest_checkout_session_with_http_info(checkout_session_id, x_ebay_c_marketplace_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id', 'x_ebay_c_marketplace_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guest_checkout_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `get_guest_checkout_session`")  # noqa: E501
        # verify the required parameter 'x_ebay_c_marketplace_id' is set
        if ('x_ebay_c_marketplace_id' not in params or
                params['x_ebay_c_marketplace_id'] is None):
            raise ValueError("Missing the required parameter `x_ebay_c_marketplace_id` when calling `get_guest_checkout_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_ebay_c_marketplace_id' in params:
            header_params['X-EBAY-C-MARKETPLACE-ID'] = params['x_ebay_c_marketplace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/guest_checkout_session/{checkoutSessionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GuestCheckoutSessionResponseV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def initiate_guest_checkout_session(self, x_ebay_c_marketplace_id, **kwargs):  # noqa: E501
        """initiate_guest_checkout_session  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method creates an eBay guest checkout session, which is the first step in performing a checkout. The method returns a <b>checkoutSessionId</b> that you use as a URI parameter in subsequent guest checkout methods.<br /><br />Also see <a href=\"/api-docs/buy/static/ref-buy-negative-testing.html\">Negative Testing Using Stubs</a> for information on how to emulate error conditions for this  method using stubs.<br /><br /><span class=\"tablenote\"><font color=\"006600\"><b>TIP:</b></font> To test the entire checkout flow, you might need a \"test\" credit card. You can generate a credit card number from <a href=\"http://www.getcreditcardnumbers.com\" target=\"_blank\">http://www.getcreditcardnumbers.com</a>.</span><br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/initiate</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/initiate</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.initiate_guest_checkout_session(x_ebay_c_marketplace_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param CreateGuestCheckoutSessionRequestV2 body: The container for the fields used by the <b>initiateGuestCheckoutSession</b> method.
        :param str x_ebay_c_enduserctx: A header that is used to specify the <b>affiliateCampaignId</b>, and optionally the <b>affiliateReferenceId</b>, to enable revenue sharing when the buyer purchases items.<br /><br /><span class=\"tablenote\"><font color=\"006600\"><b>TIP:</b></font> See <a href=\"/api-docs/buy/static/api-browse.html#Headers\" target=\"_blank\">Request headers</a> in the Buying Integration Guide for more information.</span>
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.initiate_guest_checkout_session_with_http_info(x_ebay_c_marketplace_id, **kwargs)  # noqa: E501
        else:
            (data) = self.initiate_guest_checkout_session_with_http_info(x_ebay_c_marketplace_id, **kwargs)  # noqa: E501
            return data

    def initiate_guest_checkout_session_with_http_info(self, x_ebay_c_marketplace_id, **kwargs):  # noqa: E501
        """initiate_guest_checkout_session  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method creates an eBay guest checkout session, which is the first step in performing a checkout. The method returns a <b>checkoutSessionId</b> that you use as a URI parameter in subsequent guest checkout methods.<br /><br />Also see <a href=\"/api-docs/buy/static/ref-buy-negative-testing.html\">Negative Testing Using Stubs</a> for information on how to emulate error conditions for this  method using stubs.<br /><br /><span class=\"tablenote\"><font color=\"006600\"><b>TIP:</b></font> To test the entire checkout flow, you might need a \"test\" credit card. You can generate a credit card number from <a href=\"http://www.getcreditcardnumbers.com\" target=\"_blank\">http://www.getcreditcardnumbers.com</a>.</span><br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/initiate</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/initiate</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.initiate_guest_checkout_session_with_http_info(x_ebay_c_marketplace_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param CreateGuestCheckoutSessionRequestV2 body: The container for the fields used by the <b>initiateGuestCheckoutSession</b> method.
        :param str x_ebay_c_enduserctx: A header that is used to specify the <b>affiliateCampaignId</b>, and optionally the <b>affiliateReferenceId</b>, to enable revenue sharing when the buyer purchases items.<br /><br /><span class=\"tablenote\"><font color=\"006600\"><b>TIP:</b></font> See <a href=\"/api-docs/buy/static/api-browse.html#Headers\" target=\"_blank\">Request headers</a> in the Buying Integration Guide for more information.</span>
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_ebay_c_marketplace_id', 'body', 'x_ebay_c_enduserctx']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method initiate_guest_checkout_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_ebay_c_marketplace_id' is set
        if ('x_ebay_c_marketplace_id' not in params or
                params['x_ebay_c_marketplace_id'] is None):
            raise ValueError("Missing the required parameter `x_ebay_c_marketplace_id` when calling `initiate_guest_checkout_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_ebay_c_enduserctx' in params:
            header_params['X-EBAY-C-ENDUSERCTX'] = params['x_ebay_c_enduserctx']  # noqa: E501
        if 'x_ebay_c_marketplace_id' in params:
            header_params['X-EBAY-C-MARKETPLACE-ID'] = params['x_ebay_c_marketplace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/guest_checkout_session/initiate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GuestCheckoutSessionResponseV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_guest_coupon(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """remove_guest_coupon  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method removes a coupon from an eBay guest checkout session. The <b>checkoutSessionId</b> is passed in as a URI parameter and is required. The redemption code of the coupon is specified in the payload and is also required.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/remove_coupon</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/remove_coupon</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_guest_coupon(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param CouponRequest body: The container for the fields used by the <b>removeGuestCoupon</b> method.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_guest_coupon_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_guest_coupon_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
            return data

    def remove_guest_coupon_with_http_info(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """remove_guest_coupon  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method removes a coupon from an eBay guest checkout session. The <b>checkoutSessionId</b> is passed in as a URI parameter and is required. The redemption code of the coupon is specified in the payload and is also required.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/remove_coupon</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/remove_coupon</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_guest_coupon_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param CouponRequest body: The container for the fields used by the <b>removeGuestCoupon</b> method.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_ebay_c_marketplace_id', 'checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_guest_coupon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_ebay_c_marketplace_id' is set
        if ('x_ebay_c_marketplace_id' not in params or
                params['x_ebay_c_marketplace_id'] is None):
            raise ValueError("Missing the required parameter `x_ebay_c_marketplace_id` when calling `remove_guest_coupon`")  # noqa: E501
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `remove_guest_coupon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_ebay_c_marketplace_id' in params:
            header_params['X-EBAY-C-MARKETPLACE-ID'] = params['x_ebay_c_marketplace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/guest_checkout_session/{checkoutSessionId}/remove_coupon', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GuestCheckoutSessionResponseV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_guest_quantity(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """update_guest_quantity  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method changes the quantity of the specified line item in an eBay guest checkout session.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_quantity</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_quantity</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_guest_quantity(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param UpdateQuantity body: The container for the fields used by the <b>updateGuestQuantity</b> method.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_guest_quantity_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_guest_quantity_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
            return data

    def update_guest_quantity_with_http_info(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """update_guest_quantity  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method changes the quantity of the specified line item in an eBay guest checkout session.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_quantity</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_quantity</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_guest_quantity_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param UpdateQuantity body: The container for the fields used by the <b>updateGuestQuantity</b> method.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_ebay_c_marketplace_id', 'checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_guest_quantity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_ebay_c_marketplace_id' is set
        if ('x_ebay_c_marketplace_id' not in params or
                params['x_ebay_c_marketplace_id'] is None):
            raise ValueError("Missing the required parameter `x_ebay_c_marketplace_id` when calling `update_guest_quantity`")  # noqa: E501
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `update_guest_quantity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_ebay_c_marketplace_id' in params:
            header_params['X-EBAY-C-MARKETPLACE-ID'] = params['x_ebay_c_marketplace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/guest_checkout_session/{checkoutSessionId}/update_quantity', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GuestCheckoutSessionResponseV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_guest_shipping_address(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """update_guest_shipping_address  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method changes the shipping address for the order in an eBay guest checkout session. All the line items in an order must be shipped to the same address, but the shipping method can be specific to the line item.<br /><br /><span class=\"tablenote\"><b>Note:</b> If the address submitted cannot be validated, a warning message will be returned. This does not prevent the method from executing, but you may want to verify the address.</span><br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_shipping_address</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_shipping_address</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_guest_shipping_address(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param ShippingAddressImpl body: The container for the fields used by the <b>updateGuestShippingAddress</b> method.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_guest_shipping_address_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_guest_shipping_address_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
            return data

    def update_guest_shipping_address_with_http_info(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """update_guest_shipping_address  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method changes the shipping address for the order in an eBay guest checkout session. All the line items in an order must be shipped to the same address, but the shipping method can be specific to the line item.<br /><br /><span class=\"tablenote\"><b>Note:</b> If the address submitted cannot be validated, a warning message will be returned. This does not prevent the method from executing, but you may want to verify the address.</span><br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_shipping_address</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_shipping_address</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_guest_shipping_address_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param ShippingAddressImpl body: The container for the fields used by the <b>updateGuestShippingAddress</b> method.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_ebay_c_marketplace_id', 'checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_guest_shipping_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_ebay_c_marketplace_id' is set
        if ('x_ebay_c_marketplace_id' not in params or
                params['x_ebay_c_marketplace_id'] is None):
            raise ValueError("Missing the required parameter `x_ebay_c_marketplace_id` when calling `update_guest_shipping_address`")  # noqa: E501
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `update_guest_shipping_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_ebay_c_marketplace_id' in params:
            header_params['X-EBAY-C-MARKETPLACE-ID'] = params['x_ebay_c_marketplace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/guest_checkout_session/{checkoutSessionId}/update_shipping_address', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GuestCheckoutSessionResponseV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_guest_shipping_option(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """update_guest_shipping_option  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method changes the shipping method for the specified line item in an eBay guest checkout session. The shipping option can be set for each line item. This gives the shopper the ability choose the cost of shipping for each line item.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL: </b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_shipping_option</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_shipping_option</code></li> </ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_guest_shipping_option(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param UpdateShippingOption body: The container for the fields used by the <b>updateGuestShippingOption</b> method.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_guest_shipping_option_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_guest_shipping_option_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, **kwargs)  # noqa: E501
            return data

    def update_guest_shipping_option_with_http_info(self, x_ebay_c_marketplace_id, checkout_session_id, **kwargs):  # noqa: E501
        """update_guest_shipping_option  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method changes the shipping method for the specified line item in an eBay guest checkout session. The shipping option can be set for each line item. This gives the shopper the ability choose the cost of shipping for each line item.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL: </b> <code>https://apix.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_shipping_option</code></li><li><b>Sandbox URL:</b> <code>https://apix.sandbox.ebay.com/buy/order/v2/guest_checkout_session/{checkoutSessionId}/update_shipping_option</code></li> </ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_guest_shipping_option_with_http_info(x_ebay_c_marketplace_id, checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_ebay_c_marketplace_id: A header that identifies the user's business context and is specified using a marketplace ID value.<br /><br /><span class=\"tablenote\"><b>Note:</b> This header does <i>not</i> indicate a language preference or consumer location.</span><br /><br />See <a href=\"/api-docs/static/rest-request-components.html#marketpl\" target=\"_blank\">Marketplace ID values</a> for a list of supported values. (required)
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the <b> initiateGuestCheckoutSession</b> method.<br /><br /><span class=\"tablenote\"><b>Note:</b> When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as that used when this guest checkout session was created. See <a href=\"/api-docs/buy/order/overview.html#checkout-restriction\">Checkout session restrictions</a> in the Buy Integration Guide for details.</span> (required)
        :param UpdateShippingOption body: The container for the fields used by the <b>updateGuestShippingOption</b> method.
        :return: GuestCheckoutSessionResponseV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_ebay_c_marketplace_id', 'checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_guest_shipping_option" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_ebay_c_marketplace_id' is set
        if ('x_ebay_c_marketplace_id' not in params or
                params['x_ebay_c_marketplace_id'] is None):
            raise ValueError("Missing the required parameter `x_ebay_c_marketplace_id` when calling `update_guest_shipping_option`")  # noqa: E501
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `update_guest_shipping_option`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_ebay_c_marketplace_id' in params:
            header_params['X-EBAY-C-MARKETPLACE-ID'] = params['x_ebay_c_marketplace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/guest_checkout_session/{checkoutSessionId}/update_shipping_option', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GuestCheckoutSessionResponseV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
