# coding: utf-8

"""
    Order API

    <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><span class=\"tablenote\"><b>Note:</b> This is a <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> API available only to select developers approved by business units.</span><br /><br />The Order API provides interfaces that let shoppers pay for items. It also returns payment and shipping status of the order.  # noqa: E501

    OpenAPI spec version: v2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ...buy_order.api_client import ApiClient


class GuestPurchaseOrderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_guest_purchase_order(self, purchase_order_id, **kwargs):  # noqa: E501
        """get_guest_purchase_order  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method retrieves the details about a specific guest purchase order. It returns the line items, including purchase  order status, dates created and modified, item quantity and listing data, payment and shipping information, and prices, taxes, discounts and credits.<br /><br />The <b>purchaseOrderId</b> is passed in as a URI parameter and is required.<br /><br /><span class=\"tablenote\"><b>Note:</b> The <b>purchaseOrderId</b> value is returned in the call-back URL that is sent through the new eBay pay widget. For more information about eBay managed payments and the new Order API payment flow, see <a href=\"/api-docs/buy/static/api-order.html\">Order API</a> in the Buying Integration Guide.</span><br /><br />You can use this method to not only get the details of a purchase order, but to check the value of the <a href=\"#response.purchaseOrderPaymentStatus\">purchaseOrderPaymentStatus</a> field to determine if the order has been paid for. If the order has been paid for, this field will return <code>PAID</code>.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://api.ebay.com/buy/order/v2/guest_purchase_order/{purchaseOrderId}</code></li><li><b>Sandbox URL:</b> <code>https://api.sandbox.ebay.com/buy/order/v2/guest_purchase_order/{purchaseOrderId}</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_guest_purchase_order(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str purchase_order_id: The unique identifier of a purchase order made by a guest buyer, for which details are to be retrieved.<br /><br /><span class=\"tablenote\"><b>Note:</b> This value is returned in the response URL that is sent through the new eBay pay widget. For more information about eBay managed payments and the new Order API payment flow, see <a href=\"/api-docs/buy/static/api-order.html\">Order API</a> in the Buying Integration Guide.</span> (required)
        :return: GuestPurchaseOrderV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_guest_purchase_order_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_guest_purchase_order_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
            return data

    def get_guest_purchase_order_with_http_info(self, purchase_order_id, **kwargs):  # noqa: E501
        """get_guest_purchase_order  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> This method is only available to select developers approved by business units.<br /><br />This method retrieves the details about a specific guest purchase order. It returns the line items, including purchase  order status, dates created and modified, item quantity and listing data, payment and shipping information, and prices, taxes, discounts and credits.<br /><br />The <b>purchaseOrderId</b> is passed in as a URI parameter and is required.<br /><br /><span class=\"tablenote\"><b>Note:</b> The <b>purchaseOrderId</b> value is returned in the call-back URL that is sent through the new eBay pay widget. For more information about eBay managed payments and the new Order API payment flow, see <a href=\"/api-docs/buy/static/api-order.html\">Order API</a> in the Buying Integration Guide.</span><br /><br />You can use this method to not only get the details of a purchase order, but to check the value of the <a href=\"#response.purchaseOrderPaymentStatus\">purchaseOrderPaymentStatus</a> field to determine if the order has been paid for. If the order has been paid for, this field will return <code>PAID</code>.<br /><br />For a list of supported sites and other restrictions, see <a href=\"/api-docs/buy/order/overview.html#API\">API Restrictions</a> in the Order API overview.<br /><br />The URLs for this method are:<ul><li><b>Production URL:</b> <code>https://api.ebay.com/buy/order/v2/guest_purchase_order/{purchaseOrderId}</code></li><li><b>Sandbox URL:</b> <code>https://api.sandbox.ebay.com/buy/order/v2/guest_purchase_order/{purchaseOrderId}</code></li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_guest_purchase_order_with_http_info(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str purchase_order_id: The unique identifier of a purchase order made by a guest buyer, for which details are to be retrieved.<br /><br /><span class=\"tablenote\"><b>Note:</b> This value is returned in the response URL that is sent through the new eBay pay widget. For more information about eBay managed payments and the new Order API payment flow, see <a href=\"/api-docs/buy/static/api-order.html\">Order API</a> in the Buying Integration Guide.</span> (required)
        :return: GuestPurchaseOrderV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guest_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `get_guest_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchaseOrderId'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/guest_purchase_order/{purchaseOrderId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GuestPurchaseOrderV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
