# coding: utf-8

"""
    Order API

    <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><span class=\"tablenote\"><b>Note:</b> This is a <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> API available only to select developers approved by business units.</span><br /><br />The Order API provides interfaces that let shoppers pay for items. It also returns payment and shipping status of the order.  # noqa: E501

    OpenAPI spec version: v2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GuestPurchaseOrderV2(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'line_items': 'list[OrderLineItemV2]',
        'pricing_summary': 'PricingSummary',
        'purchase_order_creation_date': 'str',
        'purchase_order_id': 'str',
        'purchase_order_payment_status': 'str',
        'purchase_order_status': 'str',
        'refunded_amount': 'Amount',
        'warnings': 'list[Error]'
    }

    attribute_map = {
        'line_items': 'lineItems',
        'pricing_summary': 'pricingSummary',
        'purchase_order_creation_date': 'purchaseOrderCreationDate',
        'purchase_order_id': 'purchaseOrderId',
        'purchase_order_payment_status': 'purchaseOrderPaymentStatus',
        'purchase_order_status': 'purchaseOrderStatus',
        'refunded_amount': 'refundedAmount',
        'warnings': 'warnings'
    }

    def __init__(self, line_items=None, pricing_summary=None, purchase_order_creation_date=None, purchase_order_id=None, purchase_order_payment_status=None, purchase_order_status=None, refunded_amount=None, warnings=None):  # noqa: E501
        """GuestPurchaseOrderV2 - a model defined in Swagger"""  # noqa: E501
        self._line_items = None
        self._pricing_summary = None
        self._purchase_order_creation_date = None
        self._purchase_order_id = None
        self._purchase_order_payment_status = None
        self._purchase_order_status = None
        self._refunded_amount = None
        self._warnings = None
        self.discriminator = None
        if line_items is not None:
            self.line_items = line_items
        if pricing_summary is not None:
            self.pricing_summary = pricing_summary
        if purchase_order_creation_date is not None:
            self.purchase_order_creation_date = purchase_order_creation_date
        if purchase_order_id is not None:
            self.purchase_order_id = purchase_order_id
        if purchase_order_payment_status is not None:
            self.purchase_order_payment_status = purchase_order_payment_status
        if purchase_order_status is not None:
            self.purchase_order_status = purchase_order_status
        if refunded_amount is not None:
            self.refunded_amount = refunded_amount
        if warnings is not None:
            self.warnings = warnings

    @property
    def line_items(self):
        """Gets the line_items of this GuestPurchaseOrderV2.  # noqa: E501

        An array of line items in the order.  # noqa: E501

        :return: The line_items of this GuestPurchaseOrderV2.  # noqa: E501
        :rtype: list[OrderLineItemV2]
        """
        return self._line_items

    @line_items.setter
    def line_items(self, line_items):
        """Sets the line_items of this GuestPurchaseOrderV2.

        An array of line items in the order.  # noqa: E501

        :param line_items: The line_items of this GuestPurchaseOrderV2.  # noqa: E501
        :type: list[OrderLineItemV2]
        """

        self._line_items = line_items

    @property
    def pricing_summary(self):
        """Gets the pricing_summary of this GuestPurchaseOrderV2.  # noqa: E501


        :return: The pricing_summary of this GuestPurchaseOrderV2.  # noqa: E501
        :rtype: PricingSummary
        """
        return self._pricing_summary

    @pricing_summary.setter
    def pricing_summary(self, pricing_summary):
        """Sets the pricing_summary of this GuestPurchaseOrderV2.


        :param pricing_summary: The pricing_summary of this GuestPurchaseOrderV2.  # noqa: E501
        :type: PricingSummary
        """

        self._pricing_summary = pricing_summary

    @property
    def purchase_order_creation_date(self):
        """Gets the purchase_order_creation_date of this GuestPurchaseOrderV2.  # noqa: E501

        The creation date of the purchase order.  # noqa: E501

        :return: The purchase_order_creation_date of this GuestPurchaseOrderV2.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_creation_date

    @purchase_order_creation_date.setter
    def purchase_order_creation_date(self, purchase_order_creation_date):
        """Sets the purchase_order_creation_date of this GuestPurchaseOrderV2.

        The creation date of the purchase order.  # noqa: E501

        :param purchase_order_creation_date: The purchase_order_creation_date of this GuestPurchaseOrderV2.  # noqa: E501
        :type: str
        """

        self._purchase_order_creation_date = purchase_order_creation_date

    @property
    def purchase_order_id(self):
        """Gets the purchase_order_id of this GuestPurchaseOrderV2.  # noqa: E501

        The unique identifier of the purchase order.  # noqa: E501

        :return: The purchase_order_id of this GuestPurchaseOrderV2.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_id

    @purchase_order_id.setter
    def purchase_order_id(self, purchase_order_id):
        """Sets the purchase_order_id of this GuestPurchaseOrderV2.

        The unique identifier of the purchase order.  # noqa: E501

        :param purchase_order_id: The purchase_order_id of this GuestPurchaseOrderV2.  # noqa: E501
        :type: str
        """

        self._purchase_order_id = purchase_order_id

    @property
    def purchase_order_payment_status(self):
        """Gets the purchase_order_payment_status of this GuestPurchaseOrderV2.  # noqa: E501

        A container that returns the payment status for the purchase order. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PurchaseOrderPaymentStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The purchase_order_payment_status of this GuestPurchaseOrderV2.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_payment_status

    @purchase_order_payment_status.setter
    def purchase_order_payment_status(self, purchase_order_payment_status):
        """Sets the purchase_order_payment_status of this GuestPurchaseOrderV2.

        A container that returns the payment status for the purchase order. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PurchaseOrderPaymentStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param purchase_order_payment_status: The purchase_order_payment_status of this GuestPurchaseOrderV2.  # noqa: E501
        :type: str
        """

        self._purchase_order_payment_status = purchase_order_payment_status

    @property
    def purchase_order_status(self):
        """Gets the purchase_order_status of this GuestPurchaseOrderV2.  # noqa: E501

        An enumeration value that indicates the current status of the buyer's payment and any refund that applies to the purchase order. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PurchaseOrderStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The purchase_order_status of this GuestPurchaseOrderV2.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_status

    @purchase_order_status.setter
    def purchase_order_status(self, purchase_order_status):
        """Sets the purchase_order_status of this GuestPurchaseOrderV2.

        An enumeration value that indicates the current status of the buyer's payment and any refund that applies to the purchase order. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PurchaseOrderStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param purchase_order_status: The purchase_order_status of this GuestPurchaseOrderV2.  # noqa: E501
        :type: str
        """

        self._purchase_order_status = purchase_order_status

    @property
    def refunded_amount(self):
        """Gets the refunded_amount of this GuestPurchaseOrderV2.  # noqa: E501


        :return: The refunded_amount of this GuestPurchaseOrderV2.  # noqa: E501
        :rtype: Amount
        """
        return self._refunded_amount

    @refunded_amount.setter
    def refunded_amount(self, refunded_amount):
        """Sets the refunded_amount of this GuestPurchaseOrderV2.


        :param refunded_amount: The refunded_amount of this GuestPurchaseOrderV2.  # noqa: E501
        :type: Amount
        """

        self._refunded_amount = refunded_amount

    @property
    def warnings(self):
        """Gets the warnings of this GuestPurchaseOrderV2.  # noqa: E501

        A container for any warning messages.  # noqa: E501

        :return: The warnings of this GuestPurchaseOrderV2.  # noqa: E501
        :rtype: list[Error]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this GuestPurchaseOrderV2.

        A container for any warning messages.  # noqa: E501

        :param warnings: The warnings of this GuestPurchaseOrderV2.  # noqa: E501
        :type: list[Error]
        """

        self._warnings = warnings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GuestPurchaseOrderV2, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GuestPurchaseOrderV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
