# coding: utf-8

"""
    Order API

    <span class=\"tablenote\"><b>Note:</b> This version of the Order API (v2) currently only supports the guest payment flow for eBay managed payments. To view the v1_beta version of the Order API, which includes both member and guest checkout payment flows, refer to the <a href=\"/api-docs/buy/order_v1/resources/methods\">Order_v1 API</a> documentation.</span><br /><br /><span class=\"tablenote\"><b>Note:</b> This is a <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"><img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\"  alt=\"Limited Release\" title=\"Limited Release\" />(Limited Release)</a> API available only to select developers approved by business units.</span><br /><br />The Order API provides interfaces that let shoppers pay for items. It also returns payment and shipping status of the order.  # noqa: E501

    OpenAPI spec version: v2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class LegacyReference(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'legacy_item_id': 'str',
        'legacy_order_id': 'str',
        'legacy_transaction_id': 'str'
    }

    attribute_map = {
        'legacy_item_id': 'legacyItemId',
        'legacy_order_id': 'legacyOrderId',
        'legacy_transaction_id': 'legacyTransactionId'
    }

    def __init__(self, legacy_item_id=None, legacy_order_id=None, legacy_transaction_id=None):  # noqa: E501
        """LegacyReference - a model defined in Swagger"""  # noqa: E501
        self._legacy_item_id = None
        self._legacy_order_id = None
        self._legacy_transaction_id = None
        self.discriminator = None
        if legacy_item_id is not None:
            self.legacy_item_id = legacy_item_id
        if legacy_order_id is not None:
            self.legacy_order_id = legacy_order_id
        if legacy_transaction_id is not None:
            self.legacy_transaction_id = legacy_transaction_id

    @property
    def legacy_item_id(self):
        """Gets the legacy_item_id of this LegacyReference.  # noqa: E501

        The legacy ID used to identify an item.<br /><br />This is used by the Post Order API <a href=\"https://developer.ebay.com/Devzone/post-order/post-order_v2_return__post.html\" target=\"_blank\">Create Return Request</a> method. This call initiates the item return process. For more information on how to use this field in the Post Order API, see <a href=\"/api-docs/buy/static/api-order.html#return-request\">Create a return request</a> in the Buy Integration Guide.<br /><br /><b> Restriction:</b> The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :return: The legacy_item_id of this LegacyReference.  # noqa: E501
        :rtype: str
        """
        return self._legacy_item_id

    @legacy_item_id.setter
    def legacy_item_id(self, legacy_item_id):
        """Sets the legacy_item_id of this LegacyReference.

        The legacy ID used to identify an item.<br /><br />This is used by the Post Order API <a href=\"https://developer.ebay.com/Devzone/post-order/post-order_v2_return__post.html\" target=\"_blank\">Create Return Request</a> method. This call initiates the item return process. For more information on how to use this field in the Post Order API, see <a href=\"/api-docs/buy/static/api-order.html#return-request\">Create a return request</a> in the Buy Integration Guide.<br /><br /><b> Restriction:</b> The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :param legacy_item_id: The legacy_item_id of this LegacyReference.  # noqa: E501
        :type: str
        """

        self._legacy_item_id = legacy_item_id

    @property
    def legacy_order_id(self):
        """Gets the legacy_order_id of this LegacyReference.  # noqa: E501

        The legacy ID of the order.<br /><br />This is used by the Post Order API <a href=\"https://developer.ebay.com/Devzone/post-order/post-order_v2_cancellation__post.html\" target=\"_blank\">Submit Cancellation Request</a> method. This method initiates the item cancellation process. For more information on how to use this field in the Post Order API, see <a href=\"/api-docs/buy/static/api-order.html#using\">Using the Post Order API</a>.<br /><br /><b>Restriction:</b> The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :return: The legacy_order_id of this LegacyReference.  # noqa: E501
        :rtype: str
        """
        return self._legacy_order_id

    @legacy_order_id.setter
    def legacy_order_id(self, legacy_order_id):
        """Sets the legacy_order_id of this LegacyReference.

        The legacy ID of the order.<br /><br />This is used by the Post Order API <a href=\"https://developer.ebay.com/Devzone/post-order/post-order_v2_cancellation__post.html\" target=\"_blank\">Submit Cancellation Request</a> method. This method initiates the item cancellation process. For more information on how to use this field in the Post Order API, see <a href=\"/api-docs/buy/static/api-order.html#using\">Using the Post Order API</a>.<br /><br /><b>Restriction:</b> The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :param legacy_order_id: The legacy_order_id of this LegacyReference.  # noqa: E501
        :type: str
        """

        self._legacy_order_id = legacy_order_id

    @property
    def legacy_transaction_id(self):
        """Gets the legacy_transaction_id of this LegacyReference.  # noqa: E501

        The legacy ID of the transaction.<br /><br />This is used by the Post Order API <a href=\"https://developer.ebay.com/devzone/post-order/post-order_v2_return__post.html\" target=\"_blank\">Create Return Request</a> call. This call initiates the item return process. For more information on how to use this field in the Post Order API, see <a href=\"/api-docs/buy/static/api-order.html#using\">Using the Post Order API</a> in the Buy Integration Guide.<br /><br /><b>Restriction:</b> The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :return: The legacy_transaction_id of this LegacyReference.  # noqa: E501
        :rtype: str
        """
        return self._legacy_transaction_id

    @legacy_transaction_id.setter
    def legacy_transaction_id(self, legacy_transaction_id):
        """Sets the legacy_transaction_id of this LegacyReference.

        The legacy ID of the transaction.<br /><br />This is used by the Post Order API <a href=\"https://developer.ebay.com/devzone/post-order/post-order_v2_return__post.html\" target=\"_blank\">Create Return Request</a> call. This call initiates the item return process. For more information on how to use this field in the Post Order API, see <a href=\"/api-docs/buy/static/api-order.html#using\">Using the Post Order API</a> in the Buy Integration Guide.<br /><br /><b>Restriction:</b> The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :param legacy_transaction_id: The legacy_transaction_id of this LegacyReference.  # noqa: E501
        :type: str
        """

        self._legacy_transaction_id = legacy_transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LegacyReference, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LegacyReference):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
