# coding: utf-8

"""
    Catalog API

    The Catalog API allows users to search for and locate an eBay catalog product that is a direct match for the product that they wish to sell. Listing against an eBay catalog product helps insure that all listings (based off of that catalog product) have complete and accurate information. In addition to helping to create high-quality listings, another benefit to the seller of using catalog information to create listings is that much of the details of the listing will be prefilled, including the listing title, the listing description, the item specifics, and a stock image for the product (if available). Sellers will not have to enter item specifics themselves, and the overall listing process is a lot faster and easier.  # noqa: E501

    OpenAPI spec version: v1_beta.5.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Aspect(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'localized_name': 'str',
        'localized_values': 'list[str]'
    }

    attribute_map = {
        'localized_name': 'localizedName',
        'localized_values': 'localizedValues'
    }

    def __init__(self, localized_name=None, localized_values=None):  # noqa: E501
        """Aspect - a model defined in Swagger"""  # noqa: E501
        self._localized_name = None
        self._localized_values = None
        self.discriminator = None
        if localized_name is not None:
            self.localized_name = localized_name
        if localized_values is not None:
            self.localized_values = localized_values

    @property
    def localized_name(self):
        """Gets the localized_name of this Aspect.  # noqa: E501

        The localized name of this category aspect.  # noqa: E501

        :return: The localized_name of this Aspect.  # noqa: E501
        :rtype: str
        """
        return self._localized_name

    @localized_name.setter
    def localized_name(self, localized_name):
        """Sets the localized_name of this Aspect.

        The localized name of this category aspect.  # noqa: E501

        :param localized_name: The localized_name of this Aspect.  # noqa: E501
        :type: str
        """

        self._localized_name = localized_name

    @property
    def localized_values(self):
        """Gets the localized_values of this Aspect.  # noqa: E501

        A list of the localized values of this category aspect.  # noqa: E501

        :return: The localized_values of this Aspect.  # noqa: E501
        :rtype: list[str]
        """
        return self._localized_values

    @localized_values.setter
    def localized_values(self, localized_values):
        """Sets the localized_values of this Aspect.

        A list of the localized values of this category aspect.  # noqa: E501

        :param localized_values: The localized_values of this Aspect.  # noqa: E501
        :type: list[str]
        """

        self._localized_values = localized_values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Aspect, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Aspect):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
