# coding: utf-8

"""
    Catalog API

    The Catalog API allows users to search for and locate an eBay catalog product that is a direct match for the product that they wish to sell. Listing against an eBay catalog product helps insure that all listings (based off of that catalog product) have complete and accurate information. In addition to helping to create high-quality listings, another benefit to the seller of using catalog information to create listings is that much of the details of the listing will be prefilled, including the listing title, the listing description, the item specifics, and a stock image for the product (if available). Sellers will not have to enter item specifics themselves, and the overall listing process is a lot faster and easier.  # noqa: E501

    OpenAPI spec version: v1_beta.5.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AspectValueDistribution(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'localized_aspect_value': 'str',
        'match_count': 'int',
        'refinement_href': 'str'
    }

    attribute_map = {
        'localized_aspect_value': 'localizedAspectValue',
        'match_count': 'matchCount',
        'refinement_href': 'refinementHref'
    }

    def __init__(self, localized_aspect_value=None, match_count=None, refinement_href=None):  # noqa: E501
        """AspectValueDistribution - a model defined in Swagger"""  # noqa: E501
        self._localized_aspect_value = None
        self._match_count = None
        self._refinement_href = None
        self.discriminator = None
        if localized_aspect_value is not None:
            self.localized_aspect_value = localized_aspect_value
        if match_count is not None:
            self.match_count = match_count
        if refinement_href is not None:
            self.refinement_href = refinement_href

    @property
    def localized_aspect_value(self):
        """Gets the localized_aspect_value of this AspectValueDistribution.  # noqa: E501

        The localized value of the category aspect identified by refinement.aspectDistributions.localizedAspectName.  # noqa: E501

        :return: The localized_aspect_value of this AspectValueDistribution.  # noqa: E501
        :rtype: str
        """
        return self._localized_aspect_value

    @localized_aspect_value.setter
    def localized_aspect_value(self, localized_aspect_value):
        """Sets the localized_aspect_value of this AspectValueDistribution.

        The localized value of the category aspect identified by refinement.aspectDistributions.localizedAspectName.  # noqa: E501

        :param localized_aspect_value: The localized_aspect_value of this AspectValueDistribution.  # noqa: E501
        :type: str
        """

        self._localized_aspect_value = localized_aspect_value

    @property
    def match_count(self):
        """Gets the match_count of this AspectValueDistribution.  # noqa: E501

        The number of times the value of localizedAspectValue has been used for eBay product listings. By comparing this quantity to the matchCount for other values of the same aspect, you can present a histogram of the values to sellers, who can use that information to select which aspect value is most appropriate for their product. You can then include the user-selected value in the the search call's aspect_filter parameter to refine your search.  # noqa: E501

        :return: The match_count of this AspectValueDistribution.  # noqa: E501
        :rtype: int
        """
        return self._match_count

    @match_count.setter
    def match_count(self, match_count):
        """Sets the match_count of this AspectValueDistribution.

        The number of times the value of localizedAspectValue has been used for eBay product listings. By comparing this quantity to the matchCount for other values of the same aspect, you can present a histogram of the values to sellers, who can use that information to select which aspect value is most appropriate for their product. You can then include the user-selected value in the the search call's aspect_filter parameter to refine your search.  # noqa: E501

        :param match_count: The match_count of this AspectValueDistribution.  # noqa: E501
        :type: int
        """

        self._match_count = match_count

    @property
    def refinement_href(self):
        """Gets the refinement_href of this AspectValueDistribution.  # noqa: E501

        A HATEOAS reference that further refines the search with this particular localizedAspectValue.  # noqa: E501

        :return: The refinement_href of this AspectValueDistribution.  # noqa: E501
        :rtype: str
        """
        return self._refinement_href

    @refinement_href.setter
    def refinement_href(self, refinement_href):
        """Sets the refinement_href of this AspectValueDistribution.

        A HATEOAS reference that further refines the search with this particular localizedAspectValue.  # noqa: E501

        :param refinement_href: The refinement_href of this AspectValueDistribution.  # noqa: E501
        :type: str
        """

        self._refinement_href = refinement_href

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AspectValueDistribution, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AspectValueDistribution):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
