# coding: utf-8

"""
    Identity API

    <span class=\"tablenote\"><b>Note:</b> This is a <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> API available only to select developers approved by business units.</span><br /><br />Retrieves the authenticated user's account profile information. It can be used to let users log into your app or site using eBay, which frees you from needing to store and protect user's PII (Personal Identifiable Information) data.  # noqa: E501

    OpenAPI spec version: v1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Phone(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'country_code': 'str',
        'number': 'str',
        'phone_type': 'str'
    }

    attribute_map = {
        'country_code': 'countryCode',
        'number': 'number',
        'phone_type': 'phoneType'
    }

    def __init__(self, country_code=None, number=None, phone_type=None):  # noqa: E501
        """Phone - a model defined in Swagger"""  # noqa: E501
        self._country_code = None
        self._number = None
        self._phone_type = None
        self.discriminator = None
        if country_code is not None:
            self.country_code = country_code
        if number is not None:
            self.number = number
        if phone_type is not None:
            self.phone_type = phone_type

    @property
    def country_code(self):
        """Gets the country_code of this Phone.  # noqa: E501

        The two-letter ISO 3166 standard of the country to which the phone number belongs.  # noqa: E501

        :return: The country_code of this Phone.  # noqa: E501
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code):
        """Sets the country_code of this Phone.

        The two-letter ISO 3166 standard of the country to which the phone number belongs.  # noqa: E501

        :param country_code: The country_code of this Phone.  # noqa: E501
        :type: str
        """

        self._country_code = country_code

    @property
    def number(self):
        """Gets the number of this Phone.  # noqa: E501

        The numeric string representing the phone number.  # noqa: E501

        :return: The number of this Phone.  # noqa: E501
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this Phone.

        The numeric string representing the phone number.  # noqa: E501

        :param number: The number of this Phone.  # noqa: E501
        :type: str
        """

        self._number = number

    @property
    def phone_type(self):
        """Gets the phone_type of this Phone.  # noqa: E501

        The type of phone service. Valid Values: MOBILE or LAND_LINE Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The phone_type of this Phone.  # noqa: E501
        :rtype: str
        """
        return self._phone_type

    @phone_type.setter
    def phone_type(self, phone_type):
        """Sets the phone_type of this Phone.

        The type of phone service. Valid Values: MOBILE or LAND_LINE Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param phone_type: The phone_type of this Phone.  # noqa: E501
        :type: str
        """

        self._phone_type = phone_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Phone, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Phone):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
