# coding: utf-8

"""
    Media API

    The Media API allows sellers to create, upload, and fetch videos.  # noqa: E501

    OpenAPI spec version: v1_beta.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Video(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'classification': 'list[str]',
        'description': 'str',
        'expiration_date': 'str',
        'moderation': 'Moderation',
        'play_lists': 'list[Play]',
        'size': 'int',
        'status': 'str',
        'status_message': 'str',
        'thumbnail': 'Image',
        'title': 'str',
        'video_id': 'str'
    }

    attribute_map = {
        'classification': 'classification',
        'description': 'description',
        'expiration_date': 'expirationDate',
        'moderation': 'moderation',
        'play_lists': 'playLists',
        'size': 'size',
        'status': 'status',
        'status_message': 'statusMessage',
        'thumbnail': 'thumbnail',
        'title': 'title',
        'video_id': 'videoId'
    }

    def __init__(self, classification=None, description=None, expiration_date=None, moderation=None, play_lists=None, size=None, status=None, status_message=None, thumbnail=None, title=None, video_id=None):  # noqa: E501
        """Video - a model defined in Swagger"""  # noqa: E501
        self._classification = None
        self._description = None
        self._expiration_date = None
        self._moderation = None
        self._play_lists = None
        self._size = None
        self._status = None
        self._status_message = None
        self._thumbnail = None
        self._title = None
        self._video_id = None
        self.discriminator = None
        if classification is not None:
            self.classification = classification
        if description is not None:
            self.description = description
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if moderation is not None:
            self.moderation = moderation
        if play_lists is not None:
            self.play_lists = play_lists
        if size is not None:
            self.size = size
        if status is not None:
            self.status = status
        if status_message is not None:
            self.status_message = status_message
        if thumbnail is not None:
            self.thumbnail = thumbnail
        if title is not None:
            self.title = title
        if video_id is not None:
            self.video_id = video_id

    @property
    def classification(self):
        """Gets the classification of this Video.  # noqa: E501

        The intended use for this video content. The video’s classification is used to associate the video with a user or seller. Currently, the classification of all videos should be set to <code>ITEM</code>.  # noqa: E501

        :return: The classification of this Video.  # noqa: E501
        :rtype: list[str]
        """
        return self._classification

    @classification.setter
    def classification(self, classification):
        """Sets the classification of this Video.

        The intended use for this video content. The video’s classification is used to associate the video with a user or seller. Currently, the classification of all videos should be set to <code>ITEM</code>.  # noqa: E501

        :param classification: The classification of this Video.  # noqa: E501
        :type: list[str]
        """

        self._classification = classification

    @property
    def description(self):
        """Gets the description of this Video.  # noqa: E501

        The description of the video. The video description is an optional field that can be set using the <a href=\" /api-docs/commerce/media/resources/video/methods/createVideo\" target=\"_blank\">createVideo</a> method.  # noqa: E501

        :return: The description of this Video.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Video.

        The description of the video. The video description is an optional field that can be set using the <a href=\" /api-docs/commerce/media/resources/video/methods/createVideo\" target=\"_blank\">createVideo</a> method.  # noqa: E501

        :param description: The description of this Video.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def expiration_date(self):
        """Gets the expiration_date of this Video.  # noqa: E501

        The expiration date of the video in Coordinated Universal Time (UTC). The video’s expiration date is automatically set to 365 days (one year) after the video’s initial upload.  # noqa: E501

        :return: The expiration_date of this Video.  # noqa: E501
        :rtype: str
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date):
        """Sets the expiration_date of this Video.

        The expiration date of the video in Coordinated Universal Time (UTC). The video’s expiration date is automatically set to 365 days (one year) after the video’s initial upload.  # noqa: E501

        :param expiration_date: The expiration_date of this Video.  # noqa: E501
        :type: str
        """

        self._expiration_date = expiration_date

    @property
    def moderation(self):
        """Gets the moderation of this Video.  # noqa: E501


        :return: The moderation of this Video.  # noqa: E501
        :rtype: Moderation
        """
        return self._moderation

    @moderation.setter
    def moderation(self, moderation):
        """Sets the moderation of this Video.


        :param moderation: The moderation of this Video.  # noqa: E501
        :type: Moderation
        """

        self._moderation = moderation

    @property
    def play_lists(self):
        """Gets the play_lists of this Video.  # noqa: E501

        The playlist created for the uploaded video, which provides the streaming video URLs to play the video. The supported streaming video protocols are DASH (Dynamic Adaptive Streaming over HTTP) and HLS (HTTP Live Streaming). The playlist will only be generated if a video is successfully uploaded with a status of <code>LIVE</code>.  # noqa: E501

        :return: The play_lists of this Video.  # noqa: E501
        :rtype: list[Play]
        """
        return self._play_lists

    @play_lists.setter
    def play_lists(self, play_lists):
        """Sets the play_lists of this Video.

        The playlist created for the uploaded video, which provides the streaming video URLs to play the video. The supported streaming video protocols are DASH (Dynamic Adaptive Streaming over HTTP) and HLS (HTTP Live Streaming). The playlist will only be generated if a video is successfully uploaded with a status of <code>LIVE</code>.  # noqa: E501

        :param play_lists: The play_lists of this Video.  # noqa: E501
        :type: list[Play]
        """

        self._play_lists = play_lists

    @property
    def size(self):
        """Gets the size of this Video.  # noqa: E501

        The size, in bytes, of the video content.  # noqa: E501

        :return: The size of this Video.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Video.

        The size, in bytes, of the video content.  # noqa: E501

        :param size: The size of this Video.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def status(self):
        """Gets the status of this Video.  # noqa: E501

        The status of the current video resource. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/media/types/api:VideoStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The status of this Video.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Video.

        The status of the current video resource. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/media/types/api:VideoStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param status: The status of this Video.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def status_message(self):
        """Gets the status_message of this Video.  # noqa: E501

        The <b>statusMessage</b> field contains additional information on the status. For example, information on why processing might have failed or if the video was blocked.  # noqa: E501

        :return: The status_message of this Video.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this Video.

        The <b>statusMessage</b> field contains additional information on the status. For example, information on why processing might have failed or if the video was blocked.  # noqa: E501

        :param status_message: The status_message of this Video.  # noqa: E501
        :type: str
        """

        self._status_message = status_message

    @property
    def thumbnail(self):
        """Gets the thumbnail of this Video.  # noqa: E501


        :return: The thumbnail of this Video.  # noqa: E501
        :rtype: Image
        """
        return self._thumbnail

    @thumbnail.setter
    def thumbnail(self, thumbnail):
        """Sets the thumbnail of this Video.


        :param thumbnail: The thumbnail of this Video.  # noqa: E501
        :type: Image
        """

        self._thumbnail = thumbnail

    @property
    def title(self):
        """Gets the title of this Video.  # noqa: E501

        The title of the video.  # noqa: E501

        :return: The title of this Video.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Video.

        The title of the video.  # noqa: E501

        :param title: The title of this Video.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def video_id(self):
        """Gets the video_id of this Video.  # noqa: E501

        The unique ID of the video.  # noqa: E501

        :return: The video_id of this Video.  # noqa: E501
        :rtype: str
        """
        return self._video_id

    @video_id.setter
    def video_id(self, video_id):
        """Sets the video_id of this Video.

        The unique ID of the video.  # noqa: E501

        :param video_id: The video_id of this Video.  # noqa: E501
        :type: str
        """

        self._video_id = video_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Video, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Video):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
