# coding: utf-8

"""
    Notification API

    The eBay Notification API enables management of the entire end-to-end eBay notification experience by allowing users to:<ul><li>Browse for supported notification topics and retrieve topic details</li><li>Create, configure, and manage notification destination endpionts</li><li>Configure, manage, and test notification subscriptions</li><li>Process eBay notifications and verify the integrity of the message payload</li></ul>  # noqa: E501

    OpenAPI spec version: v1.2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PayloadDetail(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'schema_version': 'str',
        'format': 'list[str]',
        'delivery_protocol': 'str',
        'deprecated': 'bool'
    }

    attribute_map = {
        'schema_version': 'schemaVersion',
        'format': 'format',
        'delivery_protocol': 'deliveryProtocol',
        'deprecated': 'deprecated'
    }

    def __init__(self, schema_version=None, format=None, delivery_protocol=None, deprecated=None):  # noqa: E501
        """PayloadDetail - a model defined in Swagger"""  # noqa: E501
        self._schema_version = None
        self._format = None
        self._delivery_protocol = None
        self._deprecated = None
        self.discriminator = None
        if schema_version is not None:
            self.schema_version = schema_version
        if format is not None:
            self.format = format
        if delivery_protocol is not None:
            self.delivery_protocol = delivery_protocol
        if deprecated is not None:
            self.deprecated = deprecated

    @property
    def schema_version(self):
        """Gets the schema_version of this PayloadDetail.  # noqa: E501

        The supported schema version.  # noqa: E501

        :return: The schema_version of this PayloadDetail.  # noqa: E501
        :rtype: str
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version):
        """Sets the schema_version of this PayloadDetail.

        The supported schema version.  # noqa: E501

        :param schema_version: The schema_version of this PayloadDetail.  # noqa: E501
        :type: str
        """

        self._schema_version = schema_version

    @property
    def format(self):
        """Gets the format of this PayloadDetail.  # noqa: E501

        The supported format. Presently, <code>JSON</code> is the only supported format.  # noqa: E501

        :return: The format of this PayloadDetail.  # noqa: E501
        :rtype: list[str]
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this PayloadDetail.

        The supported format. Presently, <code>JSON</code> is the only supported format.  # noqa: E501

        :param format: The format of this PayloadDetail.  # noqa: E501
        :type: list[str]
        """

        self._format = format

    @property
    def delivery_protocol(self):
        """Gets the delivery_protocol of this PayloadDetail.  # noqa: E501

        The supported delivery protocols. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/notification/types/api:ProtocolEnum'>eBay API documentation</a>  # noqa: E501

        :return: The delivery_protocol of this PayloadDetail.  # noqa: E501
        :rtype: str
        """
        return self._delivery_protocol

    @delivery_protocol.setter
    def delivery_protocol(self, delivery_protocol):
        """Sets the delivery_protocol of this PayloadDetail.

        The supported delivery protocols. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/notification/types/api:ProtocolEnum'>eBay API documentation</a>  # noqa: E501

        :param delivery_protocol: The delivery_protocol of this PayloadDetail.  # noqa: E501
        :type: str
        """

        self._delivery_protocol = delivery_protocol

    @property
    def deprecated(self):
        """Gets the deprecated of this PayloadDetail.  # noqa: E501

        A deprecation indicator.  # noqa: E501

        :return: The deprecated of this PayloadDetail.  # noqa: E501
        :rtype: bool
        """
        return self._deprecated

    @deprecated.setter
    def deprecated(self, deprecated):
        """Sets the deprecated of this PayloadDetail.

        A deprecation indicator.  # noqa: E501

        :param deprecated: The deprecated of this PayloadDetail.  # noqa: E501
        :type: bool
        """

        self._deprecated = deprecated

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PayloadDetail, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PayloadDetail):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
