# coding: utf-8

"""
    Taxonomy API

    Use the Taxonomy API to discover the most appropriate eBay categories under which sellers can offer inventory items for sale, and the most likely categories under which buyers can browse or search for items to purchase. In addition, the Taxonomy API provides metadata about the required and recommended category aspects to include in listings, and also has two operations to retrieve parts compatibility information.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AspectConstraint(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aspect_applicable_to': 'list[str]',
        'aspect_data_type': 'str',
        'aspect_enabled_for_variations': 'bool',
        'aspect_format': 'str',
        'aspect_max_length': 'int',
        'aspect_mode': 'str',
        'aspect_required': 'bool',
        'aspect_usage': 'str',
        'expected_required_by_date': 'str',
        'item_to_aspect_cardinality': 'str'
    }

    attribute_map = {
        'aspect_applicable_to': 'aspectApplicableTo',
        'aspect_data_type': 'aspectDataType',
        'aspect_enabled_for_variations': 'aspectEnabledForVariations',
        'aspect_format': 'aspectFormat',
        'aspect_max_length': 'aspectMaxLength',
        'aspect_mode': 'aspectMode',
        'aspect_required': 'aspectRequired',
        'aspect_usage': 'aspectUsage',
        'expected_required_by_date': 'expectedRequiredByDate',
        'item_to_aspect_cardinality': 'itemToAspectCardinality'
    }

    def __init__(self, aspect_applicable_to=None, aspect_data_type=None, aspect_enabled_for_variations=None, aspect_format=None, aspect_max_length=None, aspect_mode=None, aspect_required=None, aspect_usage=None, expected_required_by_date=None, item_to_aspect_cardinality=None):  # noqa: E501
        """AspectConstraint - a model defined in Swagger"""  # noqa: E501
        self._aspect_applicable_to = None
        self._aspect_data_type = None
        self._aspect_enabled_for_variations = None
        self._aspect_format = None
        self._aspect_max_length = None
        self._aspect_mode = None
        self._aspect_required = None
        self._aspect_usage = None
        self._expected_required_by_date = None
        self._item_to_aspect_cardinality = None
        self.discriminator = None
        if aspect_applicable_to is not None:
            self.aspect_applicable_to = aspect_applicable_to
        if aspect_data_type is not None:
            self.aspect_data_type = aspect_data_type
        if aspect_enabled_for_variations is not None:
            self.aspect_enabled_for_variations = aspect_enabled_for_variations
        if aspect_format is not None:
            self.aspect_format = aspect_format
        if aspect_max_length is not None:
            self.aspect_max_length = aspect_max_length
        if aspect_mode is not None:
            self.aspect_mode = aspect_mode
        if aspect_required is not None:
            self.aspect_required = aspect_required
        if aspect_usage is not None:
            self.aspect_usage = aspect_usage
        if expected_required_by_date is not None:
            self.expected_required_by_date = expected_required_by_date
        if item_to_aspect_cardinality is not None:
            self.item_to_aspect_cardinality = item_to_aspect_cardinality

    @property
    def aspect_applicable_to(self):
        """Gets the aspect_applicable_to of this AspectConstraint.  # noqa: E501

        This value indicate if the aspect identified by the <b>aspects.localizedAspectName</b> field is a product aspect (relevant to catalog products in the category) or an item/instance aspect, which is an aspect whose value will vary based on a particular instance of the product.  # noqa: E501

        :return: The aspect_applicable_to of this AspectConstraint.  # noqa: E501
        :rtype: list[str]
        """
        return self._aspect_applicable_to

    @aspect_applicable_to.setter
    def aspect_applicable_to(self, aspect_applicable_to):
        """Sets the aspect_applicable_to of this AspectConstraint.

        This value indicate if the aspect identified by the <b>aspects.localizedAspectName</b> field is a product aspect (relevant to catalog products in the category) or an item/instance aspect, which is an aspect whose value will vary based on a particular instance of the product.  # noqa: E501

        :param aspect_applicable_to: The aspect_applicable_to of this AspectConstraint.  # noqa: E501
        :type: list[str]
        """

        self._aspect_applicable_to = aspect_applicable_to

    @property
    def aspect_data_type(self):
        """Gets the aspect_data_type of this AspectConstraint.  # noqa: E501

        The data type of this aspect. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/taxonomy/types/txn:AspectDataTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The aspect_data_type of this AspectConstraint.  # noqa: E501
        :rtype: str
        """
        return self._aspect_data_type

    @aspect_data_type.setter
    def aspect_data_type(self, aspect_data_type):
        """Sets the aspect_data_type of this AspectConstraint.

        The data type of this aspect. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/taxonomy/types/txn:AspectDataTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param aspect_data_type: The aspect_data_type of this AspectConstraint.  # noqa: E501
        :type: str
        """

        self._aspect_data_type = aspect_data_type

    @property
    def aspect_enabled_for_variations(self):
        """Gets the aspect_enabled_for_variations of this AspectConstraint.  # noqa: E501

        A value of <code>true</code> indicates that this aspect can be used to help identify item variations.  # noqa: E501

        :return: The aspect_enabled_for_variations of this AspectConstraint.  # noqa: E501
        :rtype: bool
        """
        return self._aspect_enabled_for_variations

    @aspect_enabled_for_variations.setter
    def aspect_enabled_for_variations(self, aspect_enabled_for_variations):
        """Sets the aspect_enabled_for_variations of this AspectConstraint.

        A value of <code>true</code> indicates that this aspect can be used to help identify item variations.  # noqa: E501

        :param aspect_enabled_for_variations: The aspect_enabled_for_variations of this AspectConstraint.  # noqa: E501
        :type: bool
        """

        self._aspect_enabled_for_variations = aspect_enabled_for_variations

    @property
    def aspect_format(self):
        """Gets the aspect_format of this AspectConstraint.  # noqa: E501

        <i>Returned only if</i> the value of <b>aspectDataType</b> identifies a data type that requires specific formatting. Currently, this field provides formatting hints as follows: <ul> <li><b>DATE</b>: <code>YYYY</code>, <code>YYYYMM</code>, <code>YYYYMMDD</code></li> <li><b>NUMBER</b>: <code>int32</code>, <code>double</code></li> </ul>  # noqa: E501

        :return: The aspect_format of this AspectConstraint.  # noqa: E501
        :rtype: str
        """
        return self._aspect_format

    @aspect_format.setter
    def aspect_format(self, aspect_format):
        """Sets the aspect_format of this AspectConstraint.

        <i>Returned only if</i> the value of <b>aspectDataType</b> identifies a data type that requires specific formatting. Currently, this field provides formatting hints as follows: <ul> <li><b>DATE</b>: <code>YYYY</code>, <code>YYYYMM</code>, <code>YYYYMMDD</code></li> <li><b>NUMBER</b>: <code>int32</code>, <code>double</code></li> </ul>  # noqa: E501

        :param aspect_format: The aspect_format of this AspectConstraint.  # noqa: E501
        :type: str
        """

        self._aspect_format = aspect_format

    @property
    def aspect_max_length(self):
        """Gets the aspect_max_length of this AspectConstraint.  # noqa: E501

        The maximum length of the item/instance aspect's value. The seller must make sure not to exceed this length when specifying the instance aspect's value for a product. This field is only returned for instance aspects.  # noqa: E501

        :return: The aspect_max_length of this AspectConstraint.  # noqa: E501
        :rtype: int
        """
        return self._aspect_max_length

    @aspect_max_length.setter
    def aspect_max_length(self, aspect_max_length):
        """Sets the aspect_max_length of this AspectConstraint.

        The maximum length of the item/instance aspect's value. The seller must make sure not to exceed this length when specifying the instance aspect's value for a product. This field is only returned for instance aspects.  # noqa: E501

        :param aspect_max_length: The aspect_max_length of this AspectConstraint.  # noqa: E501
        :type: int
        """

        self._aspect_max_length = aspect_max_length

    @property
    def aspect_mode(self):
        """Gets the aspect_mode of this AspectConstraint.  # noqa: E501

        The manner in which values of this aspect must be specified by the seller (as free text or by selecting from available options).  For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/taxonomy/types/txn:AspectModeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The aspect_mode of this AspectConstraint.  # noqa: E501
        :rtype: str
        """
        return self._aspect_mode

    @aspect_mode.setter
    def aspect_mode(self, aspect_mode):
        """Sets the aspect_mode of this AspectConstraint.

        The manner in which values of this aspect must be specified by the seller (as free text or by selecting from available options).  For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/taxonomy/types/txn:AspectModeEnum'>eBay API documentation</a>  # noqa: E501

        :param aspect_mode: The aspect_mode of this AspectConstraint.  # noqa: E501
        :type: str
        """

        self._aspect_mode = aspect_mode

    @property
    def aspect_required(self):
        """Gets the aspect_required of this AspectConstraint.  # noqa: E501

        A value of <code>true</code> indicates that this aspect is required when offering items in the specified category.  # noqa: E501

        :return: The aspect_required of this AspectConstraint.  # noqa: E501
        :rtype: bool
        """
        return self._aspect_required

    @aspect_required.setter
    def aspect_required(self, aspect_required):
        """Sets the aspect_required of this AspectConstraint.

        A value of <code>true</code> indicates that this aspect is required when offering items in the specified category.  # noqa: E501

        :param aspect_required: The aspect_required of this AspectConstraint.  # noqa: E501
        :type: bool
        """

        self._aspect_required = aspect_required

    @property
    def aspect_usage(self):
        """Gets the aspect_usage of this AspectConstraint.  # noqa: E501

        The enumeration value returned in this field will indicate if the corresponding aspect is recommended or optional. <br /><br /><span class=\"tablenote\"> <strong>Note:</strong> This field is always returned, even for hard-mandated/required aspects (where <code><strong>aspectRequired</strong>: true</code>). The value returned for required aspects will be <code>RECOMMENDED</code>, but they are actually required and a seller will be blocked from listing or revising an item without these aspects. </span> For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/taxonomy/types/txn:AspectUsageEnum'>eBay API documentation</a>  # noqa: E501

        :return: The aspect_usage of this AspectConstraint.  # noqa: E501
        :rtype: str
        """
        return self._aspect_usage

    @aspect_usage.setter
    def aspect_usage(self, aspect_usage):
        """Sets the aspect_usage of this AspectConstraint.

        The enumeration value returned in this field will indicate if the corresponding aspect is recommended or optional. <br /><br /><span class=\"tablenote\"> <strong>Note:</strong> This field is always returned, even for hard-mandated/required aspects (where <code><strong>aspectRequired</strong>: true</code>). The value returned for required aspects will be <code>RECOMMENDED</code>, but they are actually required and a seller will be blocked from listing or revising an item without these aspects. </span> For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/taxonomy/types/txn:AspectUsageEnum'>eBay API documentation</a>  # noqa: E501

        :param aspect_usage: The aspect_usage of this AspectConstraint.  # noqa: E501
        :type: str
        """

        self._aspect_usage = aspect_usage

    @property
    def expected_required_by_date(self):
        """Gets the expected_required_by_date of this AspectConstraint.  # noqa: E501

        The expected date after which the aspect will be required.<br /><br /><span class=\"tablenote\"> <strong>Note:</strong> The value returned in this field specifies only an approximate date, which may not reflect the actual date after which the aspect is required.</span>  # noqa: E501

        :return: The expected_required_by_date of this AspectConstraint.  # noqa: E501
        :rtype: str
        """
        return self._expected_required_by_date

    @expected_required_by_date.setter
    def expected_required_by_date(self, expected_required_by_date):
        """Sets the expected_required_by_date of this AspectConstraint.

        The expected date after which the aspect will be required.<br /><br /><span class=\"tablenote\"> <strong>Note:</strong> The value returned in this field specifies only an approximate date, which may not reflect the actual date after which the aspect is required.</span>  # noqa: E501

        :param expected_required_by_date: The expected_required_by_date of this AspectConstraint.  # noqa: E501
        :type: str
        """

        self._expected_required_by_date = expected_required_by_date

    @property
    def item_to_aspect_cardinality(self):
        """Gets the item_to_aspect_cardinality of this AspectConstraint.  # noqa: E501

        Indicates whether this aspect can accept single or multiple values for items in the specified category.<br /><br /><span class=\"tablenote\"> <strong>Note:</strong> Up to 30 values can be supplied for aspects that accept multiple values.</span> For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/taxonomy/types/txn:ItemToAspectCardinalityEnum'>eBay API documentation</a>  # noqa: E501

        :return: The item_to_aspect_cardinality of this AspectConstraint.  # noqa: E501
        :rtype: str
        """
        return self._item_to_aspect_cardinality

    @item_to_aspect_cardinality.setter
    def item_to_aspect_cardinality(self, item_to_aspect_cardinality):
        """Sets the item_to_aspect_cardinality of this AspectConstraint.

        Indicates whether this aspect can accept single or multiple values for items in the specified category.<br /><br /><span class=\"tablenote\"> <strong>Note:</strong> Up to 30 values can be supplied for aspects that accept multiple values.</span> For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/taxonomy/types/txn:ItemToAspectCardinalityEnum'>eBay API documentation</a>  # noqa: E501

        :param item_to_aspect_cardinality: The item_to_aspect_cardinality of this AspectConstraint.  # noqa: E501
        :type: str
        """

        self._item_to_aspect_cardinality = item_to_aspect_cardinality

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AspectConstraint, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AspectConstraint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
