# coding: utf-8

"""
    Taxonomy API

    Use the Taxonomy API to discover the most appropriate eBay categories under which sellers can offer inventory items for sale, and the most likely categories under which buyers can browse or search for items to purchase. In addition, the Taxonomy API provides metadata about the required and recommended category aspects to include in listings, and also has two operations to retrieve parts compatibility information.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GetCompatibilityPropertyValuesResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'compatibility_property_values': 'list[CompatibilityPropertyValue]'
    }

    attribute_map = {
        'compatibility_property_values': 'compatibilityPropertyValues'
    }

    def __init__(self, compatibility_property_values=None):  # noqa: E501
        """GetCompatibilityPropertyValuesResponse - a model defined in Swagger"""  # noqa: E501
        self._compatibility_property_values = None
        self.discriminator = None
        if compatibility_property_values is not None:
            self.compatibility_property_values = compatibility_property_values

    @property
    def compatibility_property_values(self):
        """Gets the compatibility_property_values of this GetCompatibilityPropertyValuesResponse.  # noqa: E501

        This array contains all compatible vehicle property values that match the specified eBay marketplace, specified eBay category, and filters in the request. If the <strong>compatibility_property</strong> parameter value in the request is 'Trim', each value returned in each <strong>value</strong> field will be a different vehicle trim, applicable to any filters that are set in the <string>filter</string> query parameter of the request, and also based on the eBay marketplace and category specified in the call request.  # noqa: E501

        :return: The compatibility_property_values of this GetCompatibilityPropertyValuesResponse.  # noqa: E501
        :rtype: list[CompatibilityPropertyValue]
        """
        return self._compatibility_property_values

    @compatibility_property_values.setter
    def compatibility_property_values(self, compatibility_property_values):
        """Sets the compatibility_property_values of this GetCompatibilityPropertyValuesResponse.

        This array contains all compatible vehicle property values that match the specified eBay marketplace, specified eBay category, and filters in the request. If the <strong>compatibility_property</strong> parameter value in the request is 'Trim', each value returned in each <strong>value</strong> field will be a different vehicle trim, applicable to any filters that are set in the <string>filter</string> query parameter of the request, and also based on the eBay marketplace and category specified in the call request.  # noqa: E501

        :param compatibility_property_values: The compatibility_property_values of this GetCompatibilityPropertyValuesResponse.  # noqa: E501
        :type: list[CompatibilityPropertyValue]
        """

        self._compatibility_property_values = compatibility_property_values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetCompatibilityPropertyValuesResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetCompatibilityPropertyValuesResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
