# coding: utf-8

# flake8: noqa

"""
    Progress to Rate Limit API

    The <b>Analytics API</b> retrieves call-limit data and the quotas that are set for the RESTful APIs and their associated resources.  <br><br>Responses from calls made to <b>getRateLimits</b> and <b>getUerRateLimits</b> include a list of the applicable resources and the \"call limit\", or quota, that is set for each resource. In addition to quota information, the response also includes the number of remaining calls available before the limit is reached, the time remaining before the quota resets, and the length of the \"time window\" to which the quota applies.  <br><br>The <b>getRateLimits</b> and <b>getUserRateLimits</b> methods retrieve call-limit information for either an application or user, respectively, and each method must be called with an appropriate OAuth token. That is, <b>getRateLimites</b> requires an access token generated with a client credentials grant and <b>getUserRateLimites</b> requires requires an access token generated with an authorization code grant. For more information, see <a href=\"/api-docs/static/oauth-tokens.html\">OAuth tokens</a>.  <br><br>Users can analyze the response data to see whether or not a limit might be reached, and from that determine if any action needs to be taken (such as programmatically throttling their request rate). For more on call limits, see <a href=\"https://developer.ebay.com/support/app-check\" target=\"_blank\">Compatible Application Check</a>.  # noqa: E501

    OpenAPI spec version: v1_beta.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import apis into sdk package
from ..developer_analytics.api.rate_limit_api import RateLimitApi
from ..developer_analytics.api.user_rate_limit_api import UserRateLimitApi
# import ApiClient
from ..developer_analytics.api_client import ApiClient
from ..developer_analytics.configuration import Configuration
# import models into sdk package
from ..developer_analytics.models.error import Error
from ..developer_analytics.models.error_parameter import ErrorParameter
from ..developer_analytics.models.inline_response500 import InlineResponse500
from ..developer_analytics.models.rate import Rate
from ..developer_analytics.models.rate_limit import RateLimit
from ..developer_analytics.models.rate_limits_response import RateLimitsResponse
from ..developer_analytics.models.resource import Resource
