# coding: utf-8

"""
     Seller Service Metrics API 

    The <i>Analytics API</i> provides data and information about a seller and their eBay business.  <br><br>The resources and methods in this API let sellers review information on their listing performance, metrics on their customer service performance, and details on their eBay seller performance rating.  <br><br>The three resources in the Analytics API provide the following data and information: <ul><li><b>Customer Service Metric</b> &ndash; Returns benchmark data and a metric rating pertaining to a seller's customer service performance as compared to other seller's in the same peer group.</li> <li><b>Traffic Report</b> &ndash; Returns data and information that shows how buyers are engaging with a seller's listings.</li> <li><b>Seller Standards Profile</b> &ndash; Returns information pertaining to a seller's profile rating.</li></ul> Sellers can use the data and information returned by the various Analytics API methods to determine where they can make improvements to increase sales and how they might improve their seller status as viewed by eBay buyers.  <br><br>For details on using this API, see <a href=\"/api-docs/sell/static/performance/analyzing-performance.html\" title=\"Selling Integration Guide\">Analyzing seller performance</a>.  # noqa: E501

    OpenAPI spec version: 1.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class MetricBenchmark(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'adjustment': 'str',
        'basis': 'str',
        'metadata': 'BenchmarkMetadata',
        'rating': 'str'
    }

    attribute_map = {
        'adjustment': 'adjustment',
        'basis': 'basis',
        'metadata': 'metadata',
        'rating': 'rating'
    }

    def __init__(self, adjustment=None, basis=None, metadata=None, rating=None):  # noqa: E501
        """MetricBenchmark - a model defined in Swagger"""  # noqa: E501
        self._adjustment = None
        self._basis = None
        self._metadata = None
        self._rating = None
        self.discriminator = None
        if adjustment is not None:
            self.adjustment = adjustment
        if basis is not None:
            self.basis = basis
        if metadata is not None:
            self.metadata = metadata
        if rating is not None:
            self.rating = rating

    @property
    def adjustment(self):
        """Gets the adjustment of this MetricBenchmark.  # noqa: E501

        If this field is present, it indicates that the rating given to the seller was \"adjusted\" for one reason or another.  <br><br>If eBay determines that the normal rating of a seller is impacted by circumstances beyond their control, they can issue an override to adjust the rating given to the seller. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/analytics/types/api:RatingAdjustmentTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The adjustment of this MetricBenchmark.  # noqa: E501
        :rtype: str
        """
        return self._adjustment

    @adjustment.setter
    def adjustment(self, adjustment):
        """Sets the adjustment of this MetricBenchmark.

        If this field is present, it indicates that the rating given to the seller was \"adjusted\" for one reason or another.  <br><br>If eBay determines that the normal rating of a seller is impacted by circumstances beyond their control, they can issue an override to adjust the rating given to the seller. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/analytics/types/api:RatingAdjustmentTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param adjustment: The adjustment of this MetricBenchmark.  # noqa: E501
        :type: str
        """

        self._adjustment = adjustment

    @property
    def basis(self):
        """Gets the basis of this MetricBenchmark.  # noqa: E501

        This field returns the \"basis\" by which the benchmark is calculated for the customer service metric type. <br><br>Currently, the only supported basis is <code>PEER_BENCHMARK</code>. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/analytics/types/api:BenchmarkTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The basis of this MetricBenchmark.  # noqa: E501
        :rtype: str
        """
        return self._basis

    @basis.setter
    def basis(self, basis):
        """Sets the basis of this MetricBenchmark.

        This field returns the \"basis\" by which the benchmark is calculated for the customer service metric type. <br><br>Currently, the only supported basis is <code>PEER_BENCHMARK</code>. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/analytics/types/api:BenchmarkTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param basis: The basis of this MetricBenchmark.  # noqa: E501
        :type: str
        """

        self._basis = basis

    @property
    def metadata(self):
        """Gets the metadata of this MetricBenchmark.  # noqa: E501


        :return: The metadata of this MetricBenchmark.  # noqa: E501
        :rtype: BenchmarkMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this MetricBenchmark.


        :param metadata: The metadata of this MetricBenchmark.  # noqa: E501
        :type: BenchmarkMetadata
        """

        self._metadata = metadata

    @property
    def rating(self):
        """Gets the rating of this MetricBenchmark.  # noqa: E501

        This field returns seller's rating for the customer service metric.  <br><br>The rating is set to a value that equals the relative deviation between the seller's metric value and the benchmark value for the customer service metric.  <br><br>Deviation values range from <code>LOW</code> to <code>VERY HIGH</code>, and the lower the deviation, the better the seller rating. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/analytics/types/api:RatingTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The rating of this MetricBenchmark.  # noqa: E501
        :rtype: str
        """
        return self._rating

    @rating.setter
    def rating(self, rating):
        """Sets the rating of this MetricBenchmark.

        This field returns seller's rating for the customer service metric.  <br><br>The rating is set to a value that equals the relative deviation between the seller's metric value and the benchmark value for the customer service metric.  <br><br>Deviation values range from <code>LOW</code> to <code>VERY HIGH</code>, and the lower the deviation, the better the seller rating. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/analytics/types/api:RatingTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param rating: The rating of this MetricBenchmark.  # noqa: E501
        :type: str
        """

        self._rating = rating

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MetricBenchmark, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MetricBenchmark):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
