# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.16.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ...sell_inventory.api_client import ApiClient


class ProductCompatibilityApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_or_replace_product_compatibility(self, body, content_language, sku, **kwargs):  # noqa: E501
        """create_or_replace_product_compatibility  # noqa: E501

        This call is used by the seller to create or replace a list of products that are compatible with the inventory item. The inventory item is identified with a SKU value in the URI. Product compatibility is currently only applicable to motor vehicle parts and accessory categories, but more categories may be supported in the future.<br /><br /><p>In addition to the <code>authorization</code> header, which is required for all eBay REST API calls, the <strong>createOrReplaceProductCompatibility</strong> call also requires the <code>Content-Language</code> header, that sets the natural language that will be used in the field values of the request payload. For US English, the code value passed in this header should be <code>en-US</code>. To view other supported <code>Content-Language</code> values, and to read more about all supported HTTP headers for eBay REST API calls, see the <a href=\"/api-docs/static/rest-request-components.html#HTTP\">HTTP request headers</a> topic in the <strong>Using eBay RESTful APIs</strong> document.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_replace_product_compatibility(body, content_language, sku, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Compatibility body: Details of the compatibility (required)
        :param str content_language: This request header sets the natural language that will be provided in the field values of the request payload. (required)
        :param str sku: A SKU (stock keeping unit) is an unique identifier defined by a seller for a product (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_replace_product_compatibility_with_http_info(body, content_language, sku, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_replace_product_compatibility_with_http_info(body, content_language, sku, **kwargs)  # noqa: E501
            return data

    def create_or_replace_product_compatibility_with_http_info(self, body, content_language, sku, **kwargs):  # noqa: E501
        """create_or_replace_product_compatibility  # noqa: E501

        This call is used by the seller to create or replace a list of products that are compatible with the inventory item. The inventory item is identified with a SKU value in the URI. Product compatibility is currently only applicable to motor vehicle parts and accessory categories, but more categories may be supported in the future.<br /><br /><p>In addition to the <code>authorization</code> header, which is required for all eBay REST API calls, the <strong>createOrReplaceProductCompatibility</strong> call also requires the <code>Content-Language</code> header, that sets the natural language that will be used in the field values of the request payload. For US English, the code value passed in this header should be <code>en-US</code>. To view other supported <code>Content-Language</code> values, and to read more about all supported HTTP headers for eBay REST API calls, see the <a href=\"/api-docs/static/rest-request-components.html#HTTP\">HTTP request headers</a> topic in the <strong>Using eBay RESTful APIs</strong> document.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_replace_product_compatibility_with_http_info(body, content_language, sku, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Compatibility body: Details of the compatibility (required)
        :param str content_language: This request header sets the natural language that will be provided in the field values of the request payload. (required)
        :param str sku: A SKU (stock keeping unit) is an unique identifier defined by a seller for a product (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'content_language', 'sku']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_replace_product_compatibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_or_replace_product_compatibility`")  # noqa: E501
        # verify the required parameter 'content_language' is set
        if ('content_language' not in params or
                params['content_language'] is None):
            raise ValueError("Missing the required parameter `content_language` when calling `create_or_replace_product_compatibility`")  # noqa: E501
        # verify the required parameter 'sku' is set
        if ('sku' not in params or
                params['sku'] is None):
            raise ValueError("Missing the required parameter `sku` when calling `create_or_replace_product_compatibility`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sku' in params:
            path_params['sku'] = params['sku']  # noqa: E501

        query_params = []

        header_params = {}
        if 'content_language' in params:
            header_params['Content-Language'] = params['content_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/inventory_item/{sku}/product_compatibility', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_product_compatibility(self, sku, **kwargs):  # noqa: E501
        """delete_product_compatibility  # noqa: E501

        This call is used by the seller to delete the list of products that are compatible with the inventory item that is associated with the compatible product list. The inventory item is identified with a SKU value in the URI. Product compatibility is currently only applicable to motor vehicle parts and accessory categories, but more categories may be supported in the future.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_compatibility(sku, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sku: A SKU (stock keeping unit) is an unique identifier defined by a seller for a product (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_product_compatibility_with_http_info(sku, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_product_compatibility_with_http_info(sku, **kwargs)  # noqa: E501
            return data

    def delete_product_compatibility_with_http_info(self, sku, **kwargs):  # noqa: E501
        """delete_product_compatibility  # noqa: E501

        This call is used by the seller to delete the list of products that are compatible with the inventory item that is associated with the compatible product list. The inventory item is identified with a SKU value in the URI. Product compatibility is currently only applicable to motor vehicle parts and accessory categories, but more categories may be supported in the future.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_compatibility_with_http_info(sku, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sku: A SKU (stock keeping unit) is an unique identifier defined by a seller for a product (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sku']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_product_compatibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sku' is set
        if ('sku' not in params or
                params['sku'] is None):
            raise ValueError("Missing the required parameter `sku` when calling `delete_product_compatibility`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sku' in params:
            path_params['sku'] = params['sku']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/inventory_item/{sku}/product_compatibility', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_compatibility(self, sku, **kwargs):  # noqa: E501
        """get_product_compatibility  # noqa: E501

        This call is used by the seller to retrieve the list of products that are compatible with the inventory item. The SKU value for the inventory item is passed into the call URI, and a successful call with return the compatible vehicle list associated with this inventory item. Product compatibility is currently only applicable to motor vehicle parts and accessory categories, but more categories may be supported in the future.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_compatibility(sku, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sku: A SKU (stock keeping unit) is an unique identifier defined by a seller for a product (required)
        :return: Compatibility
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_compatibility_with_http_info(sku, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_compatibility_with_http_info(sku, **kwargs)  # noqa: E501
            return data

    def get_product_compatibility_with_http_info(self, sku, **kwargs):  # noqa: E501
        """get_product_compatibility  # noqa: E501

        This call is used by the seller to retrieve the list of products that are compatible with the inventory item. The SKU value for the inventory item is passed into the call URI, and a successful call with return the compatible vehicle list associated with this inventory item. Product compatibility is currently only applicable to motor vehicle parts and accessory categories, but more categories may be supported in the future.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_compatibility_with_http_info(sku, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sku: A SKU (stock keeping unit) is an unique identifier defined by a seller for a product (required)
        :return: Compatibility
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sku']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_compatibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sku' is set
        if ('sku' not in params or
                params['sku'] is None):
            raise ValueError("Missing the required parameter `sku` when calling `get_product_compatibility`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sku' in params:
            path_params['sku'] = params['sku']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/inventory_item/{sku}/product_compatibility', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Compatibility',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
