# coding: utf-8

"""
    Logistics API

    <span class=\"tablenote\"><b>Note:</b> This is a <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> API available only to select developers approved by business units.</span><br /><br />The <b>Logistics API</b> resources offer the following capabilities: <ul><li><b>shipping_quote</b> &ndash; Consolidates into a list a set of live shipping rates, or quotes, from which you can select a rate to ship a package.</li> <li><b>shipment</b> &ndash; Creates a \"shipment\" for the selected shipping rate.</li></ul> Call <b>createShippingQuote</b> to get a list of live shipping rates. The rates returned are all valid for a specific time window and all quoted prices are at eBay-negotiated rates. <br><br>Select one of the live rates and using its associated <b>rateId</b>, create a \"shipment\" for the package by calling <b>createFromShippingQuote</b>. Creating a shipment completes an agreement, and the cost of the base service and any added shipping options are summed into the returned <b>totalShippingCost</b> value. This action also generates a shipping label that you can use to ship the package.  The total cost of the shipment is incurred when the package is shipped using the supplied shipping label.  <p class=\"tablenote\"><b>Important!</b> Sellers must set up a payment method via their eBay account before they can use the methods in this API to create a shipment and the associated shipping label.</p>  # noqa: E501

    OpenAPI spec version: v1_beta.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Contact(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'company_name': 'str',
        'contact_address': 'ContactAddress',
        'full_name': 'str',
        'primary_phone': 'PhoneNumber'
    }

    attribute_map = {
        'company_name': 'companyName',
        'contact_address': 'contactAddress',
        'full_name': 'fullName',
        'primary_phone': 'primaryPhone'
    }

    def __init__(self, company_name=None, contact_address=None, full_name=None, primary_phone=None):  # noqa: E501
        """Contact - a model defined in Swagger"""  # noqa: E501
        self._company_name = None
        self._contact_address = None
        self._full_name = None
        self._primary_phone = None
        self.discriminator = None
        if company_name is not None:
            self.company_name = company_name
        if contact_address is not None:
            self.contact_address = contact_address
        if full_name is not None:
            self.full_name = full_name
        if primary_phone is not None:
            self.primary_phone = primary_phone

    @property
    def company_name(self):
        """Gets the company_name of this Contact.  # noqa: E501

        The company name with which the contact is associated.  # noqa: E501

        :return: The company_name of this Contact.  # noqa: E501
        :rtype: str
        """
        return self._company_name

    @company_name.setter
    def company_name(self, company_name):
        """Sets the company_name of this Contact.

        The company name with which the contact is associated.  # noqa: E501

        :param company_name: The company_name of this Contact.  # noqa: E501
        :type: str
        """

        self._company_name = company_name

    @property
    def contact_address(self):
        """Gets the contact_address of this Contact.  # noqa: E501


        :return: The contact_address of this Contact.  # noqa: E501
        :rtype: ContactAddress
        """
        return self._contact_address

    @contact_address.setter
    def contact_address(self, contact_address):
        """Sets the contact_address of this Contact.


        :param contact_address: The contact_address of this Contact.  # noqa: E501
        :type: ContactAddress
        """

        self._contact_address = contact_address

    @property
    def full_name(self):
        """Gets the full_name of this Contact.  # noqa: E501

        The contact's full name.  # noqa: E501

        :return: The full_name of this Contact.  # noqa: E501
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """Sets the full_name of this Contact.

        The contact's full name.  # noqa: E501

        :param full_name: The full_name of this Contact.  # noqa: E501
        :type: str
        """

        self._full_name = full_name

    @property
    def primary_phone(self):
        """Gets the primary_phone of this Contact.  # noqa: E501


        :return: The primary_phone of this Contact.  # noqa: E501
        :rtype: PhoneNumber
        """
        return self._primary_phone

    @primary_phone.setter
    def primary_phone(self, primary_phone):
        """Sets the primary_phone of this Contact.


        :param primary_phone: The primary_phone of this Contact.  # noqa: E501
        :type: PhoneNumber
        """

        self._primary_phone = primary_phone

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Contact, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Contact):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
