# coding: utf-8

"""
    Negotiation API

    The <b>Negotiations API</b> gives sellers the ability to proactively send discount offers to buyers who have shown an \"interest\" in their listings.  <br><br>By sending buyers discount offers on listings where they have shown an interest, sellers can increase the velocity of their sales.  <br><br>There are various ways for a buyer to show <i>interest </i> in a listing. For example, if a buyer adds the listing to their <b>Watch</b> list, or if they add the listing to their shopping cart and later abandon the cart, they are deemed to have shown an interest in the listing.  <br><br>In the offers that sellers send, they can discount their listings by either a percentage off the listing price, or they can set a new discounted price that is lower than the original listing price.  <br><br>For details about how seller offers work, see <a href=\"/api-docs/sell/static/marketing/offers-to-buyers.html\" title=\"Selling Integration Guide\">Sending offers to buyers</a>.  # noqa: E501

    OpenAPI spec version: v1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateOffersRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allow_counter_offer': 'bool',
        'message': 'str',
        'offer_duration': 'TimeDuration',
        'offered_items': 'list[OfferedItem]'
    }

    attribute_map = {
        'allow_counter_offer': 'allowCounterOffer',
        'message': 'message',
        'offer_duration': 'offerDuration',
        'offered_items': 'offeredItems'
    }

    def __init__(self, allow_counter_offer=None, message=None, offer_duration=None, offered_items=None):  # noqa: E501
        """CreateOffersRequest - a model defined in Swagger"""  # noqa: E501
        self._allow_counter_offer = None
        self._message = None
        self._offer_duration = None
        self._offered_items = None
        self.discriminator = None
        if allow_counter_offer is not None:
            self.allow_counter_offer = allow_counter_offer
        if message is not None:
            self.message = message
        if offer_duration is not None:
            self.offer_duration = offer_duration
        if offered_items is not None:
            self.offered_items = offered_items

    @property
    def allow_counter_offer(self):
        """Gets the allow_counter_offer of this CreateOffersRequest.  # noqa: E501

        If set to true, the buyer is allowed to make a counter-offer to the seller's offer. Note: Currently, you must set this field to false; counter-offers are not supported in this release. Default: false  # noqa: E501

        :return: The allow_counter_offer of this CreateOffersRequest.  # noqa: E501
        :rtype: bool
        """
        return self._allow_counter_offer

    @allow_counter_offer.setter
    def allow_counter_offer(self, allow_counter_offer):
        """Sets the allow_counter_offer of this CreateOffersRequest.

        If set to true, the buyer is allowed to make a counter-offer to the seller's offer. Note: Currently, you must set this field to false; counter-offers are not supported in this release. Default: false  # noqa: E501

        :param allow_counter_offer: The allow_counter_offer of this CreateOffersRequest.  # noqa: E501
        :type: bool
        """

        self._allow_counter_offer = allow_counter_offer

    @property
    def message(self):
        """Gets the message of this CreateOffersRequest.  # noqa: E501

        A seller-defined message related to the offer being made. This message is sent to the list of &quot;interested&quot; buyers. To increase the conversion rate of the offers a seller makes to buyers, eBay recommends you always add a customized message to your offers. Maximum length: 2,000 characters  # noqa: E501

        :return: The message of this CreateOffersRequest.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this CreateOffersRequest.

        A seller-defined message related to the offer being made. This message is sent to the list of &quot;interested&quot; buyers. To increase the conversion rate of the offers a seller makes to buyers, eBay recommends you always add a customized message to your offers. Maximum length: 2,000 characters  # noqa: E501

        :param message: The message of this CreateOffersRequest.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def offer_duration(self):
        """Gets the offer_duration of this CreateOffersRequest.  # noqa: E501


        :return: The offer_duration of this CreateOffersRequest.  # noqa: E501
        :rtype: TimeDuration
        """
        return self._offer_duration

    @offer_duration.setter
    def offer_duration(self, offer_duration):
        """Sets the offer_duration of this CreateOffersRequest.


        :param offer_duration: The offer_duration of this CreateOffersRequest.  # noqa: E501
        :type: TimeDuration
        """

        self._offer_duration = offer_duration

    @property
    def offered_items(self):
        """Gets the offered_items of this CreateOffersRequest.  # noqa: E501

        An array of objects where each object contains the details of an offer and the ID of the listing on which the offer is being made. Note that the service does not currently support the creation of multiple offers with a single call to sendOfferToInterestedBuyer. With this, each request can target only one listing at a time and you must populate this array with a single element that contains the details of one offer.  # noqa: E501

        :return: The offered_items of this CreateOffersRequest.  # noqa: E501
        :rtype: list[OfferedItem]
        """
        return self._offered_items

    @offered_items.setter
    def offered_items(self, offered_items):
        """Sets the offered_items of this CreateOffersRequest.

        An array of objects where each object contains the details of an offer and the ID of the listing on which the offer is being made. Note that the service does not currently support the creation of multiple offers with a single call to sendOfferToInterestedBuyer. With this, each request can target only one listing at a time and you must populate this array with a single element that contains the details of one offer.  # noqa: E501

        :param offered_items: The offered_items of this CreateOffersRequest.  # noqa: E501
        :type: list[OfferedItem]
        """

        self._offered_items = offered_items

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateOffersRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateOffersRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
