# coding: utf-8

"""
    Negotiation API

    The <b>Negotiations API</b> gives sellers the ability to proactively send discount offers to buyers who have shown an \"interest\" in their listings.  <br><br>By sending buyers discount offers on listings where they have shown an interest, sellers can increase the velocity of their sales.  <br><br>There are various ways for a buyer to show <i>interest </i> in a listing. For example, if a buyer adds the listing to their <b>Watch</b> list, or if they add the listing to their shopping cart and later abandon the cart, they are deemed to have shown an interest in the listing.  <br><br>In the offers that sellers send, they can discount their listings by either a percentage off the listing price, or they can set a new discounted price that is lower than the original listing price.  <br><br>For details about how seller offers work, see <a href=\"/api-docs/sell/static/marketing/offers-to-buyers.html\" title=\"Selling Integration Guide\">Sending offers to buyers</a>.  # noqa: E501

    OpenAPI spec version: v1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Offer(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allow_counter_offer': 'bool',
        'buyer': 'User',
        'creation_date': 'str',
        'initiated_by': 'str',
        'last_modified_date': 'str',
        'message': 'str',
        'offer_duration': 'TimeDuration',
        'offered_items': 'list[OfferedItem]',
        'offer_id': 'str',
        'offer_status': 'str',
        'offer_type': 'str',
        'revision': 'str'
    }

    attribute_map = {
        'allow_counter_offer': 'allowCounterOffer',
        'buyer': 'buyer',
        'creation_date': 'creationDate',
        'initiated_by': 'initiatedBy',
        'last_modified_date': 'lastModifiedDate',
        'message': 'message',
        'offer_duration': 'offerDuration',
        'offered_items': 'offeredItems',
        'offer_id': 'offerId',
        'offer_status': 'offerStatus',
        'offer_type': 'offerType',
        'revision': 'revision'
    }

    def __init__(self, allow_counter_offer=None, buyer=None, creation_date=None, initiated_by=None, last_modified_date=None, message=None, offer_duration=None, offered_items=None, offer_id=None, offer_status=None, offer_type=None, revision=None):  # noqa: E501
        """Offer - a model defined in Swagger"""  # noqa: E501
        self._allow_counter_offer = None
        self._buyer = None
        self._creation_date = None
        self._initiated_by = None
        self._last_modified_date = None
        self._message = None
        self._offer_duration = None
        self._offered_items = None
        self._offer_id = None
        self._offer_status = None
        self._offer_type = None
        self._revision = None
        self.discriminator = None
        if allow_counter_offer is not None:
            self.allow_counter_offer = allow_counter_offer
        if buyer is not None:
            self.buyer = buyer
        if creation_date is not None:
            self.creation_date = creation_date
        if initiated_by is not None:
            self.initiated_by = initiated_by
        if last_modified_date is not None:
            self.last_modified_date = last_modified_date
        if message is not None:
            self.message = message
        if offer_duration is not None:
            self.offer_duration = offer_duration
        if offered_items is not None:
            self.offered_items = offered_items
        if offer_id is not None:
            self.offer_id = offer_id
        if offer_status is not None:
            self.offer_status = offer_status
        if offer_type is not None:
            self.offer_type = offer_type
        if revision is not None:
            self.revision = revision

    @property
    def allow_counter_offer(self):
        """Gets the allow_counter_offer of this Offer.  # noqa: E501

        If set to true, the buyer is allowed to make a counter-offer to the seller's offer.  # noqa: E501

        :return: The allow_counter_offer of this Offer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_counter_offer

    @allow_counter_offer.setter
    def allow_counter_offer(self, allow_counter_offer):
        """Sets the allow_counter_offer of this Offer.

        If set to true, the buyer is allowed to make a counter-offer to the seller's offer.  # noqa: E501

        :param allow_counter_offer: The allow_counter_offer of this Offer.  # noqa: E501
        :type: bool
        """

        self._allow_counter_offer = allow_counter_offer

    @property
    def buyer(self):
        """Gets the buyer of this Offer.  # noqa: E501


        :return: The buyer of this Offer.  # noqa: E501
        :rtype: User
        """
        return self._buyer

    @buyer.setter
    def buyer(self, buyer):
        """Sets the buyer of this Offer.


        :param buyer: The buyer of this Offer.  # noqa: E501
        :type: User
        """

        self._buyer = buyer

    @property
    def creation_date(self):
        """Gets the creation_date of this Offer.  # noqa: E501

        The date and time when the seller's offer was created. The returned timestamp is formatted as an ISO 8601 string, which is based on the 24-hour Coordinated Universal Time (UTC) clock. Format: [YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z Example: 2018-08-20T07:09:00.000Z  # noqa: E501

        :return: The creation_date of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this Offer.

        The date and time when the seller's offer was created. The returned timestamp is formatted as an ISO 8601 string, which is based on the 24-hour Coordinated Universal Time (UTC) clock. Format: [YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z Example: 2018-08-20T07:09:00.000Z  # noqa: E501

        :param creation_date: The creation_date of this Offer.  # noqa: E501
        :type: str
        """

        self._creation_date = creation_date

    @property
    def initiated_by(self):
        """Gets the initiated_by of this Offer.  # noqa: E501

        The eBay UserName of the user (seller) who initiated the offer.  # noqa: E501

        :return: The initiated_by of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._initiated_by

    @initiated_by.setter
    def initiated_by(self, initiated_by):
        """Sets the initiated_by of this Offer.

        The eBay UserName of the user (seller) who initiated the offer.  # noqa: E501

        :param initiated_by: The initiated_by of this Offer.  # noqa: E501
        :type: str
        """

        self._initiated_by = initiated_by

    @property
    def last_modified_date(self):
        """Gets the last_modified_date of this Offer.  # noqa: E501

        The date and time when the offer was last modified. The returned timestamp is formatted as an ISO 8601 string.  # noqa: E501

        :return: The last_modified_date of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_date

    @last_modified_date.setter
    def last_modified_date(self, last_modified_date):
        """Sets the last_modified_date of this Offer.

        The date and time when the offer was last modified. The returned timestamp is formatted as an ISO 8601 string.  # noqa: E501

        :param last_modified_date: The last_modified_date of this Offer.  # noqa: E501
        :type: str
        """

        self._last_modified_date = last_modified_date

    @property
    def message(self):
        """Gets the message of this Offer.  # noqa: E501

        A seller-defined message related to the offer being made. This message is sent to the list of &quot;interested&quot; buyers along with the offer message from eBay.  # noqa: E501

        :return: The message of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Offer.

        A seller-defined message related to the offer being made. This message is sent to the list of &quot;interested&quot; buyers along with the offer message from eBay.  # noqa: E501

        :param message: The message of this Offer.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def offer_duration(self):
        """Gets the offer_duration of this Offer.  # noqa: E501


        :return: The offer_duration of this Offer.  # noqa: E501
        :rtype: TimeDuration
        """
        return self._offer_duration

    @offer_duration.setter
    def offer_duration(self, offer_duration):
        """Sets the offer_duration of this Offer.


        :param offer_duration: The offer_duration of this Offer.  # noqa: E501
        :type: TimeDuration
        """

        self._offer_duration = offer_duration

    @property
    def offered_items(self):
        """Gets the offered_items of this Offer.  # noqa: E501

        The list of items associated with the offer. Currently, the offer list is restricted to a single offer.  # noqa: E501

        :return: The offered_items of this Offer.  # noqa: E501
        :rtype: list[OfferedItem]
        """
        return self._offered_items

    @offered_items.setter
    def offered_items(self, offered_items):
        """Sets the offered_items of this Offer.

        The list of items associated with the offer. Currently, the offer list is restricted to a single offer.  # noqa: E501

        :param offered_items: The offered_items of this Offer.  # noqa: E501
        :type: list[OfferedItem]
        """

        self._offered_items = offered_items

    @property
    def offer_id(self):
        """Gets the offer_id of this Offer.  # noqa: E501

        A unique eBay-assigned identifier for the offer.  # noqa: E501

        :return: The offer_id of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._offer_id

    @offer_id.setter
    def offer_id(self, offer_id):
        """Sets the offer_id of this Offer.

        A unique eBay-assigned identifier for the offer.  # noqa: E501

        :param offer_id: The offer_id of this Offer.  # noqa: E501
        :type: str
        """

        self._offer_id = offer_id

    @property
    def offer_status(self):
        """Gets the offer_status of this Offer.  # noqa: E501

        The current state, or status, of an offer. Status states include PENDING, COUNTERED, ACCEPTED, and DECLINED. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/negotiation/types/api:OfferStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The offer_status of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._offer_status

    @offer_status.setter
    def offer_status(self, offer_status):
        """Sets the offer_status of this Offer.

        The current state, or status, of an offer. Status states include PENDING, COUNTERED, ACCEPTED, and DECLINED. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/negotiation/types/api:OfferStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param offer_status: The offer_status of this Offer.  # noqa: E501
        :type: str
        """

        self._offer_status = offer_status

    @property
    def offer_type(self):
        """Gets the offer_type of this Offer.  # noqa: E501

        The type of offer being made. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/negotiation/types/api:OfferTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The offer_type of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._offer_type

    @offer_type.setter
    def offer_type(self, offer_type):
        """Sets the offer_type of this Offer.

        The type of offer being made. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/negotiation/types/api:OfferTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param offer_type: The offer_type of this Offer.  # noqa: E501
        :type: str
        """

        self._offer_type = offer_type

    @property
    def revision(self):
        """Gets the revision of this Offer.  # noqa: E501

        A unique, eBay-assigned ID for the revision of the offer.  # noqa: E501

        :return: The revision of this Offer.  # noqa: E501
        :rtype: str
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this Offer.

        A unique, eBay-assigned ID for the revision of the offer.  # noqa: E501

        :param revision: The revision of this Offer.  # noqa: E501
        :type: str
        """

        self._revision = revision

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Offer, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Offer):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
