# coding: utf-8

"""
    Negotiation API

    The <b>Negotiations API</b> gives sellers the ability to proactively send discount offers to buyers who have shown an \"interest\" in their listings.  <br><br>By sending buyers discount offers on listings where they have shown an interest, sellers can increase the velocity of their sales.  <br><br>There are various ways for a buyer to show <i>interest </i> in a listing. For example, if a buyer adds the listing to their <b>Watch</b> list, or if they add the listing to their shopping cart and later abandon the cart, they are deemed to have shown an interest in the listing.  <br><br>In the offers that sellers send, they can discount their listings by either a percentage off the listing price, or they can set a new discounted price that is lower than the original listing price.  <br><br>For details about how seller offers work, see <a href=\"/api-docs/sell/static/marketing/offers-to-buyers.html\" title=\"Selling Integration Guide\">Sending offers to buyers</a>.  # noqa: E501

    OpenAPI spec version: v1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SendOfferToInterestedBuyersCollectionResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'offers': 'list[Offer]'
    }

    attribute_map = {
        'offers': 'offers'
    }

    def __init__(self, offers=None):  # noqa: E501
        """SendOfferToInterestedBuyersCollectionResponse - a model defined in Swagger"""  # noqa: E501
        self._offers = None
        self.discriminator = None
        if offers is not None:
            self.offers = offers

    @property
    def offers(self):
        """Gets the offers of this SendOfferToInterestedBuyersCollectionResponse.  # noqa: E501

        The offers container returns a list of the offers sent to buyers who have shown an interest in listings included in the offer.  # noqa: E501

        :return: The offers of this SendOfferToInterestedBuyersCollectionResponse.  # noqa: E501
        :rtype: list[Offer]
        """
        return self._offers

    @offers.setter
    def offers(self, offers):
        """Sets the offers of this SendOfferToInterestedBuyersCollectionResponse.

        The offers container returns a list of the offers sent to buyers who have shown an interest in listings included in the offer.  # noqa: E501

        :param offers: The offers of this SendOfferToInterestedBuyersCollectionResponse.  # noqa: E501
        :type: list[Offer]
        """

        self._offers = offers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SendOfferToInterestedBuyersCollectionResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SendOfferToInterestedBuyersCollectionResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
