# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 3
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_0.api_client import ApiClient


class EventApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_event_alert_condition(self, event_alert_condition, **kwargs):  # noqa: E501
        """create_event_alert_condition  # noqa: E501

        Create a new alert condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_event_alert_condition(event_alert_condition, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventAlertConditionCreateParams event_alert_condition: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_event_alert_condition_with_http_info(event_alert_condition, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_alert_condition_with_http_info(event_alert_condition, **kwargs)  # noqa: E501
            return data

    def create_event_alert_condition_with_http_info(self, event_alert_condition, **kwargs):  # noqa: E501
        """create_event_alert_condition  # noqa: E501

        Create a new alert condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_event_alert_condition_with_http_info(event_alert_condition, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventAlertConditionCreateParams event_alert_condition: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_alert_condition']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_alert_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_alert_condition' is set
        if ('event_alert_condition' not in params or
                params['event_alert_condition'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition` when calling `create_event_alert_condition`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_alert_condition' in params:
            body_params = params['event_alert_condition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/alert-conditions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event_channel(self, event_channel, **kwargs):  # noqa: E501
        """create_event_channel  # noqa: E501

        Create a new channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_event_channel(event_channel, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventChannelCreateParams event_channel: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_event_channel_with_http_info(event_channel, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_channel_with_http_info(event_channel, **kwargs)  # noqa: E501
            return data

    def create_event_channel_with_http_info(self, event_channel, **kwargs):  # noqa: E501
        """create_event_channel  # noqa: E501

        Create a new channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_event_channel_with_http_info(event_channel, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventChannelCreateParams event_channel: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_channel']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_channel' is set
        if ('event_channel' not in params or
                params['event_channel'] is None):
            raise ValueError("Missing the required parameter `event_channel` when calling `create_event_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_channel' in params:
            body_params = params['event_channel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/channels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event_event(self, event_event, **kwargs):  # noqa: E501
        """create_event_event  # noqa: E501

        Create a test event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_event_event(event_event, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventEvent event_event: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_event_event_with_http_info(event_event, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_event_with_http_info(event_event, **kwargs)  # noqa: E501
            return data

    def create_event_event_with_http_info(self, event_event, **kwargs):  # noqa: E501
        """create_event_event  # noqa: E501

        Create a test event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_event_event_with_http_info(event_event, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventEvent event_event: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_event']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_event' is set
        if ('event_event' not in params or
                params['event_event'] is None):
            raise ValueError("Missing the required parameter `event_event` when calling `create_event_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_event' in params:
            body_params = params['event_event']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/events', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_event_alert_condition(self, event_alert_condition_id, **kwargs):  # noqa: E501
        """delete_event_alert_condition  # noqa: E501

        Delete the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_event_alert_condition(event_alert_condition_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_alert_condition_id: Delete the alert-condition. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_event_alert_condition_with_http_info(event_alert_condition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_event_alert_condition_with_http_info(event_alert_condition_id, **kwargs)  # noqa: E501
            return data

    def delete_event_alert_condition_with_http_info(self, event_alert_condition_id, **kwargs):  # noqa: E501
        """delete_event_alert_condition  # noqa: E501

        Delete the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_event_alert_condition_with_http_info(event_alert_condition_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_alert_condition_id: Delete the alert-condition. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_alert_condition_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event_alert_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_alert_condition_id' is set
        if ('event_alert_condition_id' not in params or
                params['event_alert_condition_id'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition_id` when calling `delete_event_alert_condition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_alert_condition_id' in params:
            path_params['EventAlertConditionId'] = params['event_alert_condition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/alert-conditions/{EventAlertConditionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_event_alert_conditions(self, **kwargs):  # noqa: E501
        """delete_event_alert_conditions  # noqa: E501

        Bulk delete of alert conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_event_alert_conditions(async=True)
        >>> result = thread.get()

        :param async bool
        :param str channel: Delete only conditions for this channel
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_event_alert_conditions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_event_alert_conditions_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_event_alert_conditions_with_http_info(self, **kwargs):  # noqa: E501
        """delete_event_alert_conditions  # noqa: E501

        Bulk delete of alert conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_event_alert_conditions_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str channel: Delete only conditions for this channel
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['channel']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event_alert_conditions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'channel' in params:
            query_params.append(('channel&#x60;', params['channel']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/alert-conditions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_event_channel(self, event_channel_id, **kwargs):  # noqa: E501
        """delete_event_channel  # noqa: E501

        Delete the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_event_channel(event_channel_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_channel_id: Delete the alert-condition. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_event_channel_with_http_info(event_channel_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_event_channel_with_http_info(event_channel_id, **kwargs)  # noqa: E501
            return data

    def delete_event_channel_with_http_info(self, event_channel_id, **kwargs):  # noqa: E501
        """delete_event_channel  # noqa: E501

        Delete the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_event_channel_with_http_info(event_channel_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_channel_id: Delete the alert-condition. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_channel_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_channel_id' is set
        if ('event_channel_id' not in params or
                params['event_channel_id'] is None):
            raise ValueError("Missing the required parameter `event_channel_id` when calling `delete_event_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_channel_id' in params:
            path_params['EventChannelId'] = params['event_channel_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/channels/{EventChannelId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_alert_condition(self, event_alert_condition_id, **kwargs):  # noqa: E501
        """get_event_alert_condition  # noqa: E501

        Retrieve the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_alert_condition(event_alert_condition_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_alert_condition_id: Retrieve the alert-condition. (required)
        :return: EventAlertConditions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_alert_condition_with_http_info(event_alert_condition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_alert_condition_with_http_info(event_alert_condition_id, **kwargs)  # noqa: E501
            return data

    def get_event_alert_condition_with_http_info(self, event_alert_condition_id, **kwargs):  # noqa: E501
        """get_event_alert_condition  # noqa: E501

        Retrieve the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_alert_condition_with_http_info(event_alert_condition_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_alert_condition_id: Retrieve the alert-condition. (required)
        :return: EventAlertConditions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_alert_condition_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_alert_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_alert_condition_id' is set
        if ('event_alert_condition_id' not in params or
                params['event_alert_condition_id'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition_id` when calling `get_event_alert_condition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_alert_condition_id' in params:
            path_params['EventAlertConditionId'] = params['event_alert_condition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/alert-conditions/{EventAlertConditionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventAlertConditions',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_categories(self, **kwargs):  # noqa: E501
        """get_event_categories  # noqa: E501

        List all eventgroup categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_categories(async=True)
        >>> result = thread.get()

        :param async bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventCategoriesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_categories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_categories_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_categories_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_categories  # noqa: E501

        List all eventgroup categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_categories_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventCategoriesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_categories" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_categories`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventCategoriesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_category(self, event_category_id, **kwargs):  # noqa: E501
        """get_event_category  # noqa: E501

        Retrieve the eventgroup category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_category(event_category_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_category_id: Retrieve the eventgroup category. (required)
        :return: EventCategories
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_category_with_http_info(event_category_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_category_with_http_info(event_category_id, **kwargs)  # noqa: E501
            return data

    def get_event_category_with_http_info(self, event_category_id, **kwargs):  # noqa: E501
        """get_event_category  # noqa: E501

        Retrieve the eventgroup category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_category_with_http_info(event_category_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_category_id: Retrieve the eventgroup category. (required)
        :return: EventCategories
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_category_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_category_id' is set
        if ('event_category_id' not in params or
                params['event_category_id'] is None):
            raise ValueError("Missing the required parameter `event_category_id` when calling `get_event_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_category_id' in params:
            path_params['EventCategoryId'] = params['event_category_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/categories/{EventCategoryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventCategories',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_channel(self, event_channel_id, **kwargs):  # noqa: E501
        """get_event_channel  # noqa: E501

        Retrieve the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_channel(event_channel_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_channel_id: Retrieve the alert-condition. (required)
        :return: EventChannels
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_channel_with_http_info(event_channel_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_channel_with_http_info(event_channel_id, **kwargs)  # noqa: E501
            return data

    def get_event_channel_with_http_info(self, event_channel_id, **kwargs):  # noqa: E501
        """get_event_channel  # noqa: E501

        Retrieve the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_channel_with_http_info(event_channel_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_channel_id: Retrieve the alert-condition. (required)
        :return: EventChannels
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_channel_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_channel_id' is set
        if ('event_channel_id' not in params or
                params['event_channel_id'] is None):
            raise ValueError("Missing the required parameter `event_channel_id` when calling `get_event_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_channel_id' in params:
            path_params['EventChannelId'] = params['event_channel_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/channels/{EventChannelId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventChannels',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventgroup_definition(self, event_eventgroup_definition_id, **kwargs):  # noqa: E501
        """get_event_eventgroup_definition  # noqa: E501

        Retrieve the eventgroup definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventgroup_definition(event_eventgroup_definition_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_eventgroup_definition_id: Retrieve the eventgroup definition. (required)
        :return: EventEventgroupDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_eventgroup_definition_with_http_info(event_eventgroup_definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventgroup_definition_with_http_info(event_eventgroup_definition_id, **kwargs)  # noqa: E501
            return data

    def get_event_eventgroup_definition_with_http_info(self, event_eventgroup_definition_id, **kwargs):  # noqa: E501
        """get_event_eventgroup_definition  # noqa: E501

        Retrieve the eventgroup definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventgroup_definition_with_http_info(event_eventgroup_definition_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_eventgroup_definition_id: Retrieve the eventgroup definition. (required)
        :return: EventEventgroupDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventgroup_definition_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventgroup_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventgroup_definition_id' is set
        if ('event_eventgroup_definition_id' not in params or
                params['event_eventgroup_definition_id'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_definition_id` when calling `get_event_eventgroup_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_eventgroup_definition_id' in params:
            path_params['EventEventgroupDefinitionId'] = params['event_eventgroup_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-definitions/{EventEventgroupDefinitionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventgroupDefinitions',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventgroup_definitions(self, **kwargs):  # noqa: E501
        """get_event_eventgroup_definitions  # noqa: E501

        List all eventgroup definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventgroup_definitions(async=True)
        >>> result = thread.get()

        :param async bool
        :param int category: Return eventgroups in the specified category
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventEventgroupDefinitionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_eventgroup_definitions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventgroup_definitions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_eventgroup_definitions_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_eventgroup_definitions  # noqa: E501

        List all eventgroup definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventgroup_definitions_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int category: Return eventgroups in the specified category
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventEventgroupDefinitionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category', 'limit', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventgroup_definitions" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventgroup_definitions`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'category' in params:
            query_params.append(('category', params['category']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-definitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventgroupDefinitionsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventgroup_occurrence(self, event_eventgroup_occurrence_id, **kwargs):  # noqa: E501
        """get_event_eventgroup_occurrence  # noqa: E501

        Retrieve individual eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventgroup_occurrence(event_eventgroup_occurrence_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_eventgroup_occurrence_id: Retrieve individual eventgroup occurrence. (required)
        :return: EventEventgroupOccurrences
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence_id, **kwargs)  # noqa: E501
            return data

    def get_event_eventgroup_occurrence_with_http_info(self, event_eventgroup_occurrence_id, **kwargs):  # noqa: E501
        """get_event_eventgroup_occurrence  # noqa: E501

        Retrieve individual eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_eventgroup_occurrence_id: Retrieve individual eventgroup occurrence. (required)
        :return: EventEventgroupOccurrences
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventgroup_occurrence_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventgroup_occurrence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventgroup_occurrence_id' is set
        if ('event_eventgroup_occurrence_id' not in params or
                params['event_eventgroup_occurrence_id'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_occurrence_id` when calling `get_event_eventgroup_occurrence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_eventgroup_occurrence_id' in params:
            path_params['EventEventgroupOccurrenceId'] = params['event_eventgroup_occurrence_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-occurrences/{EventEventgroupOccurrenceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventgroupOccurrences',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventgroup_occurrences(self, **kwargs):  # noqa: E501
        """get_event_eventgroup_occurrences  # noqa: E501

        List all eventgroup occurrences.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventgroup_occurrences(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool resolved: Filter for resolved eventgroups
        :param str sort: The field that will be used for sorting.
        :param int begin: events that are in progress after this time
        :param int end: events that were in progress before this time
        :param int event_count: events for which event_count > this
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str fixer: Filter for eventgroup fixer
        :param bool ignore: Filter for ignored eventgroups
        :param int limit: Return no more than this many results at once (see resume).
        :param str cause: Filter for cause
        :param str dir: The direction of the sort.
        :return: EventEventgroupOccurrencesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_eventgroup_occurrences_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventgroup_occurrences_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_eventgroup_occurrences_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_eventgroup_occurrences  # noqa: E501

        List all eventgroup occurrences.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventgroup_occurrences_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool resolved: Filter for resolved eventgroups
        :param str sort: The field that will be used for sorting.
        :param int begin: events that are in progress after this time
        :param int end: events that were in progress before this time
        :param int event_count: events for which event_count > this
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str fixer: Filter for eventgroup fixer
        :param bool ignore: Filter for ignored eventgroups
        :param int limit: Return no more than this many results at once (see resume).
        :param str cause: Filter for cause
        :param str dir: The direction of the sort.
        :return: EventEventgroupOccurrencesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resolved', 'sort', 'begin', 'end', 'event_count', 'resume', 'fixer', 'ignore', 'limit', 'cause', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventgroup_occurrences" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventgroup_occurrences`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'resolved' in params:
            query_params.append(('resolved', params['resolved']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'event_count' in params:
            query_params.append(('event_count', params['event_count']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'fixer' in params:
            query_params.append(('fixer', params['fixer']))  # noqa: E501
        if 'ignore' in params:
            query_params.append(('ignore', params['ignore']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cause' in params:
            query_params.append(('cause', params['cause']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-occurrences', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventgroupOccurrencesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventlist(self, event_eventlist_id, **kwargs):  # noqa: E501
        """get_event_eventlist  # noqa: E501

        Retrieve the list of events for a eventgroup occureence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventlist(event_eventlist_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_eventlist_id: Retrieve the list of events for a eventgroup occureence. (required)
        :return: EventEventlists
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_eventlist_with_http_info(event_eventlist_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventlist_with_http_info(event_eventlist_id, **kwargs)  # noqa: E501
            return data

    def get_event_eventlist_with_http_info(self, event_eventlist_id, **kwargs):  # noqa: E501
        """get_event_eventlist  # noqa: E501

        Retrieve the list of events for a eventgroup occureence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventlist_with_http_info(event_eventlist_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_eventlist_id: Retrieve the list of events for a eventgroup occureence. (required)
        :return: EventEventlists
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventlist_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventlist" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventlist_id' is set
        if ('event_eventlist_id' not in params or
                params['event_eventlist_id'] is None):
            raise ValueError("Missing the required parameter `event_eventlist_id` when calling `get_event_eventlist`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_eventlist_id' in params:
            path_params['EventEventlistId'] = params['event_eventlist_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventlists/{EventEventlistId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventlists',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventlists(self, **kwargs):  # noqa: E501
        """get_event_eventlists  # noqa: E501

        List all event occurrences grouped by eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventlists(async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_instance: Return only this event occurrence
        :param int limit: Return no more than this many results at once (see resume).
        :param str severity: Minimum severity of returned events.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventEventlistsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_eventlists_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventlists_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_eventlists_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_eventlists  # noqa: E501

        List all event occurrences grouped by eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_eventlists_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_instance: Return only this event occurrence
        :param int limit: Return no more than this many results at once (see resume).
        :param str severity: Minimum severity of returned events.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventEventlistsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_instance', 'limit', 'severity', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventlists" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventlists`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'event_instance' in params:
            query_params.append(('event_instance', params['event_instance']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'severity' in params:
            query_params.append(('severity', params['severity']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventlists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventlistsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_settings(self, **kwargs):  # noqa: E501
        """get_event_settings  # noqa: E501

        Retrieve the settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_settings(async=True)
        >>> result = thread.get()

        :param async bool
        :return: EventSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_settings  # noqa: E501

        Retrieve the settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_settings_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: EventSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventSettings',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_event_alert_conditions(self, **kwargs):  # noqa: E501
        """list_event_alert_conditions  # noqa: E501

        List all alert conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_event_alert_conditions(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str channel_ids: Return only conditions for the specified channel:
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventAlertConditionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_event_alert_conditions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_event_alert_conditions_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_event_alert_conditions_with_http_info(self, **kwargs):  # noqa: E501
        """list_event_alert_conditions  # noqa: E501

        List all alert conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_event_alert_conditions_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str channel_ids: Return only conditions for the specified channel:
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventAlertConditionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'channel_ids', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_event_alert_conditions" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_event_alert_conditions`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'channel_ids' in params:
            query_params.append(('channel_ids', params['channel_ids']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/alert-conditions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventAlertConditionsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_event_channels(self, **kwargs):  # noqa: E501
        """list_event_channels  # noqa: E501

        List all channels.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_event_channels(async=True)
        >>> result = thread.get()

        :param async bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventChannelsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_event_channels_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_event_channels_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_event_channels_with_http_info(self, **kwargs):  # noqa: E501
        """list_event_channels  # noqa: E501

        List all channels.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_event_channels_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventChannelsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_event_channels" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_event_channels`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/channels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventChannelsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_alert_condition(self, event_alert_condition, event_alert_condition_id, **kwargs):  # noqa: E501
        """update_event_alert_condition  # noqa: E501

        Modify the alert-condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_alert_condition(event_alert_condition, event_alert_condition_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventAlertCondition event_alert_condition: (required)
        :param str event_alert_condition_id: Modify the alert-condition (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_event_alert_condition_with_http_info(event_alert_condition, event_alert_condition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_alert_condition_with_http_info(event_alert_condition, event_alert_condition_id, **kwargs)  # noqa: E501
            return data

    def update_event_alert_condition_with_http_info(self, event_alert_condition, event_alert_condition_id, **kwargs):  # noqa: E501
        """update_event_alert_condition  # noqa: E501

        Modify the alert-condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_alert_condition_with_http_info(event_alert_condition, event_alert_condition_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventAlertCondition event_alert_condition: (required)
        :param str event_alert_condition_id: Modify the alert-condition (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_alert_condition', 'event_alert_condition_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_alert_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_alert_condition' is set
        if ('event_alert_condition' not in params or
                params['event_alert_condition'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition` when calling `update_event_alert_condition`")  # noqa: E501
        # verify the required parameter 'event_alert_condition_id' is set
        if ('event_alert_condition_id' not in params or
                params['event_alert_condition_id'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition_id` when calling `update_event_alert_condition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_alert_condition_id' in params:
            path_params['EventAlertConditionId'] = params['event_alert_condition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_alert_condition' in params:
            body_params = params['event_alert_condition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/alert-conditions/{EventAlertConditionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_channel(self, event_channel, event_channel_id, **kwargs):  # noqa: E501
        """update_event_channel  # noqa: E501

        Modify the alert-condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_channel(event_channel, event_channel_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventChannel event_channel: (required)
        :param str event_channel_id: Modify the alert-condition (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_event_channel_with_http_info(event_channel, event_channel_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_channel_with_http_info(event_channel, event_channel_id, **kwargs)  # noqa: E501
            return data

    def update_event_channel_with_http_info(self, event_channel, event_channel_id, **kwargs):  # noqa: E501
        """update_event_channel  # noqa: E501

        Modify the alert-condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_channel_with_http_info(event_channel, event_channel_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventChannel event_channel: (required)
        :param str event_channel_id: Modify the alert-condition (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_channel', 'event_channel_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_channel' is set
        if ('event_channel' not in params or
                params['event_channel'] is None):
            raise ValueError("Missing the required parameter `event_channel` when calling `update_event_channel`")  # noqa: E501
        # verify the required parameter 'event_channel_id' is set
        if ('event_channel_id' not in params or
                params['event_channel_id'] is None):
            raise ValueError("Missing the required parameter `event_channel_id` when calling `update_event_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_channel_id' in params:
            path_params['EventChannelId'] = params['event_channel_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_channel' in params:
            body_params = params['event_channel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/channels/{EventChannelId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_eventgroup_occurrence(self, event_eventgroup_occurrence, event_eventgroup_occurrence_id, **kwargs):  # noqa: E501
        """update_event_eventgroup_occurrence  # noqa: E501

        modify eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_eventgroup_occurrence(event_eventgroup_occurrence, event_eventgroup_occurrence_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventEventgroupOccurrence event_eventgroup_occurrence: (required)
        :param str event_eventgroup_occurrence_id: modify eventgroup occurrence. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence, event_eventgroup_occurrence_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence, event_eventgroup_occurrence_id, **kwargs)  # noqa: E501
            return data

    def update_event_eventgroup_occurrence_with_http_info(self, event_eventgroup_occurrence, event_eventgroup_occurrence_id, **kwargs):  # noqa: E501
        """update_event_eventgroup_occurrence  # noqa: E501

        modify eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence, event_eventgroup_occurrence_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventEventgroupOccurrence event_eventgroup_occurrence: (required)
        :param str event_eventgroup_occurrence_id: modify eventgroup occurrence. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventgroup_occurrence', 'event_eventgroup_occurrence_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_eventgroup_occurrence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventgroup_occurrence' is set
        if ('event_eventgroup_occurrence' not in params or
                params['event_eventgroup_occurrence'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_occurrence` when calling `update_event_eventgroup_occurrence`")  # noqa: E501
        # verify the required parameter 'event_eventgroup_occurrence_id' is set
        if ('event_eventgroup_occurrence_id' not in params or
                params['event_eventgroup_occurrence_id'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_occurrence_id` when calling `update_event_eventgroup_occurrence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_eventgroup_occurrence_id' in params:
            path_params['EventEventgroupOccurrenceId'] = params['event_eventgroup_occurrence_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_eventgroup_occurrence' in params:
            body_params = params['event_eventgroup_occurrence']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-occurrences/{EventEventgroupOccurrenceId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_eventgroup_occurrences(self, event_eventgroup_occurrences, **kwargs):  # noqa: E501
        """update_event_eventgroup_occurrences  # noqa: E501

        Modify all eventgroup occurrences, resolve or ignore all  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_eventgroup_occurrences(event_eventgroup_occurrences, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventEventgroupOccurrence event_eventgroup_occurrences: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_event_eventgroup_occurrences_with_http_info(event_eventgroup_occurrences, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_eventgroup_occurrences_with_http_info(event_eventgroup_occurrences, **kwargs)  # noqa: E501
            return data

    def update_event_eventgroup_occurrences_with_http_info(self, event_eventgroup_occurrences, **kwargs):  # noqa: E501
        """update_event_eventgroup_occurrences  # noqa: E501

        Modify all eventgroup occurrences, resolve or ignore all  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_eventgroup_occurrences_with_http_info(event_eventgroup_occurrences, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventEventgroupOccurrence event_eventgroup_occurrences: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventgroup_occurrences']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_eventgroup_occurrences" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventgroup_occurrences' is set
        if ('event_eventgroup_occurrences' not in params or
                params['event_eventgroup_occurrences'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_occurrences` when calling `update_event_eventgroup_occurrences`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_eventgroup_occurrences' in params:
            body_params = params['event_eventgroup_occurrences']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-occurrences', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_settings(self, event_settings, **kwargs):  # noqa: E501
        """update_event_settings  # noqa: E501

        Update settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_settings(event_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventSettings event_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_event_settings_with_http_info(event_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_settings_with_http_info(event_settings, **kwargs)  # noqa: E501
            return data

    def update_event_settings_with_http_info(self, event_settings, **kwargs):  # noqa: E501
        """update_event_settings  # noqa: E501

        Update settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_event_settings_with_http_info(event_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param EventSettings event_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_settings']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_settings' is set
        if ('event_settings' not in params or
                params['event_settings'] is None):
            raise ValueError("Missing the required parameter `event_settings` when calling `update_event_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_settings' in params:
            body_params = params['event_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
