# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 3
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_0.api_client import ApiClient


class LicenseApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_license_license(self, license_license, **kwargs):  # noqa: E501
        """create_license_license  # noqa: E501

        Install a new license key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_license_license(license_license, async=True)
        >>> result = thread.get()

        :param async bool
        :param LicenseLicenseCreateParams license_license: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_license_license_with_http_info(license_license, **kwargs)  # noqa: E501
        else:
            (data) = self.create_license_license_with_http_info(license_license, **kwargs)  # noqa: E501
            return data

    def create_license_license_with_http_info(self, license_license, **kwargs):  # noqa: E501
        """create_license_license  # noqa: E501

        Install a new license key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_license_license_with_http_info(license_license, async=True)
        >>> result = thread.get()

        :param async bool
        :param LicenseLicenseCreateParams license_license: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['license_license']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_license_license" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'license_license' is set
        if ('license_license' not in params or
                params['license_license'] is None):
            raise ValueError("Missing the required parameter `license_license` when calling `create_license_license`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'license_license' in params:
            body_params = params['license_license']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/license/licenses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_license_license(self, license_license_id, **kwargs):  # noqa: E501
        """get_license_license  # noqa: E501

        Retrieve license information for the feature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_license_license(license_license_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str license_license_id: Retrieve license information for the feature. (required)
        :return: LicenseLicenses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_license_license_with_http_info(license_license_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_license_license_with_http_info(license_license_id, **kwargs)  # noqa: E501
            return data

    def get_license_license_with_http_info(self, license_license_id, **kwargs):  # noqa: E501
        """get_license_license  # noqa: E501

        Retrieve license information for the feature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_license_license_with_http_info(license_license_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str license_license_id: Retrieve license information for the feature. (required)
        :return: LicenseLicenses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['license_license_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_license_license" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'license_license_id' is set
        if ('license_license_id' not in params or
                params['license_license_id'] is None):
            raise ValueError("Missing the required parameter `license_license_id` when calling `get_license_license`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'license_license_id' in params:
            path_params['LicenseLicenseId'] = params['license_license_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/license/licenses/{LicenseLicenseId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseLicenses',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_license_licenses(self, **kwargs):  # noqa: E501
        """list_license_licenses  # noqa: E501

        Retrieve license information for all licensable products.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_license_licenses(async=True)
        >>> result = thread.get()

        :param async bool
        :return: LicenseLicenses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_license_licenses_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_license_licenses_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_license_licenses_with_http_info(self, **kwargs):  # noqa: E501
        """list_license_licenses  # noqa: E501

        Retrieve license information for all licensable products.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_license_licenses_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: LicenseLicenses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_license_licenses" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/license/licenses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseLicenses',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
