# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 3
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_0.api_client import ApiClient


class StatisticsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_statistics_current(self, **kwargs):  # noqa: E501
        """get_statistics_current  # noqa: E501

        Retrieve stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_current(async=True)
        >>> result = thread.get()

        :param async bool
        :param int timeout: Time in seconds to wait for results from remote nodes.
        :param list[str] keys: Multiple key names. May request matching keys or request 'all' keys. Can be comma separated list or can be used more than one time to make queries for multiple keys. May be used in conjunction with 'substr'. Also works with 'key' arguments.
        :param list[str] devid: Node devid to query. Either an <integer> or \"all\". Can be used more than one time to query multiple nodes. \"all\" queries all up nodes. 0 means query the local node. For \"cluster\" scoped keys, in any devid including 0 can be used.
        :param bool substr: Used in conjunction with the 'keys' argument, alters the behavior of keys. Makes the 'keys' arg perform a partial match. Defaults to false.
        :param list[str] key: One key name. Can be used more than one time to query multiple keys. Also works with 'keys' arguments.
        :param bool degraded: If true, try to continue even if some stats are unavailable. In this case, errors will be present in the per-key returned data.
        :param bool expand_clientid: If true, use name resolution to expand client addresses and other IDs.
        :return: StatisticsCurrent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_statistics_current_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_current_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_current_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_current  # noqa: E501

        Retrieve stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_current_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int timeout: Time in seconds to wait for results from remote nodes.
        :param list[str] keys: Multiple key names. May request matching keys or request 'all' keys. Can be comma separated list or can be used more than one time to make queries for multiple keys. May be used in conjunction with 'substr'. Also works with 'key' arguments.
        :param list[str] devid: Node devid to query. Either an <integer> or \"all\". Can be used more than one time to query multiple nodes. \"all\" queries all up nodes. 0 means query the local node. For \"cluster\" scoped keys, in any devid including 0 can be used.
        :param bool substr: Used in conjunction with the 'keys' argument, alters the behavior of keys. Makes the 'keys' arg perform a partial match. Defaults to false.
        :param list[str] key: One key name. Can be used more than one time to query multiple keys. Also works with 'keys' arguments.
        :param bool degraded: If true, try to continue even if some stats are unavailable. In this case, errors will be present in the per-key returned data.
        :param bool expand_clientid: If true, use name resolution to expand client addresses and other IDs.
        :return: StatisticsCurrent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timeout', 'keys', 'devid', 'substr', 'key', 'degraded', 'expand_clientid']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_current" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'keys' in params:
            query_params.append(('keys', params['keys']))  # noqa: E501
            collection_formats['keys'] = 'csv'  # noqa: E501
        if 'devid' in params:
            query_params.append(('devid', params['devid']))  # noqa: E501
            collection_formats['devid'] = 'csv'  # noqa: E501
        if 'substr' in params:
            query_params.append(('substr', params['substr']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
            collection_formats['key'] = 'csv'  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'expand_clientid' in params:
            query_params.append(('expand_clientid', params['expand_clientid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/current', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsCurrent',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_history(self, **kwargs):  # noqa: E501
        """get_statistics_history  # noqa: E501

        Retrieve stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_history(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Earliest time (Unix epoch seconds) of interest. Negative times are interpreted as relative (before) now.
        :param int interval: Minimum sampling interval time in seconds. If native statistics are higher resolution, data will be down-sampled.
        :param int end: Latest time (Unix epoch seconds) of interest. Negative times are interpreted as relative (before) now. If not supplied, use now as the end time.
        :param int timeout: Time in seconds to wait for results from remote nodes.
        :param bool substr: Used in conjunction with the 'keys' argument, alters the behavior of keys. Makes the 'keys' arg perform a partial match. Defaults to false.
        :param list[str] keys: Multiple key names. May request matching keys or request 'all' keys. Can be comma separated list or can be used more than one time to make queries for multiple keys. May be used in conjunction with 'substr'. Also works with 'key' arguments.
        :param list[str] devid: Node devid to query. Either an <integer> or \"all\". Can be used more than one time to query multiple nodes. \"all\" queries all up nodes. 0 means query the local node. For \"cluster\" scoped keys, in any devid including 0 can be used.
        :param bool memory_only: Only use statistics sources that reside in memory (faster, but with less retention).
        :param list[str] key: One key name. Can be used more than one time to query multiple keys. Also works with 'keys' arguments.
        :param bool degraded: If true, try to continue even if some stats are unavailable. In this case, errors will be present in the per-key returned data.
        :param int resolution: Synonymous with 'interval', if supplied supersedes interval.
        :param bool expand_clientid: If true, use name resolution to expand client addresses and other IDs.
        :return: StatisticsHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_statistics_history_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_history_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_history_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_history  # noqa: E501

        Retrieve stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_history_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Earliest time (Unix epoch seconds) of interest. Negative times are interpreted as relative (before) now.
        :param int interval: Minimum sampling interval time in seconds. If native statistics are higher resolution, data will be down-sampled.
        :param int end: Latest time (Unix epoch seconds) of interest. Negative times are interpreted as relative (before) now. If not supplied, use now as the end time.
        :param int timeout: Time in seconds to wait for results from remote nodes.
        :param bool substr: Used in conjunction with the 'keys' argument, alters the behavior of keys. Makes the 'keys' arg perform a partial match. Defaults to false.
        :param list[str] keys: Multiple key names. May request matching keys or request 'all' keys. Can be comma separated list or can be used more than one time to make queries for multiple keys. May be used in conjunction with 'substr'. Also works with 'key' arguments.
        :param list[str] devid: Node devid to query. Either an <integer> or \"all\". Can be used more than one time to query multiple nodes. \"all\" queries all up nodes. 0 means query the local node. For \"cluster\" scoped keys, in any devid including 0 can be used.
        :param bool memory_only: Only use statistics sources that reside in memory (faster, but with less retention).
        :param list[str] key: One key name. Can be used more than one time to query multiple keys. Also works with 'keys' arguments.
        :param bool degraded: If true, try to continue even if some stats are unavailable. In this case, errors will be present in the per-key returned data.
        :param int resolution: Synonymous with 'interval', if supplied supersedes interval.
        :param bool expand_clientid: If true, use name resolution to expand client addresses and other IDs.
        :return: StatisticsHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'interval', 'end', 'timeout', 'substr', 'keys', 'devid', 'memory_only', 'key', 'degraded', 'resolution', 'expand_clientid']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_history" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'substr' in params:
            query_params.append(('substr', params['substr']))  # noqa: E501
        if 'keys' in params:
            query_params.append(('keys', params['keys']))  # noqa: E501
            collection_formats['keys'] = 'csv'  # noqa: E501
        if 'devid' in params:
            query_params.append(('devid', params['devid']))  # noqa: E501
            collection_formats['devid'] = 'csv'  # noqa: E501
        if 'memory_only' in params:
            query_params.append(('memory_only', params['memory_only']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
            collection_formats['key'] = 'csv'  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'resolution' in params:
            query_params.append(('resolution', params['resolution']))  # noqa: E501
        if 'expand_clientid' in params:
            query_params.append(('expand_clientid', params['expand_clientid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsHistory',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_key(self, statistics_key_id, **kwargs):  # noqa: E501
        """get_statistics_key  # noqa: E501

        List key meta-data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_key(statistics_key_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str statistics_key_id: List key meta-data. (required)
        :return: StatisticsKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_statistics_key_with_http_info(statistics_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_key_with_http_info(statistics_key_id, **kwargs)  # noqa: E501
            return data

    def get_statistics_key_with_http_info(self, statistics_key_id, **kwargs):  # noqa: E501
        """get_statistics_key  # noqa: E501

        List key meta-data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_key_with_http_info(statistics_key_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str statistics_key_id: List key meta-data. (required)
        :return: StatisticsKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['statistics_key_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'statistics_key_id' is set
        if ('statistics_key_id' not in params or
                params['statistics_key_id'] is None):
            raise ValueError("Missing the required parameter `statistics_key_id` when calling `get_statistics_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'statistics_key_id' in params:
            path_params['StatisticsKeyId'] = params['statistics_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/keys/{StatisticsKeyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsKeys',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_keys(self, **kwargs):  # noqa: E501
        """get_statistics_keys  # noqa: E501

        List meta-data for matching keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_keys(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool count: Only count matching keys, do not return meta-data.
        :param int limit: Return no more than this many results at once (see resume).
        :param bool queryable: Only list keys that can/cannot be queries. Default is true.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: StatisticsKeysExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_statistics_keys_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_keys_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_keys_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_keys  # noqa: E501

        List meta-data for matching keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_keys_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool count: Only count matching keys, do not return meta-data.
        :param int limit: Return no more than this many results at once (see resume).
        :param bool queryable: Only list keys that can/cannot be queries. Default is true.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: StatisticsKeysExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['count', 'limit', 'queryable', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_keys" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_statistics_keys`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'count' in params:
            query_params.append(('count', params['count']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'queryable' in params:
            query_params.append(('queryable', params['queryable']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsKeysExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_operations(self, **kwargs):  # noqa: E501
        """get_statistics_operations  # noqa: E501

        Retrieve operations list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_operations(async=True)
        >>> result = thread.get()

        :param async bool
        :param list[str] protocols: A comma separated list. Only report operations for specified protocol(s). Default is all.
        :return: StatisticsOperations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_statistics_operations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_operations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_operations_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_operations  # noqa: E501

        Retrieve operations list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_operations_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param list[str] protocols: A comma separated list. Only report operations for specified protocol(s). Default is all.
        :return: StatisticsOperations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['protocols']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_operations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'protocols' in params:
            query_params.append(('protocols', params['protocols']))  # noqa: E501
            collection_formats['protocols'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/operations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsOperations',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_protocols(self, **kwargs):  # noqa: E501
        """get_statistics_protocols  # noqa: E501

        Retrieve protocol list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_protocols(async=True)
        >>> result = thread.get()

        :param async bool
        :param str type: Specifies whether internal, external, or all protocols should be returned.
        :return: StatisticsProtocols
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_statistics_protocols_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_protocols_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_protocols_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_protocols  # noqa: E501

        Retrieve protocol list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_statistics_protocols_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str type: Specifies whether internal, external, or all protocols should be returned.
        :return: StatisticsProtocols
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_protocols" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/protocols', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsProtocols',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_client(self, **kwargs):  # noqa: E501
        """get_summary_client  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_client(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param str totalby: A comma separated list specifying what should be unique. node|protocol|class|local_addr|local_name|remote_addr|remote_name|user_id|user_name|devid
        :param str user_names: A comma seperated list. Only report statistics for operations requested by users with resolved names enumerated.
        :param str remote_addresses: A comma seperated list. Only report statistics for operations requested by the remote clients with dotted-quad IP addresses enumerated.
        :param bool numeric: Whether to convert hostnames or usernames to their human readable form. False by default.
        :param str local_names: A comma seperated list. Only report statistics for operations handled by the local hosts with resolved names enumerated.
        :param str user_ids: A comma seperated list. Only report statistics for operations requested by users with numeric UIDs enumerated.
        :param str classes: Specify class(es) for which statistics should be reported. Default is all supported classes.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str local_addresses: A comma seperated list. Only report statistics for operations handled by the local hosts with dotted-quad IP addresses enumerated.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str remote_names: A comma seperated list. Only report statistics for operations requested by the remote clients with resolved names enumerated.
        :param str nodes: A comma seperated list. Specify node(s) for which statistics should be reported. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate local.
        :param str protocols: A comma seperated list of the protocol(s) you wish to return. Default is 'all' of the folowing: nfs3|smb1|nlm|ftp|http|siq|iscsi|smb2|nfs4|papi|jobd|irp|lsass_in|lsass_out|hdfs|internal|external
        :return: SummaryClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_summary_client_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_client_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_client_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_client  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_client_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param str totalby: A comma separated list specifying what should be unique. node|protocol|class|local_addr|local_name|remote_addr|remote_name|user_id|user_name|devid
        :param str user_names: A comma seperated list. Only report statistics for operations requested by users with resolved names enumerated.
        :param str remote_addresses: A comma seperated list. Only report statistics for operations requested by the remote clients with dotted-quad IP addresses enumerated.
        :param bool numeric: Whether to convert hostnames or usernames to their human readable form. False by default.
        :param str local_names: A comma seperated list. Only report statistics for operations handled by the local hosts with resolved names enumerated.
        :param str user_ids: A comma seperated list. Only report statistics for operations requested by users with numeric UIDs enumerated.
        :param str classes: Specify class(es) for which statistics should be reported. Default is all supported classes.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str local_addresses: A comma seperated list. Only report statistics for operations handled by the local hosts with dotted-quad IP addresses enumerated.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str remote_names: A comma seperated list. Only report statistics for operations requested by the remote clients with resolved names enumerated.
        :param str nodes: A comma seperated list. Specify node(s) for which statistics should be reported. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate local.
        :param str protocols: A comma seperated list of the protocol(s) you wish to return. Default is 'all' of the folowing: nfs3|smb1|nlm|ftp|http|siq|iscsi|smb2|nfs4|papi|jobd|irp|lsass_in|lsass_out|hdfs|internal|external
        :return: SummaryClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'totalby', 'user_names', 'remote_addresses', 'numeric', 'local_names', 'user_ids', 'classes', 'timeout', 'local_addresses', 'degraded', 'remote_names', 'nodes', 'protocols']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_client" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'totalby' in params:
            query_params.append(('totalby', params['totalby']))  # noqa: E501
        if 'user_names' in params:
            query_params.append(('user_names', params['user_names']))  # noqa: E501
        if 'remote_addresses' in params:
            query_params.append(('remote_addresses', params['remote_addresses']))  # noqa: E501
        if 'numeric' in params:
            query_params.append(('numeric', params['numeric']))  # noqa: E501
        if 'local_names' in params:
            query_params.append(('local_names', params['local_names']))  # noqa: E501
        if 'user_ids' in params:
            query_params.append(('user_ids', params['user_ids']))  # noqa: E501
        if 'classes' in params:
            query_params.append(('classes', params['classes']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'local_addresses' in params:
            query_params.append(('local_addresses', params['local_addresses']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'protocols' in params:
            query_params.append(('protocols', params['protocols']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/client', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryClient',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_drive(self, **kwargs):  # noqa: E501
        """get_summary_drive  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_drive(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str type: Specify drive type(s) for which statistics should be reported.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummaryDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_summary_drive_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_drive_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_drive_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_drive  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_drive_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str type: Specify drive type(s) for which statistics should be reported.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummaryDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'degraded', 'type', 'nodes', 'timeout']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_drive" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/drive', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryDrive',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_heat(self, **kwargs):  # noqa: E501
        """get_summary_heat  # noqa: E501

        File heat map, i.e. rate of file operations, and the type of operation listed by path/lin(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_heat(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param bool convertlin: Convert lin to hex. Defaults to true.
        :param str totalby: Aggregate per specified fields(s). Defaults to none.
        :param int pathdepth: Squash paths to this directory depth. Defaults to none, ie. the paths are not limited (Subject to the system limits.)
        :param bool numeric: Whether to convert hostnames or usernames to their human readable form. False by default.
        :param str events: Only report specified event types(s). A comma separated list of events. Defaults to all supported events. See [...]/platform/3/statistics/summary/filters/events for a complete list.
        :param int maxpath: Maximum bytes allocated for looking up a path. An ASCII character is 1 byte (It may be more for other types of encoding). The default is 1024 bytes. Zero (0) means unlimited (Subject to the system limits.)
        :param str classes: Specify class(es) for which statistics should be reported. Default is all supported classes. See [...]/platform/3/statistics/summary/filters/classes for a complete list.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param bool degraded: Continue to report if some nodes do not respond.
        :return: SummaryHeat
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_summary_heat_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_heat_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_heat_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_heat  # noqa: E501

        File heat map, i.e. rate of file operations, and the type of operation listed by path/lin(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_heat_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param bool convertlin: Convert lin to hex. Defaults to true.
        :param str totalby: Aggregate per specified fields(s). Defaults to none.
        :param int pathdepth: Squash paths to this directory depth. Defaults to none, ie. the paths are not limited (Subject to the system limits.)
        :param bool numeric: Whether to convert hostnames or usernames to their human readable form. False by default.
        :param str events: Only report specified event types(s). A comma separated list of events. Defaults to all supported events. See [...]/platform/3/statistics/summary/filters/events for a complete list.
        :param int maxpath: Maximum bytes allocated for looking up a path. An ASCII character is 1 byte (It may be more for other types of encoding). The default is 1024 bytes. Zero (0) means unlimited (Subject to the system limits.)
        :param str classes: Specify class(es) for which statistics should be reported. Default is all supported classes. See [...]/platform/3/statistics/summary/filters/classes for a complete list.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param bool degraded: Continue to report if some nodes do not respond.
        :return: SummaryHeat
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'convertlin', 'totalby', 'pathdepth', 'numeric', 'events', 'maxpath', 'classes', 'timeout', 'nodes', 'degraded']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_heat" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'convertlin' in params:
            query_params.append(('convertlin', params['convertlin']))  # noqa: E501
        if 'totalby' in params:
            query_params.append(('totalby', params['totalby']))  # noqa: E501
        if 'pathdepth' in params:
            query_params.append(('pathdepth', params['pathdepth']))  # noqa: E501
        if 'numeric' in params:
            query_params.append(('numeric', params['numeric']))  # noqa: E501
        if 'events' in params:
            query_params.append(('events', params['events']))  # noqa: E501
        if 'maxpath' in params:
            query_params.append(('maxpath', params['maxpath']))  # noqa: E501
        if 'classes' in params:
            query_params.append(('classes', params['classes']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/heat', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryHeat',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_protocol(self, **kwargs):  # noqa: E501
        """get_summary_protocol  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_protocol(async=True)
        >>> result = thread.get()

        :param async bool
        :param str operations: Specify operation(s) for which statistics should be reported. Default is all operations. See isi-statistics man page for complete listing of operations.
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param str totalby: Aggregate per specified fields(s). Defaults to none.
        :param bool zero: Show table entries with no values.
        :param str classes: Specify class(es) for which statistics should be reported. Default is all supported classes. See [...]/platform/3/statistics/summary/filters/classes for a complete list.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param str protocols: Specify protocol(s) for which statistics should be reported. Default is all external protocols.
        :return: SummaryProtocol
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_summary_protocol_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_protocol_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_protocol_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_protocol  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_protocol_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str operations: Specify operation(s) for which statistics should be reported. Default is all operations. See isi-statistics man page for complete listing of operations.
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param str totalby: Aggregate per specified fields(s). Defaults to none.
        :param bool zero: Show table entries with no values.
        :param str classes: Specify class(es) for which statistics should be reported. Default is all supported classes. See [...]/platform/3/statistics/summary/filters/classes for a complete list.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param str protocols: Specify protocol(s) for which statistics should be reported. Default is all external protocols.
        :return: SummaryProtocol
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['operations', 'sort', 'totalby', 'zero', 'classes', 'timeout', 'degraded', 'nodes', 'protocols']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_protocol" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'operations' in params:
            query_params.append(('operations', params['operations']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'totalby' in params:
            query_params.append(('totalby', params['totalby']))  # noqa: E501
        if 'zero' in params:
            query_params.append(('zero', params['zero']))  # noqa: E501
        if 'classes' in params:
            query_params.append(('classes', params['classes']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'protocols' in params:
            query_params.append(('protocols', params['protocols']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/protocol', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryProtocol',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_protocol_stats(self, **kwargs):  # noqa: E501
        """get_summary_protocol_stats  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_protocol_stats(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str protocol: Specify protocol(s) for which statistics should be reported. Default is all external protocols.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummaryProtocolStats
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_summary_protocol_stats_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_protocol_stats_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_protocol_stats_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_protocol_stats  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_protocol_stats_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str protocol: Specify protocol(s) for which statistics should be reported. Default is all external protocols.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummaryProtocolStats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['degraded', 'protocol', 'nodes', 'timeout']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_protocol_stats" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'protocol' in params:
            query_params.append(('protocol', params['protocol']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/protocol-stats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryProtocolStats',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_system(self, **kwargs):  # noqa: E501
        """get_summary_system  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_system(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param bool oprates: Display protocol operation rate statistics rather than the default throughput statistics.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummarySystem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_summary_system_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_system_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_system_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_system  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_summary_system_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: { drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes } Sort data by the specified comma-separated field(s). Prepend 'asc:' or 'desc:' to a field to change the sort direction.
        :param bool oprates: Display protocol operation rate statistics rather than the default throughput statistics.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: Specify node(s) for which statistics should be reported. A comma separated set of numbers. Default is 'all'. Zero (0) should be passed in as the sole argument to indicate only the local node.
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummarySystem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'oprates', 'degraded', 'nodes', 'timeout']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_system" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'oprates' in params:
            query_params.append(('oprates', params['oprates']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/system', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummarySystem',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
