# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 3
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class EventAlertCondition(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'categories': 'list[str]',
        'channel_ids': 'list[int]',
        'condition': 'str',
        'eventgroup_ids': 'list[str]',
        'interval': 'int',
        'limit': 'int',
        'severities': 'list[str]',
        'transient': 'int'
    }

    attribute_map = {
        'categories': 'categories',
        'channel_ids': 'channel_ids',
        'condition': 'condition',
        'eventgroup_ids': 'eventgroup_ids',
        'interval': 'interval',
        'limit': 'limit',
        'severities': 'severities',
        'transient': 'transient'
    }

    def __init__(self, categories=None, channel_ids=None, condition=None, eventgroup_ids=None, interval=None, limit=None, severities=None, transient=None):  # noqa: E501
        """EventAlertCondition - a model defined in Swagger"""  # noqa: E501

        self._categories = None
        self._channel_ids = None
        self._condition = None
        self._eventgroup_ids = None
        self._interval = None
        self._limit = None
        self._severities = None
        self._transient = None
        self.discriminator = None

        if categories is not None:
            self.categories = categories
        if channel_ids is not None:
            self.channel_ids = channel_ids
        if condition is not None:
            self.condition = condition
        if eventgroup_ids is not None:
            self.eventgroup_ids = eventgroup_ids
        if interval is not None:
            self.interval = interval
        if limit is not None:
            self.limit = limit
        if severities is not None:
            self.severities = severities
        if transient is not None:
            self.transient = transient

    @property
    def categories(self):
        """Gets the categories of this EventAlertCondition.  # noqa: E501

        Event Group categories to be alerted  # noqa: E501

        :return: The categories of this EventAlertCondition.  # noqa: E501
        :rtype: list[str]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """Sets the categories of this EventAlertCondition.

        Event Group categories to be alerted  # noqa: E501

        :param categories: The categories of this EventAlertCondition.  # noqa: E501
        :type: list[str]
        """

        self._categories = categories

    @property
    def channel_ids(self):
        """Gets the channel_ids of this EventAlertCondition.  # noqa: E501

        Channels for alert  # noqa: E501

        :return: The channel_ids of this EventAlertCondition.  # noqa: E501
        :rtype: list[int]
        """
        return self._channel_ids

    @channel_ids.setter
    def channel_ids(self, channel_ids):
        """Sets the channel_ids of this EventAlertCondition.

        Channels for alert  # noqa: E501

        :param channel_ids: The channel_ids of this EventAlertCondition.  # noqa: E501
        :type: list[int]
        """

        self._channel_ids = channel_ids

    @property
    def condition(self):
        """Gets the condition of this EventAlertCondition.  # noqa: E501

        Trigger condition for alert  # noqa: E501

        :return: The condition of this EventAlertCondition.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this EventAlertCondition.

        Trigger condition for alert  # noqa: E501

        :param condition: The condition of this EventAlertCondition.  # noqa: E501
        :type: str
        """
        allowed_values = ["NEW", "NEW EVENTS", "ONGOING", "SEVERITY INCREASE", "SEVERITY DECREASE", "RESOLVED"]  # noqa: E501
        if condition not in allowed_values:
            raise ValueError(
                "Invalid value for `condition` ({0}), must be one of {1}"  # noqa: E501
                .format(condition, allowed_values)
            )

        self._condition = condition

    @property
    def eventgroup_ids(self):
        """Gets the eventgroup_ids of this EventAlertCondition.  # noqa: E501

        Event Group IDs to be alerted  # noqa: E501

        :return: The eventgroup_ids of this EventAlertCondition.  # noqa: E501
        :rtype: list[str]
        """
        return self._eventgroup_ids

    @eventgroup_ids.setter
    def eventgroup_ids(self, eventgroup_ids):
        """Sets the eventgroup_ids of this EventAlertCondition.

        Event Group IDs to be alerted  # noqa: E501

        :param eventgroup_ids: The eventgroup_ids of this EventAlertCondition.  # noqa: E501
        :type: list[str]
        """

        self._eventgroup_ids = eventgroup_ids

    @property
    def interval(self):
        """Gets the interval of this EventAlertCondition.  # noqa: E501

        Required with ONGOING condition only, period in seconds between alerts of ongoing conditions  # noqa: E501

        :return: The interval of this EventAlertCondition.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this EventAlertCondition.

        Required with ONGOING condition only, period in seconds between alerts of ongoing conditions  # noqa: E501

        :param interval: The interval of this EventAlertCondition.  # noqa: E501
        :type: int
        """

        self._interval = interval

    @property
    def limit(self):
        """Gets the limit of this EventAlertCondition.  # noqa: E501

        Required with NEW EVENTS condition only, limits the number of alerts sent as events are added  # noqa: E501

        :return: The limit of this EventAlertCondition.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this EventAlertCondition.

        Required with NEW EVENTS condition only, limits the number of alerts sent as events are added  # noqa: E501

        :param limit: The limit of this EventAlertCondition.  # noqa: E501
        :type: int
        """

        self._limit = limit

    @property
    def severities(self):
        """Gets the severities of this EventAlertCondition.  # noqa: E501

        Severities to be alerted  # noqa: E501

        :return: The severities of this EventAlertCondition.  # noqa: E501
        :rtype: list[str]
        """
        return self._severities

    @severities.setter
    def severities(self, severities):
        """Sets the severities of this EventAlertCondition.

        Severities to be alerted  # noqa: E501

        :param severities: The severities of this EventAlertCondition.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["emergency", "critical", "warning", "information"]  # noqa: E501
        if not set(severities).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `severities` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(severities) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._severities = severities

    @property
    def transient(self):
        """Gets the transient of this EventAlertCondition.  # noqa: E501

        Any eventgroup lasting less than this many seconds is deemed transient and will not generate alerts under this condition.  # noqa: E501

        :return: The transient of this EventAlertCondition.  # noqa: E501
        :rtype: int
        """
        return self._transient

    @transient.setter
    def transient(self, transient):
        """Sets the transient of this EventAlertCondition.

        Any eventgroup lasting less than this many seconds is deemed transient and will not generate alerts under this condition.  # noqa: E501

        :param transient: The transient of this EventAlertCondition.  # noqa: E501
        :type: int
        """

        self._transient = transient

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventAlertCondition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
