# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI_User.ipynb (unless otherwise specified).

__all__ = ["logger"]

# Cell

from typing import *

# Internal Cell

import os

import typer
from typer import echo
from tabulate import tabulate
import datetime as dt
import pandas as pd

from ..client import Client
from . import helper
from ..logger import get_logger, set_level

# Internal Cell

app = typer.Typer(help="A set of commands for managing users in the server.")

# Cell

logger = get_logger(__name__)

# Internal Cell


@app.command()
@helper.requires_auth_token
def create(
    username: str = typer.Option(
        ..., "--username", "-un", help="The username for the new user."
    ),
    first_name: str = typer.Option(
        ...,
        "--first_name",
        "-fn",
        help="The first name for the new user.",
    ),
    last_name: str = typer.Option(
        ...,
        "--last_name",
        "-ln",
        help="The last name for the new user.",
    ),
    email: str = typer.Option(
        ...,
        "--email",
        "-e",
        help="The email for the new user.",
    ),
    password: str = typer.Option(
        ...,
        "--password",
        "-p",
        help="The password for the new user.",
    ),
    subscription_type: str = typer.Option(
        ...,
        "--subscription_type",
        "-st",
        help="User subscription type. Currently, the API supports only the following subscription types **small**, **medium** and **large**.",
    ),
    super_user: bool = typer.Option(
        False,
        "--super_user",
        "-su",
        help="If set to **True**, then the new user will have super user privilages. If **None**, then the default value "
        "**False** will be used to create a non-super user.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output user id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Create a new user in the server."""

    from ..client import User

    df = User.create(
        username=username,
        first_name=first_name,
        last_name=last_name,
        email=email,
        subscription_type=subscription_type,
        super_user=super_user,
        password=password,
    )

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        typer.echo(df.iloc[0]["id"])
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def ls(
    offset: int = typer.Option(
        0,
        "--offset",
        "-o",
        help="The number of users to offset at the beginning. If **None**, then the default value **0** will be used.",
    ),
    limit: int = typer.Option(
        100,
        "--limit",
        "-l",
        help="The maximum number of users to return from the server. If None, then the default value 100 will be used.",
    ),
    disabled: bool = typer.Option(
        False,
        "--disabled",
        help="If set to **True**, then only the deleted users will be returned. Else, the default value **False** will "
        "be used to return only the list of active users.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output only user ids separated by space",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Return the list of users available in the server."""

    from ..client import User

    ux = User.ls(offset=offset, limit=limit, disabled=disabled)

    df = User.as_df(ux)

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def disable(
    id: int = typer.Argument(
        ...,
        help="User id to disabled.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output user id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Disable a user in the server."""

    from ..client import User

    df = User.disable(user_id=int(id))

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def enable(
    id: int = typer.Argument(
        ...,
        help="User id to enable.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output user id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Enable a disabled user in the server."""

    from ..client import User

    df = User.enable(user_id=int(id))

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def update(
    user_id: int = typer.Option(
        ...,
        "--user_id",
        "-id",
        help="User id in the server.",
    ),
    username: str = typer.Option(
        None,
        "--username",
        "-un",
        help="New username for the user.",
    ),
    first_name: str = typer.Option(
        None,
        "--first_name",
        "-fn",
        help="New first name for the user.",
    ),
    last_name: str = typer.Option(
        None,
        "--last_name",
        "-ln",
        help="New last name for the user.",
    ),
    email: str = typer.Option(
        None,
        "--email",
        "-e",
        help="New email for the user.",
    ),
    password: str = typer.Option(
        None,
        "--password",
        "-p",
        help="New password for the user.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output user id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Update existing user details in the server."""

    from ..client import User

    df = User.update(
        user_id=user_id,
        username=username,
        first_name=first_name,
        last_name=last_name,
        email=email,
        password=password,
    )

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        typer.echo(df.iloc[0]["id"])
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))
