"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chatbot = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [chatbot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html).
 *
 * @experimental
 */
class Chatbot extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [chatbot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'chatbot';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateChimeWebhookConfiguration",
                "CreateSlackChannelConfiguration",
                "DeleteChimeWebhookConfiguration",
                "DeleteSlackChannelConfiguration",
                "RedeemSlackOauthCode",
                "UpdateChimeWebhookConfiguration",
                "UpdateSlackChannelConfiguration"
            ],
            "Read": [
                "DescribeChimeWebhookConfigurations",
                "DescribeSlackChannelConfigurations",
                "DescribeSlackChannels",
                "DescribeSlackWorkspaces",
                "GetSlackOauthParameters"
            ]
        };
    }
    /**
     * (experimental) Creates an AWS Chatbot Chime Webhook Configuration.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateChimeWebhookConfiguration() {
        this.to('chatbot:CreateChimeWebhookConfiguration');
        return this;
    }
    /**
     * (experimental) Creates an AWS Chatbot Slack Channel Configuration.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateSlackChannelConfiguration() {
        this.to('chatbot:CreateSlackChannelConfiguration');
        return this;
    }
    /**
     * (experimental) Deletes an AWS Chatbot Chime Webhook Configuration.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteChimeWebhookConfiguration() {
        this.to('chatbot:DeleteChimeWebhookConfiguration');
        return this;
    }
    /**
     * (experimental) Deletes an AWS Chatbot Slack Channel Configuration.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteSlackChannelConfiguration() {
        this.to('chatbot:DeleteSlackChannelConfiguration');
        return this;
    }
    /**
     * (experimental) Lists all AWS Chatbot Chime Webhook Configurations in an AWS Account.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeChimeWebhookConfigurations() {
        this.to('chatbot:DescribeChimeWebhookConfigurations');
        return this;
    }
    /**
     * (experimental) Lists all AWS Chatbot Slack Channel Configurations in an AWS account.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeSlackChannelConfigurations() {
        this.to('chatbot:DescribeSlackChannelConfigurations');
        return this;
    }
    /**
     * (experimental) Lists all public Slack channels in the Slack workspace connected to the AWS Account onboarded with AWS Chatbot service.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeSlackChannels() {
        this.to('chatbot:DescribeSlackChannels');
        return this;
    }
    /**
     * (experimental) Lists all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot service.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeSlackWorkspaces() {
        this.to('chatbot:DescribeSlackWorkspaces');
        return this;
    }
    /**
     * (experimental) Generate OAuth parameters to request Slack OAuth code to be used by the AWS Chatbot service.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetSlackOauthParameters() {
        this.to('chatbot:GetSlackOauthParameters');
        return this;
    }
    /**
     * (experimental) Redeem previously generated parameters with Slack API, to acquire OAuth tokens to be used by the AWS Chatbot service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toRedeemSlackOauthCode() {
        this.to('chatbot:RedeemSlackOauthCode');
        return this;
    }
    /**
     * (experimental) Updates an AWS Chatbot Chime Webhook Configuration.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateChimeWebhookConfiguration() {
        this.to('chatbot:UpdateChimeWebhookConfiguration');
        return this;
    }
    /**
     * (experimental) Updates an AWS Chatbot Slack Channel Configuration.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateSlackChannelConfiguration() {
        this.to('chatbot:UpdateSlackChannelConfiguration');
        return this;
    }
    /**
     * (experimental) Adds a resource of type ChatbotConfiguration to the statement.
     *
     * @param resourceType - Identifier for the resourceType.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onChatbotConfiguration(resourceType, resourceName, account, partition) {
        var arn = 'arn:${Partition}:chatbot::${Account}:${ResourceType}/${ResourceName}';
        arn = arn.replace('${ResourceType}', resourceType);
        arn = arn.replace('${ResourceName}', resourceName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
}
exports.Chatbot = Chatbot;
//# sourceMappingURL=data:application/json;base64,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