import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [network-firewall](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsnetworkfirewall.html).
 *
 * @experimental
 */
export declare class NetworkFirewall extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [network-firewall](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsnetworkfirewall.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an association between a firewall policy and a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_AssociateFirewallPolicy.html
     *
     * @experimental
     */
    toAssociateFirewallPolicy(): this;
    /**
     * (experimental) Grants permission to associate VPC subnets to a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_AssociateSubnets.html
     *
     * @experimental
     */
    toAssociateSubnets(): this;
    /**
     * (experimental) Grants permission to create an AWS Network Firewall firewall.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_CreateFirewall.html
     *
     * @experimental
     */
    toCreateFirewall(): this;
    /**
     * (experimental) Grants permission to create an AWS Network Firewall firewall policy.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_CreateFirewallPolicy.html
     *
     * @experimental
     */
    toCreateFirewallPolicy(): this;
    /**
     * (experimental) Grants permission to create an AWS Network Firewall rule group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_CreateRuleGroup.html
     *
     * @experimental
     */
    toCreateRuleGroup(): this;
    /**
     * (experimental) Grants permission to delete a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DeleteFirewall.html
     *
     * @experimental
     */
    toDeleteFirewall(): this;
    /**
     * (experimental) Grants permission to delete a firewall policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DeleteFirewallPolicy.html
     *
     * @experimental
     */
    toDeleteFirewallPolicy(): this;
    /**
     * (experimental) Grants permission to delete a resource policy for a firewall policy or rule group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DeleteResourcePolicy.html
     *
     * @experimental
     */
    toDeleteResourcePolicy(): this;
    /**
     * (experimental) Grants permission to delete a rule group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DeleteRuleGroup.html
     *
     * @experimental
     */
    toDeleteRuleGroup(): this;
    /**
     * (experimental) Grants permission to retrieve the data objects that define a firewall.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeFirewall.html
     *
     * @experimental
     */
    toDescribeFirewall(): this;
    /**
     * (experimental) Grants permission to retrieve the data objects that define a firewall policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeFirewallPolicy.html
     *
     * @experimental
     */
    toDescribeFirewallPolicy(): this;
    /**
     * (experimental) Grants permission to describe the logging configuration of a firewall.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeLoggingConfiguration.html
     *
     * @experimental
     */
    toDescribeLoggingConfiguration(): this;
    /**
     * (experimental) Grants permission to describe a resource policy for a firewall policy or rule group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeResourcePolicy.html
     *
     * @experimental
     */
    toDescribeResourcePolicy(): this;
    /**
     * (experimental) Grants permission to retrieve the data objects that define a rule group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html
     *
     * @experimental
     */
    toDescribeRuleGroup(): this;
    /**
     * (experimental) Grants permission to disassociate VPC subnets from a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/APIReference/API_DisassociateSubnets.html
     *
     * @experimental
     */
    toDisassociateSubnets(): this;
    /**
     * (experimental) Grants permission to retrieve the metadata for firewall policies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_ListFirewallPolicies.html
     *
     * @experimental
     */
    toListFirewallPolicies(): this;
    /**
     * (experimental) Grants permission to retrieve the metadata for firewalls.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_ListFirewalls.html
     *
     * @experimental
     */
    toListFirewalls(): this;
    /**
     * (experimental) Grants permission to retrieve the metadata for rule groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_ListRuleGroups.html
     *
     * @experimental
     */
    toListRuleGroups(): this;
    /**
     * (experimental) Grants permission to retrieve the tags for a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to put a resource policy for a firewall policy or rule group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_PutResourcePolicy.html
     *
     * @experimental
     */
    toPutResourcePolicy(): this;
    /**
     * (experimental) Grants permission to attach tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to add or remove delete protection for a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_UpdateFirewallDeleteProtection.html
     *
     * @experimental
     */
    toUpdateFirewallDeleteProtection(): this;
    /**
     * (experimental) Grants permission to modify the description for a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_UpdateFirewallDescription.html
     *
     * @experimental
     */
    toUpdateFirewallDescription(): this;
    /**
     * (experimental) Grants permission to modify a firewall policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_UpdateFirewallPolicy.html
     *
     * @experimental
     */
    toUpdateFirewallPolicy(): this;
    /**
     * (experimental) Grants permission to add or remove firewall policy change protection for a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_UpdateFirewallPolicyChangeProtection.html
     *
     * @experimental
     */
    toUpdateFirewallPolicyChangeProtection(): this;
    /**
     * (experimental) Grants permission to modify the logging configuration of a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_UpdateLoggingConfiguration.html
     *
     * @experimental
     */
    toUpdateLoggingConfiguration(): this;
    /**
     * (experimental) Grants permission to modify a rule group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_UpdateRuleGroup.html
     *
     * @experimental
     */
    toUpdateRuleGroup(): this;
    /**
     * (experimental) Grants permission to add or remove subnet change protection for a firewall.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_UpdateSubnetChangeProtection.html
     *
     * @experimental
     */
    toUpdateSubnetChangeProtection(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Firewall to the statement.
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_Firewall.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFirewall(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type FirewallPolicy to the statement.
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_FirewallPolicyResponse.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFirewallPolicy(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type StatefulRuleGroup to the statement.
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_RuleGroupResponse.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStatefulRuleGroup(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type StatelessRuleGroup to the statement.
     *
     * https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_RuleGroupResponse.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStatelessRuleGroup(name: string, account?: string, region?: string, partition?: string): this;
}
