import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [servicequotas](https://docs.aws.amazon.com/service-authorization/latest/reference/list_servicequotas.html).
 *
 * @experimental
 */
export declare class Servicequotas extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [servicequotas](https://docs.aws.amazon.com/service-authorization/latest/reference/list_servicequotas.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate the Service Quotas template with your organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_AssociateServiceQuotaTemplate.html
     *
     * @experimental
     */
    toAssociateServiceQuotaTemplate(): this;
    /**
     * (experimental) Grants permission to remove the specified service quota from the service quota template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_DeleteServiceQuotaIncreaseRequestFromTemplate.html
     *
     * @experimental
     */
    toDeleteServiceQuotaIncreaseRequestFromTemplate(): this;
    /**
     * (experimental) Grants permission to disassociate the Service Quotas template from your organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_DisassociateServiceQuotaTemplate.html
     *
     * @experimental
     */
    toDisassociateServiceQuotaTemplate(): this;
    /**
     * (experimental) Grants permission to return the details for the specified service quota, including the AWS default value.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_GetAWSDefaultServiceQuota.html
     *
     * @experimental
     */
    toGetAWSDefaultServiceQuota(): this;
    /**
     * (experimental) Grants permission to retrieve the ServiceQuotaTemplateAssociationStatus value, which tells you if the Service Quotas template is associated with an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_GetAssociationForServiceQuotaTemplate.html
     *
     * @experimental
     */
    toGetAssociationForServiceQuotaTemplate(): this;
    /**
     * (experimental) Grants permission to retrieve the details for a particular service quota increase request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_GetRequestedServiceQuotaChange.html
     *
     * @experimental
     */
    toGetRequestedServiceQuotaChange(): this;
    /**
     * (experimental) Grants permission to return the details for the specified service quota, including the applied value.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_GetServiceQuota.html
     *
     * @experimental
     */
    toGetServiceQuota(): this;
    /**
     * (experimental) Grants permission to retrieve the details for a service quota increase request from the service quota template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_GetServiceQuotaIncreaseRequestFromTemplate.html
     *
     * @experimental
     */
    toGetServiceQuotaIncreaseRequestFromTemplate(): this;
    /**
     * (experimental) Grants permission to list all default service quotas for the specified AWS service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListAWSDefaultServiceQuotas.html
     *
     * @experimental
     */
    toListAWSDefaultServiceQuotas(): this;
    /**
     * (experimental) Grants permission to request a list of the changes to quotas for a service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListRequestedServiceQuotaChangeHistory.html
     *
     * @experimental
     */
    toListRequestedServiceQuotaChangeHistory(): this;
    /**
     * (experimental) Grants permission to request a list of the changes to specific service quotas.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListRequestedServiceQuotaChangeHistoryByQuota.html
     *
     * @experimental
     */
    toListRequestedServiceQuotaChangeHistoryByQuota(): this;
    /**
     * (experimental) Grants permission to return a list of the service quota increase requests from the service quota template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotaIncreaseRequestsInTemplate
     *
     * @experimental
     */
    toListServiceQuotaIncreaseRequestsInTemplate(): this;
    /**
     * (experimental) Grants permission to list all service quotas for the specified AWS service, in that account, in that Region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html
     *
     * @experimental
     */
    toListServiceQuotas(): this;
    /**
     * (experimental) Grants permission to list the AWS services available in Service Quotas.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServices.html
     *
     * @experimental
     */
    toListServices(): this;
    /**
     * (experimental) Grants permission to define and add a quota to the service quota template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifService()
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_PutServiceQuotaIncreaseRequestIntoTemplate.html
     *
     * @experimental
     */
    toPutServiceQuotaIncreaseRequestIntoTemplate(): this;
    /**
     * (experimental) Grants permission to submit the request for a service quota increase.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifService()
     *
     * https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html
     *
     * @experimental
     */
    toRequestServiceQuotaIncrease(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type quota to the statement.
     *
     * https://docs.aws.amazon.com/servicequotas/latest/userguide/quota-as-resource.html
     *
     * @param serviceCode - Identifier for the serviceCode.
     * @param quotaCode - Identifier for the quotaCode.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onQuota(serviceCode: string, quotaCode: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters or restricts access to a specified AWS service.
     *
     * Applies to actions:
     * - .toPutServiceQuotaIncreaseRequestIntoTemplate()
     * - .toRequestServiceQuotaIncrease()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifService(value: string | string[], operator?: Operator | string): this;
}
