import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`, `master`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_membership#access_level GroupMembership#access_level}
    */
    readonly accessLevel: string;
    /**
    * Expiration date for the group membership. Format: `YYYY-MM-DD`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_membership#expires_at GroupMembership#expires_at}
    */
    readonly expiresAt?: string;
    /**
    * The id of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_membership#group_id GroupMembership#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_membership#id GroupMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The id of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_membership#user_id GroupMembership#user_id}
    */
    readonly userId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_membership gitlab_group_membership}
*/
export declare class GroupMembership extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_membership";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_membership gitlab_group_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupMembershipConfig
    */
    constructor(scope: Construct, id: string, config: GroupMembershipConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    get accessLevelInput(): string | undefined;
    private _expiresAt?;
    get expiresAt(): string;
    set expiresAt(value: string);
    resetExpiresAt(): void;
    get expiresAtInput(): string | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    get userIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
