# Changelog

## [2.0.4](https://github.com/NiaOrg/NiaPy/tree/2.0.4) (2022-11-20)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.3...2.0.4)

**Closed issues:**

- Make problem [\#394](https://github.com/NiaOrg/NiaPy/issues/394)

**Merged pull requests:**

- Update dependencies [\#395](https://github.com/NiaOrg/NiaPy/pull/395) ([zStupan](https://github.com/zStupan))

## [2.0.3](https://github.com/NiaOrg/NiaPy/tree/2.0.3) (2022-09-03)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.2...2.0.3)

**Fixed bugs:**

- AttributeError: 'NoneType' object has no attribute 'copy' [\#393](https://github.com/NiaOrg/NiaPy/issues/393)

**Closed issues:**

- Draft a new release [\#387](https://github.com/NiaOrg/NiaPy/issues/387)
- L-SHADE algorithm [\#386](https://github.com/NiaOrg/NiaPy/issues/386)
- Can not control the number of max\_evals or max\_iters [\#376](https://github.com/NiaOrg/NiaPy/issues/376)
- Graphical user interface \(GUI\) for NiaPy  [\#330](https://github.com/NiaOrg/NiaPy/issues/330)

**Merged pull requests:**

- L-SHADE implementation [\#390](https://github.com/NiaOrg/NiaPy/pull/390) ([AlesGartner](https://github.com/AlesGartner))
- Installation instructions for NixOS [\#389](https://github.com/NiaOrg/NiaPy/pull/389) ([firefly-cpp](https://github.com/firefly-cpp))

## [2.0.2](https://github.com/NiaOrg/NiaPy/tree/2.0.2) (2022-05-22)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.1...2.0.2)

**Closed issues:**

- all-contributors [\#375](https://github.com/NiaOrg/NiaPy/issues/375)

**Merged pull requests:**

- Installation instructions for Alpine linux users [\#384](https://github.com/NiaOrg/NiaPy/pull/384) ([firefly-cpp](https://github.com/firefly-cpp))
- Fix get\_parameters [\#383](https://github.com/NiaOrg/NiaPy/pull/383) ([zStupan](https://github.com/zStupan))

## [2.0.1](https://github.com/NiaOrg/NiaPy/tree/2.0.1) (2022-03-05)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0...2.0.1)

**Implemented enhancements:**

- Installation instructions for Arch Linux users [\#373](https://github.com/NiaOrg/NiaPy/issues/373)

**Closed issues:**

- Whale Optimization Algorithm \(WOA\) and Sparrow Search Algorithm \(SSA\) implementation [\#378](https://github.com/NiaOrg/NiaPy/issues/378)
- raise ValueError\('Newlines are not allowed'\) [\#371](https://github.com/NiaOrg/NiaPy/issues/371)
- Logging not working if optimization type set to maximization  [\#367](https://github.com/NiaOrg/NiaPy/issues/367)
- ConalgTestCase related tests warnings [\#364](https://github.com/NiaOrg/NiaPy/issues/364)
- Correct naming of Michalewicz functions [\#361](https://github.com/NiaOrg/NiaPy/issues/361)
- Second stable release [\#359](https://github.com/NiaOrg/NiaPy/issues/359)

**Merged pull requests:**

- Update docs [\#385](https://github.com/NiaOrg/NiaPy/pull/385) ([zStupan](https://github.com/zStupan))
- docs: add firefly-cpp as a contributor for platform [\#382](https://github.com/NiaOrg/NiaPy/pull/382) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- docs: add carlosal1015 as a contributor for platform [\#381](https://github.com/NiaOrg/NiaPy/pull/381) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Modify convergence plotting [\#380](https://github.com/NiaOrg/NiaPy/pull/380) ([zStupan](https://github.com/zStupan))
- Update Algorithms.md [\#377](https://github.com/NiaOrg/NiaPy/pull/377) ([firefly-cpp](https://github.com/firefly-cpp))
- Add instructions for install from AUR [\#374](https://github.com/NiaOrg/NiaPy/pull/374) ([carlosal1015](https://github.com/carlosal1015))
- Fix setup error [\#372](https://github.com/NiaOrg/NiaPy/pull/372) ([zStupan](https://github.com/zStupan))
- Add nice badge for showing the total downloads of this package [\#370](https://github.com/NiaOrg/NiaPy/pull/370) ([firefly-cpp](https://github.com/firefly-cpp))
- Add incremental testing to main workflow supported with cache [\#369](https://github.com/NiaOrg/NiaPy/pull/369) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Improve CI [\#368](https://github.com/NiaOrg/NiaPy/pull/368) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Add pytest-testmon to reduce the execution time of tests. [\#366](https://github.com/NiaOrg/NiaPy/pull/366) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Fix clonalg implementation [\#365](https://github.com/NiaOrg/NiaPy/pull/365) ([zStupan](https://github.com/zStupan))
- Refactor/fix michalewicz name [\#363](https://github.com/NiaOrg/NiaPy/pull/363) ([sisco0](https://github.com/sisco0))
- Refactor/fix py typos [\#362](https://github.com/NiaOrg/NiaPy/pull/362) ([sisco0](https://github.com/sisco0))

## [2.0.0](https://github.com/NiaOrg/NiaPy/tree/2.0.0) (2021-12-27)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc18...2.0.0)

**Fixed bugs:**

- BA implementation bug [\#352](https://github.com/NiaOrg/NiaPy/issues/352)

**Closed issues:**

- Remove vim comments [\#349](https://github.com/NiaOrg/NiaPy/issues/349)
- Infinity test problem is a duplicate of Csendes [\#347](https://github.com/NiaOrg/NiaPy/issues/347)
- Add a citation.cff file [\#346](https://github.com/NiaOrg/NiaPy/issues/346)

**Merged pull requests:**

- Do not package the tests [\#358](https://github.com/NiaOrg/NiaPy/pull/358) ([firefly-cpp](https://github.com/firefly-cpp))
- Add badge for Fedora [\#356](https://github.com/NiaOrg/NiaPy/pull/356) ([firefly-cpp](https://github.com/firefly-cpp))
- Fixed flake8 versions [\#355](https://github.com/NiaOrg/NiaPy/pull/355) ([zStupan](https://github.com/zStupan))
- Maximization example corrected [\#354](https://github.com/NiaOrg/NiaPy/pull/354) ([firefly-cpp](https://github.com/firefly-cpp))
- Fixed BA [\#353](https://github.com/NiaOrg/NiaPy/pull/353) ([zStupan](https://github.com/zStupan))
- Loa algorithm [\#351](https://github.com/NiaOrg/NiaPy/pull/351) ([AljoM](https://github.com/AljoM))
- Removed vim comments [\#350](https://github.com/NiaOrg/NiaPy/pull/350) ([zStupan](https://github.com/zStupan))
- Remove infinity test problem and add missing test problems to docs [\#348](https://github.com/NiaOrg/NiaPy/pull/348) ([zStupan](https://github.com/zStupan))
- Fixed csendes function. [\#345](https://github.com/NiaOrg/NiaPy/pull/345) ([zStupan](https://github.com/zStupan))

## [2.0.0rc18](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc18) (2021-08-18)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc17...2.0.0rc18)

**Closed issues:**

- BA, CS and FA implementations are incorrect [\#341](https://github.com/NiaOrg/NiaPy/issues/341)
- ModuleNotFoundError: No module named 'NiaPy' [\#339](https://github.com/NiaOrg/NiaPy/issues/339)
- Add Problems.md file [\#332](https://github.com/NiaOrg/NiaPy/issues/332)
- Add an example/guide showing how to solve a real-world problem  [\#215](https://github.com/NiaOrg/NiaPy/issues/215)

**Merged pull requests:**

- docs: add andrazperson as a contributor for code [\#343](https://github.com/NiaOrg/NiaPy/pull/343) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Fix various algorithms [\#342](https://github.com/NiaOrg/NiaPy/pull/342) ([zStupan](https://github.com/zStupan))
- Initial implementation of Clonal Selection Algorithm [\#340](https://github.com/NiaOrg/NiaPy/pull/340) ([andrazperson](https://github.com/andrazperson))
- docs: add firefly-cpp as a contributor for question, test [\#337](https://github.com/NiaOrg/NiaPy/pull/337) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Add Python 3.10 tag [\#336](https://github.com/NiaOrg/NiaPy/pull/336) ([firefly-cpp](https://github.com/firefly-cpp))
- Update docs [\#335](https://github.com/NiaOrg/NiaPy/pull/335) ([zStupan](https://github.com/zStupan))

## [2.0.0rc17](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc17) (2021-06-10)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc16...2.0.0rc17)

**Closed issues:**

- Maximization doesn't work [\#328](https://github.com/NiaOrg/NiaPy/issues/328)
- Remove ThrowingTask and CountingTask [\#317](https://github.com/NiaOrg/NiaPy/issues/317)
- Tasks are missing from the documentation. [\#315](https://github.com/NiaOrg/NiaPy/issues/315)
- NiaPy fails to build with Python 3.10.0a7. [\#308](https://github.com/NiaOrg/NiaPy/issues/308)

**Merged pull requests:**

- Edit Algorithms.md [\#333](https://github.com/NiaOrg/NiaPy/pull/333) ([firefly-cpp](https://github.com/firefly-cpp))
- Rename BFOA [\#331](https://github.com/NiaOrg/NiaPy/pull/331) ([zStupan](https://github.com/zStupan))
- Fixed Maximization [\#329](https://github.com/NiaOrg/NiaPy/pull/329) ([zStupan](https://github.com/zStupan))
- Remove export directory [\#327](https://github.com/NiaOrg/NiaPy/pull/327) ([zStupan](https://github.com/zStupan))
- docs: add eltociear as a contributor [\#326](https://github.com/NiaOrg/NiaPy/pull/326) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Fix typo in jade.py [\#324](https://github.com/NiaOrg/NiaPy/pull/324) ([eltociear](https://github.com/eltociear))
- Remove ThrowingTask and CountingTask [\#323](https://github.com/NiaOrg/NiaPy/pull/323) ([zStupan](https://github.com/zStupan))
- Benchmark refactor [\#321](https://github.com/NiaOrg/NiaPy/pull/321) ([zStupan](https://github.com/zStupan))
- docs: add lukapecnik as a contributor [\#320](https://github.com/NiaOrg/NiaPy/pull/320) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- docs: add zStupan as a contributor [\#319](https://github.com/NiaOrg/NiaPy/pull/319) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- docs: add hrnciar as a contributor [\#318](https://github.com/NiaOrg/NiaPy/pull/318) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Fix detection of two digit Python minor version [\#316](https://github.com/NiaOrg/NiaPy/pull/316) ([hrnciar](https://github.com/hrnciar))

## [2.0.0rc16](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc16) (2021-05-26)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc15...2.0.0rc16)

**Implemented enhancements:**

- Create a new release [\#310](https://github.com/NiaOrg/NiaPy/issues/310)

**Closed issues:**

- niapy import fails for Python 3.6.x [\#311](https://github.com/NiaOrg/NiaPy/issues/311)

**Merged pull requests:**

- Fixed import error. [\#312](https://github.com/NiaOrg/NiaPy/pull/312) ([zStupan](https://github.com/zStupan))

## [2.0.0rc15](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc15) (2021-05-14)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc14...2.0.0rc15)

**Implemented enhancements:**

- \[JOSS\] \(Optional\) Follow PEP-8 style guide in naming methods [\#123](https://github.com/NiaOrg/NiaPy/issues/123)

**Closed issues:**

- Several TODOs in ca.py [\#306](https://github.com/NiaOrg/NiaPy/issues/306)
- limit\_repair method alters the input array [\#294](https://github.com/NiaOrg/NiaPy/issues/294)
- CuckooSearch's runIteration is incompatible with other algorithms runIteration [\#281](https://github.com/NiaOrg/NiaPy/issues/281)
- """ [\#264](https://github.com/NiaOrg/NiaPy/issues/264)

**Merged pull requests:**

- Huge refactor [\#309](https://github.com/NiaOrg/NiaPy/pull/309) ([zStupan](https://github.com/zStupan))
- corrected reference URL for basic hs algorithm [\#307](https://github.com/NiaOrg/NiaPy/pull/307) ([firefly-cpp](https://github.com/firefly-cpp))
- Switched to numpy.random.Generator for generating random numbers [\#305](https://github.com/NiaOrg/NiaPy/pull/305) ([zStupan](https://github.com/zStupan))

## [2.0.0rc14](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc14) (2021-04-23)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc13...2.0.0rc14)

**Closed issues:**

- scipy dependency [\#303](https://github.com/NiaOrg/NiaPy/issues/303)
- Python 2.7 support [\#301](https://github.com/NiaOrg/NiaPy/issues/301)
- Deprecation warnings [\#297](https://github.com/NiaOrg/NiaPy/issues/297)
- Bug in Algorithm.runYield - runIteration executes nGEN - 1 times [\#293](https://github.com/NiaOrg/NiaPy/issues/293)
- User defined function [\#292](https://github.com/NiaOrg/NiaPy/issues/292)

**Merged pull requests:**

- Removed scipy dependency [\#304](https://github.com/NiaOrg/NiaPy/pull/304) ([zStupan](https://github.com/zStupan))
- Dropped Python 2 Support [\#302](https://github.com/NiaOrg/NiaPy/pull/302) ([zStupan](https://github.com/zStupan))
- Run method fix [\#300](https://github.com/NiaOrg/NiaPy/pull/300) ([zStupan](https://github.com/zStupan))
- Deprecation warnings and JADE fix [\#299](https://github.com/NiaOrg/NiaPy/pull/299) ([sisco0](https://github.com/sisco0))
- some nitpicks [\#298](https://github.com/NiaOrg/NiaPy/pull/298) ([firefly-cpp](https://github.com/firefly-cpp))
- docs: add zStupan as a contributor [\#296](https://github.com/NiaOrg/NiaPy/pull/296) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Fixed bug in Algorithm.runYield [\#295](https://github.com/NiaOrg/NiaPy/pull/295) ([zStupan](https://github.com/zStupan))
- np.float is deprecated [\#291](https://github.com/NiaOrg/NiaPy/pull/291) ([firefly-cpp](https://github.com/firefly-cpp))
- BFOA quick fix [\#290](https://github.com/NiaOrg/NiaPy/pull/290) ([zStupan](https://github.com/zStupan))

## [2.0.0rc13](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc13) (2021-03-10)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc12...2.0.0rc13)

**Closed issues:**

- BFOA implementation [\#288](https://github.com/NiaOrg/NiaPy/issues/288)
- BAT [\#286](https://github.com/NiaOrg/NiaPy/issues/286)
- BAT Optimization Algorithm [\#285](https://github.com/NiaOrg/NiaPy/issues/285)
- NiaPy conda dependecy problem [\#284](https://github.com/NiaOrg/NiaPy/issues/284)
- xlwt is archived: consider dropping xlwt requirement? [\#283](https://github.com/NiaOrg/NiaPy/issues/283)
- . [\#263](https://github.com/NiaOrg/NiaPy/issues/263)

**Merged pull requests:**

- BFOA Fix [\#289](https://github.com/NiaOrg/NiaPy/pull/289) ([zStupan](https://github.com/zStupan))
- BFOA [\#287](https://github.com/NiaOrg/NiaPy/pull/287) ([zStupan](https://github.com/zStupan))

## [2.0.0rc12](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc12) (2020-12-04)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc11...2.0.0rc12)

**Fixed bugs:**

- Fixing issues related to tests at infinity benchmark and NPAging DE. [\#267](https://github.com/NiaOrg/NiaPy/pull/267) ([sisco0](https://github.com/sisco0))
- Fix build description [\#261](https://github.com/NiaOrg/NiaPy/pull/261) ([GregaVrbancic](https://github.com/GregaVrbancic))

**Closed issues:**

- Fedora rpm build | two tests are failing [\#252](https://github.com/NiaOrg/NiaPy/issues/252)

**Merged pull requests:**

- Harris Hawks Optimization integration [\#280](https://github.com/NiaOrg/NiaPy/pull/280) ([sisco0](https://github.com/sisco0))
- Fixed some LaTeX formulas [\#279](https://github.com/NiaOrg/NiaPy/pull/279) ([sisco0](https://github.com/sisco0))
- Implementation of PLBA algorithm [\#278](https://github.com/NiaOrg/NiaPy/pull/278) ([firefly-cpp](https://github.com/firefly-cpp))
- several TODOs removed [\#277](https://github.com/NiaOrg/NiaPy/pull/277) ([firefly-cpp](https://github.com/firefly-cpp))
- tests for RS algorithm [\#276](https://github.com/NiaOrg/NiaPy/pull/276) ([firefly-cpp](https://github.com/firefly-cpp))
- corrections in table [\#275](https://github.com/NiaOrg/NiaPy/pull/275) ([firefly-cpp](https://github.com/firefly-cpp))
- Exception handling & Random Search implementation [\#274](https://github.com/NiaOrg/NiaPy/pull/274) ([firefly-cpp](https://github.com/firefly-cpp))
- Table of implemented algorithms added [\#273](https://github.com/NiaOrg/NiaPy/pull/273) ([firefly-cpp](https://github.com/firefly-cpp))
- removing TabuSearch - immature version [\#272](https://github.com/NiaOrg/NiaPy/pull/272) ([firefly-cpp](https://github.com/firefly-cpp))
- Update README.md [\#271](https://github.com/NiaOrg/NiaPy/pull/271) ([GregaVrbancic](https://github.com/GregaVrbancic))
- LaTeX codes [\#270](https://github.com/NiaOrg/NiaPy/pull/270) ([sisco0](https://github.com/sisco0))
- Update issue templates [\#269](https://github.com/NiaOrg/NiaPy/pull/269) ([GregaVrbancic](https://github.com/GregaVrbancic))
- docs: add sisco0 as a contributor [\#268](https://github.com/NiaOrg/NiaPy/pull/268) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- reference added, small fixes [\#265](https://github.com/NiaOrg/NiaPy/pull/265) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Fixes [\#262](https://github.com/NiaOrg/NiaPy/pull/262) ([lucijabrezocnik](https://github.com/lucijabrezocnik))

## [2.0.0rc11](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc11) (2020-07-19)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc10...2.0.0rc11)

**Implemented enhancements:**

- Add workflow for publish to anaconda, setup.py fixes [\#259](https://github.com/NiaOrg/NiaPy/pull/259) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Fix runner exports [\#254](https://github.com/NiaOrg/NiaPy/pull/254) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Add python 3.8 [\#250](https://github.com/NiaOrg/NiaPy/pull/250) ([GregaVrbancic](https://github.com/GregaVrbancic))

**Fixed bugs:**

- OptimizationType.MAXIMIZATION does not work with GWO [\#246](https://github.com/NiaOrg/NiaPy/issues/246)
- Possible issue with unit test [\#241](https://github.com/NiaOrg/NiaPy/issues/241)
- GWO TypeError: unsupported operand type\(s\) [\#218](https://github.com/NiaOrg/NiaPy/issues/218)
- Fix algorithm utility to work with python2 and add tests [\#239](https://github.com/NiaOrg/NiaPy/pull/239) ([GregaVrbancic](https://github.com/GregaVrbancic))

**Closed issues:**

- No module named 'NiaPy.task' [\#243](https://github.com/NiaOrg/NiaPy/issues/243)
- Example run.py not working [\#238](https://github.com/NiaOrg/NiaPy/issues/238)
- Algorithms checklist [\#188](https://github.com/NiaOrg/NiaPy/issues/188)

**Merged pull requests:**

- Update versionbump [\#260](https://github.com/NiaOrg/NiaPy/pull/260) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Documentation update [\#258](https://github.com/NiaOrg/NiaPy/pull/258) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Update Sphinx theme, update outdated stuff [\#257](https://github.com/NiaOrg/NiaPy/pull/257) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Documentation update [\#256](https://github.com/NiaOrg/NiaPy/pull/256) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- updated README file [\#255](https://github.com/NiaOrg/NiaPy/pull/255) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Installation instructions for Fedora users [\#253](https://github.com/NiaOrg/NiaPy/pull/253) ([firefly-cpp](https://github.com/firefly-cpp))
- docs: add timzatko as a contributor [\#251](https://github.com/NiaOrg/NiaPy/pull/251) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Fix GWO maximization [\#249](https://github.com/NiaOrg/NiaPy/pull/249) ([GregaVrbancic](https://github.com/GregaVrbancic))
- update getting started documentation [\#248](https://github.com/NiaOrg/NiaPy/pull/248) ([GregaVrbancic](https://github.com/GregaVrbancic))
- docs: add brett18618 as a contributor [\#242](https://github.com/NiaOrg/NiaPy/pull/242) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Fix HSABA, SABA, ABA and fixes for examples [\#240](https://github.com/NiaOrg/NiaPy/pull/240) ([kb2623](https://github.com/kb2623))

## [2.0.0rc10](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc10) (2019-11-12)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc9...2.0.0rc10)

**Implemented enhancements:**

- PSO binary functionality [\#187](https://github.com/NiaOrg/NiaPy/issues/187)
- Development [\#233](https://github.com/NiaOrg/NiaPy/pull/233) ([kb2623](https://github.com/kb2623))

**Fixed bugs:**

- FSS implementation [\#186](https://github.com/NiaOrg/NiaPy/issues/186)
- FPA implementation [\#185](https://github.com/NiaOrg/NiaPy/issues/185)

## [2.0.0rc9](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc9) (2019-11-11)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc8...2.0.0rc9)

**Merged pull requests:**

- Fix publish workflow [\#236](https://github.com/NiaOrg/NiaPy/pull/236) ([GregaVrbancic](https://github.com/GregaVrbancic))

## [2.0.0rc8](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc8) (2019-11-11)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc7...2.0.0rc8)

**Merged pull requests:**

- Fix pypi README [\#235](https://github.com/NiaOrg/NiaPy/pull/235) ([GregaVrbancic](https://github.com/GregaVrbancic))

## [2.0.0rc7](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc7) (2019-11-11)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc6...2.0.0rc7)

**Merged pull requests:**

- Fix bump2version [\#234](https://github.com/NiaOrg/NiaPy/pull/234) ([GregaVrbancic](https://github.com/GregaVrbancic))

## [2.0.0rc6](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc6) (2019-11-11)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc5...2.0.0rc6)

**Closed issues:**

- Confusion with GSO [\#221](https://github.com/NiaOrg/NiaPy/issues/221)
- No module named 'NiaPy.algorithms' [\#219](https://github.com/NiaOrg/NiaPy/issues/219)
- Documentation fix [\#211](https://github.com/NiaOrg/NiaPy/issues/211)

**Merged pull requests:**

- docs: add jhmenke as a contributor [\#232](https://github.com/NiaOrg/NiaPy/pull/232) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- replacing badges and mentions of appveyor and travis [\#231](https://github.com/NiaOrg/NiaPy/pull/231) ([GregaVrbancic](https://github.com/GregaVrbancic))
- cleanup old ci configurations [\#230](https://github.com/NiaOrg/NiaPy/pull/230) ([GregaVrbancic](https://github.com/GregaVrbancic))
- docs: add FlorianShepherd as a contributor [\#229](https://github.com/NiaOrg/NiaPy/pull/229) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- docs: add musawakiliML as a contributor [\#228](https://github.com/NiaOrg/NiaPy/pull/228) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Automatic Release [\#226](https://github.com/NiaOrg/NiaPy/pull/226) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Fixes comments in runner.py [\#225](https://github.com/NiaOrg/NiaPy/pull/225) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fix comment. replace mutation and crossover with uniform one. [\#223](https://github.com/NiaOrg/NiaPy/pull/223) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fix runner nRuns issue [\#222](https://github.com/NiaOrg/NiaPy/pull/222) ([GregaVrbancic](https://github.com/GregaVrbancic))
- update run\_jde.py [\#217](https://github.com/NiaOrg/NiaPy/pull/217) ([rhododendrom](https://github.com/rhododendrom))
- Added Cat Swarm Optimization algorithm [\#216](https://github.com/NiaOrg/NiaPy/pull/216) ([mihael-mika](https://github.com/mihael-mika))
- Bea algorithm [\#214](https://github.com/NiaOrg/NiaPy/pull/214) ([RokPot](https://github.com/RokPot))

## [2.0.0rc5](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc5) (2019-05-06)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc4...2.0.0rc5)

**Implemented enhancements:**

- Update Runner to accept an array of algorithm objects or strings [\#189](https://github.com/NiaOrg/NiaPy/issues/189)
- Merging logging and printing task in StoppingTask  [\#208](https://github.com/NiaOrg/NiaPy/pull/208) ([firefly-cpp](https://github.com/firefly-cpp))
- Upgrade runner [\#206](https://github.com/NiaOrg/NiaPy/pull/206) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Foa fix [\#199](https://github.com/NiaOrg/NiaPy/pull/199) ([lukapecnik](https://github.com/lukapecnik))
- New examples \(algorithm info + custom init population function\) [\#198](https://github.com/NiaOrg/NiaPy/pull/198) ([firefly-cpp](https://github.com/firefly-cpp))
- Dependencies, code style, etc. [\#196](https://github.com/NiaOrg/NiaPy/pull/196) ([GregaVrbancic](https://github.com/GregaVrbancic))

**Fixed bugs:**

- jDE runs without stopping [\#201](https://github.com/NiaOrg/NiaPy/issues/201)
- Logger [\#178](https://github.com/NiaOrg/NiaPy/issues/178)

**Closed issues:**

- Initial Update [\#200](https://github.com/NiaOrg/NiaPy/issues/200)
- Port FSS algorithm to the new style [\#167](https://github.com/NiaOrg/NiaPy/issues/167)
- Documentation improvements [\#155](https://github.com/NiaOrg/NiaPy/issues/155)

**Merged pull requests:**

- Custom init pop example fix [\#213](https://github.com/NiaOrg/NiaPy/pull/213) ([firefly-cpp](https://github.com/firefly-cpp))
- Fixed example and readme.md [\#212](https://github.com/NiaOrg/NiaPy/pull/212) ([bankojan](https://github.com/bankojan))
- minor fix in examples [\#210](https://github.com/NiaOrg/NiaPy/pull/210) ([firefly-cpp](https://github.com/firefly-cpp))
- Removing ScalingTask & MoveTask [\#209](https://github.com/NiaOrg/NiaPy/pull/209) ([firefly-cpp](https://github.com/firefly-cpp))
- MBO algorithm implementation. [\#207](https://github.com/NiaOrg/NiaPy/pull/207) ([bankojan](https://github.com/bankojan))
- FOA tree aging and limitRepair bug fix. [\#205](https://github.com/NiaOrg/NiaPy/pull/205) ([lukapecnik](https://github.com/lukapecnik))
- Fixes [\#203](https://github.com/NiaOrg/NiaPy/pull/203) ([kb2623](https://github.com/kb2623))
- BA and HBA [\#202](https://github.com/NiaOrg/NiaPy/pull/202) ([kb2623](https://github.com/kb2623))
- More modified examples [\#197](https://github.com/NiaOrg/NiaPy/pull/197) ([firefly-cpp](https://github.com/firefly-cpp))
- Example for custom benchmark [\#195](https://github.com/NiaOrg/NiaPy/pull/195) ([firefly-cpp](https://github.com/firefly-cpp))
- Some changes in BA and HBA [\#194](https://github.com/NiaOrg/NiaPy/pull/194) ([firefly-cpp](https://github.com/firefly-cpp))
- significant commit of flower pollination algorithm [\#193](https://github.com/NiaOrg/NiaPy/pull/193) ([rhododendrom](https://github.com/rhododendrom))
- update of sigma calculation [\#192](https://github.com/NiaOrg/NiaPy/pull/192) ([rhododendrom](https://github.com/rhododendrom))
- PSO minor changes [\#191](https://github.com/NiaOrg/NiaPy/pull/191) ([firefly-cpp](https://github.com/firefly-cpp))
- Simplified examples - part 2 [\#190](https://github.com/NiaOrg/NiaPy/pull/190) ([firefly-cpp](https://github.com/firefly-cpp))
- Simplified examples [\#184](https://github.com/NiaOrg/NiaPy/pull/184) ([firefly-cpp](https://github.com/firefly-cpp))
- New features. [\#183](https://github.com/NiaOrg/NiaPy/pull/183) ([kb2623](https://github.com/kb2623))
- FOA examples added and README.md update [\#181](https://github.com/NiaOrg/NiaPy/pull/181) ([lukapecnik](https://github.com/lukapecnik))
- FOA [\#180](https://github.com/NiaOrg/NiaPy/pull/180) ([lukapecnik](https://github.com/lukapecnik))
- add scandir dev dependency [\#176](https://github.com/NiaOrg/NiaPy/pull/176) ([GregaVrbancic](https://github.com/GregaVrbancic))
- New algorithms and port of old algorithms [\#175](https://github.com/NiaOrg/NiaPy/pull/175) ([kb2623](https://github.com/kb2623))
- fix scrutinizer python version [\#174](https://github.com/NiaOrg/NiaPy/pull/174) ([GregaVrbancic](https://github.com/GregaVrbancic))
- New tests [\#173](https://github.com/NiaOrg/NiaPy/pull/173) ([firefly-cpp](https://github.com/firefly-cpp))

## [2.0.0rc4](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc4) (2018-11-30)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc3...2.0.0rc4)

## [2.0.0rc3](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc3) (2018-11-30)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/1.0.2...2.0.0rc3)

**Closed issues:**

- New mechanism for stopCond and old best values [\#168](https://github.com/NiaOrg/NiaPy/issues/168)
- Coral Reefs Optimization Algorithm \(CRO\) and Anarchic society optimization \(ASO\)  [\#148](https://github.com/NiaOrg/NiaPy/issues/148)

**Merged pull requests:**

- Added iterations counter to some of the algorithms [\#171](https://github.com/NiaOrg/NiaPy/pull/171) ([kb2623](https://github.com/kb2623))
- Added fixes for stopping conditions [\#170](https://github.com/NiaOrg/NiaPy/pull/170) ([kb2623](https://github.com/kb2623))
- Added stopping conditions [\#169](https://github.com/NiaOrg/NiaPy/pull/169) ([kb2623](https://github.com/kb2623))
- Fish school search implementation in old format [\#166](https://github.com/NiaOrg/NiaPy/pull/166) ([tuahk](https://github.com/tuahk))
- update of comments: algorithm.py [\#165](https://github.com/NiaOrg/NiaPy/pull/165) ([rhododendrom](https://github.com/rhododendrom))
- New tests for MFO [\#164](https://github.com/NiaOrg/NiaPy/pull/164) ([firefly-cpp](https://github.com/firefly-cpp))
- Moth Flame Optimization [\#163](https://github.com/NiaOrg/NiaPy/pull/163) ([kivancguckiran](https://github.com/kivancguckiran))
- update conda build for version 1.0.2 [\#162](https://github.com/NiaOrg/NiaPy/pull/162) ([GregaVrbancic](https://github.com/GregaVrbancic))
- add conda recipe [\#160](https://github.com/NiaOrg/NiaPy/pull/160) ([GregaVrbancic](https://github.com/GregaVrbancic))
- update comments [\#159](https://github.com/NiaOrg/NiaPy/pull/159) ([rhododendrom](https://github.com/rhododendrom))
- Fixes [\#158](https://github.com/NiaOrg/NiaPy/pull/158) ([kb2623](https://github.com/kb2623))
- HBA - bugfix [\#157](https://github.com/NiaOrg/NiaPy/pull/157) ([kivancguckiran](https://github.com/kivancguckiran))

## [1.0.2](https://github.com/NiaOrg/NiaPy/tree/1.0.2) (2018-10-24)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2...1.0.2)

**Fixed bugs:**

- Hybrid Bat Algorithm coding mistake? [\#156](https://github.com/NiaOrg/NiaPy/issues/156)

**Merged pull requests:**

- fix Bat Algorithm [\#161](https://github.com/NiaOrg/NiaPy/pull/161) ([GregaVrbancic](https://github.com/GregaVrbancic))

## [2](https://github.com/NiaOrg/NiaPy/tree/2) (2018-08-30)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc2...2)

## [2.0.0rc2](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc2) (2018-08-30)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/2.0.0rc1...2.0.0rc2)

## [2.0.0rc1](https://github.com/NiaOrg/NiaPy/tree/2.0.0rc1) (2018-08-30)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/1.0.1...2.0.0rc1)

**Fixed bugs:**

- Differential evolution implementation  [\#135](https://github.com/NiaOrg/NiaPy/issues/135)

**Closed issues:**

- New feature: Support for maximization problems [\#146](https://github.com/NiaOrg/NiaPy/issues/146)
- New algorithms [\#145](https://github.com/NiaOrg/NiaPy/issues/145)
- Counting evaluations [\#142](https://github.com/NiaOrg/NiaPy/issues/142)
- Convergence plots [\#136](https://github.com/NiaOrg/NiaPy/issues/136)

**Merged pull requests:**

- fix rtd conf [\#154](https://github.com/NiaOrg/NiaPy/pull/154) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fix rtd conf [\#153](https://github.com/NiaOrg/NiaPy/pull/153) ([GregaVrbancic](https://github.com/GregaVrbancic))
- add docs dependency [\#152](https://github.com/NiaOrg/NiaPy/pull/152) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Docs build fix [\#151](https://github.com/NiaOrg/NiaPy/pull/151) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Fixes and new algorithm [\#150](https://github.com/NiaOrg/NiaPy/pull/150) ([kb2623](https://github.com/kb2623))
- New optimization algorithm and fixes for old ones [\#149](https://github.com/NiaOrg/NiaPy/pull/149) ([kb2623](https://github.com/kb2623))
- New features [\#147](https://github.com/NiaOrg/NiaPy/pull/147) ([kb2623](https://github.com/kb2623))
- Algorithm refactoring [\#144](https://github.com/NiaOrg/NiaPy/pull/144) ([kb2623](https://github.com/kb2623))
- New algorithms and benchmarks [\#143](https://github.com/NiaOrg/NiaPy/pull/143) ([kb2623](https://github.com/kb2623))
- update [\#141](https://github.com/NiaOrg/NiaPy/pull/141) ([rhododendrom](https://github.com/rhododendrom))
- Update run\_fa.py [\#140](https://github.com/NiaOrg/NiaPy/pull/140) ([rhododendrom](https://github.com/rhododendrom))
- Update run\_abc.py [\#139](https://github.com/NiaOrg/NiaPy/pull/139) ([rhododendrom](https://github.com/rhododendrom))
- fix failing build [\#138](https://github.com/NiaOrg/NiaPy/pull/138) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Fixed DE evaluations counter [\#137](https://github.com/NiaOrg/NiaPy/pull/137) ([mlaky88](https://github.com/mlaky88))
- Fix renamed PyPI package [\#134](https://github.com/NiaOrg/NiaPy/pull/134) ([jacebrowning](https://github.com/jacebrowning))
- style fix [\#133](https://github.com/NiaOrg/NiaPy/pull/133) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- style fix [\#132](https://github.com/NiaOrg/NiaPy/pull/132) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- style fix [\#131](https://github.com/NiaOrg/NiaPy/pull/131) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- citing [\#130](https://github.com/NiaOrg/NiaPy/pull/130) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Zenodo added [\#129](https://github.com/NiaOrg/NiaPy/pull/129) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- DOI added [\#128](https://github.com/NiaOrg/NiaPy/pull/128) ([lucijabrezocnik](https://github.com/lucijabrezocnik))

## [1.0.1](https://github.com/NiaOrg/NiaPy/tree/1.0.1) (2018-03-21)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/1.0.0...1.0.1)

**Closed issues:**

- \[JOSS\] Clarify target audience [\#122](https://github.com/NiaOrg/NiaPy/issues/122)
- \[JOSS\] Comment on existing libraries/frameworks [\#121](https://github.com/NiaOrg/NiaPy/issues/121)
- \[JOSS\] Better API Documentation [\#120](https://github.com/NiaOrg/NiaPy/issues/120)
- \[JOSS\] Clarify set-up requirements in README and requirements.txt [\#119](https://github.com/NiaOrg/NiaPy/issues/119)
- Testing the algorithms [\#85](https://github.com/NiaOrg/NiaPy/issues/85)
- JOSS paper [\#60](https://github.com/NiaOrg/NiaPy/issues/60)

**Merged pull requests:**

- fix [\#127](https://github.com/NiaOrg/NiaPy/pull/127) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- reference Fix [\#126](https://github.com/NiaOrg/NiaPy/pull/126) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Documentation added [\#125](https://github.com/NiaOrg/NiaPy/pull/125) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- fix for issue \#119 [\#124](https://github.com/NiaOrg/NiaPy/pull/124) ([GregaVrbancic](https://github.com/GregaVrbancic))
- dois added [\#118](https://github.com/NiaOrg/NiaPy/pull/118) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- fixes [\#117](https://github.com/NiaOrg/NiaPy/pull/117) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Fix paper title [\#116](https://github.com/NiaOrg/NiaPy/pull/116) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Fix paper [\#115](https://github.com/NiaOrg/NiaPy/pull/115) ([GregaVrbancic](https://github.com/GregaVrbancic))
- arguments: Ts-\>integer; TournamentSelection: use shuffled indices in … [\#114](https://github.com/NiaOrg/NiaPy/pull/114) ([mlaky88](https://github.com/mlaky88))

## [1.0.0](https://github.com/NiaOrg/NiaPy/tree/1.0.0) (2018-02-28)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/1.0.0rc2...1.0.0)

**Merged pull requests:**

- Runner export [\#39](https://github.com/NiaOrg/NiaPy/pull/39) ([GregaVrbancic](https://github.com/GregaVrbancic))

## [1.0.0rc2](https://github.com/NiaOrg/NiaPy/tree/1.0.0rc2) (2018-02-28)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/1.0.0rc1...1.0.0rc2)

## [1.0.0rc1](https://github.com/NiaOrg/NiaPy/tree/1.0.0rc1) (2018-02-28)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/0.1.3a2...1.0.0rc1)

**Merged pull requests:**

- fix algorithms docs [\#113](https://github.com/NiaOrg/NiaPy/pull/113) ([GregaVrbancic](https://github.com/GregaVrbancic))
- cleanup [\#112](https://github.com/NiaOrg/NiaPy/pull/112) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fix README.rst [\#111](https://github.com/NiaOrg/NiaPy/pull/111) ([GregaVrbancic](https://github.com/GregaVrbancic))
- code style fixes [\#110](https://github.com/NiaOrg/NiaPy/pull/110) ([GregaVrbancic](https://github.com/GregaVrbancic))
- whitespace fix [\#109](https://github.com/NiaOrg/NiaPy/pull/109) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Pso algorithm [\#108](https://github.com/NiaOrg/NiaPy/pull/108) ([GregaVrbancic](https://github.com/GregaVrbancic))
- CS levy flight fix [\#106](https://github.com/NiaOrg/NiaPy/pull/106) ([mlaky88](https://github.com/mlaky88))
- fix cs code style [\#105](https://github.com/NiaOrg/NiaPy/pull/105) ([GregaVrbancic](https://github.com/GregaVrbancic))
- CS fix [\#103](https://github.com/NiaOrg/NiaPy/pull/103) ([mlaky88](https://github.com/mlaky88))
- Documentation [\#102](https://github.com/NiaOrg/NiaPy/pull/102) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Finishing runner [\#101](https://github.com/NiaOrg/NiaPy/pull/101) ([GregaVrbancic](https://github.com/GregaVrbancic))

## [0.1.3a2](https://github.com/NiaOrg/NiaPy/tree/0.1.3a2) (2018-02-26)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/0.1.3a1...0.1.3a2)

## [0.1.3a1](https://github.com/NiaOrg/NiaPy/tree/0.1.3a1) (2018-02-26)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/0.1.2a4...0.1.3a1)

## [0.1.2a4](https://github.com/NiaOrg/NiaPy/tree/0.1.2a4) (2018-02-26)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/0.1.2a3...0.1.2a4)

## [0.1.2a3](https://github.com/NiaOrg/NiaPy/tree/0.1.2a3) (2018-02-26)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/0.1.2a2...0.1.2a3)

## [0.1.2a2](https://github.com/NiaOrg/NiaPy/tree/0.1.2a2) (2018-02-26)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/0.1.2a1...0.1.2a2)

**Merged pull requests:**

- fix [\#100](https://github.com/NiaOrg/NiaPy/pull/100) ([lucijabrezocnik](https://github.com/lucijabrezocnik))

## [0.1.2a1](https://github.com/NiaOrg/NiaPy/tree/0.1.2a1) (2018-02-26)

[Full Changelog](https://github.com/NiaOrg/NiaPy/compare/cd5a1ff3e1c9f426fde8b40a625abc654c5434c2...0.1.2a1)

**Merged pull requests:**

- version 0.1.2a1 [\#99](https://github.com/NiaOrg/NiaPy/pull/99) ([GregaVrbancic](https://github.com/GregaVrbancic))
- ga fix [\#98](https://github.com/NiaOrg/NiaPy/pull/98) ([mlaky88](https://github.com/mlaky88))
- test fix [\#97](https://github.com/NiaOrg/NiaPy/pull/97) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- fix docs [\#96](https://github.com/NiaOrg/NiaPy/pull/96) ([GregaVrbancic](https://github.com/GregaVrbancic))
- cs and pso fix [\#95](https://github.com/NiaOrg/NiaPy/pull/95) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- add getting started guide [\#94](https://github.com/NiaOrg/NiaPy/pull/94) ([GregaVrbancic](https://github.com/GregaVrbancic))
- algorithms docs fix [\#93](https://github.com/NiaOrg/NiaPy/pull/93) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- algorithms documentation fix [\#92](https://github.com/NiaOrg/NiaPy/pull/92) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- documentation fix [\#91](https://github.com/NiaOrg/NiaPy/pull/91) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Latex [\#90](https://github.com/NiaOrg/NiaPy/pull/90) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- fixes docs building [\#89](https://github.com/NiaOrg/NiaPy/pull/89) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fix code style [\#88](https://github.com/NiaOrg/NiaPy/pull/88) ([GregaVrbancic](https://github.com/GregaVrbancic))
- changes in DE & jDE [\#87](https://github.com/NiaOrg/NiaPy/pull/87) ([rhododendrom](https://github.com/rhododendrom))
- More changes in CS [\#86](https://github.com/NiaOrg/NiaPy/pull/86) ([rhododendrom](https://github.com/rhododendrom))
- Fixed some problems in CS [\#84](https://github.com/NiaOrg/NiaPy/pull/84) ([rhododendrom](https://github.com/rhododendrom))
- fix auto build docs [\#83](https://github.com/NiaOrg/NiaPy/pull/83) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fix docs build [\#82](https://github.com/NiaOrg/NiaPy/pull/82) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Gen docs [\#81](https://github.com/NiaOrg/NiaPy/pull/81) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fix indent [\#80](https://github.com/NiaOrg/NiaPy/pull/80) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- typo [\#79](https://github.com/NiaOrg/NiaPy/pull/79) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- new algorithms [\#78](https://github.com/NiaOrg/NiaPy/pull/78) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- NiaPy logo added [\#77](https://github.com/NiaOrg/NiaPy/pull/77) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- fix codestyle [\#76](https://github.com/NiaOrg/NiaPy/pull/76) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fixing codestyle [\#75](https://github.com/NiaOrg/NiaPy/pull/75) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Fixed evals, added cuckoo search [\#74](https://github.com/NiaOrg/NiaPy/pull/74) ([mlaky88](https://github.com/mlaky88))
- Refactoring [\#73](https://github.com/NiaOrg/NiaPy/pull/73) ([GregaVrbancic](https://github.com/GregaVrbancic))
- latex documentation fixes [\#72](https://github.com/NiaOrg/NiaPy/pull/72) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- benchmark tests added [\#71](https://github.com/NiaOrg/NiaPy/pull/71) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- tests added [\#70](https://github.com/NiaOrg/NiaPy/pull/70) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Gen docs [\#69](https://github.com/NiaOrg/NiaPy/pull/69) ([GregaVrbancic](https://github.com/GregaVrbancic))
- docs descriptions [\#68](https://github.com/NiaOrg/NiaPy/pull/68) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- prepare for docs [\#67](https://github.com/NiaOrg/NiaPy/pull/67) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- fix issues [\#66](https://github.com/NiaOrg/NiaPy/pull/66) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Readthedocs configuration [\#65](https://github.com/NiaOrg/NiaPy/pull/65) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Cleanup docs and fix benchmark comments [\#64](https://github.com/NiaOrg/NiaPy/pull/64) ([GregaVrbancic](https://github.com/GregaVrbancic))
- docs generation [\#63](https://github.com/NiaOrg/NiaPy/pull/63) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Gen docs [\#62](https://github.com/NiaOrg/NiaPy/pull/62) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Generate docs [\#61](https://github.com/NiaOrg/NiaPy/pull/61) ([GregaVrbancic](https://github.com/GregaVrbancic))
- fix csendes benchmark [\#59](https://github.com/NiaOrg/NiaPy/pull/59) ([GregaVrbancic](https://github.com/GregaVrbancic))
- compatibility bugfixes [\#58](https://github.com/NiaOrg/NiaPy/pull/58) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Docs [\#57](https://github.com/NiaOrg/NiaPy/pull/57) ([GregaVrbancic](https://github.com/GregaVrbancic))
- add OS compatibillity fixes. [\#56](https://github.com/NiaOrg/NiaPy/pull/56) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Improved Docs [\#55](https://github.com/NiaOrg/NiaPy/pull/55) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Styblinski-Tang Function added [\#54](https://github.com/NiaOrg/NiaPy/pull/54) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Sum Squares added [\#53](https://github.com/NiaOrg/NiaPy/pull/53) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- decimal fixes [\#52](https://github.com/NiaOrg/NiaPy/pull/52) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Stepint function added [\#51](https://github.com/NiaOrg/NiaPy/pull/51) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Step function [\#50](https://github.com/NiaOrg/NiaPy/pull/50) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Schumer Steiglitz Function [\#49](https://github.com/NiaOrg/NiaPy/pull/49) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Salomon function [\#48](https://github.com/NiaOrg/NiaPy/pull/48) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Quintic function added [\#47](https://github.com/NiaOrg/NiaPy/pull/47) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Qing function added [\#46](https://github.com/NiaOrg/NiaPy/pull/46) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Pinter function added [\#45](https://github.com/NiaOrg/NiaPy/pull/45) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Csendes function [\#44](https://github.com/NiaOrg/NiaPy/pull/44) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Chung reynolds function [\#43](https://github.com/NiaOrg/NiaPy/pull/43) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Ridge function [\#42](https://github.com/NiaOrg/NiaPy/pull/42) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- fix latex export [\#41](https://github.com/NiaOrg/NiaPy/pull/41) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Happy cat function added [\#40](https://github.com/NiaOrg/NiaPy/pull/40) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- add comment of arguments for fpa.py [\#38](https://github.com/NiaOrg/NiaPy/pull/38) ([rhododendrom](https://github.com/rhododendrom))
- Move test [\#37](https://github.com/NiaOrg/NiaPy/pull/37) ([GregaVrbancic](https://github.com/GregaVrbancic))
- description added [\#36](https://github.com/NiaOrg/NiaPy/pull/36) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- Feature functions2 [\#35](https://github.com/NiaOrg/NiaPy/pull/35) ([lucijabrezocnik](https://github.com/lucijabrezocnik))
- add runner export to xlsx [\#34](https://github.com/NiaOrg/NiaPy/pull/34) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Runner export [\#33](https://github.com/NiaOrg/NiaPy/pull/33) ([GregaVrbancic](https://github.com/GregaVrbancic))
- Feature functions2 [\#32](https://github.com/NiaOrg/NiaPy/pull/32) ([lucijabrezocnik](https://github.com/lucijabrezocnik))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
