import typing, clr, abc
from System import ICloneable, Array, Array_1
from System.Runtime.Serialization import ISerializable, SerializationInfo, StreamingContext, IDeserializationCallback
from System.Globalization import CultureInfo

class ArrayList(IList, ICloneable):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, c: ICollection) -> None: ...
    @typing.overload
    def __init__(self, capacity: int) -> None: ...
    @property
    def Capacity(self) -> int: ...
    @Capacity.setter
    def Capacity(self, value: int) -> int: ...
    @property
    def Count(self) -> int: ...
    @property
    def IsFixedSize(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def IsSynchronized(self) -> bool: ...
    @property
    def Item(self) -> typing.Any: ...
    @Item.setter
    def Item(self, value: typing.Any) -> typing.Any: ...
    @property
    def SyncRoot(self) -> typing.Any: ...
    @staticmethod
    def Adapter(list: IList) -> ArrayList: ...
    def Add(self, value: typing.Any) -> int: ...
    def AddRange(self, c: ICollection) -> None: ...
    def Clear(self) -> None: ...
    def Clone(self) -> typing.Any: ...
    def Contains(self, item: typing.Any) -> bool: ...
    def GetRange(self, index: int, count: int) -> ArrayList: ...
    def Insert(self, index: int, value: typing.Any) -> None: ...
    def InsertRange(self, index: int, c: ICollection) -> None: ...
    def Remove(self, obj: typing.Any) -> None: ...
    def RemoveAt(self, index: int) -> None: ...
    def RemoveRange(self, index: int, count: int) -> None: ...
    @staticmethod
    def Repeat(value: typing.Any, count: int) -> ArrayList: ...
    def SetRange(self, index: int, c: ICollection) -> None: ...
    def TrimToSize(self) -> None: ...
    # Skipped BinarySearch due to it being static, abstract and generic.

    BinarySearch : BinarySearch_MethodGroup
    class BinarySearch_MethodGroup:
        @typing.overload
        def __call__(self, value: typing.Any) -> int:...
        @typing.overload
        def __call__(self, value: typing.Any, comparer: IComparer) -> int:...
        @typing.overload
        def __call__(self, index: int, count: int, value: typing.Any, comparer: IComparer) -> int:...

    # Skipped CopyTo due to it being static, abstract and generic.

    CopyTo : CopyTo_MethodGroup
    class CopyTo_MethodGroup:
        @typing.overload
        def __call__(self, array: Array) -> None:...
        @typing.overload
        def __call__(self, array: Array, arrayIndex: int) -> None:...
        @typing.overload
        def __call__(self, index: int, array: Array, arrayIndex: int, count: int) -> None:...

    # Skipped FixedSize due to it being static, abstract and generic.

    FixedSize : FixedSize_MethodGroup
    class FixedSize_MethodGroup:
        @typing.overload
        def __call__(self, list: ArrayList) -> ArrayList:...
        @typing.overload
        def __call__(self, list: IList) -> IList:...

    # Skipped GetEnumerator due to it being static, abstract and generic.

    GetEnumerator : GetEnumerator_MethodGroup
    class GetEnumerator_MethodGroup:
        @typing.overload
        def __call__(self) -> IEnumerator:...
        @typing.overload
        def __call__(self, index: int, count: int) -> IEnumerator:...

    # Skipped IndexOf due to it being static, abstract and generic.

    IndexOf : IndexOf_MethodGroup
    class IndexOf_MethodGroup:
        @typing.overload
        def __call__(self, value: typing.Any) -> int:...
        @typing.overload
        def __call__(self, value: typing.Any, startIndex: int) -> int:...
        @typing.overload
        def __call__(self, value: typing.Any, startIndex: int, count: int) -> int:...

    # Skipped LastIndexOf due to it being static, abstract and generic.

    LastIndexOf : LastIndexOf_MethodGroup
    class LastIndexOf_MethodGroup:
        @typing.overload
        def __call__(self, value: typing.Any) -> int:...
        @typing.overload
        def __call__(self, value: typing.Any, startIndex: int) -> int:...
        @typing.overload
        def __call__(self, value: typing.Any, startIndex: int, count: int) -> int:...

    # Skipped ReadOnly due to it being static, abstract and generic.

    ReadOnly : ReadOnly_MethodGroup
    class ReadOnly_MethodGroup:
        @typing.overload
        def __call__(self, list: ArrayList) -> ArrayList:...
        @typing.overload
        def __call__(self, list: IList) -> IList:...

    # Skipped Reverse due to it being static, abstract and generic.

    Reverse : Reverse_MethodGroup
    class Reverse_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, index: int, count: int) -> None:...

    # Skipped Sort due to it being static, abstract and generic.

    Sort : Sort_MethodGroup
    class Sort_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, comparer: IComparer) -> None:...
        @typing.overload
        def __call__(self, index: int, count: int, comparer: IComparer) -> None:...

    # Skipped Synchronized due to it being static, abstract and generic.

    Synchronized : Synchronized_MethodGroup
    class Synchronized_MethodGroup:
        @typing.overload
        def __call__(self, list: ArrayList) -> ArrayList:...
        @typing.overload
        def __call__(self, list: IList) -> IList:...

    # Skipped ToArray due to it being static, abstract and generic.

    ToArray : ToArray_MethodGroup
    class ToArray_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[typing.Any]:...
        @typing.overload
        def __call__(self, type: typing.Type[typing.Any]) -> Array:...



class Comparer(ISerializable, IComparer):
    def __init__(self, culture: CultureInfo) -> None: ...
    Default : Comparer
    DefaultInvariant : Comparer
    def Compare(self, a: typing.Any, b: typing.Any) -> int: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...


class DictionaryEntry:
    def __init__(self, key: typing.Any, value: typing.Any) -> None: ...
    @property
    def Key(self) -> typing.Any: ...
    @Key.setter
    def Key(self, value: typing.Any) -> typing.Any: ...
    @property
    def Value(self) -> typing.Any: ...
    @Value.setter
    def Value(self, value: typing.Any) -> typing.Any: ...
    def Deconstruct(self, key: clr.Reference[typing.Any], value: clr.Reference[typing.Any]) -> None: ...


class Hashtable(IDictionary, ICloneable, IDeserializationCallback, ISerializable):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, capacity: int) -> None: ...
    @typing.overload
    def __init__(self, capacity: int, equalityComparer: IEqualityComparer) -> None: ...
    @typing.overload
    def __init__(self, capacity: int, hcp: IHashCodeProvider, comparer: IComparer) -> None: ...
    @typing.overload
    def __init__(self, capacity: int, loadFactor: float) -> None: ...
    @typing.overload
    def __init__(self, capacity: int, loadFactor: float, equalityComparer: IEqualityComparer) -> None: ...
    @typing.overload
    def __init__(self, capacity: int, loadFactor: float, hcp: IHashCodeProvider, comparer: IComparer) -> None: ...
    @typing.overload
    def __init__(self, d: IDictionary) -> None: ...
    @typing.overload
    def __init__(self, d: IDictionary, equalityComparer: IEqualityComparer) -> None: ...
    @typing.overload
    def __init__(self, d: IDictionary, hcp: IHashCodeProvider, comparer: IComparer) -> None: ...
    @typing.overload
    def __init__(self, d: IDictionary, loadFactor: float) -> None: ...
    @typing.overload
    def __init__(self, d: IDictionary, loadFactor: float, equalityComparer: IEqualityComparer) -> None: ...
    @typing.overload
    def __init__(self, d: IDictionary, loadFactor: float, hcp: IHashCodeProvider, comparer: IComparer) -> None: ...
    @typing.overload
    def __init__(self, equalityComparer: IEqualityComparer) -> None: ...
    @typing.overload
    def __init__(self, hcp: IHashCodeProvider, comparer: IComparer) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def IsFixedSize(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def IsSynchronized(self) -> bool: ...
    @property
    def Item(self) -> typing.Any: ...
    @Item.setter
    def Item(self, value: typing.Any) -> typing.Any: ...
    @property
    def Keys(self) -> ICollection: ...
    @property
    def SyncRoot(self) -> typing.Any: ...
    @property
    def Values(self) -> ICollection: ...
    def Add(self, key: typing.Any, value: typing.Any) -> None: ...
    def Clear(self) -> None: ...
    def Clone(self) -> typing.Any: ...
    def Contains(self, key: typing.Any) -> bool: ...
    def ContainsKey(self, key: typing.Any) -> bool: ...
    def ContainsValue(self, value: typing.Any) -> bool: ...
    def CopyTo(self, array: Array, arrayIndex: int) -> None: ...
    def GetEnumerator(self) -> IDictionaryEnumerator: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def OnDeserialization(self, sender: typing.Any) -> None: ...
    def Remove(self, key: typing.Any) -> None: ...
    @staticmethod
    def Synchronized(table: Hashtable) -> Hashtable: ...


class ICollection(IEnumerable, typing.Protocol):
    @property
    def Count(self) -> int: ...
    @property
    def IsSynchronized(self) -> bool: ...
    @property
    def SyncRoot(self) -> typing.Any: ...
    @abc.abstractmethod
    def CopyTo(self, array: Array, index: int) -> None: ...


class IComparer(typing.Protocol):
    @abc.abstractmethod
    def Compare(self, x: typing.Any, y: typing.Any) -> int: ...


class IDictionary(ICollection, typing.Protocol):
    @property
    def IsFixedSize(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Item(self) -> typing.Any: ...
    @Item.setter
    def Item(self, value: typing.Any) -> typing.Any: ...
    @property
    def Keys(self) -> ICollection: ...
    @property
    def Values(self) -> ICollection: ...
    @abc.abstractmethod
    def Add(self, key: typing.Any, value: typing.Any) -> None: ...
    @abc.abstractmethod
    def Clear(self) -> None: ...
    @abc.abstractmethod
    def Contains(self, key: typing.Any) -> bool: ...
    @abc.abstractmethod
    def GetEnumerator(self) -> IDictionaryEnumerator: ...
    @abc.abstractmethod
    def Remove(self, key: typing.Any) -> None: ...


class IDictionaryEnumerator(IEnumerator, typing.Protocol):
    @property
    def Entry(self) -> DictionaryEntry: ...
    @property
    def Key(self) -> typing.Any: ...
    @property
    def Value(self) -> typing.Any: ...


class IEnumerable(typing.Protocol):
    @abc.abstractmethod
    def GetEnumerator(self) -> IEnumerator: ...
    def __iter__(self) -> typing.Iterator[typing.Any]: ...


class IEnumerator(typing.Protocol):
    @property
    def Current(self) -> typing.Any: ...
    @abc.abstractmethod
    def MoveNext(self) -> bool: ...
    @abc.abstractmethod
    def Reset(self) -> None: ...


class IEqualityComparer(typing.Protocol):
    @abc.abstractmethod
    def Equals(self, x: typing.Any, y: typing.Any) -> bool: ...
    @abc.abstractmethod
    def GetHashCode(self, obj: typing.Any) -> int: ...


class IHashCodeProvider(typing.Protocol):
    @abc.abstractmethod
    def GetHashCode(self, obj: typing.Any) -> int: ...


class IList(ICollection, typing.Protocol):
    @property
    def IsFixedSize(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Item(self) -> typing.Any: ...
    @Item.setter
    def Item(self, value: typing.Any) -> typing.Any: ...
    @abc.abstractmethod
    def Add(self, value: typing.Any) -> int: ...
    @abc.abstractmethod
    def Clear(self) -> None: ...
    @abc.abstractmethod
    def Contains(self, value: typing.Any) -> bool: ...
    @abc.abstractmethod
    def IndexOf(self, value: typing.Any) -> int: ...
    @abc.abstractmethod
    def Insert(self, index: int, value: typing.Any) -> None: ...
    @abc.abstractmethod
    def Remove(self, value: typing.Any) -> None: ...
    @abc.abstractmethod
    def RemoveAt(self, index: int) -> None: ...


class IStructuralComparable(typing.Protocol):
    @abc.abstractmethod
    def CompareTo(self, other: typing.Any, comparer: IComparer) -> int: ...


class IStructuralEquatable(typing.Protocol):
    @abc.abstractmethod
    def Equals(self, other: typing.Any, comparer: IEqualityComparer) -> bool: ...
    @abc.abstractmethod
    def GetHashCode(self, comparer: IEqualityComparer) -> int: ...


class ListDictionaryInternal(IDictionary):
    def __init__(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def IsFixedSize(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def IsSynchronized(self) -> bool: ...
    @property
    def Item(self) -> typing.Any: ...
    @Item.setter
    def Item(self, value: typing.Any) -> typing.Any: ...
    @property
    def Keys(self) -> ICollection: ...
    @property
    def SyncRoot(self) -> typing.Any: ...
    @property
    def Values(self) -> ICollection: ...
    def Add(self, key: typing.Any, value: typing.Any) -> None: ...
    def Clear(self) -> None: ...
    def Contains(self, key: typing.Any) -> bool: ...
    def CopyTo(self, array: Array, index: int) -> None: ...
    def GetEnumerator(self) -> IDictionaryEnumerator: ...
    def Remove(self, key: typing.Any) -> None: ...

