import typing, clr, abc
from System import SystemException, Exception, Array_1, Version, Attribute, ICloneable, MarshalByRefObject, RuntimeMethodHandle, FormatException, Delegate, RuntimeFieldHandle, TypedReference, RuntimeTypeHandle, ApplicationException, MulticastDelegate, IAsyncResult, AsyncCallback, ModuleHandle, Guid, ResolveEventArgs
from System.Collections import IDictionary
from System.Runtime.Serialization import ISerializable, SerializationInfo, StreamingContext, IDeserializationCallback, IObjectReference
from System.Collections.Generic import IEnumerable_1, IList_1
from System.Security import SecurityRuleSet
from System.IO import FileStream, Stream
from System.Globalization import CultureInfo
from System.Configuration.Assemblies import AssemblyHashAlgorithm, AssemblyVersionCompatibility
from System.Runtime.InteropServices import StructLayoutAttribute

class AmbiguousMatchException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class Assembly(ISerializable, ICustomAttributeProvider, abc.ABC):
    @property
    def CodeBase(self) -> str: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DefinedTypes(self) -> IEnumerable_1[TypeInfo]: ...
    @property
    def EntryPoint(self) -> MethodInfo: ...
    @property
    def EscapedCodeBase(self) -> str: ...
    @property
    def ExportedTypes(self) -> IEnumerable_1[typing.Type[typing.Any]]: ...
    @property
    def FullName(self) -> str: ...
    @property
    def GlobalAssemblyCache(self) -> bool: ...
    @property
    def HostContext(self) -> int: ...
    @property
    def ImageRuntimeVersion(self) -> str: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsDynamic(self) -> bool: ...
    @property
    def IsFullyTrusted(self) -> bool: ...
    @property
    def Location(self) -> str: ...
    @property
    def ManifestModule(self) -> Module: ...
    @property
    def Modules(self) -> IEnumerable_1[Module]: ...
    @property
    def ReflectionOnly(self) -> bool: ...
    @property
    def SecurityRuleSet(self) -> SecurityRuleSet: ...
    @staticmethod
    def CreateQualifiedName(assemblyName: str, typeName: str) -> str: ...
    def Equals(self, o: typing.Any) -> bool: ...
    @staticmethod
    def GetAssembly(type: typing.Type[typing.Any]) -> Assembly: ...
    @staticmethod
    def GetCallingAssembly() -> Assembly: ...
    def GetCustomAttributesData(self) -> IList_1[CustomAttributeData]: ...
    @staticmethod
    def GetEntryAssembly() -> Assembly: ...
    @staticmethod
    def GetExecutingAssembly() -> Assembly: ...
    def GetExportedTypes(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetFile(self, name: str) -> FileStream: ...
    def GetForwardedTypes(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetHashCode(self) -> int: ...
    def GetManifestResourceInfo(self, resourceName: str) -> ManifestResourceInfo: ...
    def GetManifestResourceNames(self) -> Array_1[str]: ...
    def GetModule(self, name: str) -> Module: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def GetReferencedAssemblies(self) -> Array_1[AssemblyName]: ...
    def GetTypes(self) -> Array_1[typing.Type[typing.Any]]: ...
    def IsDefined(self, attributeType: typing.Type[typing.Any], inherit: bool) -> bool: ...
    @staticmethod
    def LoadFile(path: str) -> Assembly: ...
    @staticmethod
    def LoadWithPartialName(partialName: str) -> Assembly: ...
    def __eq__(self, left: Assembly, right: Assembly) -> bool: ...
    def __ne__(self, left: Assembly, right: Assembly) -> bool: ...
    @staticmethod
    def ReflectionOnlyLoadFrom(assemblyFile: str) -> Assembly: ...
    def ToString(self) -> str: ...
    @staticmethod
    def UnsafeLoadFrom(assemblyFile: str) -> Assembly: ...
    # Skipped CreateInstance due to it being static, abstract and generic.

    CreateInstance : CreateInstance_MethodGroup
    class CreateInstance_MethodGroup:
        @typing.overload
        def __call__(self, typeName: str) -> typing.Any:...
        @typing.overload
        def __call__(self, typeName: str, ignoreCase: bool) -> typing.Any:...
        @typing.overload
        def __call__(self, typeName: str, ignoreCase: bool, bindingAttr: BindingFlags, binder: Binder, args: Array_1[typing.Any], culture: CultureInfo, activationAttributes: Array_1[typing.Any]) -> typing.Any:...

    # Skipped GetCustomAttributes due to it being static, abstract and generic.

    GetCustomAttributes : GetCustomAttributes_MethodGroup
    class GetCustomAttributes_MethodGroup:
        @typing.overload
        def __call__(self, inherit: bool) -> Array_1[typing.Any]:...
        @typing.overload
        def __call__(self, attributeType: typing.Type[typing.Any], inherit: bool) -> Array_1[typing.Any]:...

    # Skipped GetFiles due to it being static, abstract and generic.

    GetFiles : GetFiles_MethodGroup
    class GetFiles_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[FileStream]:...
        @typing.overload
        def __call__(self, getResourceModules: bool) -> Array_1[FileStream]:...

    # Skipped GetLoadedModules due to it being static, abstract and generic.

    GetLoadedModules : GetLoadedModules_MethodGroup
    class GetLoadedModules_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[Module]:...
        @typing.overload
        def __call__(self, getResourceModules: bool) -> Array_1[Module]:...

    # Skipped GetManifestResourceStream due to it being static, abstract and generic.

    GetManifestResourceStream : GetManifestResourceStream_MethodGroup
    class GetManifestResourceStream_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> Stream:...
        @typing.overload
        def __call__(self, type: typing.Type[typing.Any], name: str) -> Stream:...

    # Skipped GetModules due to it being static, abstract and generic.

    GetModules : GetModules_MethodGroup
    class GetModules_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[Module]:...
        @typing.overload
        def __call__(self, getResourceModules: bool) -> Array_1[Module]:...

    # Skipped GetName due to it being static, abstract and generic.

    GetName : GetName_MethodGroup
    class GetName_MethodGroup:
        @typing.overload
        def __call__(self) -> AssemblyName:...
        @typing.overload
        def __call__(self, copiedName: bool) -> AssemblyName:...

    # Skipped GetSatelliteAssembly due to it being static, abstract and generic.

    GetSatelliteAssembly : GetSatelliteAssembly_MethodGroup
    class GetSatelliteAssembly_MethodGroup:
        @typing.overload
        def __call__(self, culture: CultureInfo) -> Assembly:...
        @typing.overload
        def __call__(self, culture: CultureInfo, version: Version) -> Assembly:...

    # Skipped GetType due to it being static, abstract and generic.

    GetType : GetType_MethodGroup
    class GetType_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> typing.Type[typing.Any]:...
        @typing.overload
        def __call__(self, name: str, throwOnError: bool) -> typing.Type[typing.Any]:...
        @typing.overload
        def __call__(self, name: str, throwOnError: bool, ignoreCase: bool) -> typing.Type[typing.Any]:...

    # Skipped Load due to it being static, abstract and generic.

    Load : Load_MethodGroup
    class Load_MethodGroup:
        @typing.overload
        def __call__(self, rawAssembly: Array_1[int]) -> Assembly:...
        @typing.overload
        def __call__(self, assemblyString: str) -> Assembly:...
        @typing.overload
        def __call__(self, assemblyRef: AssemblyName) -> Assembly:...
        @typing.overload
        def __call__(self, rawAssembly: Array_1[int], rawSymbolStore: Array_1[int]) -> Assembly:...

    # Skipped LoadFrom due to it being static, abstract and generic.

    LoadFrom : LoadFrom_MethodGroup
    class LoadFrom_MethodGroup:
        @typing.overload
        def __call__(self, assemblyFile: str) -> Assembly:...
        @typing.overload
        def __call__(self, assemblyFile: str, hashValue: Array_1[int], hashAlgorithm: AssemblyHashAlgorithm) -> Assembly:...

    # Skipped LoadModule due to it being static, abstract and generic.

    LoadModule : LoadModule_MethodGroup
    class LoadModule_MethodGroup:
        @typing.overload
        def __call__(self, moduleName: str, rawModule: Array_1[int]) -> Module:...
        @typing.overload
        def __call__(self, moduleName: str, rawModule: Array_1[int], rawSymbolStore: Array_1[int]) -> Module:...

    # Skipped ReflectionOnlyLoad due to it being static, abstract and generic.

    ReflectionOnlyLoad : ReflectionOnlyLoad_MethodGroup
    class ReflectionOnlyLoad_MethodGroup:
        @typing.overload
        def __call__(self, rawAssembly: Array_1[int]) -> Assembly:...
        @typing.overload
        def __call__(self, assemblyString: str) -> Assembly:...



class AssemblyAlgorithmIdAttribute(Attribute):
    @typing.overload
    def __init__(self, algorithmId: AssemblyHashAlgorithm) -> None: ...
    @typing.overload
    def __init__(self, algorithmId: int) -> None: ...
    @property
    def AlgorithmId(self) -> int: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyCompanyAttribute(Attribute):
    def __init__(self, company: str) -> None: ...
    @property
    def Company(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyConfigurationAttribute(Attribute):
    def __init__(self, configuration: str) -> None: ...
    @property
    def Configuration(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyContentType(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Default : AssemblyContentType # 0
    WindowsRuntime : AssemblyContentType # 1


class AssemblyCopyrightAttribute(Attribute):
    def __init__(self, copyright: str) -> None: ...
    @property
    def Copyright(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyCultureAttribute(Attribute):
    def __init__(self, culture: str) -> None: ...
    @property
    def Culture(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyDefaultAliasAttribute(Attribute):
    def __init__(self, defaultAlias: str) -> None: ...
    @property
    def DefaultAlias(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyDelaySignAttribute(Attribute):
    def __init__(self, delaySign: bool) -> None: ...
    @property
    def DelaySign(self) -> bool: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyDescriptionAttribute(Attribute):
    def __init__(self, description: str) -> None: ...
    @property
    def Description(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyFileVersionAttribute(Attribute):
    def __init__(self, version: str) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def Version(self) -> str: ...


class AssemblyFlagsAttribute(Attribute):
    # Constructor .ctor(flags : UInt32) was skipped since it collides with above method
    @typing.overload
    def __init__(self, assemblyFlags: int) -> None: ...
    @typing.overload
    def __init__(self, assemblyFlags: AssemblyNameFlags) -> None: ...
    @property
    def AssemblyFlags(self) -> int: ...
    @property
    def Flags(self) -> int: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyInformationalVersionAttribute(Attribute):
    def __init__(self, informationalVersion: str) -> None: ...
    @property
    def InformationalVersion(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyKeyFileAttribute(Attribute):
    def __init__(self, keyFile: str) -> None: ...
    @property
    def KeyFile(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyKeyNameAttribute(Attribute):
    def __init__(self, keyName: str) -> None: ...
    @property
    def KeyName(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyMetadataAttribute(Attribute):
    def __init__(self, key: str, value: str) -> None: ...
    @property
    def Key(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def Value(self) -> str: ...


class AssemblyName(ISerializable, IDeserializationCallback, ICloneable):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, assemblyName: str) -> None: ...
    @property
    def CodeBase(self) -> str: ...
    @CodeBase.setter
    def CodeBase(self, value: str) -> str: ...
    @property
    def ContentType(self) -> AssemblyContentType: ...
    @ContentType.setter
    def ContentType(self, value: AssemblyContentType) -> AssemblyContentType: ...
    @property
    def CultureInfo(self) -> CultureInfo: ...
    @CultureInfo.setter
    def CultureInfo(self, value: CultureInfo) -> CultureInfo: ...
    @property
    def CultureName(self) -> str: ...
    @CultureName.setter
    def CultureName(self, value: str) -> str: ...
    @property
    def EscapedCodeBase(self) -> str: ...
    @property
    def Flags(self) -> AssemblyNameFlags: ...
    @Flags.setter
    def Flags(self, value: AssemblyNameFlags) -> AssemblyNameFlags: ...
    @property
    def FullName(self) -> str: ...
    @property
    def HashAlgorithm(self) -> AssemblyHashAlgorithm: ...
    @HashAlgorithm.setter
    def HashAlgorithm(self, value: AssemblyHashAlgorithm) -> AssemblyHashAlgorithm: ...
    @property
    def KeyPair(self) -> StrongNameKeyPair: ...
    @KeyPair.setter
    def KeyPair(self, value: StrongNameKeyPair) -> StrongNameKeyPair: ...
    @property
    def Name(self) -> str: ...
    @Name.setter
    def Name(self, value: str) -> str: ...
    @property
    def ProcessorArchitecture(self) -> ProcessorArchitecture: ...
    @ProcessorArchitecture.setter
    def ProcessorArchitecture(self, value: ProcessorArchitecture) -> ProcessorArchitecture: ...
    @property
    def Version(self) -> Version: ...
    @Version.setter
    def Version(self, value: Version) -> Version: ...
    @property
    def VersionCompatibility(self) -> AssemblyVersionCompatibility: ...
    @VersionCompatibility.setter
    def VersionCompatibility(self, value: AssemblyVersionCompatibility) -> AssemblyVersionCompatibility: ...
    def Clone(self) -> typing.Any: ...
    @staticmethod
    def GetAssemblyName(assemblyFile: str) -> AssemblyName: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def GetPublicKey(self) -> Array_1[int]: ...
    def GetPublicKeyToken(self) -> Array_1[int]: ...
    def OnDeserialization(self, sender: typing.Any) -> None: ...
    @staticmethod
    def ReferenceMatchesDefinition(reference: AssemblyName, definition: AssemblyName) -> bool: ...
    def SetPublicKey(self, publicKey: Array_1[int]) -> None: ...
    def SetPublicKeyToken(self, publicKeyToken: Array_1[int]) -> None: ...
    def ToString(self) -> str: ...


class AssemblyNameFlags(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : AssemblyNameFlags # 0
    PublicKey : AssemblyNameFlags # 1
    Retargetable : AssemblyNameFlags # 256
    EnableJITcompileOptimizer : AssemblyNameFlags # 16384
    EnableJITcompileTracking : AssemblyNameFlags # 32768


class AssemblyNameProxy(MarshalByRefObject):
    def __init__(self) -> None: ...
    def GetAssemblyName(self, assemblyFile: str) -> AssemblyName: ...


class AssemblyProductAttribute(Attribute):
    def __init__(self, product: str) -> None: ...
    @property
    def Product(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblySignatureKeyAttribute(Attribute):
    def __init__(self, publicKey: str, countersignature: str) -> None: ...
    @property
    def Countersignature(self) -> str: ...
    @property
    def PublicKey(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyTitleAttribute(Attribute):
    def __init__(self, title: str) -> None: ...
    @property
    def Title(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyTrademarkAttribute(Attribute):
    def __init__(self, trademark: str) -> None: ...
    @property
    def Trademark(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class AssemblyVersionAttribute(Attribute):
    def __init__(self, version: str) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def Version(self) -> str: ...


class Binder(abc.ABC):
    @abc.abstractmethod
    def BindToField(self, bindingAttr: BindingFlags, match: Array_1[FieldInfo], value: typing.Any, culture: CultureInfo) -> FieldInfo: ...
    @abc.abstractmethod
    def BindToMethod(self, bindingAttr: BindingFlags, match: Array_1[MethodBase], args: clr.Reference[Array_1[typing.Any]], modifiers: Array_1[ParameterModifier], culture: CultureInfo, names: Array_1[str], state: clr.Reference[typing.Any]) -> MethodBase: ...
    @abc.abstractmethod
    def ChangeType(self, value: typing.Any, type: typing.Type[typing.Any], culture: CultureInfo) -> typing.Any: ...
    @abc.abstractmethod
    def ReorderArgumentArray(self, args: clr.Reference[Array_1[typing.Any]], state: typing.Any) -> None: ...
    @abc.abstractmethod
    def SelectMethod(self, bindingAttr: BindingFlags, match: Array_1[MethodBase], types: Array_1[typing.Type[typing.Any]], modifiers: Array_1[ParameterModifier]) -> MethodBase: ...
    @abc.abstractmethod
    def SelectProperty(self, bindingAttr: BindingFlags, match: Array_1[PropertyInfo], returnType: typing.Type[typing.Any], indexes: Array_1[typing.Type[typing.Any]], modifiers: Array_1[ParameterModifier]) -> PropertyInfo: ...


class BindingFlags(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Default : BindingFlags # 0
    IgnoreCase : BindingFlags # 1
    DeclaredOnly : BindingFlags # 2
    Instance : BindingFlags # 4
    Static : BindingFlags # 8
    Public : BindingFlags # 16
    NonPublic : BindingFlags # 32
    FlattenHierarchy : BindingFlags # 64
    InvokeMethod : BindingFlags # 256
    CreateInstance : BindingFlags # 512
    GetField : BindingFlags # 1024
    SetField : BindingFlags # 2048
    GetProperty : BindingFlags # 4096
    SetProperty : BindingFlags # 8192
    PutDispProperty : BindingFlags # 16384
    PutRefDispProperty : BindingFlags # 32768
    ExactBinding : BindingFlags # 65536
    SuppressChangeType : BindingFlags # 131072
    OptionalParamBinding : BindingFlags # 262144
    IgnoreReturn : BindingFlags # 16777216
    DoNotWrapExceptions : BindingFlags # 33554432


class CallingConventions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Standard : CallingConventions # 1
    VarArgs : CallingConventions # 2
    Any : CallingConventions # 3
    HasThis : CallingConventions # 32
    ExplicitThis : CallingConventions # 64


class ConstructorInfo(MethodBase):
    ConstructorName : str
    TypeConstructorName : str
    @property
    def Attributes(self) -> MethodAttributes: ...
    @property
    def CallingConvention(self) -> CallingConventions: ...
    @property
    def ContainsGenericParameters(self) -> bool: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def IsAbstract(self) -> bool: ...
    @property
    def IsAssembly(self) -> bool: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsConstructedGenericMethod(self) -> bool: ...
    @property
    def IsConstructor(self) -> bool: ...
    @property
    def IsFamily(self) -> bool: ...
    @property
    def IsFamilyAndAssembly(self) -> bool: ...
    @property
    def IsFamilyOrAssembly(self) -> bool: ...
    @property
    def IsFinal(self) -> bool: ...
    @property
    def IsGenericMethod(self) -> bool: ...
    @property
    def IsGenericMethodDefinition(self) -> bool: ...
    @property
    def IsHideBySig(self) -> bool: ...
    @property
    def IsPrivate(self) -> bool: ...
    @property
    def IsPublic(self) -> bool: ...
    @property
    def IsSecurityCritical(self) -> bool: ...
    @property
    def IsSecuritySafeCritical(self) -> bool: ...
    @property
    def IsSecurityTransparent(self) -> bool: ...
    @property
    def IsSpecialName(self) -> bool: ...
    @property
    def IsStatic(self) -> bool: ...
    @property
    def IsVirtual(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def MethodHandle(self) -> RuntimeMethodHandle: ...
    @property
    def MethodImplementationFlags(self) -> MethodImplAttributes: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: ConstructorInfo, right: ConstructorInfo) -> bool: ...
    def __ne__(self, left: ConstructorInfo, right: ConstructorInfo) -> bool: ...
    # Skipped Invoke due to it being static, abstract and generic.

    Invoke : Invoke_MethodGroup
    class Invoke_MethodGroup:
        @typing.overload
        def __call__(self, parameters: Array_1[typing.Any]) -> typing.Any:...
        @typing.overload
        def __call__(self, invokeAttr: BindingFlags, binder: Binder, parameters: Array_1[typing.Any], culture: CultureInfo) -> typing.Any:...



class CustomAttributeData:
    @property
    def AttributeType(self) -> typing.Type[typing.Any]: ...
    @property
    def Constructor(self) -> ConstructorInfo: ...
    @property
    def ConstructorArguments(self) -> IList_1[CustomAttributeTypedArgument]: ...
    @property
    def NamedArguments(self) -> IList_1[CustomAttributeNamedArgument]: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    def ToString(self) -> str: ...
    # Skipped GetCustomAttributes due to it being static, abstract and generic.

    GetCustomAttributes : GetCustomAttributes_MethodGroup
    class GetCustomAttributes_MethodGroup:
        @typing.overload
        def __call__(self, target: MemberInfo) -> IList_1[CustomAttributeData]:...
        @typing.overload
        def __call__(self, target: Module) -> IList_1[CustomAttributeData]:...
        @typing.overload
        def __call__(self, target: Assembly) -> IList_1[CustomAttributeData]:...
        @typing.overload
        def __call__(self, target: ParameterInfo) -> IList_1[CustomAttributeData]:...



class CustomAttributeExtensions(abc.ABC):
    # Skipped GetCustomAttribute due to it being static, abstract and generic.

    GetCustomAttribute : GetCustomAttribute_MethodGroup
    class GetCustomAttribute_MethodGroup:
        def __getitem__(self, t:typing.Type[GetCustomAttribute_1_T1]) -> GetCustomAttribute_1[GetCustomAttribute_1_T1]: ...

        GetCustomAttribute_1_T1 = typing.TypeVar('GetCustomAttribute_1_T1')
        class GetCustomAttribute_1(typing.Generic[GetCustomAttribute_1_T1]):
            GetCustomAttribute_1_T = CustomAttributeExtensions.GetCustomAttribute_MethodGroup.GetCustomAttribute_1_T1
            @typing.overload
            def __call__(self, element: Assembly) -> GetCustomAttribute_1_T:...
            @typing.overload
            def __call__(self, element: Module) -> GetCustomAttribute_1_T:...
            @typing.overload
            def __call__(self, element: MemberInfo) -> GetCustomAttribute_1_T:...
            @typing.overload
            def __call__(self, element: ParameterInfo) -> GetCustomAttribute_1_T:...
            @typing.overload
            def __call__(self, element: MemberInfo, inherit: bool) -> GetCustomAttribute_1_T:...
            @typing.overload
            def __call__(self, element: ParameterInfo, inherit: bool) -> GetCustomAttribute_1_T:...

        @typing.overload
        def __call__(self, element: Assembly, attributeType: typing.Type[typing.Any]) -> Attribute:...
        @typing.overload
        def __call__(self, element: Module, attributeType: typing.Type[typing.Any]) -> Attribute:...
        @typing.overload
        def __call__(self, element: MemberInfo, attributeType: typing.Type[typing.Any]) -> Attribute:...
        @typing.overload
        def __call__(self, element: ParameterInfo, attributeType: typing.Type[typing.Any]) -> Attribute:...
        @typing.overload
        def __call__(self, element: MemberInfo, attributeType: typing.Type[typing.Any], inherit: bool) -> Attribute:...
        @typing.overload
        def __call__(self, element: ParameterInfo, attributeType: typing.Type[typing.Any], inherit: bool) -> Attribute:...

    # Skipped GetCustomAttributes due to it being static, abstract and generic.

    GetCustomAttributes : GetCustomAttributes_MethodGroup
    class GetCustomAttributes_MethodGroup:
        def __getitem__(self, t:typing.Type[GetCustomAttributes_1_T1]) -> GetCustomAttributes_1[GetCustomAttributes_1_T1]: ...

        GetCustomAttributes_1_T1 = typing.TypeVar('GetCustomAttributes_1_T1')
        class GetCustomAttributes_1(typing.Generic[GetCustomAttributes_1_T1]):
            GetCustomAttributes_1_T = CustomAttributeExtensions.GetCustomAttributes_MethodGroup.GetCustomAttributes_1_T1
            @typing.overload
            def __call__(self, element: Assembly) -> IEnumerable_1[GetCustomAttributes_1_T]:...
            @typing.overload
            def __call__(self, element: Module) -> IEnumerable_1[GetCustomAttributes_1_T]:...
            @typing.overload
            def __call__(self, element: MemberInfo) -> IEnumerable_1[GetCustomAttributes_1_T]:...
            @typing.overload
            def __call__(self, element: ParameterInfo) -> IEnumerable_1[GetCustomAttributes_1_T]:...
            @typing.overload
            def __call__(self, element: MemberInfo, inherit: bool) -> IEnumerable_1[GetCustomAttributes_1_T]:...
            @typing.overload
            def __call__(self, element: ParameterInfo, inherit: bool) -> IEnumerable_1[GetCustomAttributes_1_T]:...

        @typing.overload
        def __call__(self, element: Assembly) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: Module) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: MemberInfo) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: ParameterInfo) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: Assembly, attributeType: typing.Type[typing.Any]) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: Module, attributeType: typing.Type[typing.Any]) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: MemberInfo, attributeType: typing.Type[typing.Any]) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: ParameterInfo, attributeType: typing.Type[typing.Any]) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: MemberInfo, inherit: bool) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: ParameterInfo, inherit: bool) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: MemberInfo, attributeType: typing.Type[typing.Any], inherit: bool) -> IEnumerable_1[Attribute]:...
        @typing.overload
        def __call__(self, element: ParameterInfo, attributeType: typing.Type[typing.Any], inherit: bool) -> IEnumerable_1[Attribute]:...

    # Skipped IsDefined due to it being static, abstract and generic.

    IsDefined : IsDefined_MethodGroup
    class IsDefined_MethodGroup:
        @typing.overload
        def __call__(self, element: Assembly, attributeType: typing.Type[typing.Any]) -> bool:...
        @typing.overload
        def __call__(self, element: Module, attributeType: typing.Type[typing.Any]) -> bool:...
        @typing.overload
        def __call__(self, element: MemberInfo, attributeType: typing.Type[typing.Any]) -> bool:...
        @typing.overload
        def __call__(self, element: ParameterInfo, attributeType: typing.Type[typing.Any]) -> bool:...
        @typing.overload
        def __call__(self, element: MemberInfo, attributeType: typing.Type[typing.Any], inherit: bool) -> bool:...
        @typing.overload
        def __call__(self, element: ParameterInfo, attributeType: typing.Type[typing.Any], inherit: bool) -> bool:...



class CustomAttributeFormatException(FormatException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class CustomAttributeNamedArgument:
    @typing.overload
    def __init__(self, memberInfo: MemberInfo, typedArgument: CustomAttributeTypedArgument) -> None: ...
    @typing.overload
    def __init__(self, memberInfo: MemberInfo, value: typing.Any) -> None: ...
    @property
    def IsField(self) -> bool: ...
    @property
    def MemberInfo(self) -> MemberInfo: ...
    @property
    def MemberName(self) -> str: ...
    @property
    def TypedValue(self) -> CustomAttributeTypedArgument: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: CustomAttributeNamedArgument, right: CustomAttributeNamedArgument) -> bool: ...
    def __ne__(self, left: CustomAttributeNamedArgument, right: CustomAttributeNamedArgument) -> bool: ...
    def ToString(self) -> str: ...


class CustomAttributeTypedArgument:
    @typing.overload
    def __init__(self, argumentType: typing.Type[typing.Any], value: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, value: typing.Any) -> None: ...
    @property
    def ArgumentType(self) -> typing.Type[typing.Any]: ...
    @property
    def Value(self) -> typing.Any: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: CustomAttributeTypedArgument, right: CustomAttributeTypedArgument) -> bool: ...
    def __ne__(self, left: CustomAttributeTypedArgument, right: CustomAttributeTypedArgument) -> bool: ...
    def ToString(self) -> str: ...


class DefaultMemberAttribute(Attribute):
    def __init__(self, memberName: str) -> None: ...
    @property
    def MemberName(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class EventAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventAttributes # 0
    SpecialName : EventAttributes # 512
    RTSpecialName : EventAttributes # 1024
    ReservedMask : EventAttributes # 1024


class EventInfo(MemberInfo):
    @property
    def AddMethod(self) -> MethodInfo: ...
    @property
    def Attributes(self) -> EventAttributes: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def EventHandlerType(self) -> typing.Type[typing.Any]: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsMulticast(self) -> bool: ...
    @property
    def IsSpecialName(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def RaiseMethod(self) -> MethodInfo: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    @property
    def RemoveMethod(self) -> MethodInfo: ...
    def AddEventHandler(self, target: typing.Any, handler: Delegate) -> None: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: EventInfo, right: EventInfo) -> bool: ...
    def __ne__(self, left: EventInfo, right: EventInfo) -> bool: ...
    def RemoveEventHandler(self, target: typing.Any, handler: Delegate) -> None: ...
    # Skipped GetAddMethod due to it being static, abstract and generic.

    GetAddMethod : GetAddMethod_MethodGroup
    class GetAddMethod_MethodGroup:
        @typing.overload
        def __call__(self) -> MethodInfo:...
        @typing.overload
        def __call__(self, nonPublic: bool) -> MethodInfo:...

    # Skipped GetOtherMethods due to it being static, abstract and generic.

    GetOtherMethods : GetOtherMethods_MethodGroup
    class GetOtherMethods_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[MethodInfo]:...
        @typing.overload
        def __call__(self, nonPublic: bool) -> Array_1[MethodInfo]:...

    # Skipped GetRaiseMethod due to it being static, abstract and generic.

    GetRaiseMethod : GetRaiseMethod_MethodGroup
    class GetRaiseMethod_MethodGroup:
        @typing.overload
        def __call__(self) -> MethodInfo:...
        @typing.overload
        def __call__(self, nonPublic: bool) -> MethodInfo:...

    # Skipped GetRemoveMethod due to it being static, abstract and generic.

    GetRemoveMethod : GetRemoveMethod_MethodGroup
    class GetRemoveMethod_MethodGroup:
        @typing.overload
        def __call__(self) -> MethodInfo:...
        @typing.overload
        def __call__(self, nonPublic: bool) -> MethodInfo:...



class ExceptionHandlingClause:
    @property
    def CatchType(self) -> typing.Type[typing.Any]: ...
    @property
    def FilterOffset(self) -> int: ...
    @property
    def Flags(self) -> ExceptionHandlingClauseOptions: ...
    @property
    def HandlerLength(self) -> int: ...
    @property
    def HandlerOffset(self) -> int: ...
    @property
    def TryLength(self) -> int: ...
    @property
    def TryOffset(self) -> int: ...
    def ToString(self) -> str: ...


class ExceptionHandlingClauseOptions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Clause : ExceptionHandlingClauseOptions # 0
    Filter : ExceptionHandlingClauseOptions # 1
    Finally : ExceptionHandlingClauseOptions # 2
    Fault : ExceptionHandlingClauseOptions # 4


class FieldAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    PrivateScope : FieldAttributes # 0
    Private : FieldAttributes # 1
    FamANDAssem : FieldAttributes # 2
    Assembly : FieldAttributes # 3
    Family : FieldAttributes # 4
    FamORAssem : FieldAttributes # 5
    Public : FieldAttributes # 6
    FieldAccessMask : FieldAttributes # 7
    Static : FieldAttributes # 16
    InitOnly : FieldAttributes # 32
    Literal : FieldAttributes # 64
    NotSerialized : FieldAttributes # 128
    HasFieldRVA : FieldAttributes # 256
    SpecialName : FieldAttributes # 512
    RTSpecialName : FieldAttributes # 1024
    HasFieldMarshal : FieldAttributes # 4096
    PinvokeImpl : FieldAttributes # 8192
    HasDefault : FieldAttributes # 32768
    ReservedMask : FieldAttributes # 38144


class FieldInfo(MemberInfo):
    @property
    def Attributes(self) -> FieldAttributes: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def FieldHandle(self) -> RuntimeFieldHandle: ...
    @property
    def FieldType(self) -> typing.Type[typing.Any]: ...
    @property
    def IsAssembly(self) -> bool: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsFamily(self) -> bool: ...
    @property
    def IsFamilyAndAssembly(self) -> bool: ...
    @property
    def IsFamilyOrAssembly(self) -> bool: ...
    @property
    def IsInitOnly(self) -> bool: ...
    @property
    def IsLiteral(self) -> bool: ...
    @property
    def IsNotSerialized(self) -> bool: ...
    @property
    def IsPinvokeImpl(self) -> bool: ...
    @property
    def IsPrivate(self) -> bool: ...
    @property
    def IsPublic(self) -> bool: ...
    @property
    def IsSecurityCritical(self) -> bool: ...
    @property
    def IsSecuritySafeCritical(self) -> bool: ...
    @property
    def IsSecurityTransparent(self) -> bool: ...
    @property
    def IsSpecialName(self) -> bool: ...
    @property
    def IsStatic(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    def GetOptionalCustomModifiers(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetRawConstantValue(self) -> typing.Any: ...
    def GetRequiredCustomModifiers(self) -> Array_1[typing.Type[typing.Any]]: ...
    @abc.abstractmethod
    def GetValue(self, obj: typing.Any) -> typing.Any: ...
    def GetValueDirect(self, obj: TypedReference) -> typing.Any: ...
    def __eq__(self, left: FieldInfo, right: FieldInfo) -> bool: ...
    def __ne__(self, left: FieldInfo, right: FieldInfo) -> bool: ...
    def SetValueDirect(self, obj: TypedReference, value: typing.Any) -> None: ...
    # Skipped GetFieldFromHandle due to it being static, abstract and generic.

    GetFieldFromHandle : GetFieldFromHandle_MethodGroup
    class GetFieldFromHandle_MethodGroup:
        @typing.overload
        def __call__(self, handle: RuntimeFieldHandle) -> FieldInfo:...
        @typing.overload
        def __call__(self, handle: RuntimeFieldHandle, declaringType: RuntimeTypeHandle) -> FieldInfo:...

    # Skipped SetValue due to it being static, abstract and generic.

    SetValue : SetValue_MethodGroup
    class SetValue_MethodGroup:
        @typing.overload
        def __call__(self, obj: typing.Any, value: typing.Any) -> None:...
        @typing.overload
        def __call__(self, obj: typing.Any, value: typing.Any, invokeAttr: BindingFlags, binder: Binder, culture: CultureInfo) -> None:...



class GenericParameterAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : GenericParameterAttributes # 0
    Covariant : GenericParameterAttributes # 1
    Contravariant : GenericParameterAttributes # 2
    VarianceMask : GenericParameterAttributes # 3
    ReferenceTypeConstraint : GenericParameterAttributes # 4
    NotNullableValueTypeConstraint : GenericParameterAttributes # 8
    DefaultConstructorConstraint : GenericParameterAttributes # 16
    SpecialConstraintMask : GenericParameterAttributes # 28


class ICustomAttributeProvider(typing.Protocol):
    @abc.abstractmethod
    def IsDefined(self, attributeType: typing.Type[typing.Any], inherit: bool) -> bool: ...
    # Skipped GetCustomAttributes due to it being static, abstract and generic.

    GetCustomAttributes : GetCustomAttributes_MethodGroup
    class GetCustomAttributes_MethodGroup:
        @typing.overload
        def __call__(self, inherit: bool) -> Array_1[typing.Any]:...
        @typing.overload
        def __call__(self, attributeType: typing.Type[typing.Any], inherit: bool) -> Array_1[typing.Any]:...



class ImageFileMachine(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    I386 : ImageFileMachine # 332
    ARM : ImageFileMachine # 452
    IA64 : ImageFileMachine # 512
    AMD64 : ImageFileMachine # 34404


class InterfaceMapping:
    InterfaceMethods : Array_1[MethodInfo]
    InterfaceType : typing.Type[typing.Any]
    TargetMethods : Array_1[MethodInfo]
    TargetType : typing.Type[typing.Any]


class IntrospectionExtensions(abc.ABC):
    @staticmethod
    def GetTypeInfo(type: typing.Type[typing.Any]) -> TypeInfo: ...


class InvalidFilterCriteriaException(ApplicationException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class IReflect(typing.Protocol):
    @property
    def UnderlyingSystemType(self) -> typing.Type[typing.Any]: ...
    @abc.abstractmethod
    def GetField(self, name: str, bindingAttr: BindingFlags) -> FieldInfo: ...
    @abc.abstractmethod
    def GetFields(self, bindingAttr: BindingFlags) -> Array_1[FieldInfo]: ...
    @abc.abstractmethod
    def GetMember(self, name: str, bindingAttr: BindingFlags) -> Array_1[MemberInfo]: ...
    @abc.abstractmethod
    def GetMembers(self, bindingAttr: BindingFlags) -> Array_1[MemberInfo]: ...
    @abc.abstractmethod
    def GetMethods(self, bindingAttr: BindingFlags) -> Array_1[MethodInfo]: ...
    @abc.abstractmethod
    def GetProperties(self, bindingAttr: BindingFlags) -> Array_1[PropertyInfo]: ...
    @abc.abstractmethod
    def InvokeMember(self, name: str, invokeAttr: BindingFlags, binder: Binder, target: typing.Any, args: Array_1[typing.Any], modifiers: Array_1[ParameterModifier], culture: CultureInfo, namedParameters: Array_1[str]) -> typing.Any: ...
    # Skipped GetMethod due to it being static, abstract and generic.

    GetMethod : GetMethod_MethodGroup
    class GetMethod_MethodGroup:
        @typing.overload
        def __call__(self, name: str, bindingAttr: BindingFlags) -> MethodInfo:...
        @typing.overload
        def __call__(self, name: str, bindingAttr: BindingFlags, binder: Binder, types: Array_1[typing.Type[typing.Any]], modifiers: Array_1[ParameterModifier]) -> MethodInfo:...

    # Skipped GetProperty due to it being static, abstract and generic.

    GetProperty : GetProperty_MethodGroup
    class GetProperty_MethodGroup:
        @typing.overload
        def __call__(self, name: str, bindingAttr: BindingFlags) -> PropertyInfo:...
        @typing.overload
        def __call__(self, name: str, bindingAttr: BindingFlags, binder: Binder, returnType: typing.Type[typing.Any], types: Array_1[typing.Type[typing.Any]], modifiers: Array_1[ParameterModifier]) -> PropertyInfo:...



class IReflectableType(typing.Protocol):
    @abc.abstractmethod
    def GetTypeInfo(self) -> TypeInfo: ...


class LocalVariableInfo:
    @property
    def IsPinned(self) -> bool: ...
    @property
    def LocalIndex(self) -> int: ...
    @property
    def LocalType(self) -> typing.Type[typing.Any]: ...
    def ToString(self) -> str: ...


class ManifestResourceInfo:
    def __init__(self, containingAssembly: Assembly, containingFileName: str, resourceLocation: ResourceLocation) -> None: ...
    @property
    def FileName(self) -> str: ...
    @property
    def ReferencedAssembly(self) -> Assembly: ...
    @property
    def ResourceLocation(self) -> ResourceLocation: ...


class MemberFilter(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, m: MemberInfo, filterCriteria: typing.Any, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> bool: ...
    def Invoke(self, m: MemberInfo, filterCriteria: typing.Any) -> bool: ...


class MemberInfo(ICustomAttributeProvider, abc.ABC):
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetCustomAttributesData(self) -> IList_1[CustomAttributeData]: ...
    def GetHashCode(self) -> int: ...
    def HasSameMetadataDefinitionAs(self, other: MemberInfo) -> bool: ...
    @abc.abstractmethod
    def IsDefined(self, attributeType: typing.Type[typing.Any], inherit: bool) -> bool: ...
    def __eq__(self, left: MemberInfo, right: MemberInfo) -> bool: ...
    def __ne__(self, left: MemberInfo, right: MemberInfo) -> bool: ...
    # Skipped GetCustomAttributes due to it being static, abstract and generic.

    GetCustomAttributes : GetCustomAttributes_MethodGroup
    class GetCustomAttributes_MethodGroup:
        @typing.overload
        def __call__(self, inherit: bool) -> Array_1[typing.Any]:...
        @typing.overload
        def __call__(self, attributeType: typing.Type[typing.Any], inherit: bool) -> Array_1[typing.Any]:...



class MemberTypes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Constructor : MemberTypes # 1
    Event : MemberTypes # 2
    Field : MemberTypes # 4
    Method : MemberTypes # 8
    Property : MemberTypes # 16
    TypeInfo : MemberTypes # 32
    Custom : MemberTypes # 64
    NestedType : MemberTypes # 128
    All : MemberTypes # 191


class MethodAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    ReuseSlot : MethodAttributes # 0
    PrivateScope : MethodAttributes # 0
    Private : MethodAttributes # 1
    FamANDAssem : MethodAttributes # 2
    Assembly : MethodAttributes # 3
    Family : MethodAttributes # 4
    FamORAssem : MethodAttributes # 5
    Public : MethodAttributes # 6
    MemberAccessMask : MethodAttributes # 7
    UnmanagedExport : MethodAttributes # 8
    Static : MethodAttributes # 16
    Final : MethodAttributes # 32
    Virtual : MethodAttributes # 64
    HideBySig : MethodAttributes # 128
    NewSlot : MethodAttributes # 256
    VtableLayoutMask : MethodAttributes # 256
    CheckAccessOnOverride : MethodAttributes # 512
    Abstract : MethodAttributes # 1024
    SpecialName : MethodAttributes # 2048
    RTSpecialName : MethodAttributes # 4096
    PinvokeImpl : MethodAttributes # 8192
    HasSecurity : MethodAttributes # 16384
    RequireSecObject : MethodAttributes # 32768
    ReservedMask : MethodAttributes # 53248


class MethodBase(MemberInfo):
    @property
    def Attributes(self) -> MethodAttributes: ...
    @property
    def CallingConvention(self) -> CallingConventions: ...
    @property
    def ContainsGenericParameters(self) -> bool: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def IsAbstract(self) -> bool: ...
    @property
    def IsAssembly(self) -> bool: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsConstructedGenericMethod(self) -> bool: ...
    @property
    def IsConstructor(self) -> bool: ...
    @property
    def IsFamily(self) -> bool: ...
    @property
    def IsFamilyAndAssembly(self) -> bool: ...
    @property
    def IsFamilyOrAssembly(self) -> bool: ...
    @property
    def IsFinal(self) -> bool: ...
    @property
    def IsGenericMethod(self) -> bool: ...
    @property
    def IsGenericMethodDefinition(self) -> bool: ...
    @property
    def IsHideBySig(self) -> bool: ...
    @property
    def IsPrivate(self) -> bool: ...
    @property
    def IsPublic(self) -> bool: ...
    @property
    def IsSecurityCritical(self) -> bool: ...
    @property
    def IsSecuritySafeCritical(self) -> bool: ...
    @property
    def IsSecurityTransparent(self) -> bool: ...
    @property
    def IsSpecialName(self) -> bool: ...
    @property
    def IsStatic(self) -> bool: ...
    @property
    def IsVirtual(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def MethodHandle(self) -> RuntimeMethodHandle: ...
    @property
    def MethodImplementationFlags(self) -> MethodImplAttributes: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    @staticmethod
    def GetCurrentMethod() -> MethodBase: ...
    def GetGenericArguments(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetHashCode(self) -> int: ...
    def GetMethodBody(self) -> MethodBody: ...
    @abc.abstractmethod
    def GetMethodImplementationFlags(self) -> MethodImplAttributes: ...
    @abc.abstractmethod
    def GetParameters(self) -> Array_1[ParameterInfo]: ...
    def __eq__(self, left: MethodBase, right: MethodBase) -> bool: ...
    def __ne__(self, left: MethodBase, right: MethodBase) -> bool: ...
    # Skipped GetMethodFromHandle due to it being static, abstract and generic.

    GetMethodFromHandle : GetMethodFromHandle_MethodGroup
    class GetMethodFromHandle_MethodGroup:
        @typing.overload
        def __call__(self, handle: RuntimeMethodHandle) -> MethodBase:...
        @typing.overload
        def __call__(self, handle: RuntimeMethodHandle, declaringType: RuntimeTypeHandle) -> MethodBase:...

    # Skipped Invoke due to it being static, abstract and generic.

    Invoke : Invoke_MethodGroup
    class Invoke_MethodGroup:
        @typing.overload
        def __call__(self, obj: typing.Any, parameters: Array_1[typing.Any]) -> typing.Any:...
        @typing.overload
        def __call__(self, obj: typing.Any, invokeAttr: BindingFlags, binder: Binder, parameters: Array_1[typing.Any], culture: CultureInfo) -> typing.Any:...



class MethodBody:
    @property
    def ExceptionHandlingClauses(self) -> IList_1[ExceptionHandlingClause]: ...
    @property
    def InitLocals(self) -> bool: ...
    @property
    def LocalSignatureMetadataToken(self) -> int: ...
    @property
    def LocalVariables(self) -> IList_1[LocalVariableInfo]: ...
    @property
    def MaxStackSize(self) -> int: ...
    def GetILAsByteArray(self) -> Array_1[int]: ...


class MethodImplAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    IL : MethodImplAttributes # 0
    Managed : MethodImplAttributes # 0
    Native : MethodImplAttributes # 1
    OPTIL : MethodImplAttributes # 2
    Runtime : MethodImplAttributes # 3
    CodeTypeMask : MethodImplAttributes # 3
    Unmanaged : MethodImplAttributes # 4
    ManagedMask : MethodImplAttributes # 4
    NoInlining : MethodImplAttributes # 8
    ForwardRef : MethodImplAttributes # 16
    Synchronized : MethodImplAttributes # 32
    NoOptimization : MethodImplAttributes # 64
    PreserveSig : MethodImplAttributes # 128
    AggressiveInlining : MethodImplAttributes # 256
    AggressiveOptimization : MethodImplAttributes # 512
    InternalCall : MethodImplAttributes # 4096
    MaxMethodImplVal : MethodImplAttributes # 65535


class MethodInfo(MethodBase):
    @property
    def Attributes(self) -> MethodAttributes: ...
    @property
    def CallingConvention(self) -> CallingConventions: ...
    @property
    def ContainsGenericParameters(self) -> bool: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def IsAbstract(self) -> bool: ...
    @property
    def IsAssembly(self) -> bool: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsConstructedGenericMethod(self) -> bool: ...
    @property
    def IsConstructor(self) -> bool: ...
    @property
    def IsFamily(self) -> bool: ...
    @property
    def IsFamilyAndAssembly(self) -> bool: ...
    @property
    def IsFamilyOrAssembly(self) -> bool: ...
    @property
    def IsFinal(self) -> bool: ...
    @property
    def IsGenericMethod(self) -> bool: ...
    @property
    def IsGenericMethodDefinition(self) -> bool: ...
    @property
    def IsHideBySig(self) -> bool: ...
    @property
    def IsPrivate(self) -> bool: ...
    @property
    def IsPublic(self) -> bool: ...
    @property
    def IsSecurityCritical(self) -> bool: ...
    @property
    def IsSecuritySafeCritical(self) -> bool: ...
    @property
    def IsSecurityTransparent(self) -> bool: ...
    @property
    def IsSpecialName(self) -> bool: ...
    @property
    def IsStatic(self) -> bool: ...
    @property
    def IsVirtual(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def MethodHandle(self) -> RuntimeMethodHandle: ...
    @property
    def MethodImplementationFlags(self) -> MethodImplAttributes: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    @property
    def ReturnParameter(self) -> ParameterInfo: ...
    @property
    def ReturnType(self) -> typing.Type[typing.Any]: ...
    @property
    def ReturnTypeCustomAttributes(self) -> ICustomAttributeProvider: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    @abc.abstractmethod
    def GetBaseDefinition(self) -> MethodInfo: ...
    def GetGenericArguments(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetGenericMethodDefinition(self) -> MethodInfo: ...
    def GetHashCode(self) -> int: ...
    def MakeGenericMethod(self, typeArguments: Array_1[typing.Type[typing.Any]]) -> MethodInfo: ...
    def __eq__(self, left: MethodInfo, right: MethodInfo) -> bool: ...
    def __ne__(self, left: MethodInfo, right: MethodInfo) -> bool: ...
    # Skipped CreateDelegate due to it being static, abstract and generic.

    CreateDelegate : CreateDelegate_MethodGroup
    class CreateDelegate_MethodGroup:
        def __getitem__(self, t:typing.Type[CreateDelegate_1_T1]) -> CreateDelegate_1[CreateDelegate_1_T1]: ...

        CreateDelegate_1_T1 = typing.TypeVar('CreateDelegate_1_T1')
        class CreateDelegate_1(typing.Generic[CreateDelegate_1_T1]):
            CreateDelegate_1_T = MethodInfo.CreateDelegate_MethodGroup.CreateDelegate_1_T1
            @typing.overload
            def __call__(self) -> CreateDelegate_1_T:...
            @typing.overload
            def __call__(self, target: typing.Any) -> CreateDelegate_1_T:...

        @typing.overload
        def __call__(self, delegateType: typing.Type[typing.Any]) -> Delegate:...
        @typing.overload
        def __call__(self, delegateType: typing.Type[typing.Any], target: typing.Any) -> Delegate:...



class Missing(ISerializable):
    Value : Missing


class Module(ISerializable, ICustomAttributeProvider, abc.ABC):
    FilterTypeName : TypeFilter
    FilterTypeNameIgnoreCase : TypeFilter
    @property
    def Assembly(self) -> Assembly: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def FullyQualifiedName(self) -> str: ...
    @property
    def MDStreamVersion(self) -> int: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def ModuleHandle(self) -> ModuleHandle: ...
    @property
    def ModuleVersionId(self) -> Guid: ...
    @property
    def Name(self) -> str: ...
    @property
    def ScopeName(self) -> str: ...
    def Equals(self, o: typing.Any) -> bool: ...
    def FindTypes(self, filter: TypeFilter, filterCriteria: typing.Any) -> Array_1[typing.Type[typing.Any]]: ...
    def GetCustomAttributesData(self) -> IList_1[CustomAttributeData]: ...
    def GetHashCode(self) -> int: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def GetPEKind(self, peKind: clr.Reference[PortableExecutableKinds], machine: clr.Reference[ImageFileMachine]) -> None: ...
    def GetTypes(self) -> Array_1[typing.Type[typing.Any]]: ...
    def IsDefined(self, attributeType: typing.Type[typing.Any], inherit: bool) -> bool: ...
    def IsResource(self) -> bool: ...
    def __eq__(self, left: Module, right: Module) -> bool: ...
    def __ne__(self, left: Module, right: Module) -> bool: ...
    def ResolveSignature(self, metadataToken: int) -> Array_1[int]: ...
    def ResolveString(self, metadataToken: int) -> str: ...
    def ToString(self) -> str: ...
    # Skipped GetCustomAttributes due to it being static, abstract and generic.

    GetCustomAttributes : GetCustomAttributes_MethodGroup
    class GetCustomAttributes_MethodGroup:
        @typing.overload
        def __call__(self, inherit: bool) -> Array_1[typing.Any]:...
        @typing.overload
        def __call__(self, attributeType: typing.Type[typing.Any], inherit: bool) -> Array_1[typing.Any]:...

    # Skipped GetField due to it being static, abstract and generic.

    GetField : GetField_MethodGroup
    class GetField_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> FieldInfo:...
        @typing.overload
        def __call__(self, name: str, bindingAttr: BindingFlags) -> FieldInfo:...

    # Skipped GetFields due to it being static, abstract and generic.

    GetFields : GetFields_MethodGroup
    class GetFields_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[FieldInfo]:...
        @typing.overload
        def __call__(self, bindingFlags: BindingFlags) -> Array_1[FieldInfo]:...

    # Skipped GetMethod due to it being static, abstract and generic.

    GetMethod : GetMethod_MethodGroup
    class GetMethod_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> MethodInfo:...
        @typing.overload
        def __call__(self, name: str, types: Array_1[typing.Type[typing.Any]]) -> MethodInfo:...
        @typing.overload
        def __call__(self, name: str, bindingAttr: BindingFlags, binder: Binder, callConvention: CallingConventions, types: Array_1[typing.Type[typing.Any]], modifiers: Array_1[ParameterModifier]) -> MethodInfo:...

    # Skipped GetMethods due to it being static, abstract and generic.

    GetMethods : GetMethods_MethodGroup
    class GetMethods_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[MethodInfo]:...
        @typing.overload
        def __call__(self, bindingFlags: BindingFlags) -> Array_1[MethodInfo]:...

    # Skipped GetType due to it being static, abstract and generic.

    GetType : GetType_MethodGroup
    class GetType_MethodGroup:
        @typing.overload
        def __call__(self, className: str) -> typing.Type[typing.Any]:...
        @typing.overload
        def __call__(self, className: str, ignoreCase: bool) -> typing.Type[typing.Any]:...
        @typing.overload
        def __call__(self, className: str, throwOnError: bool, ignoreCase: bool) -> typing.Type[typing.Any]:...

    # Skipped ResolveField due to it being static, abstract and generic.

    ResolveField : ResolveField_MethodGroup
    class ResolveField_MethodGroup:
        @typing.overload
        def __call__(self, metadataToken: int) -> FieldInfo:...
        @typing.overload
        def __call__(self, metadataToken: int, genericTypeArguments: Array_1[typing.Type[typing.Any]], genericMethodArguments: Array_1[typing.Type[typing.Any]]) -> FieldInfo:...

    # Skipped ResolveMember due to it being static, abstract and generic.

    ResolveMember : ResolveMember_MethodGroup
    class ResolveMember_MethodGroup:
        @typing.overload
        def __call__(self, metadataToken: int) -> MemberInfo:...
        @typing.overload
        def __call__(self, metadataToken: int, genericTypeArguments: Array_1[typing.Type[typing.Any]], genericMethodArguments: Array_1[typing.Type[typing.Any]]) -> MemberInfo:...

    # Skipped ResolveMethod due to it being static, abstract and generic.

    ResolveMethod : ResolveMethod_MethodGroup
    class ResolveMethod_MethodGroup:
        @typing.overload
        def __call__(self, metadataToken: int) -> MethodBase:...
        @typing.overload
        def __call__(self, metadataToken: int, genericTypeArguments: Array_1[typing.Type[typing.Any]], genericMethodArguments: Array_1[typing.Type[typing.Any]]) -> MethodBase:...

    # Skipped ResolveType due to it being static, abstract and generic.

    ResolveType : ResolveType_MethodGroup
    class ResolveType_MethodGroup:
        @typing.overload
        def __call__(self, metadataToken: int) -> typing.Type[typing.Any]:...
        @typing.overload
        def __call__(self, metadataToken: int, genericTypeArguments: Array_1[typing.Type[typing.Any]], genericMethodArguments: Array_1[typing.Type[typing.Any]]) -> typing.Type[typing.Any]:...



class ModuleResolveEventHandler(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, sender: typing.Any, e: ResolveEventArgs, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> Module: ...
    def Invoke(self, sender: typing.Any, e: ResolveEventArgs) -> Module: ...


class NullabilityInfo:
    @property
    def ElementType(self) -> NullabilityInfo: ...
    @property
    def GenericTypeArguments(self) -> Array_1[NullabilityInfo]: ...
    @property
    def ReadState(self) -> NullabilityState: ...
    @ReadState.setter
    def ReadState(self, value: NullabilityState) -> NullabilityState: ...
    @property
    def Type(self) -> typing.Type[typing.Any]: ...
    @property
    def WriteState(self) -> NullabilityState: ...
    @WriteState.setter
    def WriteState(self, value: NullabilityState) -> NullabilityState: ...


class NullabilityInfoContext:
    def __init__(self) -> None: ...
    # Skipped Create due to it being static, abstract and generic.

    Create : Create_MethodGroup
    class Create_MethodGroup:
        @typing.overload
        def __call__(self, eventInfo: EventInfo) -> NullabilityInfo:...
        @typing.overload
        def __call__(self, fieldInfo: FieldInfo) -> NullabilityInfo:...
        @typing.overload
        def __call__(self, propertyInfo: PropertyInfo) -> NullabilityInfo:...
        @typing.overload
        def __call__(self, parameterInfo: ParameterInfo) -> NullabilityInfo:...



class NullabilityState(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Unknown : NullabilityState # 0
    NotNull : NullabilityState # 1
    Nullable : NullabilityState # 2


class ObfuscateAssemblyAttribute(Attribute):
    def __init__(self, assemblyIsPrivate: bool) -> None: ...
    @property
    def AssemblyIsPrivate(self) -> bool: ...
    @property
    def StripAfterObfuscation(self) -> bool: ...
    @StripAfterObfuscation.setter
    def StripAfterObfuscation(self, value: bool) -> bool: ...
    @property
    def TypeId(self) -> typing.Any: ...


class ObfuscationAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def ApplyToMembers(self) -> bool: ...
    @ApplyToMembers.setter
    def ApplyToMembers(self, value: bool) -> bool: ...
    @property
    def Exclude(self) -> bool: ...
    @Exclude.setter
    def Exclude(self, value: bool) -> bool: ...
    @property
    def Feature(self) -> str: ...
    @Feature.setter
    def Feature(self, value: str) -> str: ...
    @property
    def StripAfterObfuscation(self) -> bool: ...
    @StripAfterObfuscation.setter
    def StripAfterObfuscation(self, value: bool) -> bool: ...
    @property
    def TypeId(self) -> typing.Any: ...


class ParameterAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : ParameterAttributes # 0
    In : ParameterAttributes # 1
    Out : ParameterAttributes # 2
    Lcid : ParameterAttributes # 4
    Retval : ParameterAttributes # 8
    Optional : ParameterAttributes # 16
    HasDefault : ParameterAttributes # 4096
    HasFieldMarshal : ParameterAttributes # 8192
    Reserved3 : ParameterAttributes # 16384
    Reserved4 : ParameterAttributes # 32768
    ReservedMask : ParameterAttributes # 61440


class ParameterInfo(IObjectReference, ICustomAttributeProvider):
    @property
    def Attributes(self) -> ParameterAttributes: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DefaultValue(self) -> typing.Any: ...
    @property
    def HasDefaultValue(self) -> bool: ...
    @property
    def IsIn(self) -> bool: ...
    @property
    def IsLcid(self) -> bool: ...
    @property
    def IsOptional(self) -> bool: ...
    @property
    def IsOut(self) -> bool: ...
    @property
    def IsRetval(self) -> bool: ...
    @property
    def Member(self) -> MemberInfo: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def Name(self) -> str: ...
    @property
    def ParameterType(self) -> typing.Type[typing.Any]: ...
    @property
    def Position(self) -> int: ...
    @property
    def RawDefaultValue(self) -> typing.Any: ...
    def GetCustomAttributesData(self) -> IList_1[CustomAttributeData]: ...
    def GetOptionalCustomModifiers(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetRealObject(self, context: StreamingContext) -> typing.Any: ...
    def GetRequiredCustomModifiers(self) -> Array_1[typing.Type[typing.Any]]: ...
    def IsDefined(self, attributeType: typing.Type[typing.Any], inherit: bool) -> bool: ...
    def ToString(self) -> str: ...
    # Skipped GetCustomAttributes due to it being static, abstract and generic.

    GetCustomAttributes : GetCustomAttributes_MethodGroup
    class GetCustomAttributes_MethodGroup:
        @typing.overload
        def __call__(self, inherit: bool) -> Array_1[typing.Any]:...
        @typing.overload
        def __call__(self, attributeType: typing.Type[typing.Any], inherit: bool) -> Array_1[typing.Any]:...



class ParameterModifier:
    def __init__(self, parameterCount: int) -> None: ...
    @property
    def Item(self) -> bool: ...
    @Item.setter
    def Item(self, value: bool) -> bool: ...


class Pointer(ISerializable):
    @staticmethod
    def Box(ptr: clr.Reference[None], type: typing.Type[typing.Any]) -> typing.Any: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def Unbox(ptr: typing.Any) -> clr.Reference[None]: ...


class PortableExecutableKinds(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    NotAPortableExecutableImage : PortableExecutableKinds # 0
    ILOnly : PortableExecutableKinds # 1
    Required32Bit : PortableExecutableKinds # 2
    PE32Plus : PortableExecutableKinds # 4
    Unmanaged32Bit : PortableExecutableKinds # 8
    Preferred32Bit : PortableExecutableKinds # 16


class ProcessorArchitecture(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : ProcessorArchitecture # 0
    MSIL : ProcessorArchitecture # 1
    X86 : ProcessorArchitecture # 2
    IA64 : ProcessorArchitecture # 3
    Amd64 : ProcessorArchitecture # 4
    Arm : ProcessorArchitecture # 5


class PropertyAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : PropertyAttributes # 0
    SpecialName : PropertyAttributes # 512
    RTSpecialName : PropertyAttributes # 1024
    HasDefault : PropertyAttributes # 4096
    Reserved2 : PropertyAttributes # 8192
    Reserved3 : PropertyAttributes # 16384
    Reserved4 : PropertyAttributes # 32768
    ReservedMask : PropertyAttributes # 62464


class PropertyInfo(MemberInfo):
    @property
    def Attributes(self) -> PropertyAttributes: ...
    @property
    def CanRead(self) -> bool: ...
    @property
    def CanWrite(self) -> bool: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def GetMethod(self) -> MethodInfo: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsSpecialName(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def PropertyType(self) -> typing.Type[typing.Any]: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    @property
    def SetMethod(self) -> MethodInfo: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetConstantValue(self) -> typing.Any: ...
    def GetHashCode(self) -> int: ...
    @abc.abstractmethod
    def GetIndexParameters(self) -> Array_1[ParameterInfo]: ...
    def GetOptionalCustomModifiers(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetRawConstantValue(self) -> typing.Any: ...
    def GetRequiredCustomModifiers(self) -> Array_1[typing.Type[typing.Any]]: ...
    def __eq__(self, left: PropertyInfo, right: PropertyInfo) -> bool: ...
    def __ne__(self, left: PropertyInfo, right: PropertyInfo) -> bool: ...
    # Skipped GetAccessors due to it being static, abstract and generic.

    GetAccessors : GetAccessors_MethodGroup
    class GetAccessors_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[MethodInfo]:...
        @typing.overload
        def __call__(self, nonPublic: bool) -> Array_1[MethodInfo]:...

    # Skipped GetGetMethod due to it being static, abstract and generic.

    GetGetMethod : GetGetMethod_MethodGroup
    class GetGetMethod_MethodGroup:
        @typing.overload
        def __call__(self) -> MethodInfo:...
        @typing.overload
        def __call__(self, nonPublic: bool) -> MethodInfo:...

    # Skipped GetSetMethod due to it being static, abstract and generic.

    GetSetMethod : GetSetMethod_MethodGroup
    class GetSetMethod_MethodGroup:
        @typing.overload
        def __call__(self) -> MethodInfo:...
        @typing.overload
        def __call__(self, nonPublic: bool) -> MethodInfo:...

    # Skipped GetValue due to it being static, abstract and generic.

    GetValue : GetValue_MethodGroup
    class GetValue_MethodGroup:
        @typing.overload
        def __call__(self, obj: typing.Any) -> typing.Any:...
        @typing.overload
        def __call__(self, obj: typing.Any, index: Array_1[typing.Any]) -> typing.Any:...
        @typing.overload
        def __call__(self, obj: typing.Any, invokeAttr: BindingFlags, binder: Binder, index: Array_1[typing.Any], culture: CultureInfo) -> typing.Any:...

    # Skipped SetValue due to it being static, abstract and generic.

    SetValue : SetValue_MethodGroup
    class SetValue_MethodGroup:
        @typing.overload
        def __call__(self, obj: typing.Any, value: typing.Any) -> None:...
        @typing.overload
        def __call__(self, obj: typing.Any, value: typing.Any, index: Array_1[typing.Any]) -> None:...
        @typing.overload
        def __call__(self, obj: typing.Any, value: typing.Any, invokeAttr: BindingFlags, binder: Binder, index: Array_1[typing.Any], culture: CultureInfo) -> None:...



class ReflectionContext(abc.ABC):
    def GetTypeForObject(self, value: typing.Any) -> TypeInfo: ...
    @abc.abstractmethod
    def MapAssembly(self, assembly: Assembly) -> Assembly: ...
    @abc.abstractmethod
    def MapType(self, type: TypeInfo) -> TypeInfo: ...


class ReflectionTypeLoadException(SystemException):
    @typing.overload
    def __init__(self, classes: Array_1[typing.Type[typing.Any]], exceptions: Array_1[Exception]) -> None: ...
    @typing.overload
    def __init__(self, classes: Array_1[typing.Type[typing.Any]], exceptions: Array_1[Exception], message: str) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def LoaderExceptions(self) -> Array_1[Exception]: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...
    @property
    def Types(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def ToString(self) -> str: ...


class ResourceAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Public : ResourceAttributes # 1
    Private : ResourceAttributes # 2


class ResourceLocation(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Embedded : ResourceLocation # 1
    ContainedInAnotherAssembly : ResourceLocation # 2
    ContainedInManifestFile : ResourceLocation # 4


class RuntimeReflectionExtensions(abc.ABC):
    @staticmethod
    def GetMethodInfo(del_: Delegate) -> MethodInfo: ...
    @staticmethod
    def GetRuntimeBaseDefinition(method: MethodInfo) -> MethodInfo: ...
    @staticmethod
    def GetRuntimeEvent(type: typing.Type[typing.Any], name: str) -> EventInfo: ...
    @staticmethod
    def GetRuntimeEvents(type: typing.Type[typing.Any]) -> IEnumerable_1[EventInfo]: ...
    @staticmethod
    def GetRuntimeField(type: typing.Type[typing.Any], name: str) -> FieldInfo: ...
    @staticmethod
    def GetRuntimeFields(type: typing.Type[typing.Any]) -> IEnumerable_1[FieldInfo]: ...
    @staticmethod
    def GetRuntimeInterfaceMap(typeInfo: TypeInfo, interfaceType: typing.Type[typing.Any]) -> InterfaceMapping: ...
    @staticmethod
    def GetRuntimeMethod(type: typing.Type[typing.Any], name: str, parameters: Array_1[typing.Type[typing.Any]]) -> MethodInfo: ...
    @staticmethod
    def GetRuntimeMethods(type: typing.Type[typing.Any]) -> IEnumerable_1[MethodInfo]: ...
    @staticmethod
    def GetRuntimeProperties(type: typing.Type[typing.Any]) -> IEnumerable_1[PropertyInfo]: ...
    @staticmethod
    def GetRuntimeProperty(type: typing.Type[typing.Any], name: str) -> PropertyInfo: ...


class StrongNameKeyPair(ISerializable, IDeserializationCallback):
    @typing.overload
    def __init__(self, keyPairArray: Array_1[int]) -> None: ...
    @typing.overload
    def __init__(self, keyPairContainer: str) -> None: ...
    @typing.overload
    def __init__(self, keyPairFile: FileStream) -> None: ...
    @property
    def PublicKey(self) -> Array_1[int]: ...


class TargetException(ApplicationException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class TargetInvocationException(ApplicationException):
    @typing.overload
    def __init__(self, inner: Exception) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class TargetParameterCountException(ApplicationException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class TypeAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    NotPublic : TypeAttributes # 0
    AutoLayout : TypeAttributes # 0
    AnsiClass : TypeAttributes # 0
    Class : TypeAttributes # 0
    Public : TypeAttributes # 1
    NestedPublic : TypeAttributes # 2
    NestedPrivate : TypeAttributes # 3
    NestedFamily : TypeAttributes # 4
    NestedAssembly : TypeAttributes # 5
    NestedFamANDAssem : TypeAttributes # 6
    NestedFamORAssem : TypeAttributes # 7
    VisibilityMask : TypeAttributes # 7
    SequentialLayout : TypeAttributes # 8
    ExplicitLayout : TypeAttributes # 16
    LayoutMask : TypeAttributes # 24
    Interface : TypeAttributes # 32
    ClassSemanticsMask : TypeAttributes # 32
    Abstract : TypeAttributes # 128
    Sealed : TypeAttributes # 256
    SpecialName : TypeAttributes # 1024
    RTSpecialName : TypeAttributes # 2048
    Import : TypeAttributes # 4096
    Serializable : TypeAttributes # 8192
    WindowsRuntime : TypeAttributes # 16384
    UnicodeClass : TypeAttributes # 65536
    AutoClass : TypeAttributes # 131072
    CustomFormatClass : TypeAttributes # 196608
    StringFormatMask : TypeAttributes # 196608
    HasSecurity : TypeAttributes # 262144
    ReservedMask : TypeAttributes # 264192
    BeforeFieldInit : TypeAttributes # 1048576
    CustomFormatMask : TypeAttributes # 12582912


class TypeDelegator(TypeInfo):
    def __init__(self, delegatingType: typing.Type[typing.Any]) -> None: ...
    @property
    def Assembly(self) -> Assembly: ...
    @property
    def AssemblyQualifiedName(self) -> str: ...
    @property
    def Attributes(self) -> TypeAttributes: ...
    @property
    def BaseType(self) -> typing.Type[typing.Any]: ...
    @property
    def ContainsGenericParameters(self) -> bool: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaredConstructors(self) -> IEnumerable_1[ConstructorInfo]: ...
    @property
    def DeclaredEvents(self) -> IEnumerable_1[EventInfo]: ...
    @property
    def DeclaredFields(self) -> IEnumerable_1[FieldInfo]: ...
    @property
    def DeclaredMembers(self) -> IEnumerable_1[MemberInfo]: ...
    @property
    def DeclaredMethods(self) -> IEnumerable_1[MethodInfo]: ...
    @property
    def DeclaredNestedTypes(self) -> IEnumerable_1[TypeInfo]: ...
    @property
    def DeclaredProperties(self) -> IEnumerable_1[PropertyInfo]: ...
    @property
    def DeclaringMethod(self) -> MethodBase: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def FullName(self) -> str: ...
    @property
    def GenericParameterAttributes(self) -> GenericParameterAttributes: ...
    @property
    def GenericParameterPosition(self) -> int: ...
    @property
    def GenericTypeArguments(self) -> Array_1[typing.Type[typing.Any]]: ...
    @property
    def GenericTypeParameters(self) -> Array_1[typing.Type[typing.Any]]: ...
    @property
    def GUID(self) -> Guid: ...
    @property
    def HasElementType(self) -> bool: ...
    @property
    def ImplementedInterfaces(self) -> IEnumerable_1[typing.Type[typing.Any]]: ...
    @property
    def IsAbstract(self) -> bool: ...
    @property
    def IsAnsiClass(self) -> bool: ...
    @property
    def IsArray(self) -> bool: ...
    @property
    def IsAutoClass(self) -> bool: ...
    @property
    def IsAutoLayout(self) -> bool: ...
    @property
    def IsByRef(self) -> bool: ...
    @property
    def IsByRefLike(self) -> bool: ...
    @property
    def IsClass(self) -> bool: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsCOMObject(self) -> bool: ...
    @property
    def IsConstructedGenericType(self) -> bool: ...
    @property
    def IsContextful(self) -> bool: ...
    @property
    def IsEnum(self) -> bool: ...
    @property
    def IsExplicitLayout(self) -> bool: ...
    @property
    def IsGenericMethodParameter(self) -> bool: ...
    @property
    def IsGenericParameter(self) -> bool: ...
    @property
    def IsGenericType(self) -> bool: ...
    @property
    def IsGenericTypeDefinition(self) -> bool: ...
    @property
    def IsGenericTypeParameter(self) -> bool: ...
    @property
    def IsImport(self) -> bool: ...
    @property
    def IsInterface(self) -> bool: ...
    @property
    def IsLayoutSequential(self) -> bool: ...
    @property
    def IsMarshalByRef(self) -> bool: ...
    @property
    def IsNested(self) -> bool: ...
    @property
    def IsNestedAssembly(self) -> bool: ...
    @property
    def IsNestedFamANDAssem(self) -> bool: ...
    @property
    def IsNestedFamily(self) -> bool: ...
    @property
    def IsNestedFamORAssem(self) -> bool: ...
    @property
    def IsNestedPrivate(self) -> bool: ...
    @property
    def IsNestedPublic(self) -> bool: ...
    @property
    def IsNotPublic(self) -> bool: ...
    @property
    def IsPointer(self) -> bool: ...
    @property
    def IsPrimitive(self) -> bool: ...
    @property
    def IsPublic(self) -> bool: ...
    @property
    def IsSealed(self) -> bool: ...
    @property
    def IsSecurityCritical(self) -> bool: ...
    @property
    def IsSecuritySafeCritical(self) -> bool: ...
    @property
    def IsSecurityTransparent(self) -> bool: ...
    @property
    def IsSerializable(self) -> bool: ...
    @property
    def IsSignatureType(self) -> bool: ...
    @property
    def IsSpecialName(self) -> bool: ...
    @property
    def IsSZArray(self) -> bool: ...
    @property
    def IsTypeDefinition(self) -> bool: ...
    @property
    def IsUnicodeClass(self) -> bool: ...
    @property
    def IsValueType(self) -> bool: ...
    @property
    def IsVariableBoundArray(self) -> bool: ...
    @property
    def IsVisible(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def Namespace(self) -> str: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    @property
    def StructLayoutAttribute(self) -> StructLayoutAttribute: ...
    @property
    def TypeHandle(self) -> RuntimeTypeHandle: ...
    @property
    def TypeInitializer(self) -> ConstructorInfo: ...
    @property
    def UnderlyingSystemType(self) -> typing.Type[typing.Any]: ...
    def GetConstructors(self, bindingAttr: BindingFlags) -> Array_1[ConstructorInfo]: ...
    def GetElementType(self) -> typing.Type[typing.Any]: ...
    def GetEvent(self, name: str, bindingAttr: BindingFlags) -> EventInfo: ...
    def GetField(self, name: str, bindingAttr: BindingFlags) -> FieldInfo: ...
    def GetFields(self, bindingAttr: BindingFlags) -> Array_1[FieldInfo]: ...
    def GetInterface(self, name: str, ignoreCase: bool) -> typing.Type[typing.Any]: ...
    def GetInterfaceMap(self, interfaceType: typing.Type[typing.Any]) -> InterfaceMapping: ...
    def GetInterfaces(self) -> Array_1[typing.Type[typing.Any]]: ...
    def GetMember(self, name: str, type: MemberTypes, bindingAttr: BindingFlags) -> Array_1[MemberInfo]: ...
    def GetMembers(self, bindingAttr: BindingFlags) -> Array_1[MemberInfo]: ...
    def GetMemberWithSameMetadataDefinitionAs(self, member: MemberInfo) -> MemberInfo: ...
    def GetMethods(self, bindingAttr: BindingFlags) -> Array_1[MethodInfo]: ...
    def GetNestedType(self, name: str, bindingAttr: BindingFlags) -> typing.Type[typing.Any]: ...
    def GetNestedTypes(self, bindingAttr: BindingFlags) -> Array_1[typing.Type[typing.Any]]: ...
    def GetProperties(self, bindingAttr: BindingFlags) -> Array_1[PropertyInfo]: ...
    def InvokeMember(self, name: str, invokeAttr: BindingFlags, binder: Binder, target: typing.Any, args: Array_1[typing.Any], modifiers: Array_1[ParameterModifier], culture: CultureInfo, namedParameters: Array_1[str]) -> typing.Any: ...
    def IsAssignableFrom(self, typeInfo: TypeInfo) -> bool: ...
    def IsDefined(self, attributeType: typing.Type[typing.Any], inherit: bool) -> bool: ...
    # Skipped GetCustomAttributes due to it being static, abstract and generic.

    GetCustomAttributes : GetCustomAttributes_MethodGroup
    class GetCustomAttributes_MethodGroup:
        @typing.overload
        def __call__(self, inherit: bool) -> Array_1[typing.Any]:...
        @typing.overload
        def __call__(self, attributeType: typing.Type[typing.Any], inherit: bool) -> Array_1[typing.Any]:...

    # Skipped GetEvents due to it being static, abstract and generic.

    GetEvents : GetEvents_MethodGroup
    class GetEvents_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[EventInfo]:...
        @typing.overload
        def __call__(self, bindingAttr: BindingFlags) -> Array_1[EventInfo]:...



class TypeFilter(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, m: typing.Type[typing.Any], filterCriteria: typing.Any, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> bool: ...
    def Invoke(self, m: typing.Type[typing.Any], filterCriteria: typing.Any) -> bool: ...


class TypeInfo(typing.Type[typing.Any], IReflectableType):
    @property
    def Assembly(self) -> Assembly: ...
    @property
    def AssemblyQualifiedName(self) -> str: ...
    @property
    def Attributes(self) -> TypeAttributes: ...
    @property
    def BaseType(self) -> typing.Type[typing.Any]: ...
    @property
    def ContainsGenericParameters(self) -> bool: ...
    @property
    def CustomAttributes(self) -> IEnumerable_1[CustomAttributeData]: ...
    @property
    def DeclaredConstructors(self) -> IEnumerable_1[ConstructorInfo]: ...
    @property
    def DeclaredEvents(self) -> IEnumerable_1[EventInfo]: ...
    @property
    def DeclaredFields(self) -> IEnumerable_1[FieldInfo]: ...
    @property
    def DeclaredMembers(self) -> IEnumerable_1[MemberInfo]: ...
    @property
    def DeclaredMethods(self) -> IEnumerable_1[MethodInfo]: ...
    @property
    def DeclaredNestedTypes(self) -> IEnumerable_1[TypeInfo]: ...
    @property
    def DeclaredProperties(self) -> IEnumerable_1[PropertyInfo]: ...
    @property
    def DeclaringMethod(self) -> MethodBase: ...
    @property
    def DeclaringType(self) -> typing.Type[typing.Any]: ...
    @property
    def FullName(self) -> str: ...
    @property
    def GenericParameterAttributes(self) -> GenericParameterAttributes: ...
    @property
    def GenericParameterPosition(self) -> int: ...
    @property
    def GenericTypeArguments(self) -> Array_1[typing.Type[typing.Any]]: ...
    @property
    def GenericTypeParameters(self) -> Array_1[typing.Type[typing.Any]]: ...
    @property
    def GUID(self) -> Guid: ...
    @property
    def HasElementType(self) -> bool: ...
    @property
    def ImplementedInterfaces(self) -> IEnumerable_1[typing.Type[typing.Any]]: ...
    @property
    def IsAbstract(self) -> bool: ...
    @property
    def IsAnsiClass(self) -> bool: ...
    @property
    def IsArray(self) -> bool: ...
    @property
    def IsAutoClass(self) -> bool: ...
    @property
    def IsAutoLayout(self) -> bool: ...
    @property
    def IsByRef(self) -> bool: ...
    @property
    def IsByRefLike(self) -> bool: ...
    @property
    def IsClass(self) -> bool: ...
    @property
    def IsCollectible(self) -> bool: ...
    @property
    def IsCOMObject(self) -> bool: ...
    @property
    def IsConstructedGenericType(self) -> bool: ...
    @property
    def IsContextful(self) -> bool: ...
    @property
    def IsEnum(self) -> bool: ...
    @property
    def IsExplicitLayout(self) -> bool: ...
    @property
    def IsGenericMethodParameter(self) -> bool: ...
    @property
    def IsGenericParameter(self) -> bool: ...
    @property
    def IsGenericType(self) -> bool: ...
    @property
    def IsGenericTypeDefinition(self) -> bool: ...
    @property
    def IsGenericTypeParameter(self) -> bool: ...
    @property
    def IsImport(self) -> bool: ...
    @property
    def IsInterface(self) -> bool: ...
    @property
    def IsLayoutSequential(self) -> bool: ...
    @property
    def IsMarshalByRef(self) -> bool: ...
    @property
    def IsNested(self) -> bool: ...
    @property
    def IsNestedAssembly(self) -> bool: ...
    @property
    def IsNestedFamANDAssem(self) -> bool: ...
    @property
    def IsNestedFamily(self) -> bool: ...
    @property
    def IsNestedFamORAssem(self) -> bool: ...
    @property
    def IsNestedPrivate(self) -> bool: ...
    @property
    def IsNestedPublic(self) -> bool: ...
    @property
    def IsNotPublic(self) -> bool: ...
    @property
    def IsPointer(self) -> bool: ...
    @property
    def IsPrimitive(self) -> bool: ...
    @property
    def IsPublic(self) -> bool: ...
    @property
    def IsSealed(self) -> bool: ...
    @property
    def IsSecurityCritical(self) -> bool: ...
    @property
    def IsSecuritySafeCritical(self) -> bool: ...
    @property
    def IsSecurityTransparent(self) -> bool: ...
    @property
    def IsSerializable(self) -> bool: ...
    @property
    def IsSignatureType(self) -> bool: ...
    @property
    def IsSpecialName(self) -> bool: ...
    @property
    def IsSZArray(self) -> bool: ...
    @property
    def IsTypeDefinition(self) -> bool: ...
    @property
    def IsUnicodeClass(self) -> bool: ...
    @property
    def IsValueType(self) -> bool: ...
    @property
    def IsVariableBoundArray(self) -> bool: ...
    @property
    def IsVisible(self) -> bool: ...
    @property
    def MemberType(self) -> MemberTypes: ...
    @property
    def MetadataToken(self) -> int: ...
    @property
    def Module(self) -> Module: ...
    @property
    def Name(self) -> str: ...
    @property
    def Namespace(self) -> str: ...
    @property
    def ReflectedType(self) -> typing.Type[typing.Any]: ...
    @property
    def StructLayoutAttribute(self) -> StructLayoutAttribute: ...
    @property
    def TypeHandle(self) -> RuntimeTypeHandle: ...
    @property
    def TypeInitializer(self) -> ConstructorInfo: ...
    @property
    def UnderlyingSystemType(self) -> typing.Type[typing.Any]: ...
    def AsType(self) -> typing.Type[typing.Any]: ...
    def GetDeclaredEvent(self, name: str) -> EventInfo: ...
    def GetDeclaredField(self, name: str) -> FieldInfo: ...
    def GetDeclaredMethod(self, name: str) -> MethodInfo: ...
    def GetDeclaredMethods(self, name: str) -> IEnumerable_1[MethodInfo]: ...
    def GetDeclaredNestedType(self, name: str) -> TypeInfo: ...
    def GetDeclaredProperty(self, name: str) -> PropertyInfo: ...
    def IsAssignableFrom(self, typeInfo: TypeInfo) -> bool: ...

