import typing, abc
from System import Attribute
from System.Security import IPermission

class CodeAccessSecurityAttribute(SecurityAttribute):
    @property
    def Action(self) -> SecurityAction: ...
    @Action.setter
    def Action(self, value: SecurityAction) -> SecurityAction: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def Unrestricted(self) -> bool: ...
    @Unrestricted.setter
    def Unrestricted(self, value: bool) -> bool: ...


class PermissionState(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : PermissionState # 0
    Unrestricted : PermissionState # 1


class SecurityAction(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Demand : SecurityAction # 2
    Assert : SecurityAction # 3
    Deny : SecurityAction # 4
    PermitOnly : SecurityAction # 5
    LinkDemand : SecurityAction # 6
    InheritanceDemand : SecurityAction # 7
    RequestMinimum : SecurityAction # 8
    RequestOptional : SecurityAction # 9
    RequestRefuse : SecurityAction # 10


class SecurityAttribute(Attribute):
    @property
    def Action(self) -> SecurityAction: ...
    @Action.setter
    def Action(self, value: SecurityAction) -> SecurityAction: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def Unrestricted(self) -> bool: ...
    @Unrestricted.setter
    def Unrestricted(self, value: bool) -> bool: ...
    @abc.abstractmethod
    def CreatePermission(self) -> IPermission: ...


class SecurityPermissionAttribute(CodeAccessSecurityAttribute):
    def __init__(self, action: SecurityAction) -> None: ...
    @property
    def Action(self) -> SecurityAction: ...
    @Action.setter
    def Action(self, value: SecurityAction) -> SecurityAction: ...
    @property
    def Assertion(self) -> bool: ...
    @Assertion.setter
    def Assertion(self, value: bool) -> bool: ...
    @property
    def BindingRedirects(self) -> bool: ...
    @BindingRedirects.setter
    def BindingRedirects(self, value: bool) -> bool: ...
    @property
    def ControlAppDomain(self) -> bool: ...
    @ControlAppDomain.setter
    def ControlAppDomain(self, value: bool) -> bool: ...
    @property
    def ControlDomainPolicy(self) -> bool: ...
    @ControlDomainPolicy.setter
    def ControlDomainPolicy(self, value: bool) -> bool: ...
    @property
    def ControlEvidence(self) -> bool: ...
    @ControlEvidence.setter
    def ControlEvidence(self, value: bool) -> bool: ...
    @property
    def ControlPolicy(self) -> bool: ...
    @ControlPolicy.setter
    def ControlPolicy(self, value: bool) -> bool: ...
    @property
    def ControlPrincipal(self) -> bool: ...
    @ControlPrincipal.setter
    def ControlPrincipal(self, value: bool) -> bool: ...
    @property
    def ControlThread(self) -> bool: ...
    @ControlThread.setter
    def ControlThread(self, value: bool) -> bool: ...
    @property
    def Execution(self) -> bool: ...
    @Execution.setter
    def Execution(self, value: bool) -> bool: ...
    @property
    def Flags(self) -> SecurityPermissionFlag: ...
    @Flags.setter
    def Flags(self, value: SecurityPermissionFlag) -> SecurityPermissionFlag: ...
    @property
    def Infrastructure(self) -> bool: ...
    @Infrastructure.setter
    def Infrastructure(self, value: bool) -> bool: ...
    @property
    def RemotingConfiguration(self) -> bool: ...
    @RemotingConfiguration.setter
    def RemotingConfiguration(self, value: bool) -> bool: ...
    @property
    def SerializationFormatter(self) -> bool: ...
    @SerializationFormatter.setter
    def SerializationFormatter(self, value: bool) -> bool: ...
    @property
    def SkipVerification(self) -> bool: ...
    @SkipVerification.setter
    def SkipVerification(self, value: bool) -> bool: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def UnmanagedCode(self) -> bool: ...
    @UnmanagedCode.setter
    def UnmanagedCode(self, value: bool) -> bool: ...
    @property
    def Unrestricted(self) -> bool: ...
    @Unrestricted.setter
    def Unrestricted(self, value: bool) -> bool: ...
    def CreatePermission(self) -> IPermission: ...


class SecurityPermissionFlag(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    NoFlags : SecurityPermissionFlag # 0
    Assertion : SecurityPermissionFlag # 1
    UnmanagedCode : SecurityPermissionFlag # 2
    SkipVerification : SecurityPermissionFlag # 4
    Execution : SecurityPermissionFlag # 8
    ControlThread : SecurityPermissionFlag # 16
    ControlEvidence : SecurityPermissionFlag # 32
    ControlPolicy : SecurityPermissionFlag # 64
    SerializationFormatter : SecurityPermissionFlag # 128
    ControlDomainPolicy : SecurityPermissionFlag # 256
    ControlPrincipal : SecurityPermissionFlag # 512
    ControlAppDomain : SecurityPermissionFlag # 1024
    RemotingConfiguration : SecurityPermissionFlag # 2048
    Infrastructure : SecurityPermissionFlag # 4096
    BindingRedirects : SecurityPermissionFlag # 8192
    AllFlags : SecurityPermissionFlag # 16383

