import typing
from TransformsAI.Animo.Learning.Observations.Primitives import CompositeObservation, Observation, ObservationBuffer
from TransformsAI.Animo.Objects import Character, TypeIds
from System import Array_1, IEquatable_1
from TransformsAI.Animo.Grid import GridObject, VoxelGrid
from TransformsAI.Animo.Numerics import Vector3Int

class AffinitiesObservation(CompositeObservation):
    def __init__(self, parent: Observation, name: str, character: Character) -> None: ...
    @property
    def AffinityObservations(self) -> Array_1[AffinityObservation]: ...
    @property
    def InnerObservations(self) -> Array_1[Observation]: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...


class AffinityData(IEquatable_1[AffinityData]):
    @property
    def AffinityType(self) -> AffinityType: ...
    @AffinityType.setter
    def AffinityType(self, value: AffinityType) -> AffinityType: ...
    @property
    def CharacterId(self) -> int: ...
    @CharacterId.setter
    def CharacterId(self, value: int) -> int: ...
    @property
    def ItemType(self) -> TypeIds: ...
    @ItemType.setter
    def ItemType(self, value: TypeIds) -> TypeIds: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: AffinityData, right: AffinityData) -> bool: ...
    def __ne__(self, left: AffinityData, right: AffinityData) -> bool: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: AffinityData) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...



class AffinityObservation(CompositeObservation):
    def __init__(self, parent: Observation, name: str, character: Character, slotNum: int) -> None: ...
    MaxAffinityDistance : float
    ObservedObject : GridObject
    @property
    def InnerObservations(self) -> Array_1[Observation]: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Prepare(self) -> None: ...


class AffinityType(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : AffinityType # 0
    Item : AffinityType # 1
    Character : AffinityType # 2


class AgentObservations(CompositeObservation):
    def __init__(self, character: Character, visionMask: Array_1[int]) -> None: ...
    @property
    def AffinityObservations(self) -> AffinitiesObservation: ...
    @AffinityObservations.setter
    def AffinityObservations(self, value: AffinitiesObservation) -> AffinitiesObservation: ...
    @property
    def Character(self) -> Character: ...
    @property
    def GridObservations(self) -> GridObservation: ...
    @GridObservations.setter
    def GridObservations(self, value: GridObservation) -> GridObservation: ...
    @property
    def InnerObservations(self) -> Array_1[Observation]: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Perceive(self, buffer: ObservationBuffer) -> None: ...


class GridObservation(CompositeObservation):
    def __init__(self, parent: Observation, name: str, character: Character, visionMask: Array_1[int] = ...) -> None: ...
    cacheSize : int
    DefaultVisionMask : Array_1[int]
    LabelCache : Array_1[str]
    LabelOffset : Vector3Int
    @property
    def InnerObservations(self) -> Array_1[Observation]: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    @property
    def RelativeCellObservations(self) -> Array_1[RelativeCellObservation]: ...
    @RelativeCellObservations.setter
    def RelativeCellObservations(self, value: Array_1[RelativeCellObservation]) -> Array_1[RelativeCellObservation]: ...
    def GetCellLabel(self, coordinate: Vector3Int) -> str: ...


class RelativeCellObservation(CompositeObservation):
    def __init__(self, parent: Observation, name: str, character: Character, gridOffset: Vector3Int) -> None: ...
    GridOffset : Vector3Int
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def InnerObservations(self) -> Array_1[Observation]: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Prepare(self) -> None: ...

