"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Billingconductor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [billingconductor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingconductor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Billingconductor extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [billingconductor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingconductor.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'billingconductor';
        this.accessLevelList = {
            Write: [
                'AssociateAccounts',
                'AssociatePricingRules',
                'BatchAssociateResourcesToCustomLineItem',
                'BatchDisassociateResourcesFromCustomLineItem',
                'CreateBillingGroup',
                'CreateCustomLineItem',
                'CreatePricingPlan',
                'CreatePricingRule',
                'DeleteBillingGroup',
                'DeleteCustomLineItem',
                'DeletePricingPlan',
                'DeletePricingRule',
                'DisassociateAccounts',
                'DisassociatePricingRules',
                'UpdateBillingGroup',
                'UpdateCustomLineItem',
                'UpdatePricingPlan',
                'UpdatePricingRule'
            ],
            List: [
                'ListAccountAssociations',
                'ListPricingPlansAssociatedWithPricingRule',
                'ListPricingRulesAssociatedToPricingPlan',
                'ListResourcesAssociatedToCustomLineItem'
            ],
            Read: [
                'ListBillingGroupCostReports',
                'ListBillingGroups',
                'ListCustomLineItems',
                'ListPricingPlans',
                'ListPricingRules',
                'ListTagsResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate between one and 30 accounts to a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_AssociateAccounts.html
     */
    toAssociateAccounts() {
        return this.to('AssociateAccounts');
    }
    /**
     * Grants permission to associate pricing rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_AssociatePricingRules.html
     */
    toAssociatePricingRules() {
        return this.to('AssociatePricingRules');
    }
    /**
     * Grants permission to batch associate resources to a percentage custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_BatchAssociateResourcesToCustomLineItem.html
     */
    toBatchAssociateResourcesToCustomLineItem() {
        return this.to('BatchAssociateResourcesToCustomLineItem');
    }
    /**
     * Grants permission to batch disassociate resources from a percentage custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_BatchDisassociateResourcesFromCustomLineItem.html
     */
    toBatchDisassociateResourcesFromCustomLineItem() {
        return this.to('BatchDisassociateResourcesFromCustomLineItem');
    }
    /**
     * Grants permission to create a billing group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreateBillingGroup.html
     */
    toCreateBillingGroup() {
        return this.to('CreateBillingGroup');
    }
    /**
     * Grants permission to create a custom line item
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreateCustomLineItem.html
     */
    toCreateCustomLineItem() {
        return this.to('CreateCustomLineItem');
    }
    /**
     * Grants permission to create a pricing plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreatePricingPlan.html
     */
    toCreatePricingPlan() {
        return this.to('CreatePricingPlan');
    }
    /**
     * Grants permission to create a pricing rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreatePricingRule.html
     */
    toCreatePricingRule() {
        return this.to('CreatePricingRule');
    }
    /**
     * Grants permission to delete a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeleteBillingGroup.html
     */
    toDeleteBillingGroup() {
        return this.to('DeleteBillingGroup');
    }
    /**
     * Grants permission to delete a custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeleteCustomLineItem.html
     */
    toDeleteCustomLineItem() {
        return this.to('DeleteCustomLineItem');
    }
    /**
     * Grants permission to delete a pricing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeletePricingPlan.html
     */
    toDeletePricingPlan() {
        return this.to('DeletePricingPlan');
    }
    /**
     * Grants permission to delete a pricing rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeletePricingRule.html
     */
    toDeletePricingRule() {
        return this.to('DeletePricingRule');
    }
    /**
     * Grants permission to detach between one and 30 accounts from a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DisassociateAccounts.html
     */
    toDisassociateAccounts() {
        return this.to('DisassociateAccounts');
    }
    /**
     * Grants permission to disassociate pricing rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DisassociatePricingRules.html
     */
    toDisassociatePricingRules() {
        return this.to('DisassociatePricingRules');
    }
    /**
     * Grants permission to list the linked accounts of the payer account for the given billing period while also providing the billing group the linked accounts belong to
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListAccountAssociations.html
     */
    toListAccountAssociations() {
        return this.to('ListAccountAssociations');
    }
    /**
     * Grants permission to view the billing group cost report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListBillingGroupCostReports.html
     */
    toListBillingGroupCostReports() {
        return this.to('ListBillingGroupCostReports');
    }
    /**
     * Grants permission to view the details of billing groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListBillingGroups.html
     */
    toListBillingGroups() {
        return this.to('ListBillingGroups');
    }
    /**
     * Grants permission to view custom line item details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListCustomLineItems.html
     */
    toListCustomLineItems() {
        return this.to('ListCustomLineItems');
    }
    /**
     * Grants permission to view the pricing plans details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingPlans.html
     */
    toListPricingPlans() {
        return this.to('ListPricingPlans');
    }
    /**
     * Grants permission to list pricing plans associated with a pricing rule
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingPlansAssociatedWithPricingRule.html
     */
    toListPricingPlansAssociatedWithPricingRule() {
        return this.to('ListPricingPlansAssociatedWithPricingRule');
    }
    /**
     * Grants permission to view pricing rules details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingRules.html
     */
    toListPricingRules() {
        return this.to('ListPricingRules');
    }
    /**
     * Grants permission to list pricing rules associated to a pricing plan
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingRulesAssociatedToPricingPlan.html
     */
    toListPricingRulesAssociatedToPricingPlan() {
        return this.to('ListPricingRulesAssociatedToPricingPlan');
    }
    /**
     * Grants permission to list resources associated to a percentage custom line item
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListResourcesAssociatedToCustomLineItem.html
     */
    toListResourcesAssociatedToCustomLineItem() {
        return this.to('ListResourcesAssociatedToCustomLineItem');
    }
    /**
     * Grants permission to list tags of a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsResource() {
        return this.to('ListTagsResource');
    }
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdateBillingGroup.html
     */
    toUpdateBillingGroup() {
        return this.to('UpdateBillingGroup');
    }
    /**
     * Grants permission to update a custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdateCustomLineItem.html
     */
    toUpdateCustomLineItem() {
        return this.to('UpdateCustomLineItem');
    }
    /**
     * Grants permission to update a pricing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdatePricingPlan.html
     */
    toUpdatePricingPlan() {
        return this.to('UpdatePricingPlan');
    }
    /**
     * Grants permission to update a pricing rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdatePricingRule.html
     */
    toUpdatePricingRule() {
        return this.to('UpdatePricingRule');
    }
    /**
     * Adds a resource of type billingGroup to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBillingGroup(resourceId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:billingconductor::${account || '*'}:billinggroup/${resourceId}`);
    }
    /**
     * Adds a resource of type pricingPlan to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPricingPlan(resourceId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:billingconductor::${account || '*'}:pricingplan/${resourceId}`);
    }
    /**
     * Adds a resource of type pricingRule to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPricingRule(resourceId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:billingconductor::${account || '*'}:pricingrule/${resourceId}`);
    }
    /**
     * Adds a resource of type customLineItem to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomLineItem(resourceId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:billingconductor::${account || '*'}:customlineitem/${resourceId}`);
    }
}
exports.Billingconductor = Billingconductor;
_a = JSII_RTTI_SYMBOL_1;
Billingconductor[_a] = { fqn: "iam-floyd.Billingconductor", version: "0.340.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmlsbGluZ2NvbmR1Y3Rvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImJpbGxpbmdjb25kdWN0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxzQ0FBNEM7QUFFNUM7Ozs7R0FJRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsd0JBQWU7SUFHbkQ7Ozs7T0FJRztJQUNILFlBQVksR0FBWTtRQUN0QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFSTixrQkFBYSxHQUFHLGtCQUFrQixDQUFDO1FBaVhoQyxvQkFBZSxHQUFvQjtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsbUJBQW1CO2dCQUNuQix1QkFBdUI7Z0JBQ3ZCLHlDQUF5QztnQkFDekMsOENBQThDO2dCQUM5QyxvQkFBb0I7Z0JBQ3BCLHNCQUFzQjtnQkFDdEIsbUJBQW1CO2dCQUNuQixtQkFBbUI7Z0JBQ25CLG9CQUFvQjtnQkFDcEIsc0JBQXNCO2dCQUN0QixtQkFBbUI7Z0JBQ25CLG1CQUFtQjtnQkFDbkIsc0JBQXNCO2dCQUN0QiwwQkFBMEI7Z0JBQzFCLG9CQUFvQjtnQkFDcEIsc0JBQXNCO2dCQUN0QixtQkFBbUI7Z0JBQ25CLG1CQUFtQjthQUNwQjtZQUNELElBQUksRUFBRTtnQkFDSix5QkFBeUI7Z0JBQ3pCLDJDQUEyQztnQkFDM0MseUNBQXlDO2dCQUN6Qyx5Q0FBeUM7YUFDMUM7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osNkJBQTZCO2dCQUM3QixtQkFBbUI7Z0JBQ25CLHFCQUFxQjtnQkFDckIsa0JBQWtCO2dCQUNsQixrQkFBa0I7Z0JBQ2xCLGtCQUFrQjthQUNuQjtZQUNELE9BQU8sRUFBRTtnQkFDUCxhQUFhO2dCQUNiLGVBQWU7YUFDaEI7U0FDRixDQUFDO0lBL1lGLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUNBQXlDO1FBQzlDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5Q0FBeUMsQ0FBQyxDQUFDO0lBQzVELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw4Q0FBOEM7UUFDbkQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhDQUE4QyxDQUFDLENBQUM7SUFDakUsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNkJBQTZCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQ0FBMkM7UUFDaEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJDQUEyQyxDQUFDLENBQUM7SUFDOUQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUNBQXlDO1FBQzlDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5Q0FBeUMsQ0FBQyxDQUFDO0lBQzVELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5Q0FBeUM7UUFDOUMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlDQUF5QyxDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQTJDRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLGNBQWMsQ0FBQyxVQUFrQixFQUFFLE9BQWdCLEVBQUUsU0FBa0I7UUFDNUUsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sc0JBQXVCLE9BQU8sSUFBSSxHQUFJLGlCQUFrQixVQUFXLEVBQUUsQ0FBQyxDQUFDO0lBQ25ILENBQUM7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLGFBQWEsQ0FBQyxVQUFrQixFQUFFLE9BQWdCLEVBQUUsU0FBa0I7UUFDM0UsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sc0JBQXVCLE9BQU8sSUFBSSxHQUFJLGdCQUFpQixVQUFXLEVBQUUsQ0FBQyxDQUFDO0lBQ2xILENBQUM7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLGFBQWEsQ0FBQyxVQUFrQixFQUFFLE9BQWdCLEVBQUUsU0FBa0I7UUFDM0UsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sc0JBQXVCLE9BQU8sSUFBSSxHQUFJLGdCQUFpQixVQUFXLEVBQUUsQ0FBQyxDQUFDO0lBQ2xILENBQUM7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLGdCQUFnQixDQUFDLFVBQWtCLEVBQUUsT0FBZ0IsRUFBRSxTQUFrQjtRQUM5RSxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksS0FBTSxzQkFBdUIsT0FBTyxJQUFJLEdBQUksbUJBQW9CLFVBQVcsRUFBRSxDQUFDLENBQUM7SUFDckgsQ0FBQzs7QUF6ZEgsNENBMGRDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi9zaGFyZWQnO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbYmlsbGluZ2NvbmR1Y3Rvcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzYmlsbGluZ2NvbmR1Y3Rvci5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIEJpbGxpbmdjb25kdWN0b3IgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdiaWxsaW5nY29uZHVjdG9yJztcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtiaWxsaW5nY29uZHVjdG9yXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3NiaWxsaW5nY29uZHVjdG9yLmh0bWwpLlxuICAgKlxuICAgKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gYXNzb2NpYXRlIGJldHdlZW4gb25lIGFuZCAzMCBhY2NvdW50cyB0byBhIGJpbGxpbmcgZ3JvdXBcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Bc3NvY2lhdGVBY2NvdW50cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9Bc3NvY2lhdGVBY2NvdW50cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQXNzb2NpYXRlQWNjb3VudHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBhc3NvY2lhdGUgcHJpY2luZyBydWxlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Fzc29jaWF0ZVByaWNpbmdSdWxlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9Bc3NvY2lhdGVQcmljaW5nUnVsZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Fzc29jaWF0ZVByaWNpbmdSdWxlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGJhdGNoIGFzc29jaWF0ZSByZXNvdXJjZXMgdG8gYSBwZXJjZW50YWdlIGN1c3RvbSBsaW5lIGl0ZW1cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9CYXRjaEFzc29jaWF0ZVJlc291cmNlc1RvQ3VzdG9tTGluZUl0ZW0uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQmF0Y2hBc3NvY2lhdGVSZXNvdXJjZXNUb0N1c3RvbUxpbmVJdGVtKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdCYXRjaEFzc29jaWF0ZVJlc291cmNlc1RvQ3VzdG9tTGluZUl0ZW0nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBiYXRjaCBkaXNhc3NvY2lhdGUgcmVzb3VyY2VzIGZyb20gYSBwZXJjZW50YWdlIGN1c3RvbSBsaW5lIGl0ZW1cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9CYXRjaERpc2Fzc29jaWF0ZVJlc291cmNlc0Zyb21DdXN0b21MaW5lSXRlbS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9CYXRjaERpc2Fzc29jaWF0ZVJlc291cmNlc0Zyb21DdXN0b21MaW5lSXRlbSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hEaXNhc3NvY2lhdGVSZXNvdXJjZXNGcm9tQ3VzdG9tTGluZUl0ZW0nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBiaWxsaW5nIGdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2JpbGxpbmdjb25kdWN0b3IvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlQmlsbGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUJpbGxpbmdHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlQmlsbGluZ0dyb3VwJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgY3VzdG9tIGxpbmUgaXRlbVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZUN1c3RvbUxpbmVJdGVtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUN1c3RvbUxpbmVJdGVtKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVDdXN0b21MaW5lSXRlbScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHByaWNpbmcgcGxhblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVByaWNpbmdQbGFuLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVByaWNpbmdQbGFuKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVQcmljaW5nUGxhbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHByaWNpbmcgcnVsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVByaWNpbmdSdWxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVByaWNpbmdSdWxlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVQcmljaW5nUnVsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIGJpbGxpbmcgZ3JvdXBcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVCaWxsaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlQmlsbGluZ0dyb3VwKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVCaWxsaW5nR3JvdXAnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBjdXN0b20gbGluZSBpdGVtXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2JpbGxpbmdjb25kdWN0b3IvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlQ3VzdG9tTGluZUl0ZW0uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlQ3VzdG9tTGluZUl0ZW0oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUN1c3RvbUxpbmVJdGVtJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgcHJpY2luZyBwbGFuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2JpbGxpbmdjb25kdWN0b3IvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlUHJpY2luZ1BsYW4uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUHJpY2luZ1BsYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVByaWNpbmdQbGFuJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgcHJpY2luZyBydWxlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2JpbGxpbmdjb25kdWN0b3IvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlUHJpY2luZ1J1bGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUHJpY2luZ1J1bGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVByaWNpbmdSdWxlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGV0YWNoIGJldHdlZW4gb25lIGFuZCAzMCBhY2NvdW50cyBmcm9tIGEgYmlsbGluZyBncm91cFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rpc2Fzc29jaWF0ZUFjY291bnRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rpc2Fzc29jaWF0ZUFjY291bnRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEaXNhc3NvY2lhdGVBY2NvdW50cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRpc2Fzc29jaWF0ZSBwcmljaW5nIHJ1bGVzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2JpbGxpbmdjb25kdWN0b3IvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGlzYXNzb2NpYXRlUHJpY2luZ1J1bGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rpc2Fzc29jaWF0ZVByaWNpbmdSdWxlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGlzYXNzb2NpYXRlUHJpY2luZ1J1bGVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCB0aGUgbGlua2VkIGFjY291bnRzIG9mIHRoZSBwYXllciBhY2NvdW50IGZvciB0aGUgZ2l2ZW4gYmlsbGluZyBwZXJpb2Qgd2hpbGUgYWxzbyBwcm92aWRpbmcgdGhlIGJpbGxpbmcgZ3JvdXAgdGhlIGxpbmtlZCBhY2NvdW50cyBiZWxvbmcgdG9cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RBY2NvdW50QXNzb2NpYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RBY2NvdW50QXNzb2NpYXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0QWNjb3VudEFzc29jaWF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgdGhlIGJpbGxpbmcgZ3JvdXAgY29zdCByZXBvcnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RCaWxsaW5nR3JvdXBDb3N0UmVwb3J0cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0QmlsbGluZ0dyb3VwQ29zdFJlcG9ydHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RCaWxsaW5nR3JvdXBDb3N0UmVwb3J0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgdGhlIGRldGFpbHMgb2YgYmlsbGluZyBncm91cHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RCaWxsaW5nR3JvdXBzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RCaWxsaW5nR3JvdXBzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0QmlsbGluZ0dyb3VwcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgY3VzdG9tIGxpbmUgaXRlbSBkZXRhaWxzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0Q3VzdG9tTGluZUl0ZW1zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RDdXN0b21MaW5lSXRlbXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RDdXN0b21MaW5lSXRlbXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB2aWV3IHRoZSBwcmljaW5nIHBsYW5zIGRldGFpbHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RQcmljaW5nUGxhbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFByaWNpbmdQbGFucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFByaWNpbmdQbGFucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgcHJpY2luZyBwbGFucyBhc3NvY2lhdGVkIHdpdGggYSBwcmljaW5nIHJ1bGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RQcmljaW5nUGxhbnNBc3NvY2lhdGVkV2l0aFByaWNpbmdSdWxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RQcmljaW5nUGxhbnNBc3NvY2lhdGVkV2l0aFByaWNpbmdSdWxlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UHJpY2luZ1BsYW5zQXNzb2NpYXRlZFdpdGhQcmljaW5nUnVsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgcHJpY2luZyBydWxlcyBkZXRhaWxzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0UHJpY2luZ1J1bGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RQcmljaW5nUnVsZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RQcmljaW5nUnVsZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHByaWNpbmcgcnVsZXMgYXNzb2NpYXRlZCB0byBhIHByaWNpbmcgcGxhblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2JpbGxpbmdjb25kdWN0b3IvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFByaWNpbmdSdWxlc0Fzc29jaWF0ZWRUb1ByaWNpbmdQbGFuLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RQcmljaW5nUnVsZXNBc3NvY2lhdGVkVG9QcmljaW5nUGxhbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFByaWNpbmdSdWxlc0Fzc29jaWF0ZWRUb1ByaWNpbmdQbGFuJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCByZXNvdXJjZXMgYXNzb2NpYXRlZCB0byBhIHBlcmNlbnRhZ2UgY3VzdG9tIGxpbmUgaXRlbVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2JpbGxpbmdjb25kdWN0b3IvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFJlc291cmNlc0Fzc29jaWF0ZWRUb0N1c3RvbUxpbmVJdGVtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RSZXNvdXJjZXNBc3NvY2lhdGVkVG9DdXN0b21MaW5lSXRlbSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFJlc291cmNlc0Fzc29jaWF0ZWRUb0N1c3RvbUxpbmVJdGVtJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCB0YWdzIG9mIGEgcmVzb3VyY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RUYWdzRm9yUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFRhZ3NSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFRhZ3NSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHRhZyBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9UYWdSZXNvdXJjZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9UYWdSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVGFnUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1bnRhZyBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VbnRhZ1Jlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VudGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VudGFnUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBiaWxsaW5nIGdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2JpbGxpbmdjb25kdWN0b3IvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlQmlsbGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUJpbGxpbmdHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlQmlsbGluZ0dyb3VwJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgY3VzdG9tIGxpbmUgaXRlbVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUN1c3RvbUxpbmVJdGVtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUN1c3RvbUxpbmVJdGVtKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVDdXN0b21MaW5lSXRlbScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhIHByaWNpbmcgcGxhblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZVByaWNpbmdQbGFuLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVByaWNpbmdQbGFuKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVQcmljaW5nUGxhbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhIHByaWNpbmcgcnVsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZVByaWNpbmdSdWxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVByaWNpbmdSdWxlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVQcmljaW5nUnVsZScpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFdyaXRlOiBbXG4gICAgICAnQXNzb2NpYXRlQWNjb3VudHMnLFxuICAgICAgJ0Fzc29jaWF0ZVByaWNpbmdSdWxlcycsXG4gICAgICAnQmF0Y2hBc3NvY2lhdGVSZXNvdXJjZXNUb0N1c3RvbUxpbmVJdGVtJyxcbiAgICAgICdCYXRjaERpc2Fzc29jaWF0ZVJlc291cmNlc0Zyb21DdXN0b21MaW5lSXRlbScsXG4gICAgICAnQ3JlYXRlQmlsbGluZ0dyb3VwJyxcbiAgICAgICdDcmVhdGVDdXN0b21MaW5lSXRlbScsXG4gICAgICAnQ3JlYXRlUHJpY2luZ1BsYW4nLFxuICAgICAgJ0NyZWF0ZVByaWNpbmdSdWxlJyxcbiAgICAgICdEZWxldGVCaWxsaW5nR3JvdXAnLFxuICAgICAgJ0RlbGV0ZUN1c3RvbUxpbmVJdGVtJyxcbiAgICAgICdEZWxldGVQcmljaW5nUGxhbicsXG4gICAgICAnRGVsZXRlUHJpY2luZ1J1bGUnLFxuICAgICAgJ0Rpc2Fzc29jaWF0ZUFjY291bnRzJyxcbiAgICAgICdEaXNhc3NvY2lhdGVQcmljaW5nUnVsZXMnLFxuICAgICAgJ1VwZGF0ZUJpbGxpbmdHcm91cCcsXG4gICAgICAnVXBkYXRlQ3VzdG9tTGluZUl0ZW0nLFxuICAgICAgJ1VwZGF0ZVByaWNpbmdQbGFuJyxcbiAgICAgICdVcGRhdGVQcmljaW5nUnVsZSdcbiAgICBdLFxuICAgIExpc3Q6IFtcbiAgICAgICdMaXN0QWNjb3VudEFzc29jaWF0aW9ucycsXG4gICAgICAnTGlzdFByaWNpbmdQbGFuc0Fzc29jaWF0ZWRXaXRoUHJpY2luZ1J1bGUnLFxuICAgICAgJ0xpc3RQcmljaW5nUnVsZXNBc3NvY2lhdGVkVG9QcmljaW5nUGxhbicsXG4gICAgICAnTGlzdFJlc291cmNlc0Fzc29jaWF0ZWRUb0N1c3RvbUxpbmVJdGVtJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0xpc3RCaWxsaW5nR3JvdXBDb3N0UmVwb3J0cycsXG4gICAgICAnTGlzdEJpbGxpbmdHcm91cHMnLFxuICAgICAgJ0xpc3RDdXN0b21MaW5lSXRlbXMnLFxuICAgICAgJ0xpc3RQcmljaW5nUGxhbnMnLFxuICAgICAgJ0xpc3RQcmljaW5nUnVsZXMnLFxuICAgICAgJ0xpc3RUYWdzUmVzb3VyY2UnXG4gICAgXSxcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnVGFnUmVzb3VyY2UnLFxuICAgICAgJ1VudGFnUmVzb3VyY2UnXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBiaWxsaW5nR3JvdXAgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYmlsbGluZ2NvbmR1Y3Rvci9sYXRlc3QvdXNlcmd1aWRlL3VuZGVyc3RhbmRpbmctZWIuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gcmVzb3VyY2VJZCAtIElkZW50aWZpZXIgZm9yIHRoZSByZXNvdXJjZUlkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uQmlsbGluZ0dyb3VwKHJlc291cmNlSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgJ2F3cycgfTpiaWxsaW5nY29uZHVjdG9yOjokeyBhY2NvdW50IHx8ICcqJyB9OmJpbGxpbmdncm91cC8keyByZXNvdXJjZUlkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBwcmljaW5nUGxhbiB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC91c2VyZ3VpZGUvdW5kZXJzdGFuZGluZy1lYi5odG1sXG4gICAqXG4gICAqIEBwYXJhbSByZXNvdXJjZUlkIC0gSWRlbnRpZmllciBmb3IgdGhlIHJlc291cmNlSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25QcmljaW5nUGxhbihyZXNvdXJjZUlkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06YmlsbGluZ2NvbmR1Y3Rvcjo6JHsgYWNjb3VudCB8fCAnKicgfTpwcmljaW5ncGxhbi8keyByZXNvdXJjZUlkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBwcmljaW5nUnVsZSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC91c2VyZ3VpZGUvdW5kZXJzdGFuZGluZy1lYi5odG1sXG4gICAqXG4gICAqIEBwYXJhbSByZXNvdXJjZUlkIC0gSWRlbnRpZmllciBmb3IgdGhlIHJlc291cmNlSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25QcmljaW5nUnVsZShyZXNvdXJjZUlkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06YmlsbGluZ2NvbmR1Y3Rvcjo6JHsgYWNjb3VudCB8fCAnKicgfTpwcmljaW5ncnVsZS8keyByZXNvdXJjZUlkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBjdXN0b21MaW5lSXRlbSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iaWxsaW5nY29uZHVjdG9yL2xhdGVzdC91c2VyZ3VpZGUvdW5kZXJzdGFuZGluZy1lYi5odG1sXG4gICAqXG4gICAqIEBwYXJhbSByZXNvdXJjZUlkIC0gSWRlbnRpZmllciBmb3IgdGhlIHJlc291cmNlSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25DdXN0b21MaW5lSXRlbShyZXNvdXJjZUlkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06YmlsbGluZ2NvbmR1Y3Rvcjo6JHsgYWNjb3VudCB8fCAnKicgfTpjdXN0b21saW5laXRlbS8keyByZXNvdXJjZUlkIH1gKTtcbiAgfVxufVxuIl19