"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [lambda](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslambda.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Lambda extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [lambda](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslambda.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'lambda';
        this.accessLevelList = {
            'Permissions management': [
                'AddLayerVersionPermission',
                'AddPermission',
                'DisableReplication',
                'EnableReplication',
                'RemoveLayerVersionPermission',
                'RemovePermission'
            ],
            Write: [
                'CreateAlias',
                'CreateCodeSigningConfig',
                'CreateEventSourceMapping',
                'CreateFunction',
                'DeleteAlias',
                'DeleteCodeSigningConfig',
                'DeleteEventSourceMapping',
                'DeleteFunction',
                'DeleteFunctionCodeSigningConfig',
                'DeleteFunctionConcurrency',
                'DeleteFunctionEventInvokeConfig',
                'DeleteLayerVersion',
                'DeleteProvisionedConcurrencyConfig',
                'InvokeAsync',
                'InvokeFunction',
                'PublishLayerVersion',
                'PublishVersion',
                'PutFunctionCodeSigningConfig',
                'PutFunctionConcurrency',
                'PutFunctionEventInvokeConfig',
                'PutProvisionedConcurrencyConfig',
                'UpdateAlias',
                'UpdateCodeSigningConfig',
                'UpdateEventSourceMapping',
                'UpdateFunctionCode',
                'UpdateFunctionCodeSigningConfig',
                'UpdateFunctionConfiguration',
                'UpdateFunctionEventInvokeConfig'
            ],
            Read: [
                'GetAccountSettings',
                'GetAlias',
                'GetCodeSigningConfig',
                'GetEventSourceMapping',
                'GetFunction',
                'GetFunctionCodeSigningConfig',
                'GetFunctionConcurrency',
                'GetFunctionConfiguration',
                'GetFunctionEventInvokeConfig',
                'GetLayerVersion',
                'GetLayerVersionPolicy',
                'GetPolicy',
                'GetProvisionedConcurrencyConfig',
                'ListTags'
            ],
            List: [
                'ListAliases',
                'ListCodeSigningConfigs',
                'ListEventSourceMappings',
                'ListFunctionEventInvokeConfigs',
                'ListFunctions',
                'ListFunctionsByCodeSigningConfig',
                'ListLayerVersions',
                'ListLayers',
                'ListProvisionedConcurrencyConfigs',
                'ListVersionsByFunction'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to add permissions to the resource-based policy of a version of an AWS Lambda layer
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_AddLayerVersionPermission.html
     */
    toAddLayerVersionPermission() {
        return this.to('AddLayerVersionPermission');
    }
    /**
     * Grants permission to give an AWS service or another account permission to use an AWS Lambda function
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPrincipal()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html
     */
    toAddPermission() {
        return this.to('AddPermission');
    }
    /**
     * Grants permission to create an alias for a Lambda function version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_CreateAlias.html
     */
    toCreateAlias() {
        return this.to('CreateAlias');
    }
    /**
     * Grants permission to create an AWS Lambda code signing config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_CreateCodeSigningConfig.html
     */
    toCreateCodeSigningConfig() {
        return this.to('CreateCodeSigningConfig');
    }
    /**
     * Grants permission to create a mapping between an event source and an AWS Lambda function
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFunctionArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_CreateEventSourceMapping.html
     */
    toCreateEventSourceMapping() {
        return this.to('CreateEventSourceMapping');
    }
    /**
     * Grants permission to create an AWS Lambda function
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLayer()
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     * - .ifCodeSigningConfigArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html
     */
    toCreateFunction() {
        return this.to('CreateFunction');
    }
    /**
     * Grants permission to delete an AWS Lambda function alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteAlias.html
     */
    toDeleteAlias() {
        return this.to('DeleteAlias');
    }
    /**
     * Grants permission to delete an AWS Lambda code signing config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteCodeSigningConfig.html
     */
    toDeleteCodeSigningConfig() {
        return this.to('DeleteCodeSigningConfig');
    }
    /**
     * Grants permission to delete an AWS Lambda event source mapping
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFunctionArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteEventSourceMapping.html
     */
    toDeleteEventSourceMapping() {
        return this.to('DeleteEventSourceMapping');
    }
    /**
     * Grants permission to delete an AWS Lambda function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteFunction.html
     */
    toDeleteFunction() {
        return this.to('DeleteFunction');
    }
    /**
     * Grants permission to detach a code signing config from an AWS Lambda function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteFunctionCodeSigningConfig.html
     */
    toDeleteFunctionCodeSigningConfig() {
        return this.to('DeleteFunctionCodeSigningConfig');
    }
    /**
     * Grants permission to remove a concurrent execution limit from an AWS Lambda function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteFunctionConcurrency.html
     */
    toDeleteFunctionConcurrency() {
        return this.to('DeleteFunctionConcurrency');
    }
    /**
     * Grants permission to delete the configuration for asynchronous invocation for an AWS Lambda function, version, or alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteFunctionEventInvokeConfig.html
     */
    toDeleteFunctionEventInvokeConfig() {
        return this.to('DeleteFunctionEventInvokeConfig');
    }
    /**
     * Grants permission to delete a version of an AWS Lambda layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteLayerVersion.html
     */
    toDeleteLayerVersion() {
        return this.to('DeleteLayerVersion');
    }
    /**
     * Grants permission to delete the provisioned concurrency configuration for an AWS Lambda function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteProvisionedConcurrencyConfig.html
     */
    toDeleteProvisionedConcurrencyConfig() {
        return this.to('DeleteProvisionedConcurrencyConfig');
    }
    /**
     * Grants permission to disable replication for a Lambda@Edge function
     *
     * Access Level: Permissions management
     */
    toDisableReplication() {
        return this.to('DisableReplication');
    }
    /**
     * Grants permission to enable replication for a Lambda@Edge function
     *
     * Access Level: Permissions management
     */
    toEnableReplication() {
        return this.to('EnableReplication');
    }
    /**
     * Grants permission to view details about an account's limits and usage in an AWS Region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetAccountSettings.html
     */
    toGetAccountSettings() {
        return this.to('GetAccountSettings');
    }
    /**
     * Grants permission to view details about an AWS Lambda function alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetAlias.html
     */
    toGetAlias() {
        return this.to('GetAlias');
    }
    /**
     * Grants permission to view details about an AWS Lambda code signing config
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetCodeSigningConfig.html
     */
    toGetCodeSigningConfig() {
        return this.to('GetCodeSigningConfig');
    }
    /**
     * Grants permission to view details about an AWS Lambda event source mapping
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifFunctionArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetEventSourceMapping.html
     */
    toGetEventSourceMapping() {
        return this.to('GetEventSourceMapping');
    }
    /**
     * Grants permission to view details about an AWS Lambda function
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunction.html
     */
    toGetFunction() {
        return this.to('GetFunction');
    }
    /**
     * Grants permission to view the code signing config arn attached to an AWS Lambda function
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionCodeSigningConfig.html
     */
    toGetFunctionCodeSigningConfig() {
        return this.to('GetFunctionCodeSigningConfig');
    }
    /**
     * Grants permission to view details about the reserved concurrency configuration for a function
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConcurrency.html
     */
    toGetFunctionConcurrency() {
        return this.to('GetFunctionConcurrency');
    }
    /**
     * Grants permission to view details about the version-specific settings of an AWS Lambda function or version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html
     */
    toGetFunctionConfiguration() {
        return this.to('GetFunctionConfiguration');
    }
    /**
     * Grants permission to view the configuration for asynchronous invocation for a function, version, or alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionEventInvokeConfig.html
     */
    toGetFunctionEventInvokeConfig() {
        return this.to('GetFunctionEventInvokeConfig');
    }
    /**
     * Grants permission to view details about a version of an AWS Lambda layer. Note this action also supports GetLayerVersionByArn API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetLayerVersion.html
     */
    toGetLayerVersion() {
        return this.to('GetLayerVersion');
    }
    /**
     * Grants permission to view the resource-based policy for a version of an AWS Lambda layer
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetLayerVersionPolicy.html
     */
    toGetLayerVersionPolicy() {
        return this.to('GetLayerVersionPolicy');
    }
    /**
     * Grants permission to view the resource-based policy for an AWS Lambda function, version, or alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetPolicy.html
     */
    toGetPolicy() {
        return this.to('GetPolicy');
    }
    /**
     * Grants permission to view the provisioned concurrency configuration for an AWS Lambda function's alias or version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetProvisionedConcurrencyConfig.html
     */
    toGetProvisionedConcurrencyConfig() {
        return this.to('GetProvisionedConcurrencyConfig');
    }
    /**
     * Grants permission to invoke a function asynchronously (Deprecated)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_InvokeAsync.html
     */
    toInvokeAsync() {
        return this.to('InvokeAsync');
    }
    /**
     * Grants permission to invoke an AWS Lambda function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html
     */
    toInvokeFunction() {
        return this.to('InvokeFunction');
    }
    /**
     * Grants permission to retrieve a list of aliases for an AWS Lambda function
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListAliases.html
     */
    toListAliases() {
        return this.to('ListAliases');
    }
    /**
     * Grants permission to retrieve a list of AWS Lambda code signing configs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListCodeSigningConfigs.html
     */
    toListCodeSigningConfigs() {
        return this.to('ListCodeSigningConfigs');
    }
    /**
     * Grants permission to retrieve a list of AWS Lambda event source mappings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListEventSourceMappings.html
     */
    toListEventSourceMappings() {
        return this.to('ListEventSourceMappings');
    }
    /**
     * Grants permission to retrieve a list of configurations for asynchronous invocation for a function
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListFunctionEventInvokeConfigs.html
     */
    toListFunctionEventInvokeConfigs() {
        return this.to('ListFunctionEventInvokeConfigs');
    }
    /**
     * Grants permission to retrieve a list of AWS Lambda functions, with the version-specific configuration of each function
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListFunctions.html
     */
    toListFunctions() {
        return this.to('ListFunctions');
    }
    /**
     * Grants permission to retrieve a list of AWS Lambda functions by the code signing config assigned
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListFunctionsByCodeSigningConfig.html
     */
    toListFunctionsByCodeSigningConfig() {
        return this.to('ListFunctionsByCodeSigningConfig');
    }
    /**
     * Grants permission to retrieve a list of versions of an AWS Lambda layer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListLayerVersions.html
     */
    toListLayerVersions() {
        return this.to('ListLayerVersions');
    }
    /**
     * Grants permission to retrieve a list of AWS Lambda layers, with details about the latest version of each layer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListLayers.html
     */
    toListLayers() {
        return this.to('ListLayers');
    }
    /**
     * Grants permission to retrieve a list of provisioned concurrency configurations for an AWS Lambda function
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListProvisionedConcurrencyConfigs.html
     */
    toListProvisionedConcurrencyConfigs() {
        return this.to('ListProvisionedConcurrencyConfigs');
    }
    /**
     * Grants permission to retrieve a list of tags for an AWS Lambda function
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListTags.html
     */
    toListTags() {
        return this.to('ListTags');
    }
    /**
     * Grants permission to retrieve a list of versions for an AWS Lambda function
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListVersionsByFunction.html
     */
    toListVersionsByFunction() {
        return this.to('ListVersionsByFunction');
    }
    /**
     * Grants permission to create an AWS Lambda layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html
     */
    toPublishLayerVersion() {
        return this.to('PublishLayerVersion');
    }
    /**
     * Grants permission to create an AWS Lambda function version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PublishVersion.html
     */
    toPublishVersion() {
        return this.to('PublishVersion');
    }
    /**
     * Grants permission to attach a code signing config to an AWS Lambda function
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCodeSigningConfigArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PutFunctionCodeSigningConfig.html
     */
    toPutFunctionCodeSigningConfig() {
        return this.to('PutFunctionCodeSigningConfig');
    }
    /**
     * Grants permission to configure reserved concurrency for an AWS Lambda function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PutFunctionConcurrency.html
     */
    toPutFunctionConcurrency() {
        return this.to('PutFunctionConcurrency');
    }
    /**
     * Grants permission to configures options for asynchronous invocation on an AWS Lambda function, version, or alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PutFunctionEventInvokeConfig.html
     */
    toPutFunctionEventInvokeConfig() {
        return this.to('PutFunctionEventInvokeConfig');
    }
    /**
     * Grants permission to configure provisioned concurrency for an AWS Lambda function's alias or version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PutProvisionedConcurrencyConfig.html
     */
    toPutProvisionedConcurrencyConfig() {
        return this.to('PutProvisionedConcurrencyConfig');
    }
    /**
     * Grants permission to remove a statement from the permissions policy for a version of an AWS Lambda layer
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_RemoveLayerVersionPermission.html
     */
    toRemoveLayerVersionPermission() {
        return this.to('RemoveLayerVersionPermission');
    }
    /**
     * Grants permission to revoke function-use permission from an AWS service or another account
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPrincipal()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_RemovePermission.html
     */
    toRemovePermission() {
        return this.to('RemovePermission');
    }
    /**
     * Grants permission to add tags to an AWS Lambda function
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_TagResources.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from an AWS Lambda function
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update the configuration of an AWS Lambda function's alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateAlias.html
     */
    toUpdateAlias() {
        return this.to('UpdateAlias');
    }
    /**
     * Grants permission to update an AWS Lambda code signing config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateCodeSigningConfig.html
     */
    toUpdateCodeSigningConfig() {
        return this.to('UpdateCodeSigningConfig');
    }
    /**
     * Grants permission to update the configuration of an AWS Lambda event source mapping
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFunctionArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateEventSourceMapping.html
     */
    toUpdateEventSourceMapping() {
        return this.to('UpdateEventSourceMapping');
    }
    /**
     * Grants permission to update the code of an AWS Lambda function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionCode.html
     */
    toUpdateFunctionCode() {
        return this.to('UpdateFunctionCode');
    }
    /**
     * Grants permission to update the code signing config of an AWS Lambda function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionCodeSigningConfig.html
     */
    toUpdateFunctionCodeSigningConfig() {
        return this.to('UpdateFunctionCodeSigningConfig');
    }
    /**
     * Grants permission to modify the version-specific settings of an AWS Lambda function
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLayer()
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionConfiguration.html
     */
    toUpdateFunctionConfiguration() {
        return this.to('UpdateFunctionConfiguration');
    }
    /**
     * Grants permission to modify the configuration for asynchronous invocation for an AWS Lambda function, version, or alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionEventInvokeConfig.html
     */
    toUpdateFunctionEventInvokeConfig() {
        return this.to('UpdateFunctionEventInvokeConfig');
    }
    /**
     * Adds a resource of type code signing config to the statement
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param codeSigningConfigId - Identifier for the codeSigningConfigId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onCodeSigningConfig(codeSigningConfigId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lambda:${region || '*'}:${account || '*'}:code-signing-config:${codeSigningConfigId}`);
    }
    /**
     * Adds a resource of type eventSourceMapping to the statement
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param uUID - Identifier for the uUID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onEventSourceMapping(uUID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lambda:${region || '*'}:${account || '*'}:event-source-mapping:${uUID}`);
    }
    /**
     * Adds a resource of type function to the statement
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param functionName - Identifier for the functionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onFunction(functionName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lambda:${region || '*'}:${account || '*'}:function:${functionName}`);
    }
    /**
     * Adds a resource of type function alias to the statement
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param functionName - Identifier for the functionName.
     * @param alias - Identifier for the alias.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onFunctionAlias(functionName, alias, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lambda:${region || '*'}:${account || '*'}:function:${functionName}:${alias}`);
    }
    /**
     * Adds a resource of type function version to the statement
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param functionName - Identifier for the functionName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onFunctionVersion(functionName, version, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lambda:${region || '*'}:${account || '*'}:function:${functionName}:${version}`);
    }
    /**
     * Adds a resource of type layer to the statement
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param layerName - Identifier for the layerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onLayer(layerName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lambda:${region || '*'}:${account || '*'}:layer:${layerName}`);
    }
    /**
     * Adds a resource of type layerVersion to the statement
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param layerName - Identifier for the layerName.
     * @param layerVersion - Identifier for the layerVersion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onLayerVersion(layerName, layerVersion, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lambda:${region || '*'}:${account || '*'}:layer:${layerName}:${layerVersion}`);
    }
    /**
     * Filters access by the ARN of an AWS Lambda code signing config
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toPutFunctionCodeSigningConfig()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCodeSigningConfigArn(value, operator) {
        return this.if(`CodeSigningConfigArn`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ARN of an AWS Lambda function
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * Applies to actions:
     * - .toCreateEventSourceMapping()
     * - .toDeleteEventSourceMapping()
     * - .toGetEventSourceMapping()
     * - .toUpdateEventSourceMapping()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFunctionArn(value, operator) {
        return this.if(`FunctionArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the ARN of a version of an AWS Lambda layer
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toUpdateFunctionConfiguration()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifLayer(value, operator) {
        return this.if(`Layer`, value, operator || 'StringLike');
    }
    /**
     * Filters access by restricting the AWS service or account that can invoke a function
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * Applies to actions:
     * - .toAddPermission()
     * - .toRemovePermission()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPrincipal(value, operator) {
        return this.if(`Principal`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ID of security groups configured for the AWS Lambda function
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toUpdateFunctionConfiguration()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSecurityGroupIds(value, operator) {
        return this.if(`SecurityGroupIds`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ID of subnets configured for the AWS Lambda function
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toUpdateFunctionConfiguration()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSubnetIds(value, operator) {
        return this.if(`SubnetIds`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ID of the VPC configured for the AWS Lambda function
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toUpdateFunctionConfiguration()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcIds(value, operator) {
        return this.if(`VpcIds`, value, operator || 'StringLike');
    }
}
exports.Lambda = Lambda;
_a = JSII_RTTI_SYMBOL_1;
Lambda[_a] = { fqn: "iam-floyd.Lambda", version: "0.340.0" };
//# sourceMappingURL=data:application/json;base64,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