"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// This file is used in the base variant of the package: iam-floyd
/**
 * Base class for the Policy Statement
 */
class PolicyStatementBase {
    constructor(sid) {
        this.sid = '';
        /**
         * Holds the prefix of the service actions, e.g. `ec2`
         */
        this.servicePrefix = '';
        if (typeof sid !== 'undefined') {
            this.sid = sid;
        }
    }
    /**
     * JSON-ify the policy statement
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        const statement = {};
        if (this.sid.length) {
            statement.Sid = this.sid;
        }
        return statement;
    }
}
exports.PolicyStatementBase = PolicyStatementBase;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementBase[_a] = { fqn: "iam-floyd.PolicyStatementBase", version: "0.340.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMS1iYXNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiMS1iYXNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsa0VBQWtFO0FBRWxFOztHQUVHO0FBQ0gsTUFBYSxtQkFBbUI7SUFROUIsWUFBWSxHQUFZO1FBUGpCLFFBQUcsR0FBRyxFQUFFLENBQUM7UUFFaEI7O1dBRUc7UUFDSSxrQkFBYSxHQUFHLEVBQUUsQ0FBQztRQUd4QixJQUFJLE9BQU8sR0FBRyxLQUFLLFdBQVcsRUFBRTtZQUM5QixJQUFJLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQztTQUNoQjtJQUNILENBQUM7SUFFRDs7OztPQUlHO0lBRUksTUFBTTtRQUNYLE1BQU0sU0FBUyxHQUFRLEVBQUUsQ0FBQztRQUUxQixJQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsTUFBTSxFQUFFO1lBQ25CLFNBQVMsQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQztTQUMxQjtRQUVELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7O0FBNUJILGtEQTZCQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIFRoaXMgZmlsZSBpcyB1c2VkIGluIHRoZSBiYXNlIHZhcmlhbnQgb2YgdGhlIHBhY2thZ2U6IGlhbS1mbG95ZFxuXG4vKipcbiAqIEJhc2UgY2xhc3MgZm9yIHRoZSBQb2xpY3kgU3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBQb2xpY3lTdGF0ZW1lbnRCYXNlIHtcbiAgcHVibGljIHNpZCA9ICcnO1xuXG4gIC8qKlxuICAgKiBIb2xkcyB0aGUgcHJlZml4IG9mIHRoZSBzZXJ2aWNlIGFjdGlvbnMsIGUuZy4gYGVjMmBcbiAgICovXG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJyc7XG5cbiAgY29uc3RydWN0b3Ioc2lkPzogc3RyaW5nKSB7XG4gICAgaWYgKHR5cGVvZiBzaWQgIT09ICd1bmRlZmluZWQnKSB7XG4gICAgICB0aGlzLnNpZCA9IHNpZDtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogSlNPTi1pZnkgdGhlIHBvbGljeSBzdGF0ZW1lbnRcbiAgICpcbiAgICogVXNlZCB3aGVuIEpTT04uc3RyaW5naWZ5KCkgaXMgY2FsbGVkXG4gICAqL1xuXG4gIHB1YmxpYyB0b0pTT04oKTogYW55IHtcbiAgICBjb25zdCBzdGF0ZW1lbnQ6IGFueSA9IHt9O1xuXG4gICAgaWYgKHRoaXMuc2lkLmxlbmd0aCkge1xuICAgICAgc3RhdGVtZW50LlNpZCA9IHRoaXMuc2lkO1xuICAgIH1cblxuICAgIHJldHVybiBzdGF0ZW1lbnQ7XG4gIH1cbn1cbiJdfQ==